/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.assembly;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import oracle.javatools.assembly.AssemblyException;
import oracle.javatools.assembly.AssemblyFactory;

public abstract class ObjectFactory
implements AssemblyFactory {
    public static final byte OBJECT_CODE = 11;
    public static final byte DEFAULT_VERSION = 1;
    public static final byte NULL_VERSION = 0;
    private static final byte END_BARRIER = 45;

    public byte getObjectCode() {
        return 11;
    }

    public abstract Object assembleImpl(DataInput var1) throws IOException, AssemblyException;

    public abstract void disassembleImpl(Object var1, DataOutput var2) throws IOException, ClassCastException, AssemblyException;

    public byte getDisassemblyVersion() {
        return 1;
    }

    public Object versionedAssemble(DataInput input, int version) throws IOException, AssemblyException {
        return this.assembleImpl(input);
    }

    protected void readBarrier(DataInput input, byte barrier) throws IOException, AssemblyException {
        byte actual = input.readByte();
        if (actual != barrier) {
            throw new AssemblyException("Barrier data misread", (AssemblyFactory)this);
        }
    }

    @Override
    public Object assemble(byte[] data) throws AssemblyException {
        ByteArrayInputStream is = new ByteArrayInputStream(data);
        DataInputStream dis = new DataInputStream(is);
        return this.assemble(dis);
    }

    @Override
    public byte[] disassemble(Object object) throws AssemblyException, ClassCastException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(os);
        this.disassemble(object, dos);
        return os.toByteArray();
    }

    protected void writeBarrier(DataOutput output, byte barrier) throws IOException {
        output.writeByte(barrier);
    }

    @Override
    public Object assemble(DataInput input) throws AssemblyException {
        try {
            byte objectCode = this.getObjectCode();
            this.readBarrier(input, objectCode);
            byte version = input.readByte();
            Object object = version != 0 ? this.versionedAssemble(input, version) : null;
            this.readBarrier(input, (byte)45);
            return object;
        }
        catch (IOException e) {
            throw new AssemblyException(e, (AssemblyFactory)this);
        }
    }

    @Override
    public void disassemble(Object object, DataOutput output) throws AssemblyException, ClassCastException {
        try {
            byte objectCode = this.getObjectCode();
            this.writeBarrier(output, objectCode);
            byte version = object == null ? (byte)0 : this.getDisassemblyVersion();
            output.writeByte(version);
            if (version != 0) {
                this.disassembleImpl(object, output);
            }
            this.writeBarrier(output, (byte)45);
        }
        catch (IOException e) {
            throw new AssemblyException(e, (AssemblyFactory)this);
        }
    }
}

