/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.assembly;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.javatools.assembly.AssemblyException;
import oracle.javatools.assembly.AssemblyFactory;
import oracle.javatools.assembly.ObjectArrayFactory;
import oracle.javatools.assembly.ObjectFactory;

public class ListFactory
extends ObjectFactory {
    private AssemblyFactory _arrayFactory;
    private static final byte LIST_CODE = 17;

    public ListFactory(AssemblyFactory objectFactory) {
        this._arrayFactory = new ObjectArrayFactory(objectFactory);
    }

    @Override
    public byte getObjectCode() {
        return 17;
    }

    @Override
    public Object assembleImpl(DataInput input) throws IOException, AssemblyException {
        Object[] object = (Object[])this._arrayFactory.assemble(input);
        return new ArrayList<Object>(Arrays.asList(object));
    }

    @Override
    public void disassembleImpl(Object object, DataOutput output) throws IOException, ClassCastException, AssemblyException {
        List list = (List)object;
        Object[] array = list.toArray();
        this._arrayFactory.disassemble(array, output);
    }
}

