/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.quickdiff.reference;

import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import oracle.ide.history.HistoryManager;
import oracle.ide.history.LocalState;
import oracle.ide.model.NodeListener;
import oracle.ide.net.URLFileSystem;
import oracle.ide.quickdiff.QuickDiffMenuConstants;
import oracle.ide.quickdiff.QuickDiffReference;
import oracle.ide.quickdiff.QuickDiffReferenceProvider;
import oracle.ide.quickdiff.res.QuickDiffArb;
import oracle.javatools.compare.algorithm.text.TextCompareContributor;
import oracle.jdeveloper.compare.URLContributor;

public class OldestLocalStateReferenceProvider
extends QuickDiffReferenceProvider {
    public static final String ID = "OldestLocalState";

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getName() {
        return QuickDiffArb.getString(1);
    }

    @Override
    public float getMenuSection() {
        return QuickDiffMenuConstants.SECTION_IDE_REFERENCES;
    }

    @Override
    public QuickDiffReference createReference(final URL url) {
        return new QuickDiffReference(url){

            @Override
            protected final NodeListener createNodeListener() {
                return new QuickDiffReference.DefaultNodeListener();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final TextCompareContributor createCompareContributor() throws Exception {
                LocalState[] localStates = HistoryManager.getHistoryManager().getLocalHistory(url);
                if (localStates == null) {
                    return null;
                }
                Arrays.sort(localStates, new Comparator<LocalState>(){

                    @Override
                    public int compare(LocalState o1, LocalState o2) {
                        return o1.getDate().compareTo(o2.getDate());
                    }
                });
                Class<?> clazz = HistoryManager.getHistoryManager().getClass();
                synchronized (clazz) {
                    if (localStates.length == 0) {
                        return null;
                    }
                    URL dataUrl = localStates[0].getDataURL();
                    URL nodeUrl = localStates[0].getNodeURL();
                    if (URLFileSystem.getLength((URL)dataUrl) <= 0L) {
                        dataUrl = localStates.length >= 2 ? localStates[1].getDataURL() : null;
                        nodeUrl = localStates.length >= 2 ? localStates[1].getNodeURL() : null;
                    }
                    return dataUrl != null && URLFileSystem.exists((URL)dataUrl) ? new URLContributor(nodeUrl, dataUrl) : null;
                }
            }

            @Override
            public final InputStream openInputStream() {
                return null;
            }
        };
    }
}

