/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util;

import com.fasterxml.jackson.jr.ob.JSON;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.Base64;
import java.util.Map;
import oracle.dbtools.oci.OCIRESTClient;
import oracle.dbtools.oci.OCIRequest;
import org.apache.hc.core5.http.ParseException;

public class AutoBastionUtil {
    private static String databaseOCID = null;
    private static String databaseConnString = null;
    private static String secretOCID = null;
    private static String db_user = null;
    private static String db_pass = null;
    private static String db_IP = null;
    private static String subnetOCID = null;
    private static String compartmentId = null;
    private static String databasePort = null;
    private static String databasePE = null;
    private OCIRESTClient client = null;
    private String connOCID = null;
    private String region = null;

    public AutoBastionUtil(String connOCID, OCIRESTClient client, String region) throws GeneralSecurityException, IOException, ParseException {
        this.connOCID = connOCID;
        this.client = client;
        this.region = region;
        this.getConnectionInfo(this.region, this.connOCID);
        this.getDatabaseInfo(databaseOCID, this.region);
    }

    private void getConnectionInfo(String region, String connOCID) throws GeneralSecurityException, IOException, ParseException {
        URI root = URI.create(AutoBastionUtil.generateOCIurl(region, connOCID));
        OCIRequest req = new OCIRequest.Builder().host(root.getHost()).method("get").target("/20201005/databaseToolsConnections/" + connOCID).build();
        String baseInfo = this.client.getString(req);
        JSON j = JSON.builder().enable(new JSON.Feature[]{JSON.Feature.FAIL_ON_DUPLICATE_MAP_KEYS}).build();
        Map map = j.mapFrom((Object)baseInfo);
        String connectionString = (String)map.get("connectionString");
        databasePort = connectionString.split("=")[6].substring(0, 4);
        db_user = (String)map.get("userName");
        databaseConnString = (String)map.get("connectionString");
        secretOCID = (String)((Map)map.get("userPassword")).get("secretID");
        databaseOCID = (String)((Map)map.get("relatedResource")).get("identifier");
        compartmentId = (String)map.get("compartmentId");
    }

    private void getDatabaseInfo(String databaseOCID, String region) throws GeneralSecurityException, IOException, ParseException {
        String dbhost = "database." + region + ".oraclecloud.com";
        OCIRequest req = new OCIRequest.Builder().host(dbhost).method("get").target("/20160918/autonomousDatabases/" + databaseOCID).build();
        String baseInfo = this.client.getString(req);
        JSON j = JSON.builder().enable(new JSON.Feature[]{JSON.Feature.FAIL_ON_DUPLICATE_MAP_KEYS}).build();
        Map map = j.mapFrom((Object)baseInfo);
        subnetOCID = (String)map.get("subnetId");
        db_IP = (String)map.get("privateEndpointIp");
        databasePE = (String)map.get("privateEndpoint");
    }

    private static String generateOCIurl(String region, String ocid) {
        if (!((String)ocid).endsWith("/")) {
            ocid = (String)ocid + "/";
        }
        Object url = "https://";
        if (region.contains("r1")) {
            url = (String)url + "test-04.";
        }
        if (!region.contains("r1")) {
            url = (String)url + "dbtools.";
        }
        url = region.contains(".") ? (String)url + region + "/20201005/ords/" + (String)ocid : (String)url + region + ".oci.oraclecloud.com/20201005/ords/" + (String)ocid;
        return url;
    }

    public String getSubnetOCID() {
        return subnetOCID;
    }

    public String getDbEndpointIP() {
        return db_IP;
    }

    public String getDb_pass() throws GeneralSecurityException, IOException, ParseException {
        String secret_host = "secrets.vaults." + this.region + ".oci.oraclecloud.com";
        OCIRequest req = new OCIRequest.Builder().host(secret_host).method("get").target("/20190301/secretbundles/" + this.getSecretOCID() + "?stage=CURRENT").build();
        String secretJson = this.client.getString(req);
        JSON j = JSON.builder().enable(new JSON.Feature[]{JSON.Feature.FAIL_ON_DUPLICATE_MAP_KEYS}).build();
        Map map = j.mapFrom((Object)secretJson);
        String passwdEncoded = (String)((Map)map.get("secretBundleContent")).get("content");
        return new String(Base64.getDecoder().decode(passwdEncoded.getBytes()));
    }

    public String getDB_USER() {
        return db_user;
    }

    public String getDatabaseConnString() {
        return databaseConnString;
    }

    public String getSecretOCID() {
        return secretOCID;
    }

    public String getDatabaseOCID() {
        return databaseOCID;
    }

    public String getCompartmentId() {
        return compartmentId;
    }

    public String getDatabasePort() {
        return databasePort;
    }

    public String modifyDBurl() {
        String newUrl = databaseConnString.replace("host=" + databasePE, "host=localhost");
        return newUrl;
    }
}

