/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ssh.core;

import java.util.EventObject;
import oracle.dbtools.raptor.ssh.core.Descriptor;
import oracle.dbtools.raptor.ssh.core.HostDescriptor;
import oracle.dbtools.raptor.ssh.core.Store;
import oracle.dbtools.raptor.ssh.core.TunnelDescriptor;

public final class StoreEvent
extends EventObject {
    private final HostDescriptor host;
    private final TunnelDescriptor tunnel;
    private final Descriptor oldDesc;
    private final EventType type;

    public static StoreEvent createHostAddedEvent(Store store, HostDescriptor desc) {
        return new StoreEvent(store, EventType.HOST_ADDED, desc, null, null);
    }

    public static StoreEvent createHostRemovedEvent(Store store, HostDescriptor desc) {
        return new StoreEvent(store, EventType.HOST_REMOVED, desc, null, null);
    }

    public static StoreEvent createHostChangedEvent(Store store, HostDescriptor desc, HostDescriptor oldDesc) {
        return new StoreEvent(store, EventType.HOST_CHANGED, desc, null, oldDesc);
    }

    public static StoreEvent createTunnelAddedEvent(Store store, HostDescriptor host, TunnelDescriptor tunnel) {
        return new StoreEvent(store, EventType.TUNNEL_ADDED, host, tunnel, null);
    }

    public static StoreEvent createTunnelRemovedEvent(Store store, HostDescriptor host, TunnelDescriptor tunnel) {
        return new StoreEvent(store, EventType.TUNNEL_REMOVED, host, tunnel, null);
    }

    public static StoreEvent createTunnelChangedEvent(Store store, HostDescriptor host, TunnelDescriptor tunnel, TunnelDescriptor oldTunnel) {
        return new StoreEvent(store, EventType.TUNNEL_CHANGED, host, tunnel, oldTunnel);
    }

    private StoreEvent(Store store, EventType type, HostDescriptor desc, TunnelDescriptor tunnelDesc, Descriptor oldDesc) {
        super(store);
        this.host = desc;
        this.tunnel = tunnelDesc;
        this.type = type;
        this.oldDesc = oldDesc;
    }

    public HostDescriptor getHostDescriptor() {
        return this.host;
    }

    public TunnelDescriptor getTunnelDescriptor() {
        return this.tunnel;
    }

    public Descriptor getOldDescriptor() {
        return this.oldDesc;
    }

    public EventType getType() {
        return this.type;
    }

    public static enum EventType {
        HOST_ADDED,
        HOST_REMOVED,
        HOST_CHANGED,
        TUNNEL_ADDED,
        TUNNEL_REMOVED,
        TUNNEL_CHANGED;

    }
}

