/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import oracle.olapi.data.source.ColumnDefinition;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.Source;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.mdm.MdmQuery;
import oracle.olapi.metadata.mdm.MdmQueryColumn;
import oracle.olapi.metadata.mdm.MdmViewColumn;
import oracle.olapi.syntax.BaseMetadataObjectReference;
import oracle.olapi.syntax.BaseQuery;
import oracle.olapi.syntax.DataType;
import oracle.olapi.syntax.MetadataObjectReference;
import oracle.olapi.syntax.Query;
import oracle.olapi.syntax.SyntaxException;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.TypedExpression;
import oracle.olapi.syntax.ValidationContext;
import oracle.olapi.syntax.parser.ExpParser;

public final class ColumnExpression
extends TypedExpression {
    private BaseQuery m_Query = null;
    private MdmViewColumn m_ViewColumn = null;
    private BaseMetadataObjectReference m_MetadataColumn = null;
    private ColumnDefinition m_ColumnDefinition = null;

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        String string = this.getQuery().getName();
        if (null != string) {
            string = string + ".";
        }
        string = string + this.getColumnName();
        syntaxPrintingContext.appendIdentifier(string);
    }

    MdmQueryColumn getQueryColumn() {
        if (null != this.m_ViewColumn) {
            return this.m_ViewColumn;
        }
        return (MdmQueryColumn)((Object)this.m_MetadataColumn.getBaseMetadataObject());
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        if (null != this.m_MetadataColumn) {
            this.m_MetadataColumn = (BaseMetadataObjectReference)validationContext.validate(this.m_MetadataColumn);
        }
        this.m_Query = (BaseQuery)validationContext.validate(this.m_Query);
        if (null != this.m_MetadataColumn && this.m_MetadataColumn.isValid() || null != this.m_ViewColumn) {
            this.setDataType(this.getQueryColumn().getSQLDataType().getDataType());
        } else {
            this.setDataType(DataType.NULL_TYPE);
        }
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        if (!this.m_Query.isDefinitionComplete()) {
            return false;
        }
        if (null != this.m_MetadataColumn && !this.m_MetadataColumn.isDefinitionComplete()) {
            return false;
        }
        return super.checkIfDefinitionIsComplete();
    }

    public ColumnExpression(MdmQueryColumn mdmQueryColumn, Query query) {
        ColumnExpression.validateValue(mdmQueryColumn);
        ColumnExpression.validateValue(query);
        if (!(query instanceof BaseQuery)) {
            throw new SyntaxException("BaseQuery Expected");
        }
        this.m_Query = (BaseQuery)query;
        if (mdmQueryColumn instanceof MdmViewColumn) {
            this.m_ViewColumn = (MdmViewColumn)mdmQueryColumn;
        } else {
            BaseMetadataObject baseMetadataObject = mdmQueryColumn.getColumnObject();
            this.m_MetadataColumn = new MetadataObjectReference(baseMetadataObject, MdmQueryColumn.class);
        }
        this.setDataType(mdmQueryColumn.getSQLDataType().getDataType());
        this.initialize();
    }

    public ColumnExpression(ExpParser expParser, BaseMetadataObjectReference baseMetadataObjectReference) {
        this.m_MetadataColumn = baseMetadataObjectReference;
        this.m_Query = new BaseQuery(expParser, expParser.getIDResolver().getUnresolvedMetadataObjectReference(this.m_MetadataColumn.getIdentifier().getParentID(), MdmQuery.class, 2));
        this.initialize();
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitColumnExpression(this, object);
    }

    public Query getQuery() {
        return this.m_Query;
    }

    public String getColumnName() {
        if (null != this.m_MetadataColumn) {
            return this.m_MetadataColumn.getName();
        }
        if (null != this.m_ViewColumn) {
            return this.m_ViewColumn.getName();
        }
        return null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ColumnExpression)) {
            return false;
        }
        ColumnExpression columnExpression = (ColumnExpression)object;
        return this.getColumnName().equalsIgnoreCase(columnExpression.getColumnName()) && this.getQuery().equals(columnExpression.getQuery());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Source getListSource(DataProvider dataProvider) {
        if (null == this.m_ColumnDefinition) {
            ColumnExpression columnExpression = this;
            synchronized (columnExpression) {
                if (null == this.m_ColumnDefinition) {
                    this.m_ColumnDefinition = new ColumnDefinition(this, dataProvider, dataProvider.getTransactionProvider().getCurrentTransaction());
                }
            }
        }
        if (this.m_ColumnDefinition.getDataProvider() != dataProvider) {
            throw new SyntaxException("WrongDataProvider");
        }
        return this.m_ColumnDefinition.getSource();
    }
}

