/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.util;

import java.util.Properties;
import oracle.jdbc.OracleConnection;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.metadata.deployment.AW;
import oracle.olapi.metadata.mdm.MdmDatabaseSchema;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.util.UtilityBase;

public final class DeleteAW
extends UtilityBase {
    public static final String AW_NAME_PROPERTY = "aw";

    public static void main(String[] stringArray) {
        Properties properties = DeleteAW.parseCommandLineProperties(stringArray);
        String string = (String)properties.get(AW_NAME_PROPERTY);
        if (null == string) {
            throw new IllegalArgumentException("Must specifiy -aw");
        }
        string = string.toUpperCase().trim();
        try {
            OracleConnection oracleConnection = DeleteAW.connect(properties);
            DataProvider dataProvider = DeleteAW.createDataProvider(oracleConnection, properties);
            MdmMetadataProvider mdmMetadataProvider = dataProvider.getMdmMetadataProvider();
            MdmDatabaseSchema mdmDatabaseSchema = DeleteAW.getDatabaseSchema(mdmMetadataProvider, properties);
            AW aW = mdmDatabaseSchema.findOrCreateAW(string);
            String string2 = (String)properties.get("user");
            System.out.println("Deleting AW " + string2.toUpperCase() + "." + string.toUpperCase());
            mdmDatabaseSchema.removeAW(aW, true);
            System.out.println("Committing...");
            dataProvider.getTransactionProvider().commitCurrentTransaction();
            System.out.println("Commit Successful");
            dataProvider.close();
            oracleConnection.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception.toString());
        }
    }
}

