/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mdm;

import java.util.List;
import oracle.olapi.data.source.FundamentalMetadataObject;
import oracle.olapi.data.source.FundamentalMetadataProvider;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.SourceDefinition;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.mdm.MdmCube;
import oracle.olapi.metadata.mdm.MdmDimensionCalculationModel;
import oracle.olapi.metadata.mdm.MdmMeasure;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmObjectVisitor;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.metadata.mdm.MdmSchema;
import oracle.olapi.metadata.mdm.MdmXMLTags;
import oracle.olapi.transaction.Transaction;

public final class MdmMeasureDimension
extends MdmPrimaryDimension {
    public static final String MEASURE_DIMENSION_NAME = "MEASURE_DIMENSION";
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{MdmXMLTags.MEASURE_REF, MdmXMLTags.VALUE_CALC_MODEL};

    MdmMeasureDimension(MdmMetadataProvider mdmMetadataProvider) {
        super(mdmMetadataProvider);
    }

    @Override
    protected void finishObjectCreation() {
        super.finishObjectCreation();
        if (!this.getMetadataProvider().getDataProvider().read11gMetadata()) {
            return;
        }
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getMetadataProvider().getDataProvider().getFundamentalMetadataProvider();
        this.ensureCalcModel(MdmXMLTags.VALUE_CALC_MODEL, "Value", fundamentalMetadataProvider.getValueDataType());
    }

    @Override
    public Object acceptVisitor(MdmObjectVisitor mdmObjectVisitor, Object object) {
        return mdmObjectVisitor.visitMdmMeasureDimension(this, object);
    }

    public final List getMeasures() {
        return this.getPropertyListValues(MdmXMLTags.MEASURE_REF);
    }

    @Override
    final List getMembers() {
        return this.getMeasures();
    }

    @Override
    protected XMLTag getXMLTag() {
        return MdmXMLTags.MEASURE_DIMENSION_TAG;
    }

    @Override
    protected XMLTag getPropertyXMLTag(String string, String string2) {
        XMLTag xMLTag = this.findXMLTag(string, string2, LOCAL_TAGS);
        if (null == xMLTag) {
            return super.getPropertyXMLTag(string, string2);
        }
        return xMLTag;
    }

    public void addMeasure(MdmMeasure mdmMeasure) {
        this.addToListProperty(MdmXMLTags.MEASURE_REF, mdmMeasure);
    }

    public void removeMeasure(MdmMeasure mdmMeasure) {
        this.removeFromListProperty(MdmXMLTags.MEASURE_REF, mdmMeasure);
    }

    final SourceDefinition getElementType(Transaction transaction) {
        SourceDefinition sourceDefinition = null;
        for (MdmMeasure mdmMeasure : this.getMeasures()) {
            FundamentalMetadataObject fundamentalMetadataObject = (FundamentalMetadataObject)mdmMeasure.getType();
            SourceDefinition sourceDefinition2 = fundamentalMetadataObject.getSource().getDefinition();
            if (sourceDefinition == null) {
                sourceDefinition = sourceDefinition2;
                continue;
            }
            sourceDefinition = sourceDefinition.getCommonType(sourceDefinition2, transaction);
        }
        return sourceDefinition;
    }

    public final MdmDimensionCalculationModel getValueCalcModel() {
        return (MdmDimensionCalculationModel)this.getPropertyObjectValue(MdmXMLTags.VALUE_CALC_MODEL);
    }

    public final void setValueCalcModel(MdmDimensionCalculationModel mdmDimensionCalculationModel) {
        this.setPropertyObjectValue(MdmXMLTags.VALUE_CALC_MODEL, mdmDimensionCalculationModel);
    }

    public MdmMeasure createCustomMeasure(String string, Source source, int n) {
        return ((MdmMetadataProvider)this.getBaseMetadataProvider()).getMdmCustomObjectFactory().createCustomMeasure(string, this, source, n);
    }

    public MdmMeasure createCustomMeasure(String string, MdmSchema mdmSchema, Source source, int n) {
        return ((MdmMetadataProvider)this.getBaseMetadataProvider()).getMdmCustomObjectFactory().createCustomMeasure(string, this, mdmSchema, source, n);
    }

    @Override
    final MdmDimensionCalculationModel getExtractModel() {
        MdmDimensionCalculationModel mdmDimensionCalculationModel = null;
        MdmDimensionCalculationModel mdmDimensionCalculationModel2 = this.getNumberCalcModel();
        if (mdmDimensionCalculationModel2.getAssignments().size() > 0 || mdmDimensionCalculationModel2.getAutoAssignments().size() > 0) {
            mdmDimensionCalculationModel = mdmDimensionCalculationModel2;
        }
        if ((mdmDimensionCalculationModel2 = this.getStringCalcModel()).getAssignments().size() > 0 || mdmDimensionCalculationModel2.getAutoAssignments().size() > 0) {
            if (mdmDimensionCalculationModel != null) {
                return this.getValueCalcModel();
            }
            mdmDimensionCalculationModel = mdmDimensionCalculationModel2;
        }
        if ((mdmDimensionCalculationModel2 = this.getDateCalcModel()).getAssignments().size() > 0 || mdmDimensionCalculationModel2.getAutoAssignments().size() > 0) {
            if (mdmDimensionCalculationModel != null) {
                return this.getValueCalcModel();
            }
            mdmDimensionCalculationModel = mdmDimensionCalculationModel2;
        }
        if ((mdmDimensionCalculationModel2 = this.getBooleanCalcModel()).getAssignments().size() > 0 || mdmDimensionCalculationModel2.getAutoAssignments().size() > 0) {
            if (mdmDimensionCalculationModel != null) {
                return this.getValueCalcModel();
            }
            mdmDimensionCalculationModel = mdmDimensionCalculationModel2;
        }
        if (null == mdmDimensionCalculationModel) {
            mdmDimensionCalculationModel = this.getValueCalcModel();
        }
        return mdmDimensionCalculationModel;
    }

    public final MdmCube getCube() {
        return (MdmCube)this.getContainedByObject();
    }
}

