/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.conversion;

import java.util.List;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.conversion.LegacyXMLBaseObject;
import oracle.olapi.metadata.conversion.LegacyXMLConverter;
import oracle.olapi.metadata.conversion.LegacyXMLCube;
import oracle.olapi.metadata.conversion.LegacyXMLCubeDimRef;
import oracle.olapi.metadata.conversion.LegacyXMLSolveDefinition;
import oracle.olapi.metadata.conversion.LegacyXMLTags;
import oracle.olapi.metadata.mdm.MdmBaseMeasure;
import oracle.olapi.metadata.mdm.MdmCube;
import oracle.olapi.metadata.mdm.MdmMeasure;
import oracle.olapi.syntax.ConsistentSolveSpecification;

class LegacyXMLMeasure
extends LegacyXMLBaseObject {
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{LegacyXMLTags.MEAS_DATA_TYPE, LegacyXMLTags.SPARSE_TYPE, LegacyXMLTags.AUTO_SOLVE, LegacyXMLTags.IS_INTERNAL, LegacyXMLTags.USE_GLOBAL_INDEX, LegacyXMLTags.FORCE_CALC, LegacyXMLTags.FORCE_ORDER, LegacyXMLTags.SOLVE_DEFINITION_LC_REF, LegacyXMLTags.CUBE_DIM_REFS};

    protected LegacyXMLMeasure(BaseMetadataProvider baseMetadataProvider) {
        super(baseMetadataProvider);
    }

    final String getDataType() {
        return this.getPropertyStringValue(LegacyXMLTags.MEAS_DATA_TYPE);
    }

    final String getSparseType() {
        return this.getPropertyStringValue(LegacyXMLTags.SPARSE_TYPE);
    }

    final String getAutoSolve() {
        return this.getPropertyStringValue(LegacyXMLTags.AUTO_SOLVE);
    }

    final boolean getIsInternal() {
        return this.getPropertyBooleanValue(LegacyXMLTags.IS_INTERNAL);
    }

    final boolean getUseGlobalIndex() {
        return this.getPropertyBooleanValue(LegacyXMLTags.USE_GLOBAL_INDEX);
    }

    final boolean getForceCalc() {
        return this.getPropertyBooleanValue(LegacyXMLTags.FORCE_CALC);
    }

    final boolean getForceOrder() {
        return this.getPropertyBooleanValue(LegacyXMLTags.FORCE_ORDER);
    }

    final LegacyXMLSolveDefinition getSolveDefinition() {
        return (LegacyXMLSolveDefinition)this.getPropertyObjectValue(LegacyXMLTags.SOLVE_DEFINITION_LC_REF);
    }

    final List<LegacyXMLCubeDimRef> getCubeDimRefs() {
        return this.getPropertyListValues(LegacyXMLTags.CUBE_DIM_REFS);
    }

    final LegacyXMLCube getCube() {
        return (LegacyXMLCube)this.getContainedByObject();
    }

    final MdmMeasure getMdmMeasure() {
        return (MdmMeasure)this.getConvertToObject();
    }

    final MdmBaseMeasure getMdmBaseMeasure() {
        return (MdmBaseMeasure)this.getConvertToObject();
    }

    final void setMdmMeasure(MdmMeasure mdmMeasure) {
        this.setConvertToObject(mdmMeasure);
    }

    @Override
    protected XMLTag getPropertyXMLTag(String string, String string2) {
        XMLTag xMLTag = this.findXMLTag(string, string2, LOCAL_TAGS);
        if (null == xMLTag) {
            return super.getPropertyXMLTag(string, string2);
        }
        return xMLTag;
    }

    @Override
    protected XMLTag getXMLTag() {
        return LegacyXMLTags.MEASURE_TAG;
    }

    @Override
    protected boolean validateState(LegacyXMLConverter legacyXMLConverter) {
        if (!super.validateState(legacyXMLConverter)) {
            return false;
        }
        return null == this.getSolveDefinition() || this.getSolveDefinition().isValid();
    }

    @Override
    protected void convertToMdm(LegacyXMLConverter legacyXMLConverter) {
        if (null == this.getMdmMeasure()) {
            MdmCube mdmCube = this.getCube().getMdmCube();
            MdmBaseMeasure mdmBaseMeasure = mdmCube.findOrCreateBaseMeasure(this.getName());
            mdmBaseMeasure.setSQLDataType(LegacyXMLConverter.getSQLDataType(this.getDataType()));
            if (null != this.getSolveDefinition()) {
                ConsistentSolveSpecification consistentSolveSpecification = this.getSolveDefinition().getSynConsistentSolveSpecification();
                mdmBaseMeasure.setConsistentSolveSpecification(consistentSolveSpecification);
            }
            this.setMdmBaseMeasure(mdmBaseMeasure);
        }
        super.convertToMdm(legacyXMLConverter);
    }

    @Override
    protected int getBaseConvertOrderNumber(LegacyXMLConverter legacyXMLConverter) {
        if (null == this.getSolveDefinition()) {
            return super.getBaseConvertOrderNumber(legacyXMLConverter);
        }
        return this.getSolveDefinition().getConvertOrderNumber(legacyXMLConverter);
    }

    private void setMdmBaseMeasure(MdmBaseMeasure mdmBaseMeasure) {
        this.setMdmMeasure(mdmBaseMeasure);
    }
}

