/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import oracle.express.idl.util.WstringHolder;
import oracle.olapi.data.source.DataProvider;
import oracle.xml.parser.v2.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.ParserAdapter;

public final class PersistentLanguageFetcher
extends DefaultHandler {
    private List m_Languages = new ArrayList();
    private static final int STATE_INITIAL = 0;
    private static final int STATE_MAIN = 1;
    private static final int STATE_ELEM = 2;
    private int m_State = 0;
    private static final String PERSISTENT_LANGUAGES_TAG = "PersistentLanguages";
    private static final String LANGUAGE_TAG = "Language";
    private static final String NLS_NAME_ATTR_TAG = "nls_name";

    PersistentLanguageFetcher() {
    }

    public final List getLanguages() {
        return this.m_Languages;
    }

    public final void addLanguage(String string) {
        this.m_Languages.add(string);
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        switch (this.m_State) {
            case 0: {
                if (string2.equals(PERSISTENT_LANGUAGES_TAG)) {
                    this.m_State = 1;
                    break;
                }
                throw new SAXException("Unexpected XML Tag: " + string3);
            }
            case 1: {
                if (string2.equals(LANGUAGE_TAG)) {
                    this.m_State = 2;
                    String string4 = attributes.getValue(NLS_NAME_ATTR_TAG);
                    if (string4 != null) {
                        this.addLanguage(string4);
                        break;
                    }
                    throw new SAXException("Expecting attribute nls_name for element " + string3);
                }
                throw new SAXException("Unexpected XML Tag: " + string3);
            }
            case 2: {
                throw new SAXException("Not expecting sub-element for " + string3);
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        switch (this.m_State) {
            case 0: {
                throw new SAXException("Got endElement without startElement");
            }
            case 1: {
                this.m_State = 0;
                break;
            }
            case 2: {
                this.m_State = 1;
            }
        }
    }

    private static XMLReader createXMLReader() {
        int[] nArray = new int[]{2, 3};
        PersistentLanguageFetcher persistentLanguageFetcher = new PersistentLanguageFetcher();
        ParserAdapter parserAdapter = new ParserAdapter((Parser)new SAXParser());
        parserAdapter.setContentHandler(persistentLanguageFetcher);
        parserAdapter.setEntityResolver(persistentLanguageFetcher);
        parserAdapter.setErrorHandler(persistentLanguageFetcher);
        return parserAdapter;
    }

    public static List fetchPersistentLanguages(String[] stringArray, DataProvider dataProvider) {
        if (stringArray.length > 0) {
            XMLReader xMLReader = PersistentLanguageFetcher.createXMLReader();
            WstringHolder wstringHolder = dataProvider.getPersistentLanguagesXML(stringArray);
            InputSource inputSource = new InputSource(new StringReader(wstringHolder.value));
            PersistentLanguageFetcher.processXML(inputSource, xMLReader);
            PersistentLanguageFetcher persistentLanguageFetcher = (PersistentLanguageFetcher)xMLReader.getContentHandler();
            return persistentLanguageFetcher.getLanguages();
        }
        return new ArrayList();
    }

    private static void processXML(InputSource inputSource, XMLReader xMLReader) {
        if (null == inputSource) {
            return;
        }
        try {
            xMLReader.parse(inputSource);
        }
        catch (SAXException sAXException) {
            throw new RuntimeException(sAXException.toString());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }
}

