/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata;

import java.util.ArrayList;
import java.util.List;
import oracle.olapi.metadata.MetadataListProperty;

final class MetadataListModificationStep {
    public static final int ADD = 0;
    public static final int REMOVE = 1;
    public static final int CLEAR = 2;
    private Object m_Object = null;
    private ArrayList m_ClearedObjects = null;
    private int m_Position = -1;
    private int m_Action = -1;

    MetadataListModificationStep(Object object, int n) {
        this.setObject(object);
        this.setAction(n);
    }

    void applyModification(MetadataListProperty metadataListProperty) {
        switch (this.getAction()) {
            case 0: {
                if (metadataListProperty.isMetadataObjectList() && metadataListProperty.containsObject(this.getObject())) break;
                if (-1 == this.getPosition()) {
                    metadataListProperty.getObjects().add(this.getObject());
                    break;
                }
                metadataListProperty.getObjects().add(this.getPosition(), this.getObject());
                break;
            }
            case 1: {
                metadataListProperty.getObjects().remove(this.getObject());
                break;
            }
            case 2: {
                this.setClearedObjects(metadataListProperty.getObjects());
                metadataListProperty.getObjects().clear();
            }
        }
    }

    int getAction() {
        return this.m_Action;
    }

    Object getObject() {
        return this.m_Object;
    }

    int getPosition() {
        return this.m_Position;
    }

    static MetadataListModificationStep newAddAction(Object object, int n) {
        MetadataListModificationStep metadataListModificationStep = new MetadataListModificationStep(object, 0);
        metadataListModificationStep.setPosition(n);
        return metadataListModificationStep;
    }

    static MetadataListModificationStep newRemoveAction(Object object) {
        MetadataListModificationStep metadataListModificationStep = new MetadataListModificationStep(object, 1);
        return metadataListModificationStep;
    }

    static MetadataListModificationStep newClearAction() {
        MetadataListModificationStep metadataListModificationStep = new MetadataListModificationStep(null, 2);
        return metadataListModificationStep;
    }

    void setAction(int n) {
        this.m_Action = n;
    }

    void setObject(Object object) {
        this.m_Object = object;
    }

    void setPosition(int n) {
        this.m_Position = n;
    }

    String getActionString() {
        if (0 == this.getAction()) {
            return "ADD";
        }
        if (1 == this.getAction()) {
            return "REMOVE";
        }
        return "CLEAR";
    }

    private void setClearedObjects(List list) {
        if (null == this.m_ClearedObjects) {
            this.m_ClearedObjects = new ArrayList();
        } else {
            this.m_ClearedObjects.clear();
        }
        this.m_ClearedObjects.addAll(list);
    }

    List getClearedObjects() {
        return this.m_ClearedObjects;
    }

    List getObjects() {
        if (2 == this.getAction()) {
            return this.getClearedObjects();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(1);
        arrayList.add(this.getObject());
        return arrayList;
    }
}

