/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.log;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Properties;
import oracle.olapi.log.Formatter;
import oracle.olapi.log.LogEvent;
import oracle.olapi.log.LogHandler;
import oracle.olapi.log.LogHandlerFactory;

public class WriterLogHandler
implements LogHandlerFactory {
    public static final String AUTOFLUSH_KEY = "autoflush";
    public static final String PATH_KEY = "path";
    public static final String APPEND_KEY = "append";

    @Override
    public LogHandler createLogHandler(Properties properties) {
        try {
            String string = properties.getProperty(PATH_KEY);
            Boolean bl = new Boolean(properties.getProperty(AUTOFLUSH_KEY, "false"));
            Boolean bl2 = new Boolean(properties.getProperty(APPEND_KEY, "false"));
            return new Handler(string, bl, bl2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static class Handler
    implements LogHandler {
        private PrintWriter writer = null;
        private boolean closeOnShutdown = false;
        private Formatter formatter = null;

        public Handler(Writer writer, boolean bl) {
            this.writer = new PrintWriter(writer, bl);
        }

        public Handler(String string, boolean bl, boolean bl2) throws IOException {
            this(new FileWriter(string, bl2), bl);
            this.closeOnShutdown = true;
        }

        @Override
        public void start() {
            this.formatter = new Formatter();
        }

        @Override
        public void stop() {
            this.writer.flush();
            if (this.closeOnShutdown) {
                this.writer.close();
            }
            this.formatter = null;
        }

        @Override
        public void addMessage(LogEvent logEvent) {
            String string = (String)logEvent.acceptVisitor(this.formatter, this.writer);
            this.writer.println(string);
        }
    }
}

