/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.data.source;

import oracle.olapi.data.source.BooleanSource;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.DateSource;
import oracle.olapi.data.source.FundamentalMetadataObject;
import oracle.olapi.data.source.FundamentalMetadataProvider;
import oracle.olapi.data.source.NumberSource;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.StringSource;
import oracle.olapi.metadata.mdm.MdmLevel;
import oracle.olapi.metadata.mdm.MdmLevelHierarchy;
import oracle.olapi.metadata.mdm.MdmTimeDimension;

public abstract class SourceExpressionFactory {
    private DataProvider m_DataProvider = null;

    protected SourceExpressionFactory(DataProvider dataProvider) {
        this.setDataProvider(dataProvider);
    }

    public NumberSource abs(NumberSource numberSource) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (NumberSource)this.functionJoin(fundamentalMetadataProvider.getAbsFunction(), fundamentalMetadataProvider.getAbsArgParameter(), numberSource);
    }

    private final Source aggregationJoin(FundamentalMetadataObject fundamentalMetadataObject, FundamentalMetadataObject fundamentalMetadataObject2, Source source) {
        Source source2 = this.getDataProvider().createListOfSources(new Source[]{source}, false);
        return this.functionJoin(fundamentalMetadataObject, fundamentalMetadataObject2, source2);
    }

    public BooleanSource and(BooleanSource booleanSource, BooleanSource booleanSource2) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (BooleanSource)this.functionJoin(fundamentalMetadataProvider.getAndFunction(), fundamentalMetadataProvider.getAndLhsParameter(), booleanSource, fundamentalMetadataProvider.getAndRhsParameter(), booleanSource2);
    }

    public NumberSource arccos(NumberSource numberSource) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (NumberSource)this.functionJoin(fundamentalMetadataProvider.getArccosFunction(), fundamentalMetadataProvider.getArccosArgParameter(), numberSource);
    }

    public NumberSource arcsin(NumberSource numberSource) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (NumberSource)this.functionJoin(fundamentalMetadataProvider.getArcsinFunction(), fundamentalMetadataProvider.getArcsinArgParameter(), numberSource);
    }

    public NumberSource arctan(NumberSource numberSource) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (NumberSource)this.functionJoin(fundamentalMetadataProvider.getArctanFunction(), fundamentalMetadataProvider.getArctanArgParameter(), numberSource);
    }

    public NumberSource average(Source source, boolean bl) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        if (bl) {
            return (NumberSource)this.aggregationJoin(fundamentalMetadataProvider.getAverageFunction(), fundamentalMetadataProvider.getAverageListParameter(), source);
        }
        return (NumberSource)this.aggregationJoin(fundamentalMetadataProvider.getAverageIgnoreFunction(), fundamentalMetadataProvider.getAverageIgnoreListParameter(), source);
    }

    public NumberSource cos(NumberSource numberSource) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (NumberSource)this.functionJoin(fundamentalMetadataProvider.getCosFunction(), fundamentalMetadataProvider.getCosArgParameter(), numberSource);
    }

    public NumberSource cosh(NumberSource numberSource) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (NumberSource)this.functionJoin(fundamentalMetadataProvider.getCoshFunction(), fundamentalMetadataProvider.getCoshArgParameter(), numberSource);
    }

    public NumberSource count(Source source, boolean bl) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        if (bl) {
            return (NumberSource)this.aggregationJoin(fundamentalMetadataProvider.getCountFunction(), fundamentalMetadataProvider.getCountListParameter(), source);
        }
        return (NumberSource)this.aggregationJoin(fundamentalMetadataProvider.getCountIgnoreFunction(), fundamentalMetadataProvider.getCountIgnoreListParameter(), source);
    }

    public NumberSource div(NumberSource numberSource, NumberSource numberSource2) {
        return this.div(numberSource, numberSource2, false);
    }

    public NumberSource div(NumberSource numberSource, NumberSource numberSource2, boolean bl) {
        FundamentalMetadataObject fundamentalMetadataObject;
        FundamentalMetadataObject fundamentalMetadataObject2;
        FundamentalMetadataObject fundamentalMetadataObject3;
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        if (bl) {
            fundamentalMetadataObject3 = fundamentalMetadataProvider.getDiv2Function();
            fundamentalMetadataObject2 = fundamentalMetadataProvider.getDiv2LhsParameter();
            fundamentalMetadataObject = fundamentalMetadataProvider.getDiv2RhsParameter();
        } else {
            fundamentalMetadataObject3 = fundamentalMetadataProvider.getDivFunction();
            fundamentalMetadataObject2 = fundamentalMetadataProvider.getDivLhsParameter();
            fundamentalMetadataObject = fundamentalMetadataProvider.getDivRhsParameter();
        }
        return (NumberSource)this.functionJoin(fundamentalMetadataObject3, fundamentalMetadataObject2, numberSource, fundamentalMetadataObject, numberSource2);
    }

    public BooleanSource eq(Source source, Source source2) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (BooleanSource)this.functionJoin(fundamentalMetadataProvider.getEqFunction(), fundamentalMetadataProvider.getEqLhsParameter(), source, fundamentalMetadataProvider.getEqRhsParameter(), source2);
    }

    public BooleanSource forAll(BooleanSource booleanSource, boolean bl) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        if (bl) {
            return (BooleanSource)this.aggregationJoin(fundamentalMetadataProvider.getForAllFunction(), fundamentalMetadataProvider.getForAllListParameter(), booleanSource);
        }
        return (BooleanSource)this.aggregationJoin(fundamentalMetadataProvider.getForAllIgnoreFunction(), fundamentalMetadataProvider.getForAllIgnoreListParameter(), booleanSource);
    }

    public BooleanSource forAny(BooleanSource booleanSource, boolean bl) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        if (bl) {
            return (BooleanSource)this.aggregationJoin(fundamentalMetadataProvider.getForAnyFunction(), fundamentalMetadataProvider.getForAnyListParameter(), booleanSource);
        }
        return (BooleanSource)this.aggregationJoin(fundamentalMetadataProvider.getForAnyIgnoreFunction(), fundamentalMetadataProvider.getForAnyIgnoreListParameter(), booleanSource);
    }

    public BooleanSource forNone(BooleanSource booleanSource, boolean bl) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        if (bl) {
            return (BooleanSource)this.aggregationJoin(fundamentalMetadataProvider.getForNoneFunction(), fundamentalMetadataProvider.getForNoneListParameter(), booleanSource);
        }
        return (BooleanSource)this.aggregationJoin(fundamentalMetadataProvider.getForNoneIgnoreFunction(), fundamentalMetadataProvider.getForNoneIgnoreListParameter(), booleanSource);
    }

    private final Source functionJoin(FundamentalMetadataObject fundamentalMetadataObject, FundamentalMetadataObject fundamentalMetadataObject2, Source source) {
        return fundamentalMetadataObject.getSource().join(fundamentalMetadataObject2.getSource(), source, 0, false);
    }

    private final Source functionJoin(FundamentalMetadataObject fundamentalMetadataObject, FundamentalMetadataObject fundamentalMetadataObject2, Source source, FundamentalMetadataObject fundamentalMetadataObject3, Source source2) {
        return fundamentalMetadataObject.getSource().join(fundamentalMetadataObject2.getSource(), source, 0, false).join(fundamentalMetadataObject3.getSource(), source2, 0, false);
    }

    private final Source functionJoin(FundamentalMetadataObject fundamentalMetadataObject, FundamentalMetadataObject fundamentalMetadataObject2, Source source, FundamentalMetadataObject fundamentalMetadataObject3, Source source2, FundamentalMetadataObject fundamentalMetadataObject4, Source source3) {
        return fundamentalMetadataObject.getSource().join(fundamentalMetadataObject2.getSource(), source, 0, false).join(fundamentalMetadataObject3.getSource(), source2, 0, false).join(fundamentalMetadataObject4.getSource(), source3, 0, false);
    }

    public BooleanSource ge(Source source, Source source2) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (BooleanSource)this.functionJoin(fundamentalMetadataProvider.getGeFunction(), fundamentalMetadataProvider.getGeLhsParameter(), source, fundamentalMetadataProvider.getGeRhsParameter(), source2);
    }

    public DataProvider getDataProvider() {
        return this.m_DataProvider;
    }

    private final FundamentalMetadataProvider getFundamentalMetadataProvider() {
        return this.getDataProvider().getFundamentalMetadataProvider();
    }

    public BooleanSource gt(Source source, Source source2) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (BooleanSource)this.functionJoin(fundamentalMetadataProvider.getGtFunction(), fundamentalMetadataProvider.getGtLhsParameter(), source, fundamentalMetadataProvider.getGtRhsParameter(), source2);
    }

    public BooleanSource hasValue(Source source) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (BooleanSource)this.functionJoin(fundamentalMetadataProvider.getHasValueFunction(), fundamentalMetadataProvider.getHasValueArgParameter(), source);
    }

    public DateSource implies(BooleanSource booleanSource, DateSource dateSource, DateSource dateSource2) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (DateSource)this.functionJoin(fundamentalMetadataProvider.getImpliesDateFunction(), fundamentalMetadataProvider.getImpliesDateConditionParameter(), booleanSource, fundamentalMetadataProvider.getImpliesDateTrueParameter(), dateSource, fundamentalMetadataProvider.getImpliesDateFalseParameter(), dateSource2);
    }

    public NumberSource implies(BooleanSource booleanSource, NumberSource numberSource, NumberSource numberSource2) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (NumberSource)this.functionJoin(fundamentalMetadataProvider.getImpliesNumberFunction(), fundamentalMetadataProvider.getImpliesNumberConditionParameter(), booleanSource, fundamentalMetadataProvider.getImpliesNumberTrueParameter(), numberSource, fundamentalMetadataProvider.getImpliesNumberFalseParameter(), numberSource2);
    }

    public StringSource implies(BooleanSource booleanSource, StringSource stringSource, StringSource stringSource2) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (StringSource)this.functionJoin(fundamentalMetadataProvider.getImpliesStringFunction(), fundamentalMetadataProvider.getImpliesStringConditionParameter(), booleanSource, fundamentalMetadataProvider.getImpliesStringTrueParameter(), stringSource, fundamentalMetadataProvider.getImpliesStringFalseParameter(), stringSource2);
    }

    public NumberSource indexOf(StringSource stringSource, StringSource stringSource2, NumberSource numberSource) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (NumberSource)this.functionJoin(fundamentalMetadataProvider.getIndexOfFunction(), fundamentalMetadataProvider.getIndexOfArgParameter(), stringSource, fundamentalMetadataProvider.getIndexOfSubstringParameter(), stringSource2, fundamentalMetadataProvider.getIndexOfFromIndexParameter(), numberSource);
    }

    public NumberSource intpart(NumberSource numberSource) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (NumberSource)this.functionJoin(fundamentalMetadataProvider.getIntpartFunction(), fundamentalMetadataProvider.getIntpartArgParameter(), numberSource);
    }

    public BooleanSource le(Source source, Source source2) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (BooleanSource)this.functionJoin(fundamentalMetadataProvider.getLeFunction(), fundamentalMetadataProvider.getLeLhsParameter(), source, fundamentalMetadataProvider.getLeRhsParameter(), source2);
    }

    public NumberSource length(StringSource stringSource) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (NumberSource)this.functionJoin(fundamentalMetadataProvider.getLengthFunction(), fundamentalMetadataProvider.getLengthArgParameter(), stringSource);
    }

    public BooleanSource like(StringSource stringSource, StringSource stringSource2) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (BooleanSource)this.functionJoin(fundamentalMetadataProvider.getLikeFunction(), fundamentalMetadataProvider.getLikeLhsParameter(), stringSource, fundamentalMetadataProvider.getLikeRhsParameter(), stringSource2);
    }

    public NumberSource log(NumberSource numberSource) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (NumberSource)this.functionJoin(fundamentalMetadataProvider.getLogFunction(), fundamentalMetadataProvider.getLogArgParameter(), numberSource);
    }

    public BooleanSource lt(Source source, Source source2) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (BooleanSource)this.functionJoin(fundamentalMetadataProvider.getLtFunction(), fundamentalMetadataProvider.getLtLhsParameter(), source, fundamentalMetadataProvider.getLtRhsParameter(), source2);
    }

    public NumberSource maximum(NumberSource numberSource, boolean bl) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        if (bl) {
            return (NumberSource)this.aggregationJoin(fundamentalMetadataProvider.getMaximumFunction(), fundamentalMetadataProvider.getMaximumListParameter(), numberSource);
        }
        return (NumberSource)this.aggregationJoin(fundamentalMetadataProvider.getMaximumIgnoreFunction(), fundamentalMetadataProvider.getMaximumIgnoreListParameter(), numberSource);
    }

    public NumberSource minimum(NumberSource numberSource, boolean bl) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        if (bl) {
            return (NumberSource)this.aggregationJoin(fundamentalMetadataProvider.getMinimumFunction(), fundamentalMetadataProvider.getMinimumListParameter(), numberSource);
        }
        return (NumberSource)this.aggregationJoin(fundamentalMetadataProvider.getMinimumIgnoreFunction(), fundamentalMetadataProvider.getMinimumIgnoreListParameter(), numberSource);
    }

    public NumberSource minus(NumberSource numberSource, NumberSource numberSource2) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (NumberSource)this.functionJoin(fundamentalMetadataProvider.getMinusFunction(), fundamentalMetadataProvider.getMinusLhsParameter(), numberSource, fundamentalMetadataProvider.getMinusRhsParameter(), numberSource2);
    }

    public BooleanSource ne(Source source, Source source2) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (BooleanSource)this.functionJoin(fundamentalMetadataProvider.getNeFunction(), fundamentalMetadataProvider.getNeLhsParameter(), source, fundamentalMetadataProvider.getNeRhsParameter(), source2);
    }

    public NumberSource negate(NumberSource numberSource) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (NumberSource)this.functionJoin(fundamentalMetadataProvider.getNegateFunction(), fundamentalMetadataProvider.getNegateArgParameter(), numberSource);
    }

    public BooleanSource not(BooleanSource booleanSource) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (BooleanSource)this.functionJoin(fundamentalMetadataProvider.getNotFunction(), fundamentalMetadataProvider.getNotArgParameter(), booleanSource);
    }

    public BooleanSource or(BooleanSource booleanSource, BooleanSource booleanSource2) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (BooleanSource)this.functionJoin(fundamentalMetadataProvider.getOrFunction(), fundamentalMetadataProvider.getOrLhsParameter(), booleanSource, fundamentalMetadataProvider.getOrRhsParameter(), booleanSource2);
    }

    public NumberSource plus(NumberSource numberSource, NumberSource numberSource2) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (NumberSource)this.functionJoin(fundamentalMetadataProvider.getPlusFunction(), fundamentalMetadataProvider.getPlusLhsParameter(), numberSource, fundamentalMetadataProvider.getPlusRhsParameter(), numberSource2);
    }

    public DateSource plusDays(DateSource dateSource, NumberSource numberSource) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (DateSource)this.functionJoin(fundamentalMetadataProvider.getPlusDaysFunction(), fundamentalMetadataProvider.getPlusDaysLhsParameter(), dateSource, fundamentalMetadataProvider.getPlusDaysRhsParameter(), numberSource);
    }

    public DateSource plusMonths(DateSource dateSource, NumberSource numberSource) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (DateSource)this.functionJoin(fundamentalMetadataProvider.getPlusMonthsFunction(), fundamentalMetadataProvider.getPlusMonthsLhsParameter(), dateSource, fundamentalMetadataProvider.getPlusMonthsRhsParameter(), numberSource);
    }

    public NumberSource pow(NumberSource numberSource, NumberSource numberSource2) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (NumberSource)this.functionJoin(fundamentalMetadataProvider.getPowFunction(), fundamentalMetadataProvider.getPowLhsParameter(), numberSource, fundamentalMetadataProvider.getPowRhsParameter(), numberSource2);
    }

    public NumberSource rem(NumberSource numberSource, NumberSource numberSource2) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (NumberSource)this.functionJoin(fundamentalMetadataProvider.getRemFunction(), fundamentalMetadataProvider.getRemLhsParameter(), numberSource, fundamentalMetadataProvider.getRemRhsParameter(), numberSource2);
    }

    public StringSource remove(StringSource stringSource, NumberSource numberSource, NumberSource numberSource2) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (StringSource)this.functionJoin(fundamentalMetadataProvider.getRemoveFunction(), fundamentalMetadataProvider.getRemoveArgParameter(), stringSource, fundamentalMetadataProvider.getRemoveIndexParameter(), numberSource, fundamentalMetadataProvider.getRemoveLengthParameter(), numberSource2);
    }

    public StringSource replace(StringSource stringSource, StringSource stringSource2, StringSource stringSource3) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (StringSource)this.functionJoin(fundamentalMetadataProvider.getReplaceFunction(), fundamentalMetadataProvider.getReplaceArgParameter(), stringSource, fundamentalMetadataProvider.getReplaceOldParameter(), stringSource2, fundamentalMetadataProvider.getReplaceNewParameter(), stringSource3);
    }

    public NumberSource round(NumberSource numberSource, NumberSource numberSource2) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (NumberSource)this.functionJoin(fundamentalMetadataProvider.getRoundFunction(), fundamentalMetadataProvider.getRoundArgParameter(), numberSource, fundamentalMetadataProvider.getRoundMultipleParameter(), numberSource2);
    }

    final void setDataProvider(DataProvider dataProvider) {
        this.m_DataProvider = dataProvider;
    }

    public NumberSource sin(NumberSource numberSource) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (NumberSource)this.functionJoin(fundamentalMetadataProvider.getSinFunction(), fundamentalMetadataProvider.getSinArgParameter(), numberSource);
    }

    public NumberSource sinh(NumberSource numberSource) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (NumberSource)this.functionJoin(fundamentalMetadataProvider.getSinhFunction(), fundamentalMetadataProvider.getSinhArgParameter(), numberSource);
    }

    public NumberSource sqrt(NumberSource numberSource) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (NumberSource)this.functionJoin(fundamentalMetadataProvider.getSqrtFunction(), fundamentalMetadataProvider.getSqrtArgParameter(), numberSource);
    }

    public NumberSource stdev(NumberSource numberSource, boolean bl) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        if (bl) {
            return (NumberSource)this.aggregationJoin(fundamentalMetadataProvider.getStdevFunction(), fundamentalMetadataProvider.getStdevListParameter(), numberSource);
        }
        return (NumberSource)this.aggregationJoin(fundamentalMetadataProvider.getStdevIgnoreFunction(), fundamentalMetadataProvider.getStdevIgnoreListParameter(), numberSource);
    }

    public StringSource substring(StringSource stringSource, NumberSource numberSource, NumberSource numberSource2) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (StringSource)this.functionJoin(fundamentalMetadataProvider.getSubstringFunction(), fundamentalMetadataProvider.getSubstringArgParameter(), stringSource, fundamentalMetadataProvider.getSubstringIndexParameter(), numberSource, fundamentalMetadataProvider.getSubstringLengthParameter(), numberSource2);
    }

    public NumberSource tan(NumberSource numberSource) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (NumberSource)this.functionJoin(fundamentalMetadataProvider.getTanFunction(), fundamentalMetadataProvider.getTanArgParameter(), numberSource);
    }

    public NumberSource tanh(NumberSource numberSource) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (NumberSource)this.functionJoin(fundamentalMetadataProvider.getTanhFunction(), fundamentalMetadataProvider.getTanhArgParameter(), numberSource);
    }

    public StringSource textFill(StringSource stringSource, NumberSource numberSource) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (StringSource)this.functionJoin(fundamentalMetadataProvider.getTextFillFunction(), fundamentalMetadataProvider.getTextFillArgParameter(), stringSource, fundamentalMetadataProvider.getTextFillWidthParameter(), numberSource);
    }

    public NumberSource times(NumberSource numberSource, NumberSource numberSource2) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (NumberSource)this.functionJoin(fundamentalMetadataProvider.getTimesFunction(), fundamentalMetadataProvider.getTimesLhsParameter(), numberSource, fundamentalMetadataProvider.getTimesRhsParameter(), numberSource2);
    }

    public StringSource toLowercase(StringSource stringSource) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (StringSource)this.functionJoin(fundamentalMetadataProvider.getToLowercaseFunction(), fundamentalMetadataProvider.getToLowercaseArgParameter(), stringSource);
    }

    public NumberSource total(NumberSource numberSource, boolean bl) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        if (bl) {
            return (NumberSource)this.aggregationJoin(fundamentalMetadataProvider.getTotalFunction(), fundamentalMetadataProvider.getTotalListParameter(), numberSource);
        }
        return (NumberSource)this.aggregationJoin(fundamentalMetadataProvider.getTotalIgnoreFunction(), fundamentalMetadataProvider.getTotalIgnoreListParameter(), numberSource);
    }

    public StringSource toUppercase(StringSource stringSource) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (StringSource)this.functionJoin(fundamentalMetadataProvider.getToUppercaseFunction(), fundamentalMetadataProvider.getToUppercaseArgParameter(), stringSource);
    }

    public StringSource trim(StringSource stringSource) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (StringSource)this.functionJoin(fundamentalMetadataProvider.getTrimFunction(), fundamentalMetadataProvider.getTrimArgParameter(), stringSource);
    }

    public StringSource trimLeading(StringSource stringSource) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (StringSource)this.functionJoin(fundamentalMetadataProvider.getTrimLeadingFunction(), fundamentalMetadataProvider.getTrimLeadingArgParameter(), stringSource);
    }

    public StringSource trimTrailing(StringSource stringSource) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (StringSource)this.functionJoin(fundamentalMetadataProvider.getTrimTrailingFunction(), fundamentalMetadataProvider.getTrimTrailingArgParameter(), stringSource);
    }

    public NumberSource cumulativeTotal(NumberSource numberSource, MdmLevelHierarchy mdmLevelHierarchy, int n, MdmLevel mdmLevel) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return this.cumulativeAggregation(numberSource, mdmLevelHierarchy, n, mdmLevel, fundamentalMetadataProvider.getTotalFunction(), fundamentalMetadataProvider.getTotalListParameter());
    }

    public NumberSource cumulativeAverage(NumberSource numberSource, MdmLevelHierarchy mdmLevelHierarchy, int n, MdmLevel mdmLevel) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return this.cumulativeAggregation(numberSource, mdmLevelHierarchy, n, mdmLevel, fundamentalMetadataProvider.getAverageFunction(), fundamentalMetadataProvider.getAverageListParameter());
    }

    public NumberSource cumulativeMaximum(NumberSource numberSource, MdmLevelHierarchy mdmLevelHierarchy, int n, MdmLevel mdmLevel) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return this.cumulativeAggregation(numberSource, mdmLevelHierarchy, n, mdmLevel, fundamentalMetadataProvider.getMaximumFunction(), fundamentalMetadataProvider.getMaximumListParameter());
    }

    public NumberSource cumulativeMinimum(NumberSource numberSource, MdmLevelHierarchy mdmLevelHierarchy, int n, MdmLevel mdmLevel) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return this.cumulativeAggregation(numberSource, mdmLevelHierarchy, n, mdmLevel, fundamentalMetadataProvider.getMinimumFunction(), fundamentalMetadataProvider.getMinimumListParameter());
    }

    private final NumberSource cumulativeAggregation(NumberSource numberSource, MdmLevelHierarchy mdmLevelHierarchy, int n, MdmLevel mdmLevel, FundamentalMetadataObject fundamentalMetadataObject, FundamentalMetadataObject fundamentalMetadataObject2) {
        Source source;
        Source source2;
        Source source3 = mdmLevelHierarchy.getSource();
        Source source4 = mdmLevelHierarchy.getLevelAttribute().getSource();
        Source source5 = null;
        if (null == mdmLevel) {
            source5 = source3.join(source4, source4);
        } else {
            source2 = mdmLevelHierarchy.getAncestorsAttribute().getSource();
            source = mdmLevel.getSource().selectValues(source2);
            source5 = source3.join(source, source).join(source4, source4);
        }
        source2 = (NumberSource)numberSource.join(source5.cumulativeInterval(n));
        source = this.aggregationJoin(fundamentalMetadataObject, fundamentalMetadataObject2, source2);
        return (NumberSource)source.join(source5, source3.value());
    }

    public NumberSource lag(NumberSource numberSource, MdmLevelHierarchy mdmLevelHierarchy, int n) {
        Source source = mdmLevelHierarchy.getSource();
        Source source2 = mdmLevelHierarchy.getLevelAttribute().getSource();
        Source source3 = source.join(source2, source2);
        return (NumberSource)numberSource.joinHidden(source3.offset(-n)).join(source3, source.value());
    }

    public NumberSource lagMonths(NumberSource numberSource, MdmLevelHierarchy mdmLevelHierarchy, int n) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return this.lagPeriods(numberSource, mdmLevelHierarchy, n, fundamentalMetadataProvider.getPlusMonthsFunction(), fundamentalMetadataProvider.getPlusMonthsLhsParameter(), fundamentalMetadataProvider.getPlusMonthsRhsParameter());
    }

    public NumberSource lagDays(NumberSource numberSource, MdmLevelHierarchy mdmLevelHierarchy, int n) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return this.lagPeriods(numberSource, mdmLevelHierarchy, n, fundamentalMetadataProvider.getPlusDaysFunction(), fundamentalMetadataProvider.getPlusDaysLhsParameter(), fundamentalMetadataProvider.getPlusDaysRhsParameter());
    }

    private final NumberSource lagPeriods(NumberSource numberSource, MdmLevelHierarchy mdmLevelHierarchy, int n, FundamentalMetadataObject fundamentalMetadataObject, FundamentalMetadataObject fundamentalMetadataObject2, FundamentalMetadataObject fundamentalMetadataObject3) {
        MdmTimeDimension mdmTimeDimension = (MdmTimeDimension)mdmLevelHierarchy.getPrimaryDimension();
        DateSource dateSource = (DateSource)mdmTimeDimension.getEndDateAttribute().getSource();
        NumberSource numberSource2 = (NumberSource)mdmTimeDimension.getTimeSpanAttribute().getSource();
        DateSource dateSource2 = dateSource.plusDays(numberSource2.negate()).plusDays(1);
        NumberSource numberSource3 = this.getDataProvider().createConstantSource(-n);
        DateSource dateSource3 = (DateSource)this.functionJoin(fundamentalMetadataObject, fundamentalMetadataObject2, dateSource2, fundamentalMetadataObject3, numberSource3);
        Source source = mdmLevelHierarchy.getSource();
        Source source2 = mdmLevelHierarchy.getLevelAttribute().getSource();
        Source source3 = source.join(source2, source2).join((Source)dateSource2, dateSource3);
        return ((NumberSource)numberSource.join(source3)).maximum();
    }

    public final NumberSource positionalPeriodsAgo(NumberSource numberSource, MdmLevelHierarchy mdmLevelHierarchy, MdmLevel mdmLevel, int n) {
        Source source = mdmLevelHierarchy.getSource();
        Source source2 = mdmLevel.getSource();
        Source source3 = mdmLevelHierarchy.getAncestorsAttribute().getSource();
        Source source4 = mdmLevelHierarchy.getLevelAttribute().getSource();
        Source source5 = source2.selectValues(source3);
        Source source6 = source2.offset(n).join(source2, source5);
        Source source7 = source.join(source5, source5).join(source4, source4);
        NumberSource numberSource2 = source7.positionOfValues(source.value());
        Source source8 = source.join(source5, source6).join(source4, source4);
        Source source9 = this.atOrLast(source8, numberSource2);
        return ((NumberSource)numberSource.join(source9)).maximum();
    }

    private final Source atOrLast(Source source, NumberSource numberSource) {
        NumberSource numberSource2 = source.count();
        BooleanSource booleanSource = numberSource.le(numberSource2);
        NumberSource numberSource3 = booleanSource.implies(numberSource, numberSource2);
        return source.at(numberSource3);
    }

    public NumberSource movingTotal(NumberSource numberSource, MdmLevelHierarchy mdmLevelHierarchy, int n, int n2) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return this.movingAggregation(numberSource, mdmLevelHierarchy, n, n2, fundamentalMetadataProvider.getTotalFunction(), fundamentalMetadataProvider.getTotalListParameter());
    }

    public NumberSource movingAverage(NumberSource numberSource, MdmLevelHierarchy mdmLevelHierarchy, int n, int n2) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return this.movingAggregation(numberSource, mdmLevelHierarchy, n, n2, fundamentalMetadataProvider.getAverageFunction(), fundamentalMetadataProvider.getAverageListParameter());
    }

    public NumberSource movingMaximum(NumberSource numberSource, MdmLevelHierarchy mdmLevelHierarchy, int n, int n2) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return this.movingAggregation(numberSource, mdmLevelHierarchy, n, n2, fundamentalMetadataProvider.getMaximumFunction(), fundamentalMetadataProvider.getMaximumListParameter());
    }

    public NumberSource movingMinimum(NumberSource numberSource, MdmLevelHierarchy mdmLevelHierarchy, int n, int n2) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return this.movingAggregation(numberSource, mdmLevelHierarchy, n, n2, fundamentalMetadataProvider.getMinimumFunction(), fundamentalMetadataProvider.getMinimumListParameter());
    }

    public NumberSource median(NumberSource numberSource) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (NumberSource)this.aggregationJoin(fundamentalMetadataProvider.getMedianFunction(), fundamentalMetadataProvider.getMedianListParameter(), numberSource);
    }

    public StringSource plus(StringSource stringSource, StringSource stringSource2) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (StringSource)this.functionJoin(fundamentalMetadataProvider.getPlusStringFunction(), fundamentalMetadataProvider.getPlusStringLhsParameter(), stringSource, fundamentalMetadataProvider.getPlusStringRhsParameter(), stringSource2);
    }

    public NumberSource variance(NumberSource numberSource) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (NumberSource)this.aggregationJoin(fundamentalMetadataProvider.getVarianceFunction(), fundamentalMetadataProvider.getVarianceListParameter(), numberSource);
    }

    public NumberSource variancePop(NumberSource numberSource) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (NumberSource)this.aggregationJoin(fundamentalMetadataProvider.getVariancePopFunction(), fundamentalMetadataProvider.getVariancePopListParameter(), numberSource);
    }

    public NumberSource varianceSamp(NumberSource numberSource) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (NumberSource)this.aggregationJoin(fundamentalMetadataProvider.getVarianceSampFunction(), fundamentalMetadataProvider.getVarianceSampListParameter(), numberSource);
    }

    public NumberSource stdevPop(NumberSource numberSource) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (NumberSource)this.aggregationJoin(fundamentalMetadataProvider.getStdevPopFunction(), fundamentalMetadataProvider.getStdevPopListParameter(), numberSource);
    }

    public NumberSource stdevSamp(NumberSource numberSource) {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getFundamentalMetadataProvider();
        return (NumberSource)this.aggregationJoin(fundamentalMetadataProvider.getStdevSampFunction(), fundamentalMetadataProvider.getStdevSampListParameter(), numberSource);
    }

    private final NumberSource movingAggregation(NumberSource numberSource, MdmLevelHierarchy mdmLevelHierarchy, int n, int n2, FundamentalMetadataObject fundamentalMetadataObject, FundamentalMetadataObject fundamentalMetadataObject2) {
        Source source = mdmLevelHierarchy.getSource();
        Source source2 = mdmLevelHierarchy.getLevelAttribute().getSource();
        Source source3 = source.join(source2, source2);
        NumberSource numberSource2 = (NumberSource)numberSource.join(source3.movingInterval(n, n2));
        Source source4 = this.aggregationJoin(fundamentalMetadataObject, fundamentalMetadataObject2, numberSource2);
        return (NumberSource)source4.join(source3, source.value());
    }
}

