/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.data.source;

import java.util.ArrayList;
import java.util.List;
import oracle.olapi.data.source.Model;
import oracle.olapi.data.source.Qualification;
import oracle.olapi.data.source.Source;

public class Assignment {
    private List m_Qualifications = null;
    private Source m_Assigned = null;
    private int m_Precedence = 0;
    private Model m_Owner = null;

    public Assignment(Model model, Qualification[] qualificationArray, Source source, int n) {
        this.m_Owner = model;
        this.m_Qualifications = new ArrayList();
        if (qualificationArray != null) {
            for (int i = 0; i < qualificationArray.length; ++i) {
                this.addQualification(qualificationArray[i]);
            }
        }
        this.m_Assigned = source;
        this.m_Precedence = n;
    }

    private Assignment(Model model, Source source, int n) {
        this.m_Owner = model;
        this.m_Qualifications = new ArrayList();
        this.m_Assigned = source;
        this.m_Precedence = n;
    }

    void addQualification(Qualification qualification) {
        this.m_Qualifications.add(qualification);
    }

    public Assignment createCopy() {
        Assignment assignment = new Assignment(this.getOwner(), this.getAssignedSource(), this.getPrecedence());
        for (int i = 0; i < this.getQualifications().size(); ++i) {
            Qualification qualification = (Qualification)this.getQualifications().get(i);
            Qualification qualification2 = qualification.createCopy();
            assignment.addQualification(qualification2);
        }
        return assignment;
    }

    public void assign(Model model, Source source, Source source2) {
        Qualification[] qualificationArray = new Qualification[this.getQualifications().size()];
        for (int i = 0; i < qualificationArray.length; ++i) {
            Qualification qualification;
            Qualification qualification2 = (Qualification)this.getQualifications().get(i);
            qualificationArray[i] = qualification = qualification2.clone(source, source2);
        }
        model.assign(qualificationArray, this.getAssignedSource(), this.getPrecedence());
    }

    public final Model getOwner() {
        return this.m_Owner;
    }

    public final List getQualifications() {
        return this.m_Qualifications;
    }

    public final Source getAssignedSource() {
        return this.m_Assigned;
    }

    public final int getPrecedence() {
        return this.m_Precedence;
    }
}

