/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.data.cursor;

import java.util.Date;
import oracle.olapi.data.cursor.IncorrectDataTypeException;
import oracle.olapi.data.cursor.SourceType;
import oracle.olapi.data.cursor.ValueCursor;

public class CursorInput {
    private Object _currentValue;
    private ValueCursor _valueCursor = null;
    private SourceType _sourceType;

    public CursorInput(Object object) {
        if (object instanceof String) {
            this._setSourceType(SourceType.STRING_SOURCE);
        } else if (object instanceof Date) {
            this._setSourceType(SourceType.DATE_SOURCE);
        } else if (object instanceof Boolean) {
            this._setSourceType(SourceType.BOOLEAN_SOURCE);
        } else if (object instanceof Short || object instanceof Integer || object instanceof Float || object instanceof Double) {
            this._setSourceType(SourceType.NUMBER_SOURCE);
        } else {
            throw new IncorrectDataTypeException();
        }
        this.setCurrentValue(object);
    }

    public CursorInput(String string) {
        this._setSourceType(SourceType.STRING_SOURCE);
        this.setCurrentString(string);
    }

    public CursorInput(Date date) {
        this._setSourceType(SourceType.DATE_SOURCE);
        this.setCurrentDate(date);
    }

    public CursorInput(short s) {
        this._setSourceType(SourceType.NUMBER_SOURCE);
        this.setCurrentShort(s);
    }

    public CursorInput(int n) {
        this._setSourceType(SourceType.NUMBER_SOURCE);
        this.setCurrentInteger(n);
    }

    public CursorInput(float f) {
        this._setSourceType(SourceType.NUMBER_SOURCE);
        this.setCurrentFloat(f);
    }

    public CursorInput(double d) {
        this._setSourceType(SourceType.NUMBER_SOURCE);
        this.setCurrentDouble(d);
    }

    public CursorInput(boolean bl) {
        this._setSourceType(SourceType.BOOLEAN_SOURCE);
        this.setCurrentBoolean(bl);
    }

    public CursorInput(ValueCursor valueCursor) {
        this._valueCursor = valueCursor;
        this._setSourceType(SourceType.VALUE_SOURCE);
        this.synchronize();
    }

    public Object getCurrentValue() {
        return this._currentValue;
    }

    public String getCurrentString() {
        String string = null;
        try {
            string = (String)this.getCurrentValue();
        }
        catch (ClassCastException classCastException) {
            throw new IncorrectDataTypeException();
        }
        return string;
    }

    public Date getCurrentDate() {
        Date date = null;
        try {
            date = (Date)this.getCurrentValue();
        }
        catch (ClassCastException classCastException) {
            throw new IncorrectDataTypeException();
        }
        return date;
    }

    public short getCurrentShort() {
        Short s = null;
        try {
            s = (Short)this.getCurrentValue();
        }
        catch (ClassCastException classCastException) {
            throw new IncorrectDataTypeException();
        }
        return s;
    }

    public int getCurrentInteger() {
        Integer n = null;
        try {
            n = (Integer)this.getCurrentValue();
        }
        catch (ClassCastException classCastException) {
            throw new IncorrectDataTypeException();
        }
        return n;
    }

    public float getCurrentFloat() {
        Float f = null;
        try {
            f = (Float)this.getCurrentValue();
        }
        catch (ClassCastException classCastException) {
            throw new IncorrectDataTypeException();
        }
        return f.floatValue();
    }

    public double getCurrentDouble() {
        Double d = null;
        try {
            d = (Double)this.getCurrentValue();
        }
        catch (ClassCastException classCastException) {
            throw new IncorrectDataTypeException();
        }
        return d;
    }

    public boolean getCurrentBoolean() {
        Boolean bl = null;
        try {
            bl = (Boolean)this.getCurrentValue();
        }
        catch (ClassCastException classCastException) {
            throw new IncorrectDataTypeException();
        }
        return bl;
    }

    public void setCurrentValue(Object object) {
        if (object instanceof String) {
            this.verifySourceType(SourceType.STRING_SOURCE);
        } else if (object instanceof Date) {
            this.verifySourceType(SourceType.DATE_SOURCE);
        } else if (object instanceof Boolean) {
            this.verifySourceType(SourceType.BOOLEAN_SOURCE);
        } else if (object instanceof Short || object instanceof Integer || object instanceof Float || object instanceof Double) {
            this.verifySourceType(SourceType.NUMBER_SOURCE);
        } else {
            throw new IncorrectDataTypeException();
        }
        this._setCurrentValue(object);
    }

    public void setCurrentString(String string) {
        this.verifySourceType(SourceType.STRING_SOURCE);
        this._setCurrentValue(string);
    }

    public void setCurrentDate(Date date) {
        this.verifySourceType(SourceType.DATE_SOURCE);
        this._setCurrentValue(date);
    }

    public void setCurrentShort(short s) {
        this.verifySourceType(SourceType.NUMBER_SOURCE);
        this._setCurrentValue(new Short(s));
    }

    public void setCurrentInteger(int n) {
        this.verifySourceType(SourceType.NUMBER_SOURCE);
        this._setCurrentValue(new Integer(n));
    }

    public void setCurrentFloat(float f) {
        this.verifySourceType(SourceType.NUMBER_SOURCE);
        this._setCurrentValue(new Float(f));
    }

    public void setCurrentDouble(double d) {
        this.verifySourceType(SourceType.NUMBER_SOURCE);
        this._setCurrentValue(new Double(d));
    }

    public void setCurrentBoolean(boolean bl) {
        this.verifySourceType(SourceType.BOOLEAN_SOURCE);
        this._setCurrentValue(new Boolean(bl));
    }

    public void synchronize() {
        if (this.getValueCursor() == null) {
            return;
        }
        Object object = this.getValueCursor().getCurrentValue();
        this.setCurrentValue(object);
    }

    public final ValueCursor getValueCursor() {
        return this._valueCursor;
    }

    public final SourceType getSourceType() {
        return this._sourceType;
    }

    private void _setSourceType(SourceType sourceType) {
        this._sourceType = sourceType;
    }

    private void _setCurrentValue(Object object) {
        this._currentValue = object;
    }

    private void verifySourceType(SourceType sourceType) {
        if (this.getSourceType() != sourceType && this.getSourceType() != SourceType.VALUE_SOURCE) {
            throw new IncorrectDataTypeException();
        }
    }
}

