/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.data.full;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.olapi.data.cursor.SourceType;
import oracle.olapi.data.source.BooleanSource;
import oracle.olapi.data.source.DateSource;
import oracle.olapi.data.source.NumberSource;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.SourceDefinition;
import oracle.olapi.data.source.StringSource;
import oracle.olapi.transaction.metadataStateManager.MetadataState;

class DefinitionManagerState
implements MetadataState {
    private List fInputSourceDefinitions = null;
    private SourceType[] fInputSourceTypes = null;

    public DefinitionManagerState(Source[] sourceArray) {
        ArrayList<SourceDefinition> arrayList = new ArrayList<SourceDefinition>();
        if (null != sourceArray) {
            for (int i = 0; i < sourceArray.length; ++i) {
                arrayList.add(sourceArray[i].getDefinition());
            }
        }
        this.setInputSourceDefinitions(arrayList);
        this.calculateInputSourceTypes();
    }

    private DefinitionManagerState(List list, SourceType[] sourceTypeArray) {
        this.setInputSourceDefinitions(list);
        this.setInputSourceTypes(sourceTypeArray);
    }

    private final void calculateInputSourceTypes() {
        SourceType[] sourceTypeArray = new SourceType[this.getInputSourceDefinitions().size()];
        Iterator iterator = this.getInputSourceDefinitions().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Source source = ((SourceDefinition)iterator.next()).getSource();
            sourceTypeArray[n] = source instanceof NumberSource ? SourceType.NUMBER_SOURCE : (source instanceof StringSource ? SourceType.STRING_SOURCE : (source instanceof BooleanSource ? SourceType.BOOLEAN_SOURCE : (source instanceof DateSource ? SourceType.DATE_SOURCE : SourceType.VALUE_SOURCE)));
            ++n;
        }
        this.setInputSourceTypes(sourceTypeArray);
    }

    @Override
    public Object clone() {
        SourceType[] sourceTypeArray = null;
        if (this.getInputSourceTypes() != null) {
            sourceTypeArray = new SourceType[this.getInputSourceTypes().length];
            System.arraycopy(this.getInputSourceTypes(), 0, sourceTypeArray, 0, sourceTypeArray.length);
        }
        return new DefinitionManagerState(new ArrayList(this.getInputSourceDefinitions()), sourceTypeArray);
    }

    final List getInputSourceDefinitions() {
        return this.fInputSourceDefinitions;
    }

    final SourceType[] getInputSourceTypes() {
        return this.fInputSourceTypes;
    }

    private final void setInputSourceDefinitions(List list) {
        this.fInputSourceDefinitions = list;
    }

    private final void setInputSourceTypes(SourceType[] sourceTypeArray) {
        this.fInputSourceTypes = sourceTypeArray;
    }
}

