/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.idl.util;

import oracle.express.idl.util.InterfaceStub;
import oracle.express.idl.util.OlapiException;
import oracle.express.idl.util.OlapiStreamable;
import oracle.express.idl.util.OlapiTracer;
import oracle.sql.NUMBER;

public class BooleanHelper {
    private BooleanHelper() {
    }

    public static boolean SQL2Java(InterfaceStub interfaceStub, Integer n) {
        boolean bl = n != 0;
        OlapiTracer.log("BooleanHelper.SQL2Java: sqlboolean = " + n + ", jboolean = " + bl);
        return bl;
    }

    public static Integer Java2SQL(InterfaceStub interfaceStub, boolean bl) {
        Integer n = new Integer(bl ? 1 : 0);
        OlapiTracer.log("BooleanHelper.Java2SQL: jboolean = " + bl + ", sqlboolean = " + n);
        return n;
    }

    public static boolean SQL2Java(InterfaceStub interfaceStub, OlapiStreamable olapiStreamable) {
        OlapiTracer.enter("BooleanHelper.SQL2Java");
        boolean bl = false;
        try {
            byte[] byArray = new byte[olapiStreamable.read()];
            byte by = (byte)olapiStreamable.read();
            olapiStreamable.read(byArray);
            if (1 == by) {
                byArray[0] = (byte)(byArray[0] | 0x80);
            }
            bl = NUMBER.toBoolean((byte[])byArray);
            OlapiTracer.log("jboolean = " + bl);
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("BooleanHelper.SQL2Java");
        return bl;
    }

    public static void Java2SQL(InterfaceStub interfaceStub, OlapiStreamable olapiStreamable, boolean bl) {
        OlapiTracer.enter("BooleanHelper.Java2SQL");
        OlapiTracer.log("jboolean = " + bl);
        try {
            byte[] byArray = NUMBER.toBytes((int)(bl ? 1 : 0));
            olapiStreamable.write(byArray.length);
            if (byArray[0] >= 0) {
                olapiStreamable.write(0);
            } else {
                olapiStreamable.write(1);
                byArray[0] = (byte)(byArray[0] & 0x7F);
            }
            olapiStreamable.write(byArray);
        }
        catch (Exception exception) {
            throw new OlapiException((Object)exception);
        }
        OlapiTracer.leave("BooleanHelper.Java2SQL");
    }
}

