/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.aw;

import java.util.Date;
import java.util.StringTokenizer;

final class AWExpressionGenerator {
    final String abs(String string) {
        return this.generateFunctionExpression(string, "ABS");
    }

    final String and(String string, String string2) {
        return this.generateBinaryOpExpression(string, string2, " AND ");
    }

    final String arccos(String string) {
        return this.generateFunctionExpression(string, "ARCCOS");
    }

    final String arcsin(String string) {
        return this.generateFunctionExpression(string, "ARCSIN");
    }

    final String arctan(String string) {
        return this.generateFunctionExpression(string, "ARCTAN");
    }

    final void beginOLAPExpression(StringBuffer stringBuffer) {
        stringBuffer.append("OLAP_EXPRESSION(%view%.\"");
    }

    final String cos(String string) {
        return this.generateFunctionExpression(string, "COS");
    }

    final String cosh(String string) {
        return this.generateFunctionExpression(string, "COSH");
    }

    final String div(String string, String string2) {
        return this.generateBinaryOpExpression(string, string2, " / ");
    }

    final void endOLAPExpression(StringBuffer stringBuffer) {
        stringBuffer.append("\")");
    }

    final String eq(String string, String string2) {
        return this.generateBinaryOpExpression(string, string2, " EQ ");
    }

    final String ge(String string, String string2) {
        return this.generateBinaryOpExpression(string, string2, " GE ");
    }

    final String generateBinaryOpExpression(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append(string);
        stringBuffer.append(")");
        stringBuffer.append(string3);
        stringBuffer.append("(");
        stringBuffer.append(string2);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    final String generateConstantExpression(double d) {
        String string = Double.toString(d);
        if (string.indexOf(69) >= 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("TO_NUMBER('");
            stringBuffer.append(string);
            stringBuffer.append("')");
            string = stringBuffer.toString();
        }
        return string;
    }

    final String generateConstantExpression(float f) {
        return this.generateConstantExpression((double)f);
    }

    final String generateConstantExpression(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n);
        return stringBuffer.toString();
    }

    final String generateConstantExpression(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(l);
        return stringBuffer.toString();
    }

    final String generateConstantExpression(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 2);
        String string2 = "'\\";
        stringBuffer.append("'");
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.length() == 1 && string2.indexOf(string3) >= 0) {
                stringBuffer.append('\\');
            }
            stringBuffer.append(string3);
        }
        stringBuffer.append("'");
        return stringBuffer.toString();
    }

    final String generateConstantExpression(Date date) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(date);
        return stringBuffer.toString();
    }

    final String generateConstantExpression(short s) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(s);
        return stringBuffer.toString();
    }

    protected String generateFunctionExpression(String[] stringArray, char c, String string) {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(string);
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(i == 0 ? (char)'(' : (char)c);
                stringBuffer.append(stringArray[i]);
            }
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    protected String generateFunctionExpression(String[] stringArray, String string) {
        return this.generateFunctionExpression(stringArray, ',', string);
    }

    final String generateFunctionExpression(String string, String string2) {
        return this.generateFunctionExpression(new String[]{string}, string2);
    }

    final String generateFunctionExpression(String string, String string2, String string3) {
        return this.generateFunctionExpression(new String[]{string, string2}, string3);
    }

    final String generateFunctionExpression(String string, String string2, String string3, String string4) {
        return this.generateFunctionExpression(new String[]{string, string2, string3}, string4);
    }

    final String generateUnaryOpExpression(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        stringBuffer.append("(");
        stringBuffer.append(string);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    final String gt(String string, String string2) {
        return this.generateBinaryOpExpression(string, string2, " GT ");
    }

    final String hasValue(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(" NE NA");
        return stringBuffer.toString();
    }

    final String implies(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IF (");
        stringBuffer.append(string);
        stringBuffer.append(") THEN (");
        stringBuffer.append(string2);
        stringBuffer.append(") ELSE (");
        stringBuffer.append(string3);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    final String indexOf(String string, String string2, String string3) {
        return this.generateFunctionExpression(string, string2, string3, "FINDCHARS");
    }

    final String intpart(String string) {
        return this.generateFunctionExpression(string, "INTPART");
    }

    final String le(String string, String string2) {
        return this.generateBinaryOpExpression(string, string2, " LE ");
    }

    final String length(String string) {
        return this.generateFunctionExpression(string, "NUMCHARS");
    }

    final String like(String string, String string2) {
        return this.generateBinaryOpExpression(string, string2, " LIKE ");
    }

    final String log(String string) {
        return this.generateFunctionExpression(string, "LOG");
    }

    final String lt(String string, String string2) {
        return this.generateBinaryOpExpression(string, string2, " LT ");
    }

    final String minus(String string, String string2) {
        return this.generateBinaryOpExpression(string, string2, " - ");
    }

    final String ne(String string, String string2) {
        return this.generateBinaryOpExpression(string, string2, " NE ");
    }

    final String negate(String string) {
        return this.generateUnaryOpExpression(string, "-");
    }

    final String not(String string) {
        return this.generateUnaryOpExpression(string, "NOT ");
    }

    final String or(String string, String string2) {
        return this.generateBinaryOpExpression(string, string2, " OR ");
    }

    final String plus(String string, String string2) {
        return this.generateBinaryOpExpression(string, string2, " + ");
    }

    final String plusDays(String string, String string2) {
        return this.generateBinaryOpExpression(string, string2, " + ");
    }

    final String plusMonths(String string, String string2) {
        return this.generateFunctionExpression(string, string2, "ADDMONTHS");
    }

    final String pow(String string, String string2) {
        return this.generateBinaryOpExpression(string, string2, " ** ");
    }

    final String rem(String string, String string2) {
        return this.generateFunctionExpression(string, string2, "REM");
    }

    final String remove(String string, String string2, String string3) {
        return this.generateFunctionExpression(string, string2, string3, "REMCHARS");
    }

    final String replace(String string, String string2, String string3) {
        return this.generateFunctionExpression(string, string2, string3, "REPLCHARS");
    }

    final String round(String string, String string2) {
        return this.generateFunctionExpression(string, string2, "ROUND");
    }

    final String sin(String string) {
        return this.generateFunctionExpression(string, "SIN");
    }

    final String sinh(String string) {
        return this.generateFunctionExpression(string, "SINH");
    }

    final String sqrt(String string) {
        return this.generateFunctionExpression(string, "SQRT");
    }

    final String substring(String string, String string2, String string3) {
        return this.generateFunctionExpression(string, string2, string3, "EXTCHARS");
    }

    final String tan(String string) {
        return this.generateFunctionExpression(string, "TAN");
    }

    final String tanh(String string) {
        return this.generateFunctionExpression(string, "TANH");
    }

    final String textFill(String string, String string2) {
        return this.generateFunctionExpression(string, string2, "TEXTFILL");
    }

    final String times(String string, String string2) {
        return this.generateBinaryOpExpression(string, string2, " * ");
    }

    final String toLowercase(String string) {
        return this.generateFunctionExpression(string, "LOWCASE");
    }

    final String toUppercase(String string) {
        return this.generateFunctionExpression(string, "UPCASE");
    }

    final String trim(String string) {
        return this.generateFunctionExpression(string, "TRUE", "TRUE", "BLANKSTRIP");
    }

    final String trimLeading(String string) {
        return this.generateFunctionExpression(string, "TRUE", "FALSE", "BLANKSTRIP");
    }

    final String trimTrailing(String string) {
        return this.generateFunctionExpression(string, "FALSE", "TRUE", "BLANKSTRIP");
    }

    final String generateLagFunction(String string, int n, String string2, String string3) {
        return this.generateFunctionExpression(new String[]{string, this.generateConstantExpression(n), string2, "LEVELREL " + string3}, "LAG");
    }

    final String toInteger(String string) {
        return this.generateFunctionExpression(string, "INTEGER", "CONVERT");
    }

    final String generateFirstDimVal(String string) {
        return this.generateFunctionExpression(string, "STATFIRST");
    }

    final String generateQDR(String string, String string2, String string3) {
        if (string2 == null || string3 == null) {
            return string;
        }
        return this.generateFunctionExpression(new String[]{string, string2, string3}, ' ', "QUAL");
    }

    protected int fillArray(String[] stringArray, int n, String[] stringArray2, String[] stringArray3) {
        int n2 = 0;
        for (int i = 0; i < stringArray2.length; ++i) {
            if (stringArray2[i] == null || stringArray3[i] == null) continue;
            stringArray[n++] = stringArray2[i];
            stringArray[n++] = stringArray3[i];
            ++n2;
        }
        return n2;
    }

    final String generateQDR(String string, String[] stringArray, String[] stringArray2) {
        if (stringArray.length == 1) {
            return this.generateQDR(string, stringArray[0], stringArray2[0]);
        }
        if (string.indexOf(32) >= 0 || string.indexOf(40) >= 0) {
            String[] stringArray3 = new String[stringArray.length * 2 + 1];
            if (this.fillArray(stringArray3, 1, stringArray, stringArray2) == 0) {
                return string;
            }
            stringArray3[0] = string;
            return this.generateFunctionExpression(stringArray3, ' ', "QUAL");
        }
        String[] stringArray4 = new String[stringArray.length * 2];
        if (this.fillArray(stringArray4, 0, stringArray, stringArray2) == 0) {
            return string;
        }
        return this.generateFunctionExpression(stringArray4, ' ', string);
    }

    final String generateLimitLevelRel(String string, String string2) {
        return this.generateLimitFunction(string, "TO", "LEVELREL " + string2);
    }

    final String generateTimeArithmetic(String string, String string2, int n, String string3, String string4) {
        return this.generateTimeArithmetic(string, string2, null, n, string3, string4, null);
    }

    final String generateTimeArithmetic(String string, String string2, String string3, int n, String string4, String string5, String string6) {
        StringBuffer stringBuffer = new StringBuffer(80);
        stringBuffer.append(string);
        stringBuffer.append(" - ");
        stringBuffer.append(string2);
        if (n > 0) {
            stringBuffer.append(" + ");
            stringBuffer.append(this.generateConstantExpression(n));
        } else if (n < 0) {
            stringBuffer.append(" - ");
            stringBuffer.append(this.generateConstantExpression(-n));
        }
        return this.generateQDR(stringBuffer.toString(), string3, string6);
    }

    final String generateAddMonthsFunction(String string, int n) {
        return this.generateFunctionExpression(string, this.generateConstantExpression(n), "ADD_MONTHS");
    }

    final String generateLimitFunction(String string, String string2, String string3) {
        return this.generateFunctionExpression(new String[]{string, string2, string3}, ' ', "LIMIT");
    }

    final String generateLagDaysFunction(String string, int n, String string2, String string3, String string4, String string5, String string6, String string7) {
        String string8 = this.generateBinaryOpExpression(this.generateTimeArithmetic(string3, string4, n, string5, string6), this.generateTimeArithmetic(string3, string4, string2, 0, string5, string6, this.getValue()), "EQ");
        String string9 = this.generateFirstDimVal(this.generateLimitFunction(this.generateLimitLevelRel(string2, string7), "KEEP", string8));
        return this.setValue(string2, this.generateQDR(string, string2, string9));
    }

    final String generateLagMonthsFunction(String string, int n, String string2, String string3, String string4, String string5, String string6, String string7) {
        String string8 = this.generateBinaryOpExpression(this.generateAddMonths(this.generateTimeArithmetic(string3, string4, 1, string5, string6), n), this.generateTimeArithmetic(string3, string4, string2, 1, string5, string6, this.getValue()), "EQ");
        String string9 = this.generateFirstDimVal(this.generateLimitFunction(this.generateLimitLevelRel(string2, string7), "KEEP", string8));
        return this.setValue(string2, this.generateQDR(string, string2, string9));
    }

    public String generateCumulativeTotalFunction(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, int n) {
        CharSequence charSequence;
        String string10 = null;
        if (string5 == null) {
            string10 = this.generateLimitLevelRel(string2, string7);
        } else {
            charSequence = new StringBuffer(80);
            ((StringBuffer)charSequence).append("DESCENDANTS USING ");
            ((StringBuffer)charSequence).append(string8);
            ((StringBuffer)charSequence).append(' ');
            ((StringBuffer)charSequence).append(this.generateQDR(string9, new String[]{string6}, new String[]{this.generateConstantExpression(string5)}));
            string10 = this.generateLimitFunction(string2, "TO", ((StringBuffer)charSequence).toString());
            string10 = this.generateLimitFunction(string10, "KEEP", "LEVELREL " + string7);
        }
        charSequence = this.generateFunctionExpression(string10, string2, "-STATRANK");
        charSequence = this.generateFunctionExpression((String)charSequence, this.generateConstantExpression(0), "NAFILL");
        String string11 = this.generateFunctionExpression(new String[]{string, charSequence, this.generateConstantExpression(0), this.generateConstantExpression(1), string2, string10}, "MOVINGTOTAL");
        return string11;
    }

    public String generateMovingAverageFunction(String string, String string2, String string3, int n, int n2) {
        return this.generateFunctionExpression(new String[]{string, this.generateConstantExpression(n), this.generateConstantExpression(n2), this.generateConstantExpression(1), string2, "LEVELREL " + string3}, "MOVINGAVERAGE");
    }

    public String generateAddMonths(String string, int n) {
        return this.generateFunctionExpression(string, this.generateConstantExpression(n), "ADD_MONTHS");
    }

    public String getValue() {
        return "__AWG.SAVED.DIMVAL";
    }

    public String setValue(String string, String string2) {
        return this.generateFunctionExpression(this.generateFunctionExpression(this.toInteger(string), "__AWG.STOREVAL"), string2, "NAFILL");
    }
}

