/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.weblogic;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.core.ojdl.logging.LogUtil;
import oracle.core.ojdl.logging.config.ServerLoggingConfiguration;
import oracle.core.ojdl.logging.context.LoggingContextManager;
import oracle.core.ojdl.messages.Messages;
import oracle.core.ojdl.weblogic.WLSLoggingContextProvider;

public class ODLConfiguration {
    public static final String CONFIG_DIR = "config" + File.separator + "fmwconfig" + File.separator + "servers";
    public static final String CONFIG_FILE = "logging.xml";

    public static void main(String[] args) {
        String serverName = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String serverName = System.getProperty("weblogic.Name");
                if (serverName != null && serverName.length() > 0) {
                    System.setProperty("oracle.core.ojdl.logging.componentId", serverName);
                }
                String APP_CTX_PROVIDER = "oracle.core.ojdl.logging.applicationcontextprovider";
                if (System.getProperty("oracle.core.ojdl.logging.applicationcontextprovider") == null) {
                    System.setProperty("oracle.core.ojdl.logging.applicationcontextprovider", "oracle.core.ojdl.logging.WlsApplicationContextImpl");
                }
                String USR_CTX_PROVIDER = "oracle.core.ojdl.logging.usercontextprovider";
                if (System.getProperty("oracle.core.ojdl.logging.usercontextprovider") == null) {
                    System.setProperty("oracle.core.ojdl.logging.usercontextprovider", "oracle.core.ojdl.logging.WlsUserContextImpl");
                }
                return serverName;
            }
        });
        LoggingContextManager.setDefaultLoggingContextProvider(new WLSLoggingContextProvider());
        Logger logger = Logger.getLogger("oracle.odl", Messages.class.getName());
        File f = new File(CONFIG_DIR + File.separator + serverName + File.separator + CONFIG_FILE);
        File alternateFile = new File("config/logging.xml");
        if (!f.exists() && alternateFile.exists()) {
            logger.log(Level.WARNING, "Default logging configuration file '" + f.getAbsolutePath() + "' not found.");
            f = alternateFile;
        }
        String path = f.getAbsolutePath();
        logger.log(Level.CONFIG, "ODL-52080", path);
        boolean removeDefaultConsoleHandler = System.getProperty("oracle.core.ojdl.logging.removeDefaultConsoleHandler", "true").equals("true");
        Logger root = Logger.getLogger("");
        Handler consoleHandler = null;
        if (removeDefaultConsoleHandler) {
            for (Handler h : root.getHandlers()) {
                if (!ConsoleHandler.class.getName().equals(h.getClass().getName())) continue;
                consoleHandler = h;
            }
        }
        Properties env = new Properties();
        String domainHome = System.getProperty("domain.home");
        if (domainHome != null && domainHome.length() > 0 && serverName != null && serverName.length() > 0) {
            env.setProperty("SERVER_LOG_ROOT", domainHome + File.separator + "servers" + File.separator + serverName + File.separator + "logs");
            env.setProperty("SERVER_NAME", serverName);
        }
        try {
            ServerLoggingConfiguration.readConfiguration(path, env);
            if (consoleHandler != null) {
                root.removeHandler(consoleHandler);
                consoleHandler.close();
            }
        }
        catch (Exception e) {
            LogUtil.log(logger, Level.WARNING, "ODL-52081", new Object[]{path, e}, (Throwable)e);
        }
        try {
            Class<?> logDump = Class.forName("oracle.as.management.logging.tools.LogDump");
            logDump.getDeclaredMethod("init", String.class, String.class).invoke(null, domainHome, serverName);
            Class<?> activeLogConfigDump = Class.forName("oracle.as.management.logging.tools.ActiveLogConfigDump");
            activeLogConfigDump.getDeclaredMethod("init", new Class[0]).invoke(null, new Object[0]);
            Class<?> quickTraceDump = Class.forName("oracle.as.management.logging.tools.QuickTraceDump");
            quickTraceDump.getDeclaredMethod("init", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            LogUtil.log(logger, Level.WARNING, "ODL-52083", new Object[]{e.toString()}, (Throwable)e);
        }
    }
}

