/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.util;

import java.io.IOException;

public class XMLUtil {
    public static void escapeXMLchars(String str, Appendable sb) {
        try {
            if (str == null) {
                return;
            }
            int k = 0;
            int i = 0;
            int len = str.length();
            while (i < len) {
                char ch;
                if ((ch = str.charAt(i++)) == '&') {
                    sb.append(str, k, i - 1);
                    k = i;
                    sb.append("&amp;");
                    continue;
                }
                if (ch == '<') {
                    sb.append(str, k, i - 1);
                    k = i;
                    sb.append("&lt;");
                    continue;
                }
                if (ch >= ' ' || ch == '\n' || ch == '\r' || ch == '\t') continue;
                sb.append(str, k, i - 1);
                k = i;
                sb.append("&#");
                sb.append(Integer.toString(ch));
                sb.append(';');
            }
            if (k == 0) {
                sb.append(str);
            } else if (k < i) {
                sb.append(str, k, i);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void escapeAttrChars(String str, Appendable sb) {
        try {
            if (str == null) {
                return;
            }
            int k = 0;
            int i = 0;
            int len = str.length();
            while (i < len) {
                char ch;
                if ((ch = str.charAt(i++)) == '\'') {
                    sb.append(str, k, i - 1);
                    k = i;
                    sb.append("&apos;");
                    continue;
                }
                if (ch == '&') {
                    sb.append(str, k, i - 1);
                    k = i;
                    sb.append("&amp;");
                    continue;
                }
                if (ch == '<') {
                    sb.append(str, k, i - 1);
                    k = i;
                    sb.append("&lt;");
                    continue;
                }
                if (ch >= ' ' || ch == '\n' || ch == '\r' || ch == '\t') continue;
                sb.append(str, k, i - 1);
                k = i;
                sb.append("&#");
                sb.append(Integer.toString(ch));
                sb.append(';');
            }
            if (k == 0) {
                sb.append(str);
            } else if (k < i) {
                sb.append(str, k, i);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

