/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.logging.impl;

import java.util.ResourceBundle;
import java.util.WeakHashMap;
import oracle.core.ojdl.logging.MessageIdKeyResourceBundle;
import oracle.core.ojdl.logging.MessageIdResourceBundle;

public class MessageIdSupport {
    private WeakHashMap m_bundles = new WeakHashMap();
    private static final Object MSG_ID_KEY_BUNDLE = new Object();
    private static final Object MSG_ID_SUFFIX_BUNDLE = new Object();
    private static final Object UNMARKED_BUNDLE = new Object();
    private static final String MSG_ID_SUFFIX_MARKER = "oracle.core.ojdl.logging.MessageIdSuffixResourceBundle";
    private static final String MSG_ID_KEY_MARKER = "oracle.core.ojdl.logging.MessageIdKeyResourceBundle";
    private static final String MARKER_FIELD = "ORACLE_LOGGING_MSG_ID_KEY_BUNDLE";
    private static final String MSG_ID_SUFFIX = ".MSGID";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessageId(ResourceBundle bundle, String key) {
        Object bt;
        if (bundle == null) {
            return null;
        }
        if (bundle instanceof MessageIdKeyResourceBundle) {
            return key;
        }
        if (bundle instanceof MessageIdResourceBundle) {
            try {
                return ((MessageIdResourceBundle)((Object)bundle)).getMessageId(key);
            }
            catch (Exception e1) {
                return null;
            }
        }
        WeakHashMap weakHashMap = this.m_bundles;
        synchronized (weakHashMap) {
            bt = this.m_bundles.get(bundle);
            if (bt == null) {
                try {
                    bundle.getString(MSG_ID_KEY_MARKER);
                    bt = MSG_ID_KEY_BUNDLE;
                }
                catch (Exception e1) {
                    try {
                        bundle.getString(MSG_ID_SUFFIX_MARKER);
                        bt = MSG_ID_SUFFIX_BUNDLE;
                    }
                    catch (Exception e2) {
                        Class<?> cl = bundle.getClass();
                        try {
                            cl.getDeclaredField(MARKER_FIELD);
                            bt = MSG_ID_KEY_BUNDLE;
                        }
                        catch (NoSuchFieldException e3) {
                            bt = UNMARKED_BUNDLE;
                        }
                    }
                    this.m_bundles.put(bundle, bt);
                }
            }
        }
        if (bt == MSG_ID_KEY_BUNDLE) {
            return key;
        }
        if (bt == MSG_ID_SUFFIX_BUNDLE) {
            try {
                return bundle.getString(key + MSG_ID_SUFFIX);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }
}

