/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.logging.config;

import java.io.File;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import oracle.core.ojdl.logging.LoggingConfigurationException;
import oracle.core.ojdl.logging.impl.LoggingConfigurationImpl;
import oracle.core.ojdl.messages.Messages;
import org.w3c.dom.Document;

public class ServerLoggingConfiguration
extends LoggingConfigurationImpl {
    private static ServerLoggingConfiguration s_config;
    private static String s_path;

    private ServerLoggingConfiguration(String filename, Properties env) throws LoggingConfigurationException {
        super(filename, env);
    }

    private ServerLoggingConfiguration(Document doc) throws LoggingConfigurationException {
        super(doc);
    }

    public static void readConfiguration(String filename) throws LoggingConfigurationException {
        ServerLoggingConfiguration.readConfiguration(filename, null);
    }

    public static void readConfiguration(String filename, Properties env) throws LoggingConfigurationException {
        String cp = ServerLoggingConfiguration.getCanonicalPath(filename);
        if (s_path != null) {
            if (!s_path.equals(cp)) {
                Logger.getLogger("oracle.odl", Messages.class.getName()).log(Level.SEVERE, "ODL-52087", new Object[]{s_path, cp});
            }
        } else {
            s_path = cp;
        }
        if (s_config == null) {
            s_config = new ServerLoggingConfiguration(filename, env);
            LogManager.getLogManager().addPropertyChangeListener(s_config);
        } else {
            s_config.reload(filename);
        }
    }

    public static void readConfiguration(Document document) throws LoggingConfigurationException {
        if (s_path != null) {
            Logger.getLogger("oracle.odl", Messages.class.getName()).log(Level.SEVERE, "ODL-52087", new Object[]{s_path, ""});
        }
        ServerLoggingConfiguration.resetConfig();
        s_config = new ServerLoggingConfiguration(document);
        LogManager.getLogManager().addPropertyChangeListener(s_config);
    }

    public static void resetConfig() {
        if (s_config != null) {
            s_config.reset();
            LogManager.getLogManager().removePropertyChangeListener(s_config);
        }
    }

    public static Properties getHandlerDefaults() {
        Properties handlerDefaults = s_config == null ? new Properties() : s_config.getCachedHandlerDefaults();
        return handlerDefaults;
    }

    private static String getCanonicalPath(String path) {
        File f = new File(path);
        try {
            return f.getCanonicalPath();
        }
        catch (Exception e) {
            return f.getAbsolutePath();
        }
    }
}

