/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.logging;

import java.security.AccessController;
import java.security.PrivilegedAction;
import oracle.core.ojdl.logging.context.ApplicationContext;
import weblogic.utils.classloaders.Annotation;
import weblogic.utils.classloaders.GenericClassLoader;

class WlsApplicationContextImpl
implements ApplicationContext {
    WlsApplicationContextImpl() {
    }

    @Override
    public String getApplicationName() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return this._getApplicationName();
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return WlsApplicationContextImpl.this._getApplicationName();
            }
        });
    }

    private String _getApplicationName() {
        try {
            for (ClassLoader cl = Thread.currentThread().getContextClassLoader(); cl != null; cl = cl.getParent()) {
                Annotation a;
                if (!(cl instanceof GenericClassLoader) || (a = ((GenericClassLoader)cl).getAnnotation()) == null) continue;
                return a.getApplicationName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

