/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.logging;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import oracle.core.ojdl.BufferedLogWriter;
import oracle.core.ojdl.ExceptionHandler;
import oracle.core.ojdl.FileLogWriter;
import oracle.core.ojdl.LogFormatter;
import oracle.core.ojdl.LogMessage;
import oracle.core.ojdl.LogWriter;
import oracle.core.ojdl.LogWriterException;
import oracle.core.ojdl.ODL11Formatter;
import oracle.core.ojdl.ODLTextFormatter;
import oracle.core.ojdl.RotationSupport;
import oracle.core.ojdl.XMLFormatter;
import oracle.core.ojdl.logging.ODLFormatter;
import oracle.core.ojdl.logging.ODLHandlerBase;
import oracle.core.ojdl.logging.ODLHandlerException;
import oracle.core.ojdl.logging.ODLLevel;
import oracle.core.ojdl.messages.Msgs;

public class ODLHandler
extends ODLHandlerBase {
    private static String PROP_PREFIX = "oracle.core.ojdl.logging.ODLHandler";
    private static String SUPPL_ATTRS_PROP = PROP_PREFIX + ".supplementalAttributes";
    private static String USE_SRCMET_PROP = PROP_PREFIX + ".useSourceClassAndMethod";
    private static String USE_DEF_ATTRS_PROP = PROP_PREFIX + ".useDefaultAttributes";
    private static String INCLUDE_MSG_ARGS_PROP = PROP_PREFIX + ".includeMessageArguments";
    private LogWriter m_logWriter;
    private ODLFormatter m_formatter;
    private Level m_autoFlushLevel = ODLLevel.NOTIFICATION;
    private String m_name;
    ThreadLocal<RecursionCounter> m_recursionCounter = new ThreadLocal<RecursionCounter>(){

        @Override
        protected RecursionCounter initialValue() {
            return new RecursionCounter();
        }
    };
    private static final String PREFIX = ODLHandler.class.getName() + ".";
    private final int m_maxRecursionDepth;
    private final int m_maxInternalRecursionDepth;

    public ODLHandler(String logDirectory, long maxFileSize, long maxLogSize, String encoding) throws ODLHandlerException {
        this(new ODLTextFormatter(), logDirectory, maxFileSize, maxLogSize, encoding);
    }

    public ODLHandler(LogFormatter formatter, String path, long maxFileSize, long maxLogSize, String encoding) throws ODLHandlerException {
        String[] values = ODLHandler.getSystemProperties(new String[]{"maxRecursionDepth", "maxInternalRecursionDepth"});
        this.m_maxRecursionDepth = values[0] == null ? 2 : Integer.parseInt(values[0]);
        this.m_maxInternalRecursionDepth = values[1] == null ? 0 : Integer.parseInt(values[1]);
        this.init(formatter, path, maxFileSize, maxLogSize, encoding);
    }

    ODLHandler(LogFormatter formatter) throws ODLHandlerException {
        String[] values = ODLHandler.getSystemProperties(new String[]{"maxRecursionDepth", "maxInternalRecursionDepth"});
        this.m_maxRecursionDepth = values[0] == null ? 2 : Integer.parseInt(values[0]);
        this.m_maxInternalRecursionDepth = values[1] == null ? 0 : Integer.parseInt(values[1]);
        this.m_rwLock.writeLock().lock();
        try {
            this.m_formatter = new ODLFormatter(formatter);
            this.initProperties();
        }
        catch (Exception e) {
            throw new ODLHandlerException(e);
        }
        finally {
            this.m_rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init(LogFormatter formatter, String path, long maxFileSize, long maxLogSize, String encoding) throws ODLHandlerException {
        this.m_rwLock.writeLock().lock();
        try {
            if (this.m_logWriter != null) {
                this.m_logWriter.close();
                this.m_logWriter = null;
            }
            File f = new File(path);
            String defaultFilename = null;
            if (formatter instanceof ODLTextFormatter) {
                defaultFilename = "diagnostic.log";
            } else if (formatter instanceof ODL11Formatter || formatter instanceof XMLFormatter) {
                defaultFilename = "log.xml";
            }
            this.m_formatter = new ODLFormatter(formatter);
            Class<FileLogWriter> clazz = FileLogWriter.class;
            synchronized (FileLogWriter.class) {
                String filename = defaultFilename != null && (f.isDirectory() || !f.exists() && (path.length() <= 4 || path.charAt(path.length() - 4) != '.')) ? new File(f, defaultFilename).getAbsolutePath() : path;
                this.m_logWriter = FileLogWriter.create(formatter, filename, true, maxFileSize, maxLogSize, encoding);
                // ** MonitorExit[var11_8] (shouldn't be in output)
                this.m_logWriter.setExceptionHandler(new ExceptionHandler(true));
                this.setEncoding(encoding);
                this.initProperties();
            }
        }
        catch (Exception e) {
            throw new ODLHandlerException(e);
        }
        finally {
            this.m_rwLock.writeLock().unlock();
        }
        {
            return;
        }
    }

    ODLFormatter getODLFormatter() {
        return this.m_formatter;
    }

    public ODLHandler(String logDirectory, long maxFileSize, long maxLogSize) throws ODLHandlerException {
        this(logDirectory, maxFileSize, maxLogSize, null);
    }

    public ODLHandler(String logDirectory, long maxFileSize) throws ODLHandlerException {
        this(logDirectory, maxFileSize, Long.MAX_VALUE, null);
    }

    public ODLHandler(String logDirectory) throws ODLHandlerException {
        this(logDirectory, Long.MAX_VALUE, Long.MAX_VALUE, null);
    }

    public ODLHandler(String logDirectory, String encoding) throws ODLHandlerException {
        this(logDirectory, Long.MAX_VALUE, Long.MAX_VALUE, encoding);
    }

    public ODLHandler(LogFormatter formatter, String filename, String encoding) throws ODLHandlerException {
        this(formatter, filename, Long.MAX_VALUE, Long.MAX_VALUE, encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFormat() {
        this.m_rwLock.readLock().lock();
        try {
            String string = this.m_formatter.getFormat();
            return string;
        }
        finally {
            this.m_rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPath() {
        this.m_rwLock.readLock().lock();
        try {
            String string = ((FileLogWriter)this.m_logWriter).getPath();
            return string;
        }
        finally {
            this.m_rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxFileSize(long sizeInBytes) {
        this.m_rwLock.writeLock().lock();
        try {
            ((RotationSupport)((Object)this.m_logWriter)).setMaxSegmentSize(sizeInBytes);
        }
        finally {
            this.m_rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaxFileSize() {
        this.m_rwLock.readLock().lock();
        try {
            long l = ((RotationSupport)((Object)this.m_logWriter)).getMaxSegmentSize();
            return l;
        }
        finally {
            this.m_rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxLogSize(long sizeInBytes) {
        this.m_rwLock.writeLock().lock();
        try {
            ((RotationSupport)((Object)this.m_logWriter)).setMaxSize(sizeInBytes);
        }
        finally {
            this.m_rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaxLogSize() {
        this.m_rwLock.readLock().lock();
        try {
            long l = ((RotationSupport)((Object)this.m_logWriter)).getMaxSize();
            return l;
        }
        finally {
            this.m_rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBaseRotationTime(long baseTime) {
        this.m_rwLock.writeLock().lock();
        try {
            ((RotationSupport)((Object)this.m_logWriter)).setBaseRotationTime(baseTime);
        }
        finally {
            this.m_rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBaseRotationTime() {
        this.m_rwLock.readLock().lock();
        try {
            long l = ((RotationSupport)((Object)this.m_logWriter)).getBaseRotationTime();
            return l;
        }
        finally {
            this.m_rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRotationFrequency(int frequency) {
        this.m_rwLock.writeLock().lock();
        try {
            ((RotationSupport)((Object)this.m_logWriter)).setRotationFrequency(frequency);
        }
        finally {
            this.m_rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRotationFrequency() {
        this.m_rwLock.readLock().lock();
        try {
            int n = ((RotationSupport)((Object)this.m_logWriter)).getRotationFrequency();
            return n;
        }
        finally {
            this.m_rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRetentionPeriod(int retentionPeriod) {
        this.m_rwLock.writeLock().lock();
        try {
            ((RotationSupport)((Object)this.m_logWriter)).setRetentionPeriod(retentionPeriod);
        }
        finally {
            this.m_rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRetentionPeriod() {
        this.m_rwLock.readLock().lock();
        try {
            int n = ((RotationSupport)((Object)this.m_logWriter)).getRetentionPeriod();
            return n;
        }
        finally {
            this.m_rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKeepOpen(boolean keepOpen) {
        this.m_rwLock.writeLock().lock();
        try {
            ((RotationSupport)((Object)this.m_logWriter)).setKeepOpen(keepOpen);
        }
        finally {
            this.m_rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getKeepOpen() {
        this.m_rwLock.readLock().lock();
        try {
            boolean bl = ((RotationSupport)((Object)this.m_logWriter)).getKeepOpen();
            return bl;
        }
        finally {
            this.m_rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeleteFiles(boolean deleteFiles) {
        this.m_rwLock.writeLock().lock();
        try {
            ((RotationSupport)((Object)this.m_logWriter)).setDeleteFiles(deleteFiles);
        }
        finally {
            this.m_rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getDeleteFiles() {
        this.m_rwLock.readLock().lock();
        try {
            boolean bl = ((RotationSupport)((Object)this.m_logWriter)).getDeleteFiles();
            return bl;
        }
        finally {
            this.m_rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getLockMode() {
        this.m_rwLock.readLock().lock();
        try {
            boolean bl = ((RotationSupport)((Object)this.m_logWriter)).getLockMode();
            return bl;
        }
        finally {
            this.m_rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLockMode(boolean lockMode) {
        this.m_rwLock.writeLock().lock();
        try {
            ((RotationSupport)((Object)this.m_logWriter)).setLockMode(lockMode);
        }
        finally {
            this.m_rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLockTimeOut() {
        this.m_rwLock.readLock().lock();
        try {
            long l = ((RotationSupport)((Object)this.m_logWriter)).getLockTimeOut();
            return l;
        }
        finally {
            this.m_rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLockTimeOut(long time) {
        this.m_rwLock.writeLock().lock();
        try {
            ((RotationSupport)((Object)this.m_logWriter)).setLockTimeOut(time);
        }
        finally {
            this.m_rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBaseEncoding(String encoding) throws UnsupportedEncodingException {
        this.m_rwLock.writeLock().lock();
        try {
            super.setEncoding(encoding);
        }
        finally {
            this.m_rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEncoding(String encoding) throws UnsupportedEncodingException {
        this.m_rwLock.writeLock().lock();
        try {
            super.setEncoding(encoding);
            try {
                ((BufferedLogWriter)this.m_logWriter).setEncoding(this.getEncoding());
            }
            catch (LogWriterException e) {
                throw new UnsupportedEncodingException(encoding);
            }
        }
        finally {
            this.m_rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.m_rwLock.writeLock().lock();
        try {
            if (this.m_logWriter == null) {
                return;
            }
            try {
                this.m_logWriter.close();
            }
            catch (Exception e) {
                this.reportError("", e, 3);
            }
            this.m_logWriter = null;
        }
        finally {
            this.m_rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        this.m_rwLock.readLock().lock();
        try {
            if (this.m_logWriter == null) {
                return;
            }
            try {
                this.m_logWriter.flush();
            }
            catch (Exception e) {
                this.reportError("", e, 2);
            }
        }
        finally {
            this.m_rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord rec) {
        RecursionCounter counter = this.m_recursionCounter.get();
        if (!counter.isLoggable()) {
            if (!counter.isInternalCtx()) {
                this.reportError(Msgs.get("ODL-52029", this.m_maxRecursionDepth), null, 0);
            }
            return;
        }
        try {
            counter.enter();
            this.publish(rec, counter);
        }
        finally {
            counter.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void publish(LogRecord rec, RecursionCounter counter) {
        this.m_rwLock.readLock().lock();
        try {
            LogMessage msg;
            if (this.m_logWriter == null || !this.isLoggable(rec)) {
                return;
            }
            try {
                msg = this.m_formatter.toLogMessage(rec, counter);
            }
            catch (Exception e) {
                this.reportError("", e, 5);
                this.m_rwLock.readLock().unlock();
                return;
            }
            try {
                if (this.m_logWriter != null) {
                    this.m_logWriter.write(msg);
                }
            }
            catch (Exception e) {
                this.reportError("", e, 1);
            }
            if (rec.getLevel().intValue() >= this.m_autoFlushLevel.intValue()) {
                this.flush();
            }
        }
        finally {
            this.m_rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoFlushLevel(Level level) {
        this.m_rwLock.writeLock().lock();
        try {
            this.m_autoFlushLevel = level;
        }
        finally {
            this.m_rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Level getAutoFlushLevel() {
        this.m_rwLock.readLock().lock();
        try {
            Level level = this.m_autoFlushLevel;
            return level;
        }
        finally {
            this.m_rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSupplementalAttributes(String[] attrNames) {
        this.m_rwLock.writeLock().lock();
        try {
            this.m_formatter.setSupplementalAttributes(attrNames);
        }
        finally {
            this.m_rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSupplementalAttributes() {
        this.m_rwLock.readLock().lock();
        try {
            String[] stringArray = this.m_formatter.getSupplementalAttributes();
            return stringArray;
        }
        finally {
            this.m_rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUseSourceClassAndMethod(boolean useSrcClassAndMethod) {
        this.m_rwLock.writeLock().lock();
        try {
            this.m_formatter.setUseSourceClassAndMethod(useSrcClassAndMethod);
        }
        finally {
            this.m_rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUseSourceClassAndMethod(Level level) {
        this.m_rwLock.writeLock().lock();
        try {
            this.m_formatter.setUseSourceClassAndMethod(level);
        }
        finally {
            this.m_rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getUseSourceClassAndMethod() {
        this.m_rwLock.readLock().lock();
        try {
            boolean bl = this.m_formatter.getUseSourceClassAndMethod();
            return bl;
        }
        finally {
            this.m_rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Level getUseSourceClassAndMethodLevel() {
        this.m_rwLock.readLock().lock();
        try {
            Level level = this.m_formatter.getUseSourceClassAndMethodLevel();
            return level;
        }
        finally {
            this.m_rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUseDefaultAttributes(boolean useDefaultAttributes) {
        this.m_rwLock.writeLock().lock();
        try {
            this.m_formatter.setUseDefaultAttributes(useDefaultAttributes);
        }
        finally {
            this.m_rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getUseDefaultAttributes() {
        this.m_rwLock.readLock().lock();
        try {
            boolean bl = this.m_formatter.getUseDefaultAttributes();
            return bl;
        }
        finally {
            this.m_rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIncludeMessageArguments(boolean includeMessageArguments) {
        this.m_rwLock.writeLock().lock();
        try {
            this.m_formatter.setIncludeMessageArguments(includeMessageArguments);
        }
        finally {
            this.m_rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getIncludeMessageArguments() {
        this.m_rwLock.readLock().lock();
        try {
            boolean bl = this.m_formatter.getIncludeMessageArguments();
            return bl;
        }
        finally {
            this.m_rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIncludeMessageArgumentsLevel(Level includeMessageArgumentsLevel) {
        this.m_rwLock.writeLock().lock();
        try {
            this.m_formatter.setIncludeMessageArgumentsLevel(includeMessageArgumentsLevel);
        }
        finally {
            this.m_rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Level getIncludeMessageArgumentsLevel() {
        this.m_rwLock.readLock().lock();
        try {
            Level level = this.m_formatter.getIncludeMessageArgumentsLevel();
            return level;
        }
        finally {
            this.m_rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUseThreadName(boolean useThreadName) {
        this.m_rwLock.writeLock().lock();
        try {
            this.m_formatter.setUseThreadName(useThreadName);
        }
        finally {
            this.m_rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getUseThreadName() {
        this.m_rwLock.readLock().lock();
        try {
            boolean bl = this.m_formatter.getUseThreadName();
            return bl;
        }
        finally {
            this.m_rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUseRealThreadId(boolean useRealThreadId) {
        this.m_rwLock.writeLock().lock();
        try {
            this.m_formatter.setUseRealThreadId(useRealThreadId);
        }
        finally {
            this.m_rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getUseRealThreadId() {
        this.m_rwLock.readLock().lock();
        try {
            boolean bl = this.m_formatter.getUseRealThreadId();
            return bl;
        }
        finally {
            this.m_rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setApplicationContextProvider(String appCtx) {
        this.m_rwLock.writeLock().lock();
        try {
            this.m_formatter.setApplicationContextProvider(appCtx);
        }
        finally {
            this.m_rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getApplicationContextProvider() {
        this.m_rwLock.readLock().lock();
        try {
            String string = this.m_formatter.getApplicationContextProvider();
            return string;
        }
        finally {
            this.m_rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserContextProvider(String userCtx) {
        this.m_rwLock.writeLock().lock();
        try {
            this.m_formatter.setUserContextProvider(userCtx);
        }
        finally {
            this.m_rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserContextProvider() {
        this.m_rwLock.readLock().lock();
        try {
            String string = this.m_formatter.getUserContextProvider();
            return string;
        }
        finally {
            this.m_rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocale(Locale locale) {
        this.m_rwLock.writeLock().lock();
        try {
            this.m_formatter.setLocale(locale);
        }
        finally {
            this.m_rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Locale getLocale() {
        this.m_rwLock.readLock().lock();
        try {
            Locale locale = this.m_formatter.getLocale();
            return locale;
        }
        finally {
            this.m_rwLock.readLock().unlock();
        }
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    LogMessage toLogMessage(LogRecord rec, RecursionCounter recursionCounter) {
        return this.m_formatter.toLogMessage(rec, recursionCounter);
    }

    private void initProperties() {
        HashMap props = (HashMap)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                HashMap<String, String> props = new HashMap<String, String>(4);
                props.put(SUPPL_ATTRS_PROP, System.getProperty(SUPPL_ATTRS_PROP));
                props.put(USE_SRCMET_PROP, System.getProperty(USE_SRCMET_PROP));
                props.put(USE_DEF_ATTRS_PROP, System.getProperty(USE_DEF_ATTRS_PROP));
                props.put(INCLUDE_MSG_ARGS_PROP, System.getProperty(INCLUDE_MSG_ARGS_PROP));
                return props;
            }
        });
        String s = this.getProperty(SUPPL_ATTRS_PROP, props);
        if (s != null) {
            this.setSupplementalAttributes(ODLHandler.parseAttrList(s));
        }
        if ((s = this.getProperty(USE_SRCMET_PROP, props)) != null) {
            this.setUseSourceClassAndMethod(s.equalsIgnoreCase("true"));
        }
        if ((s = this.getProperty(USE_DEF_ATTRS_PROP, props)) != null) {
            this.setUseDefaultAttributes(s.equalsIgnoreCase("true"));
        }
        if ((s = this.getProperty(INCLUDE_MSG_ARGS_PROP, props)) != null) {
            this.setIncludeMessageArguments(s.equalsIgnoreCase("true"));
        }
    }

    private String getProperty(String key, HashMap<String, String> props) {
        String s = props.get(key);
        if (s == null) {
            s = LogManager.getLogManager().getProperty(key);
        }
        return s;
    }

    static String[] parseAttrList(String s) {
        StringTokenizer st = new StringTokenizer(s, ",");
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            tokens.add(st.nextToken().trim());
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    private static String[] getSystemProperties(final String[] names) {
        return AccessController.doPrivileged(new PrivilegedAction<String[]>(){

            @Override
            public String[] run() {
                String[] values = new String[names.length];
                for (int i = 0; i < names.length; ++i) {
                    values[i] = System.getProperty(PREFIX + names[i]);
                }
                return values;
            }
        });
    }

    final class RecursionCounter {
        private int count = 0;
        private int ctxCount = 0;

        RecursionCounter() {
        }

        void enter() {
            ++this.count;
        }

        void exit() {
            --this.count;
        }

        boolean enterInternalCtx() {
            ++this.ctxCount;
            return this.ctxCount > 1;
        }

        void exitInternalCtx() {
            --this.ctxCount;
        }

        boolean isLoggable() {
            return this.count <= ODLHandler.this.m_maxRecursionDepth && this.ctxCount <= ODLHandler.this.m_maxInternalRecursionDepth;
        }

        boolean isInternalCtx() {
            return this.ctxCount > 0;
        }
    }
}

