/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.logging;

import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public abstract class LogUtil {
    public static void log(Logger logger, Level level, String msg, Object[] args, Throwable t) {
        if (!logger.isLoggable(level)) {
            return;
        }
        LogRecord rec = new LogRecord(level, msg);
        rec.setLoggerName(logger.getName());
        rec.setParameters(args);
        rec.setResourceBundle(logger.getResourceBundle());
        rec.setResourceBundleName(logger.getResourceBundleName());
        rec.setThrown(t);
        logger.log(rec);
    }

    public static void log(Logger logger, Level level, String msg, Object arg, Throwable t) {
        LogUtil.log(logger, level, msg, new Object[]{arg}, t);
    }

    public static void logp(Logger logger, Level level, String srcClass, String srcMethod, String msg, Object[] args, Throwable t) {
        if (!logger.isLoggable(level)) {
            return;
        }
        LogRecord rec = new LogRecord(level, msg);
        rec.setLoggerName(logger.getName());
        rec.setParameters(args);
        rec.setResourceBundle(logger.getResourceBundle());
        rec.setResourceBundleName(logger.getResourceBundleName());
        rec.setSourceClassName(srcClass);
        rec.setSourceMethodName(srcMethod);
        rec.setThrown(t);
        logger.log(rec);
    }

    public static void logrb(Logger logger, Level level, String srcClass, String srcMethod, String bundleName, String msg, Object[] args, Throwable t) {
        if (!logger.isLoggable(level)) {
            return;
        }
        LogRecord rec = new LogRecord(level, msg);
        rec.setLoggerName(logger.getName());
        rec.setParameters(args);
        rec.setResourceBundle(LogUtil.getResourceBundle(bundleName));
        rec.setResourceBundleName(bundleName);
        rec.setSourceClassName(srcClass);
        rec.setSourceMethodName(srcMethod);
        rec.setThrown(t);
        logger.log(rec);
    }

    private static ResourceBundle getResourceBundle(String resourceBundleName) {
        if (resourceBundleName == null) {
            return null;
        }
        Locale loc = Locale.getDefault();
        Object rb = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null) {
            try {
                return ResourceBundle.getBundle(resourceBundleName, loc, cl);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            return ResourceBundle.getBundle(resourceBundleName, loc, ClassLoader.getSystemClassLoader());
        }
        catch (Exception e) {
            return null;
        }
    }
}

