/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.management.tracing.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import oracle.as.management.tracing.impl.LoggerFactory;
import oracle.as.management.tracing.impl.WM_MBeanInvoker;
import oracle.dms.context.ExecutionContext;

class MBeanInvoker {
    private static Logger s_logger = LoggerFactory.getLogger();

    public static MBeanInvoker newInstance() {
        try {
            Class<?> wmClass = Class.forName("commonj.work.WorkManager");
            InitialContext ctx = new InitialContext();
            Object wm = ctx.lookup("java:comp/env/wm/default");
            if (wm != null && wmClass.isAssignableFrom(wm.getClass())) {
                return new WM_MBeanInvoker(wm);
            }
        }
        catch (Throwable t) {
            s_logger.log(Level.FINE, "Unable to find default WorkManager instance. Using default MBeanInvoker implementation", t);
        }
        return new MBeanInvoker();
    }

    protected MBeanInvoker() {
    }

    public List<Result> invoke(MBeanServer mbs, List<ObjectName> targets, String opName, Object[] params, String[] signature) throws Exception {
        ArrayList<Worker> workers = new ArrayList<Worker>(targets.size());
        for (ObjectName target : targets) {
            workers.add(new Worker(mbs, target, opName, params, signature));
        }
        if (s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, this.getClass().getName(), "invoke", "Invoking operation " + opName + " on " + targets.size() + " targets");
        }
        return this.invokeAll(workers);
    }

    protected List<Result> invokeAll(List<Worker> workers) throws Exception {
        ArrayList<Result> results = new ArrayList<Result>(workers.size());
        for (Worker worker : workers) {
            results.add(worker.call());
        }
        return results;
    }

    protected static class Worker
    implements Runnable,
    Callable<Result> {
        private final MBeanServer m_mbs;
        private final ObjectName m_target;
        private final String m_opName;
        private final Object[] m_params;
        private final String[] m_signature;
        private String m_wrappedCtx;
        private Result m_result;

        Worker(MBeanServer mbs, ObjectName target, String opName, Object[] params, String[] signature) {
            this.m_mbs = mbs;
            this.m_target = target;
            this.m_opName = opName;
            this.m_params = params;
            this.m_signature = signature;
        }

        void setContext(String wrappedCtx) {
            this.m_wrappedCtx = wrappedCtx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object opResult = null;
            Exception opException = null;
            try {
                if (this.m_wrappedCtx != null) {
                    ExecutionContext.unwrap((String)this.m_wrappedCtx);
                }
                if (s_logger.isLoggable(Level.FINE)) {
                    s_logger.logp(Level.FINE, this.getClass().getName(), "run", "MBeanInvoker.Worker.run invoking opeation '" + this.m_opName + "' on target '" + this.m_target + "'");
                }
                opResult = this.m_mbs.invoke(this.m_target, this.m_opName, this.m_params, this.m_signature);
                if (s_logger.isLoggable(Level.FINE)) {
                    s_logger.logp(Level.FINE, this.getClass().getName(), "run", "MBeanInvoker.Worker.run invoked opeation '" + this.m_opName + "' on target '" + this.m_target + "'");
                }
                this.m_result = new Result(this.m_target, opResult, opException);
            }
            catch (Exception e) {
                if (s_logger.isLoggable(Level.FINE)) {
                    s_logger.logp(Level.FINE, this.getClass().getName(), "run", "Failed to invoke operation '" + this.m_opName + "' on target '" + this.m_target + "'; caught exception: " + e, e);
                }
                opException = e;
            }
            finally {
                this.m_result = new Result(this.m_target, opResult, opException);
            }
        }

        @Override
        public Result call() {
            this.run();
            return this.m_result;
        }

        public Result getResult() {
            return this.m_result;
        }
    }

    static class Result {
        private final ObjectName m_target;
        private final Object m_result;
        private final Exception m_exception;

        Result(ObjectName target, Object result, Exception exception) {
            this.m_target = target;
            this.m_result = result;
            this.m_exception = exception;
        }

        ObjectName getTarget() {
            return this.m_target;
        }

        Object getResult() {
            return this.m_result;
        }

        Exception getException() {
            return this.m_exception;
        }

        boolean isSuccessful() {
            return this.m_exception == null;
        }
    }
}

