/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.management.tracing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import oracle.as.management.tracing.TraceProviderParameterInfo;

public class TraceProviderInfo
implements Serializable {
    private String m_name;
    private String m_userVisibleName;
    private String m_desc;
    private List<TraceProviderParameterInfo> m_params = new ArrayList<TraceProviderParameterInfo>(0);
    private List<String> m_supportedAttributes = new ArrayList<String>(0);
    private static final long serialVersionUID = 20110715L;
    private static CompositeType s_compositeType;
    private static final String TYPE_NAME;
    private static final String[] ITEM_NAMES;

    public String getName() {
        return this.m_name;
    }

    public String getUserVisibleName() {
        return this.m_userVisibleName;
    }

    public String getDescription() {
        return this.m_desc;
    }

    public List<String> getSupportedAttributes() {
        return this.m_supportedAttributes;
    }

    public List<TraceProviderParameterInfo> getParameterInfo() {
        return this.m_params;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setUserVisibleName(String userVisibleName) {
        this.m_userVisibleName = userVisibleName;
    }

    public void setDescription(String desc) {
        this.m_desc = desc;
    }

    public void setSupportedAttributes(List<String> supportedAttributes) {
        this.m_supportedAttributes = new ArrayList<String>(supportedAttributes);
    }

    public void setParameterInfo(List<TraceProviderParameterInfo> params) {
        this.m_params = params;
    }

    public static TraceProviderInfo from(CompositeData cd) throws OpenDataException {
        CompositeData[] cdArray;
        CompositeType ct = cd.getCompositeType();
        if (!TraceProviderInfo.class.getName().equals(ct.getTypeName())) {
            throw new IllegalArgumentException("Invalid argument");
        }
        TraceProviderInfo pi = new TraceProviderInfo();
        pi.setName((String)cd.get("name"));
        pi.setUserVisibleName((String)cd.get("userVisibleName"));
        pi.setDescription((String)cd.get("description"));
        String[] strArray = (String[])cd.get("supportedAttributes");
        if (strArray != null) {
            ArrayList<String> list = new ArrayList<String>(strArray.length);
            for (String item : strArray) {
                list.add(item);
            }
            pi.setSupportedAttributes(list);
        }
        if ((cdArray = (CompositeData[])cd.get("parameterInfo")) != null) {
            ArrayList<TraceProviderParameterInfo> list = new ArrayList<TraceProviderParameterInfo>(cdArray.length);
            for (CompositeData item : cdArray) {
                list.add(TraceProviderParameterInfo.from(item));
            }
            pi.setParameterInfo(list);
        }
        return pi;
    }

    public CompositeData toCompositeData(CompositeType ct) throws OpenDataException {
        if (ct == null) {
            ct = TraceProviderInfo.toCompositeType();
        } else if (!TraceProviderInfo.toCompositeType().equals(ct)) {
            throw new IllegalArgumentException("Invalid argument CompositeType");
        }
        return new CompositeDataSupport(ct, ITEM_NAMES, new Object[]{this.getName(), this.getUserVisibleName(), this.getDescription(), TraceProviderInfo.stringListToOpenData(this.getSupportedAttributes()), TraceProviderInfo.paramInfoListToOpenData(this.getParameterInfo())});
    }

    public static CompositeType toCompositeType() {
        return s_compositeType;
    }

    private static String[] stringListToOpenData(List<String> list) {
        if (list == null) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    private static CompositeData[] paramInfoListToOpenData(List<TraceProviderParameterInfo> list) throws OpenDataException {
        if (list == null) {
            return null;
        }
        CompositeData[] cds = new CompositeData[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            cds[i] = list.get(i).toCompositeData(null);
        }
        return cds;
    }

    static {
        TYPE_NAME = TraceProviderInfo.class.getName();
        ITEM_NAMES = new String[]{"name", "userVisibleName", "description", "supportedAttributes", "parameterInfo"};
        try {
            s_compositeType = new CompositeType(TYPE_NAME, TYPE_NAME, ITEM_NAMES, ITEM_NAMES, new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, new ArrayType(1, SimpleType.STRING), new ArrayType(1, TraceProviderParameterInfo.toCompositeType())});
        }
        catch (OpenDataException e) {
            Logger.getLogger("oracle.odl.tracing").log(Level.FINE, "Unable to initialize CompositeType: " + e, e);
        }
    }
}

