/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.Collection;
import oracle.javatools.db.AbstractIncrementer;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;

class AbstractIncrementerValidator<T extends AbstractIncrementer>
extends DBObjectValidator<T> {
    private static final int OK = 1;
    private static final int ERROR_ZERO_INCREMENT = -2;
    private static final int ERROR_INCREMENT_TOO_MANY_DIGITS = -3;
    private static final int ERROR_INCREMENT_TOO_BIG = -4;
    private static final int ERROR_START_TOO_MANY_DIGITS = -5;
    private static final int ERROR_START_LESS_THAN_MIN = -6;
    private static final int ERROR_START_GREATER_THAN_MAX = -7;
    private static final int ERROR_MIN_TOO_MANY_DIGITS = -8;
    private static final int ERROR_MIN_GREATER_THAN_START = -9;
    private static final int ERROR_MIN_GREATER_THAN_MAX = -10;
    private static final int ERROR_MAX_TOO_MANY_DIGITS = -11;
    private static final int ERROR_MAX_LESS_THAN_START = -12;
    private static final int ERROR_MAX_LESS_THAN_MIN = -13;
    private static final int ERROR_CACHE_TOO_MANY_DIGITS = -14;
    private static final int ERROR_CACHE_TOO_SMALL = -15;
    private static final int ERROR_CACHE_TOO_BIG = -16;
    private static final int ERROR_MAX_REQD_FOR_ASCENDING_CYCLE = -17;
    private static final BigInteger MAX27 = BigInteger.valueOf(10L).pow(27);
    private static final BigInteger MIN26 = BigInteger.valueOf(10L).pow(26).negate();
    private static final BigInteger DIGITS28 = BigInteger.valueOf(10L).pow(28).subtract(BigInteger.ONE);

    public AbstractIncrementerValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    protected Collection<String> listAlwaysValidProperties() {
        Collection collection = super.listAlwaysValidProperties();
        collection.add("orderFlag");
        collection.add("cycleFlag");
        return collection;
    }

    private String formatBigInteger(BigInteger bigInteger, BigInteger bigInteger2) {
        String string = bigInteger2.toString();
        if (null == bigInteger) {
            string = MessageFormat.format(APIBundle.get((String)"SEQUENCE_DEFAULT"), string);
        }
        return string;
    }

    private boolean tooBig(BigInteger bigInteger) {
        return bigInteger.abs().compareTo(DIGITS28) > 0;
    }

    private BigInteger getIncrement(BigInteger bigInteger) {
        BigInteger bigInteger2 = BigInteger.ONE;
        if (bigInteger != null && !bigInteger.equals(BigInteger.ZERO)) {
            bigInteger2 = bigInteger;
        }
        return bigInteger2;
    }

    private BigInteger getMaxValue(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = MAX27;
        if (null != bigInteger2) {
            bigInteger3 = bigInteger2;
        } else if (bigInteger.signum() < 0) {
            bigInteger3 = BigInteger.ONE.negate();
        }
        return bigInteger3;
    }

    private BigInteger getMinValue(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = BigInteger.ONE;
        if (null != bigInteger2) {
            bigInteger3 = bigInteger2;
        } else if (bigInteger.signum() < 0) {
            bigInteger3 = MIN26;
        }
        return bigInteger3;
    }

    protected void validateIncrement(T t, T t2) throws ValidationException {
        BigInteger bigInteger = t2.getIncrementBy();
        BigInteger bigInteger2 = t2.getMinValue();
        BigInteger bigInteger3 = t2.getMaxValue();
        int n = this.validateIncrement(bigInteger, bigInteger2, bigInteger3);
        switch (n) {
            case -3: {
                throw new ValidationException(t2, MessageFormat.format(APIBundle.get((String)"SEQUENCE_ERROR_INCREMENT_TOO_MANY_DIGITS"), t2.getName()));
            }
            case -2: {
                throw new ValidationException(t2, MessageFormat.format(APIBundle.get((String)"SEQUENCE_ERROR_ZERO_INCREMENT"), t2.getName()));
            }
            case -4: {
                BigInteger bigInteger4 = this.getIncrement(bigInteger);
                BigInteger bigInteger5 = this.getMinValue(bigInteger4, bigInteger2);
                BigInteger bigInteger6 = this.getMaxValue(bigInteger4, bigInteger3);
                throw new ValidationException(t2, MessageFormat.format(APIBundle.get((String)"SEQUENCE_ERROR_INCREMENT_TOO_BIG"), this.formatBigInteger(bigInteger, bigInteger4), this.formatBigInteger(bigInteger2, bigInteger5), this.formatBigInteger(bigInteger3, bigInteger6)));
            }
        }
        if (1 != n) {
            // empty if block
        }
    }

    private int validateIncrement(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        int n = 1;
        if (null != bigInteger) {
            if (bigInteger.equals(BigInteger.ZERO)) {
                n = -2;
            } else if (this.tooBig(bigInteger)) {
                n = -3;
            } else {
                BigInteger bigInteger4 = bigInteger;
                BigInteger bigInteger5 = this.getMaxValue(bigInteger4, bigInteger3);
                BigInteger bigInteger6 = this.getMinValue(bigInteger4, bigInteger2);
                if (bigInteger4.abs().compareTo(bigInteger5.subtract(bigInteger6).abs()) >= 0) {
                    n = -4;
                }
            }
        }
        return n;
    }

    protected void validateStartWith(T t, T t2) throws ValidationException {
        BigInteger bigInteger = t2.getIncrementBy();
        BigInteger bigInteger2 = this.getIncrement(bigInteger);
        BigInteger bigInteger3 = t2.getStartWith();
        BigInteger bigInteger4 = t2.getMinValue();
        BigInteger bigInteger5 = t2.getMaxValue();
        int n = this.validateStartWith(bigInteger3, bigInteger, bigInteger4, bigInteger5);
        switch (n) {
            case -5: {
                throw new ValidationException(t2, MessageFormat.format(APIBundle.get((String)"SEQUENCE_ERROR_START_TOO_MANY_DIGITS"), t2.getName()));
            }
            case -6: {
                throw new ValidationException(t2, MessageFormat.format(APIBundle.get((String)"SEQUENCE_ERROR_START_LESS_THAN_MIN"), bigInteger3, this.formatBigInteger(bigInteger4, this.getMinValue(bigInteger2, bigInteger4))));
            }
            case -7: {
                String string = bigInteger3.toString();
                throw new ValidationException(t2, MessageFormat.format(APIBundle.get((String)"SEQUENCE_ERROR_START_GREATER_THAN_MAX"), string, this.formatBigInteger(bigInteger5, this.getMaxValue(bigInteger2, bigInteger5))));
            }
        }
        if (1 != n) {
            // empty if block
        }
    }

    private int validateStartWith(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) throws ValidationException {
        int n = 1;
        if (null != bigInteger) {
            if (this.tooBig(bigInteger)) {
                n = -5;
            } else {
                BigInteger bigInteger5 = this.getIncrement(bigInteger2);
                BigInteger bigInteger6 = bigInteger;
                if (bigInteger5.signum() > 0) {
                    BigInteger bigInteger7 = this.getMinValue(bigInteger5, bigInteger3);
                    if (bigInteger6.compareTo(bigInteger7) < 0) {
                        n = -6;
                    }
                } else {
                    BigInteger bigInteger8 = this.getMaxValue(bigInteger5, bigInteger4);
                    if (bigInteger6.compareTo(bigInteger8) > 0) {
                        n = -7;
                    }
                }
            }
        }
        return n;
    }

    protected void validateMinValue(T t, T t2) throws ValidationException {
        BigInteger bigInteger = t2.getStartWith();
        BigInteger bigInteger2 = t2.getMinValue();
        BigInteger bigInteger3 = t2.getMaxValue();
        int n = this.validateMinValue(bigInteger2, bigInteger, bigInteger3);
        switch (n) {
            case -8: {
                throw new ValidationException(t2, MessageFormat.format(APIBundle.get((String)"SEQUENCE_ERROR_MIN_TOO_MANY_DIGITS"), t2.getName()));
            }
            case -9: {
                throw new ValidationException(t2, MessageFormat.format(APIBundle.get((String)"SEQUENCE_ERROR_MIN_GREATER_THAN_START"), t2.getMinValue(), t2.getStartWith()));
            }
            case -10: {
                throw new ValidationException(t2, MessageFormat.format(APIBundle.get((String)"SEQUENCE_ERROR_MIN_GREATER_THAN_MAX"), t2.getMinValue(), t2.getMaxValue()));
            }
        }
        if (1 != n) {
            // empty if block
        }
    }

    private int validateMinValue(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) throws ValidationException {
        int n = 1;
        if (null != bigInteger) {
            if (this.tooBig(bigInteger)) {
                n = -8;
            } else {
                if (null != bigInteger2 && bigInteger.compareTo(bigInteger2) > 0) {
                    n = -9;
                }
                if (null != bigInteger3 && bigInteger.compareTo(bigInteger3) > 0) {
                    n = -10;
                }
            }
        }
        return n;
    }

    protected void validateMaxValue(T t, T t2) throws ValidationException {
        BigInteger bigInteger = t2.getStartWith();
        BigInteger bigInteger2 = t2.getMinValue();
        BigInteger bigInteger3 = t2.getMaxValue();
        BigInteger bigInteger4 = t2.getIncrementBy();
        Boolean bl = t2.getCycleFlag();
        int n = this.validateMaxValue(bigInteger3, bigInteger, bigInteger2, bigInteger4, bl);
        switch (n) {
            case -11: {
                throw new ValidationException(t2, MessageFormat.format(APIBundle.get((String)"SEQUENCE_ERROR_MAX_TOO_MANY_DIGITS"), t2.getName()));
            }
            case -12: {
                throw new ValidationException(t2, MessageFormat.format(APIBundle.get((String)"SEQUENCE_ERROR_MAX_LESS_THAN_START"), t2.getMaxValue(), t2.getStartWith()));
            }
            case -13: {
                throw new ValidationException(t2, MessageFormat.format(APIBundle.get((String)"SEQUENCE_ERROR_MAX_LESS_THAN_MIN"), t2.getMaxValue(), t2.getMinValue()));
            }
            case -17: {
                throw new ValidationException(t2, APIBundle.get((String)"SEQUENCE_ERROR_ASC_CYCLIC_NO_MAXVALUE"));
            }
        }
        if (1 != n) {
            // empty if block
        }
    }

    private int validateMaxValue(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, Boolean bl) throws ValidationException {
        int n = 1;
        BigInteger bigInteger5 = this.getIncrement(bigInteger4);
        if (null != bl && bl.equals(Boolean.TRUE) && bigInteger5.signum() > 0 && bigInteger == null) {
            n = -17;
        } else if (null != bigInteger) {
            if (this.tooBig(bigInteger)) {
                n = -11;
            } else {
                if (null != bigInteger2 && bigInteger.compareTo(bigInteger2) < 0) {
                    n = -12;
                }
                if (null != bigInteger3 && bigInteger.compareTo(bigInteger3) <= 0) {
                    n = -13;
                }
            }
        }
        return n;
    }

    protected void validateCache(T t, T t2) throws ValidationException {
        BigInteger bigInteger = t2.getIncrementBy();
        BigInteger bigInteger2 = t2.getCacheSize();
        BigInteger bigInteger3 = t2.getMinValue();
        BigInteger bigInteger4 = t2.getMaxValue();
        Boolean bl = t2.getCycleFlag();
        Boolean bl2 = t2.getCacheFlag();
        boolean bl3 = false;
        if (bl2 == null || !bl2.equals(Boolean.FALSE)) {
            if (bl2 == null && bigInteger2 == null) {
                bigInteger2 = BigInteger.valueOf(20L);
                bl3 = true;
            }
            if (bigInteger2 == null) {
                throw new ValidationException(t2, MessageFormat.format(APIBundle.get((String)"SEQUENCE_ERROR_CACHE_TOO_SMALL"), "", t2.getName()));
            }
            int n = this.validateCache(bigInteger2, bigInteger, bigInteger3, bigInteger4, bl);
            switch (n) {
                case -14: {
                    throw new ValidationException(t2, MessageFormat.format(APIBundle.get((String)"SEQUENCE_ERROR_CACHE_TOO_MANY_DIGITS"), t2.getName()));
                }
                case -15: {
                    throw new ValidationException(t2, MessageFormat.format(APIBundle.get((String)"SEQUENCE_ERROR_CACHE_TOO_SMALL"), bigInteger2.toString()));
                }
                case -16: {
                    BigInteger bigInteger5 = this.maxCacheSize(bigInteger, bigInteger3, bigInteger4);
                    if (bl3) {
                        throw new ValidationException(t2, MessageFormat.format(APIBundle.get((String)"SEQUENCE_ERROR_DFLT_CACHE_TOO_BIG"), bigInteger5.toString()));
                    }
                    throw new ValidationException(t2, MessageFormat.format(APIBundle.get((String)"SEQUENCE_ERROR_CACHE_TOO_BIG"), bigInteger2.toString(), bigInteger5.toString()));
                }
            }
            if (1 != n) {
                // empty if block
            }
        }
    }

    private int validateCache(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, Boolean bl) throws ValidationException {
        int n = 1;
        if (null != bigInteger) {
            BigInteger bigInteger5;
            if (this.tooBig(bigInteger)) {
                n = -14;
            } else if (bigInteger.compareTo(BigInteger.valueOf(2L)) < 0) {
                n = -15;
            } else if (null != bl && bl.equals(Boolean.TRUE) && bigInteger.compareTo(bigInteger5 = this.maxCacheSize(bigInteger2, bigInteger3, bigInteger4)) > 0) {
                n = -16;
            }
        }
        return n;
    }

    private BigInteger maxCacheSize(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        BigInteger bigInteger4 = this.getIncrement(bigInteger);
        BigInteger bigInteger5 = this.getMaxValue(bigInteger4, bigInteger3);
        BigInteger bigInteger6 = this.getMinValue(bigInteger4, bigInteger2);
        BigInteger[] bigIntegerArray = bigInteger5.subtract(bigInteger6).abs().divideAndRemainder(bigInteger4.abs());
        BigInteger bigInteger7 = bigIntegerArray[0];
        if (bigIntegerArray[1].signum() > 0) {
            bigInteger7 = bigInteger7.add(BigInteger.ONE);
        }
        return bigInteger7;
    }
}

