/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sybase.anywhere;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.stream.IntStream;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.datatypes.DataTypeCache;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.jdbc.JdbcDatabaseDescriptor;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sybase.AdaptiveServerDDLGenerator;
import oracle.javatools.db.sybase.anywhere.AdaptiveServerAnywhereDatabase;

public class AdaptiveServerAnywhereDescriptor
extends JdbcDatabaseDescriptor {
    public static final int MAX_NAME_LENGTH = 128;
    public static final char OPEN_QUOTE_IDENTIFIER = '[';
    public static final char CLOSE_QUOTE_IDENTIFIER = ']';
    private static final Set RESERVED_WORDS = new HashSet<String>(Arrays.asList("ADD", "ALL", "ALTER", "AND", "ANY", "AS", "ASC", "BACKUP", "BEGIN", "BETWEEN", "BIGINT", "BINARY", "BIT", "BOTTOM", "BREAK", "BY", "CALL", "CAPABILITY", "CASCADE", "CASE", "CAST", "CHAR", "CHAR_CONVERT", "CHARACTER", "CHECK", "CHECKPOINT", "CLOSE", "COMMENT", "COMMIT", "CONNECT", "CONSTRAINT", "CONTAINS", "CONTINUE", "CONVERT", "CREATE", "CROSS", "CUBE", "CURRENT", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "DATE", "DBSPACE", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DELETE", "DELETING", "DESC", "DISTINCT", "DO", "DOUBLE", "DROP", "DYNAMIC", "ELSE", "ELSEIF", "ENCRYPTED", "END", "ENDIF", "ESCAPE", "EXCEPT", "EXCEPTION", "EXEC", "EXECUTE", "EXISTING", "EXISTS", "EXTERNLOGIN", "FETCH", "FIRST", "FLOAT", "FOR", "FORCE", "FOREIGN", "FORWARD", "FROM", "FULL", "GOTO", "GRANT", "GROUP", "HAVING", "HOLDLOCK", "IDENTIFIED", "IF", "IN", "INDEX", "INDEX_LPAREN", "INNER", "INOUT", "INSENSITIVE", "INSERT", "INSERTING", "INSTALL", "INSTEAD", "INT", "INTEGER", "INTEGRATED", "INTERSECT", "INTO", "IQ", "IS", "ISOLATION", "JOIN", "KEY", "LATERAL", "LEFT", "LIKE", "LOCK", "LOGIN", "LONG", "MATCH", "MEMBERSHIP", "MESSAGE", "MODE", "MODIFY", "NATURAL", "NEW", "NO", "NOHOLDLOCK", "NOT", "NOTIFY", "NULL", "NUMERIC", "OF", "OFF", "ON", "OPEN", "OPTION", "OPTIONS", "OR", "ORDER", "OTHERS", "OUT", "OUTER", "OVER", "PASSTHROUGH", "PRECISION", "PREPEARE", "PRIMARY", "PRINT", "PRIVILEGES", "PROC", "PROCEDURE", "PUBLICATION", "RAISERROR", "READTEXT", "REAL", "REFERENCE", "REFERENCES", "RELEASE", "REMOTE", "REMOVE", "RENAME", "REORGANIZE", "RESOURCE", "RESTORE", "RESTRICT", "RETURN", "REVOKE", "RIGHT", "ROLLBACK", "ROLLUP", "SAVE", "SAVEPOINT", "SCROLL", "SELECT", "SENSITIVE", "SESSION", "SET", "SETUSER", "SHARE", "SMALLINT", "SOME", "SQLCODE", "SQLSTATE", "START", "STOP", "SUBTRANS", "SUBTRANSACTION", "SYNCHRONIZE", "SYNTAX_ERROR", "TABLE", "TEMPORARY", "TEXTSIZE", "THEN", "TIME", "TIMESTAMP", "TINYINT", "TO", "TOP", "TRAN", "TRIGGER", "TRUNCATE", "TSEQUAL", "UNBOUNDED", "UNION", "UNIQUE", "UNKNOWN", "UNSIGNED", "UPDATE", "UPDATING", "USER", "USING", "VALIDATE", "VALUES", "VARBINARY", "VARCHAR", "VARIABLE", "VARYING", "VIEW", "WAIT", "WAITFOR", "WHEN", "WHERE", "WHILE", "WINDOW", "WITH", "WITH_CUBE", "WITH_LPAREN", "WITH_ROLLUP", "WITHIN", "WORK", "WRITETEXT"));

    public AdaptiveServerAnywhereDescriptor(Class<? extends AdaptiveServerAnywhereDatabase> clazz) {
        super(clazz);
    }

    @Override
    public int getCasePolicy() {
        return 3;
    }

    @Override
    public String getIdentifierQuoteString() {
        return String.valueOf('\"');
    }

    @Override
    public int getMaxNameLength(String string) {
        return 128;
    }

    @Override
    public void validateName(String string, String string2) throws InvalidNameException {
        boolean bl = true;
        String string3 = "";
        try {
            AdaptiveServerAnywhereDescriptor.validateIdentifier((String)string2, (char)'\"', (int)128, (String)"_$#@", (boolean)false, (Set)RESERVED_WORDS, (int)this.getCasePolicy(), (boolean)this.allowSurrogatesInIdentifierValidation());
        }
        catch (InvalidNameException invalidNameException) {
            bl = false;
            string3 = invalidNameException.getMessage();
        }
        char c = string2.charAt(0);
        if (bl && c != '\"' && !Character.isAlphabetic(string2.codePointAt(0)) && c != '_' && c != '$' && c != '#' && c != '@') {
            throw new InvalidNameException(null, APIBundle.get((String)"INVALID_IDENTIFIER_ILLEGAL_CHARACTER"));
        }
        if (!bl && c == '[' && string2.indexOf(91, 1) == -1 && string2.indexOf(93, 1) == string2.length() - 1 && string2.length() > 2 && string2.length() < 131) {
            bl = true;
        }
        if (!bl) {
            throw new InvalidNameException(null, string3);
        }
        String string4 = c == '\"' ? string2.substring(1, string2.length() - 1) : string2;
        Integer n = 0;
        IntStream intStream = string2.codePoints();
        PrimitiveIterator.OfInt ofInt = intStream.iterator();
        while (ofInt.hasNext()) {
            Integer n2 = (Integer)ofInt.next();
            if (Character.isISOControl(n2) || "\"".indexOf(n2) != -1 || "\\".indexOf(n) != -1 && "\\".indexOf(n2) != -1) {
                throw new InvalidNameException(null, APIBundle.get((String)"INVALID_IDENTIFIER_ILLEGAL_CHARACTER"));
            }
            n = n2;
        }
        for (int i = 0; i < string4.length(); ++i) {
            if (string2.charAt(i) != '\'' || ++i != string4.length() - 1 && string2.charAt(i) == '\'') continue;
            throw new InvalidNameException(null, APIBundle.get((String)"INVALID_IDENTIFIER_ILLEGAL_CHARACTER"));
        }
    }

    @Override
    public DDLGenerator getDDLGenerator(DBObjectProvider dBObjectProvider) {
        return new AdaptiveServerDDLGenerator(this.getDatabaseClass(), dBObjectProvider);
    }

    @Override
    public Collection<String> getReservedWords() {
        return RESERVED_WORDS;
    }

    @Override
    public String getDatabaseType() {
        return "SybaseAnywhere";
    }

    @Override
    protected void registerDataTypes(DataTypeCache dataTypeCache) {
        if (this.getDatabaseVersion() == 0) {
            dataTypeCache.registerDataType("BIGINT");
            dataTypeCache.registerDataType("BINARY");
            dataTypeCache.registerDataType("BIT");
            dataTypeCache.registerDataType("CHARACTER VARYING");
            dataTypeCache.registerDataType("CHARACTER");
            dataTypeCache.registerDataType("DATE");
            dataTypeCache.registerDataType("DATETIME");
            dataTypeCache.registerDataType("DECIMAL");
            dataTypeCache.registerDataType("DOUBLE PRECISION");
            dataTypeCache.registerDataType("DOUBLE");
            dataTypeCache.registerDataType("FLOAT");
            dataTypeCache.registerDataType("IMAGE");
            dataTypeCache.registerDataType("INT");
            dataTypeCache.registerDataType("INTEGER");
            dataTypeCache.registerDataType("LONG BINARY");
            dataTypeCache.registerDataType("LONG VARCHAR");
            dataTypeCache.registerDataType("MONEY");
            dataTypeCache.registerDataType("NUMERIC");
            dataTypeCache.registerDataType("REAL");
            dataTypeCache.registerDataType("SMALLDATETIME");
            dataTypeCache.registerDataType("SMALLINT");
            dataTypeCache.registerDataType("SMALLMONEY");
            dataTypeCache.registerDataType("TEXT");
            dataTypeCache.registerDataType("TIME");
            dataTypeCache.registerDataType("TIMESTAMP");
            dataTypeCache.registerDataType("TINYINT");
            dataTypeCache.registerDataType("UNIQUEIDENTIFIER");
            dataTypeCache.registerDataType("UNIQUEIDENTIFIERSTR");
            dataTypeCache.registerDataType("VARBINARY");
            dataTypeCache.registerDataType("VARCHAR");
            dataTypeCache.registerDataType("XML");
        }
    }
}

