/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sqlite;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import oracle.javatools.db.BaseDatabaseCreator;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.sqlite.SQLiteDatabase;
import oracle.javatools.db.sqlite.SQLiteDatabaseDescriptor;
import oracle.javatools.db.sqlite.SQLiteDatabaseImpl;

public class SQLiteDatabaseFactory
extends BaseDatabaseCreator {
    protected Database createDatabaseImpl(String string, String string2, Connection connection) {
        int n = this.getSQLiteConnectionVersion(connection);
        if (n == 0) {
            return null;
        }
        return new SQLiteDatabaseImpl(string, string2, connection);
    }

    protected int getSQLiteConnectionVersion(Connection connection) {
        int n = 0;
        if (connection != null) {
            try {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                String string = databaseMetaData.getDatabaseProductName();
                if ("SQLite".equals(string)) {
                    String string2 = databaseMetaData.getDatabaseProductVersion();
                    if (string2 != null) {
                        String[] stringArray = string2.split("\\.");
                        int n2 = 10000;
                        for (int i = 0; i < stringArray.length && i < 3; ++i) {
                            try {
                                int n3 = Integer.valueOf(stringArray[i]);
                                n += n3 * n2;
                                n2 /= 100;
                                continue;
                            }
                            catch (NumberFormatException numberFormatException) {
                                n = 0;
                                break;
                            }
                        }
                    }
                    if (n == 0) {
                        n = databaseMetaData.getDatabaseMajorVersion() * 10000;
                    }
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return n;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(Class clazz) {
        SQLiteDatabaseDescriptor sQLiteDatabaseDescriptor = null;
        if (SQLiteDatabase.class.isAssignableFrom(clazz)) {
            sQLiteDatabaseDescriptor = new SQLiteDatabaseDescriptor(clazz);
        }
        return sQLiteDatabaseDescriptor;
    }
}

