/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql.parser;

import java.util.ArrayList;
import java.util.List;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.PlSqlAttribute;
import oracle.javatools.db.plsql.PlSqlMethod;
import oracle.javatools.db.plsql.PlSqlReference;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlSubProgram;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenPattern;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.plsql.parser.PlSqlSpecAndBodyBuilder;
import oracle.javatools.util.Tuple;

public class TypeBuilder
extends PlSqlSpecAndBodyBuilder<Type> {
    private static final String action = "action";
    private static final String ADD = "ADD";
    private static final String ATTRIBUTE = "ATTRIBUTE";
    private static final String authid = "authid";
    private static final String ccontext = "ccontext";
    private static final String clibname = "clibname";
    private static final String cname = "cname";
    private static final String CURRENT_USER = "CURRENT_USER";
    private static final String CustomDatum = "CustomDatum";
    private static final String datatype = "datatype";
    private static final String DROP = "DROP";
    private static final String extname = "extname";
    private static final String extvarname = "extvarname";
    private static final String final_ = "final";
    private static final String FINAL = "FINAL";
    private static final String INSTANTIABLE = "INSTANTIABLE";
    private static final String inst = "inst";
    private static final String isAsUnder = "isAsUnder";
    private static final String javaname = "javaname";
    private static final String limit = "limit";
    private static final String methodType = "methodType";
    private static final String name = "name";
    private static final String notFinal = "notFinal";
    private static final String notInst = "notInst";
    private static final String NOT = "NOT";
    private static final String oid = "oid";
    private static final String OPAQUE = "OPAQUE";
    private static final String OraData = "OraData";
    private static final String over = "over";
    private static final String PRAGMA = "PRAGMA";
    private static final String SQLData = "SQLData";
    private static final String start = "start";
    private static final String typ = "type";
    private static final String under = "under";
    private static final String UNDER = "UNDER";
    private static final String using = "using";
    private static final String what = "what";
    private PlSqlTokenPattern m_selfSearch;

    public TypeBuilder(AbstractDBObjectProvider abstractDBObjectProvider) {
        super(abstractDBObjectProvider, "TYPE");
    }

    @Override
    protected void addChildren(Object object, Type type, PlSqlParser plSqlParser) throws CancelledException {
    }

    @Override
    protected void buildObjectProperties(Type type, PlSqlParser plSqlParser) throws CancelledException {
        PlSqlToken plSqlToken = plSqlParser.getTypeToken();
        PlSqlSearch plSqlSearch = new PlSqlSearch("[create [or replace]] TYPE ?. [OID ?] [AUTHID ?] <isAsUnder {IS|AS|UNDER}> <type [{OPAQUE|OBJECT|TABLE OF|VARRAY|VARYING ARRAY}]>");
        String string = null;
        String string2 = null;
        if (plSqlSearch.matches(plSqlToken)) {
            if (plSqlSearch.getNamedMatchStartToken(isAsUnder).matches(UNDER)) {
                string = "OBJECT";
            } else {
                plSqlToken = plSqlSearch.getNamedMatchStartToken(typ);
                if (plSqlToken != null) {
                    if (plSqlToken.matches("OBJECT") || plSqlToken.matches(OPAQUE)) {
                        string = "OBJECT";
                    } else {
                        string = "COLLECTION";
                        string2 = plSqlToken.matches("TABLE") ? "TABLE" : "VARYING ARRAY";
                    }
                }
            }
        }
        type.setTypeCode(string);
        type.setCollectionType(string2);
        StringBuffer stringBuffer = new StringBuffer("{<ref [REF]> ");
        if (type.getSchema() != null) {
            stringBuffer.append("[").append(type.getSchema().getName()).append(" .]");
        }
        stringBuffer.append(type.getName()).append("|SELF AS RESULT}");
        this.m_selfSearch = new PlSqlTokenPattern(stringBuffer.toString());
        if ("OBJECT".equals(string)) {
            this.deriveObjectProperties(type, plSqlParser);
        } else {
            this.deriveCollectionProperties(type, plSqlParser);
        }
        for (Tuple tuple : plSqlParser.getAlterStatements()) {
            for (Tuple<PlSqlToken, PlSqlToken> tuple2 : this.getAlterClauses((Tuple<PlSqlToken, PlSqlToken>)tuple)) {
                this.processAlterClause(type, tuple2, plSqlParser);
            }
        }
        this.m_selfSearch = null;
    }

    @Override
    protected PlSqlTokenPattern getSelfSearch() {
        return this.m_selfSearch;
    }

    private List<Tuple<PlSqlToken, PlSqlToken>> getAlterClauses(Tuple<PlSqlToken, PlSqlToken> tuple) {
        PlSqlSearch plSqlSearch = new PlSqlSearch("alter type ?. <start ?>");
        ArrayList<Tuple<PlSqlToken, PlSqlToken>> arrayList = new ArrayList<Tuple<PlSqlToken, PlSqlToken>>();
        int n = ((PlSqlToken)tuple.getSecond()).getEnd();
        if (plSqlSearch.matches((PlSqlToken)tuple.getFirst(), (PlSqlToken)tuple.getSecond())) {
            PlSqlToken plSqlToken;
            PlSqlToken plSqlToken2 = plSqlToken = plSqlSearch.getNamedMatchStartToken(start);
            int n2 = 0;
            while (!plSqlToken2.isEndMarker() && plSqlToken2.getStart() < n) {
                if (plSqlToken2.matches("(")) {
                    ++n2;
                } else if (plSqlToken2.matches(")")) {
                    --n2;
                } else if (n2 == 0 && plSqlToken2.matches(",")) {
                    arrayList.add((Tuple<PlSqlToken, PlSqlToken>)new Tuple((Object)plSqlToken, (Object)((PlSqlToken)plSqlToken2.getPrevCodeToken())));
                    plSqlToken = (PlSqlToken)plSqlToken2.getNextCodeToken();
                }
                plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
            }
            if (plSqlToken2.isEndMarker()) {
                plSqlToken2 = (PlSqlToken)plSqlToken2.getPrevCodeToken();
            }
            arrayList.add((Tuple<PlSqlToken, PlSqlToken>)new Tuple((Object)plSqlToken, (Object)plSqlToken2));
        }
        return arrayList;
    }

    private void deriveObjectProperties(Type type, PlSqlParser plSqlParser) throws CancelledException {
        boolean bl = true;
        boolean bl2 = true;
        PlSqlSearch plSqlSearch = new PlSqlSearch("TYPE ?. [FORCE] [OID <oid ?>] [AUTHID <authid ?>] {{IS|AS}OBJECT|UNDER <under ?.>|{IS|AS}OPAQUE VARYING (*) USING LIBRARY ?} [EXTERNAL NAME <extname ?> LANGUAGE JAVA USING <using ?>]");
        if (plSqlSearch.matches(plSqlParser.getTypeToken())) {
            PlSqlAttribute plSqlAttribute;
            PlSqlToken plSqlToken;
            int n;
            PlSqlToken plSqlToken2;
            type.setOID(plSqlSearch.getNamedMatch(oid));
            boolean bl3 = CURRENT_USER.equalsIgnoreCase(plSqlSearch.getNamedMatch(authid));
            type.setAuthidCurrentUser(bl3);
            if (plSqlSearch.getNamedMatch(under) != null) {
                plSqlToken2 = plSqlSearch.getNamedMatchStartToken(under);
                PlSqlToken object = plSqlSearch.getNamedMatchEndToken(under);
                PlSqlReference plSqlReference = this.findDataTypeReference(plSqlToken2, object, "underTypeReference", plSqlParser);
                type.setUnderTypeReference(plSqlReference);
            }
            type.setSqljExternalName(this.getNameSearchStripQuotes(plSqlSearch, extname));
            if (type.getSqljExternalName() != null) {
                plSqlToken2 = null;
                String string = plSqlSearch.getNamedMatch(using);
                if (SQLData.equalsIgnoreCase(string)) {
                    plSqlToken2 = Type.SQLJUsingType.SQLData;
                } else if (OraData.equalsIgnoreCase(string)) {
                    plSqlToken2 = Type.SQLJUsingType.OraData;
                }
                if (CustomDatum.equalsIgnoreCase(string)) {
                    plSqlToken2 = Type.SQLJUsingType.CustomDatum;
                }
                type.setSqljUsing((Type.SQLJUsingType)plSqlToken2);
            }
            plSqlToken2 = plSqlParser.getTokenAtOffset(plSqlParser.getEndOffsetOfObject());
            while (!plSqlToken2.isCode() || plSqlToken2.matches(";") || plSqlToken2.matches("/")) {
                plSqlToken2 = (PlSqlToken)plSqlToken2.getPrevCodeToken();
            }
            if (plSqlToken2.matches(INSTANTIABLE) && (plSqlToken2 = (PlSqlToken)plSqlToken2.getPrevCodeToken()).matches(NOT)) {
                bl2 = false;
                plSqlToken2 = (PlSqlToken)plSqlToken2.getPrevCodeToken();
            }
            if (plSqlToken2.matches(FINAL) && (plSqlToken2 = (PlSqlToken)plSqlToken2.getPrevCodeToken()).matches(NOT)) {
                bl = false;
            }
            type.setFinal(bl);
            type.setInstantiable(bl2);
            for (Object object : plSqlParser.getPropertyNodes((DBObjectPlSqlFragment)type, "attributes")) {
                n = plSqlParser.getStartOffset(object);
                plSqlToken = plSqlParser.getTokenAtOffset(n);
                plSqlAttribute = this.getAttribute(type, plSqlToken, null, plSqlParser);
                if (plSqlAttribute == null) continue;
                type.addAttribute(plSqlAttribute);
            }
            for (Object object : plSqlParser.getPropertyNodes((DBObjectPlSqlFragment)type, "methods")) {
                n = plSqlParser.getStartOffset(object);
                plSqlToken = plSqlParser.getTokenAtOffset(n);
                plSqlAttribute = this.getMethod(type, plSqlToken, plSqlParser);
                if (plSqlAttribute == null) continue;
                type.addMethod((PlSqlMethod)plSqlAttribute);
            }
        }
    }

    private void deriveCollectionProperties(Type type, PlSqlParser plSqlParser) throws CancelledException {
        PlSqlSearch plSqlSearch = new PlSqlSearch("TYPE ?. [FORCE] [OID <oid ?>] {IS|AS} { {VARRAY | VARYING ARRAY} ( <limit ?> ) |   TABLE } OF <datatype ?%> [NOT NULL]");
        if (plSqlSearch.matches(this.getParser(type).getTypeToken())) {
            type.setOID(plSqlSearch.getNamedMatch(oid));
            type.setLimit(this.getIntegerNamedMatch(plSqlSearch, limit));
            PlSqlToken plSqlToken = plSqlSearch.getNamedMatchStartToken(datatype);
            PlSqlToken plSqlToken2 = plSqlSearch.getNamedMatchEndToken(datatype);
            PlSqlReference plSqlReference = this.findDataTypeReference(plSqlToken, plSqlToken2, "ofTypeUsageReference", plSqlParser);
            type.setOfTypeUsageReference(plSqlReference);
        }
    }

    private void processAlterClause(Type type, Tuple<PlSqlToken, PlSqlToken> tuple, PlSqlParser plSqlParser) throws CancelledException {
        PlSqlSearch plSqlSearch;
        PlSqlToken plSqlToken;
        PlSqlSearch plSqlSearch2 = new PlSqlSearch("{INVALIDATE|CASCADE}");
        PlSqlToken plSqlToken2 = (PlSqlToken)tuple.getFirst();
        if (plSqlSearch2.isWithin(plSqlToken2, plSqlToken = (PlSqlToken)tuple.getSecond())) {
            plSqlToken = (PlSqlToken)plSqlSearch2.getStartToken().getPrevCodeToken();
        }
        if ((plSqlSearch = new PlSqlSearch("<action {ADD|DROP|MODIFY}> <what ?>")).matches(plSqlToken2)) {
            PlSqlToken plSqlToken3 = plSqlSearch.getNamedMatchStartToken(action);
            PlSqlToken plSqlToken4 = plSqlSearch.getNamedMatchStartToken(what);
            PlSqlToken plSqlToken5 = (PlSqlToken)plSqlToken4.getNextCodeToken();
            if (plSqlToken4.matches(ATTRIBUTE)) {
                boolean bl = true;
                while (bl) {
                    if (plSqlToken5.matches("(") || plSqlToken5.matches(",")) {
                        plSqlToken5 = (PlSqlToken)plSqlToken5.getNextCodeToken();
                    }
                    PlSqlSearch plSqlSearch3 = plSqlToken3.matches(DROP) ? new PlSqlSearch("<name ?>") : new PlSqlSearch("<name ?> <datatype ?%> [EXTERNAL NAME <extname ?>]");
                    bl = false;
                    if (!plSqlSearch3.matches(plSqlToken5)) continue;
                    PlSqlToken plSqlToken6 = plSqlSearch3.getEndToken();
                    this.processAlterAttributeClause(type, plSqlSearch.getNamedMatch(action), plSqlToken5, plSqlToken6, plSqlParser);
                    plSqlToken5 = (PlSqlToken)plSqlToken6.getNextCodeToken();
                    bl = plSqlToken5.matches(",") && plSqlToken5.getStart() < plSqlToken.getStart();
                }
            } else if (plSqlToken3.matches(ADD)) {
                PlSqlMethod plSqlMethod = this.getMethod(type, plSqlToken4, plSqlParser);
                if (plSqlMethod != null) {
                    type.addMethod(plSqlMethod);
                }
            } else if (plSqlToken3.matches(DROP)) {
                this.processDropMethodClause(type, plSqlToken4, plSqlParser);
            } else {
                PlSqlSearch plSqlSearch4 = new PlSqlSearch("MODIFY {LIMIT <limit ?>|ELEMENT TYPE <datatype ?%>}");
                if (plSqlSearch4.matches(plSqlToken2, plSqlToken)) {
                    String string = plSqlSearch4.getNamedMatch(datatype);
                    if (string != null) {
                        PlSqlToken plSqlToken7 = plSqlSearch4.getNamedMatchStartToken(datatype);
                        PlSqlToken plSqlToken8 = plSqlSearch4.getNamedMatchEndToken(datatype);
                        PlSqlReference plSqlReference = this.findDataTypeReference(plSqlToken7, plSqlToken8, "ofTypeUsageReference", plSqlParser);
                        type.setOfTypeUsageReference(plSqlReference);
                    } else {
                        type.setLimit(this.getIntegerNamedMatch(plSqlSearch4, limit));
                    }
                }
            }
        } else {
            PlSqlSearch plSqlSearch5 = new PlSqlSearch(" { <notInst NOT INSTANTIABLE>|   <inst INSTANTIABLE>|   <notFinal NOT FINAL>|   <final FINAL>}...");
            if (plSqlSearch5.matches(plSqlToken2, plSqlToken)) {
                if (plSqlSearch5.getNamedMatch(notInst) != null) {
                    type.setInstantiable(false);
                } else if (plSqlSearch5.getNamedMatch(inst) != null) {
                    type.setInstantiable(true);
                }
                if (plSqlSearch5.getNamedMatch(notFinal) != null) {
                    type.setFinal(false);
                } else if (plSqlSearch5.getNamedMatch(final_) != null) {
                    type.setFinal(true);
                }
            }
        }
    }

    private PlSqlAttribute getAttribute(Type type, PlSqlToken plSqlToken, PlSqlToken plSqlToken2, PlSqlParser plSqlParser) throws CancelledException {
        PlSqlSearch plSqlSearch = new PlSqlSearch("<name ?> <datatype ?%> [EXTERNAL NAME <extname ?>]");
        PlSqlAttribute plSqlAttribute = null;
        if (plSqlSearch.matches(plSqlToken, plSqlToken2)) {
            PlSqlToken plSqlToken3 = plSqlSearch.getNamedMatchStartToken(name);
            String string = this.getProvider().getInternalName(plSqlToken3.getSource());
            plSqlAttribute = TypeBuilder.createFragment(PlSqlAttribute.class);
            plSqlAttribute.setParent((DBObject)type);
            this.setCommon(plSqlParser, (DBObjectPlSqlFragment)plSqlAttribute, plSqlSearch.getStartToken().getStart(), plSqlSearch.getEndToken().getEnd(), string, plSqlToken3);
            PlSqlToken plSqlToken4 = plSqlSearch.getNamedMatchStartToken(datatype);
            PlSqlToken plSqlToken5 = plSqlSearch.getNamedMatchEndToken(datatype);
            PlSqlReference plSqlReference = this.findDataTypeReference(plSqlToken4, plSqlToken5, "dataTypeReference", plSqlParser);
            plSqlAttribute.setDataTypeReference(plSqlReference);
            plSqlAttribute.setSqljExternalName(this.getNameSearchStripQuotes(plSqlSearch, extname));
        }
        return plSqlAttribute;
    }

    private PlSqlMethod getMethod(Type type, PlSqlToken plSqlToken, PlSqlParser plSqlParser) throws CancelledException {
        PlSqlSearch plSqlSearch = new PlSqlSearch("[ { NOT FINAL | <final FINAL> |     NOT OVERRIDING | <over OVERRIDING> |     <notInst  NOT INSTANTIABLE> | INSTANTIABLE }...] <methodType {MEMBER|STATIC|CONSTRUCTOR|MAP MEMBER|ORDER MEMBER}> { PROCEDURE <pname ?> <pparams [(...)]> |   FUNCTION <fname ?> <fparams [(...)]> RETURN <datatype {SELF AS RESULT|?%}> } [EXTERNAL {NAME <extname ?> | VARIABLE NAME <extvarname ?> } ][{DETERMINISTIC|PIPELINED|RESULT_CACHE}...][ {IS|AS} LANGUAGE     { JAVA NAME <javaname ?>     | C [NAME <cname ?>] LIBRARY <clibname ?.>       [AGENT IN ({^)}...) ]       [WITH <ccontext CONTEXT>]       [PARAMETERS ({^)}...) ]     } ]");
        PlSqlMethod plSqlMethod = null;
        if (plSqlSearch.matches(plSqlToken)) {
            plSqlMethod = TypeBuilder.createFragment(PlSqlMethod.class);
            plSqlMethod.setParent((DBObject)type);
            plSqlMethod.setStartOffset(Integer.valueOf(plSqlSearch.getStartToken().getStart()));
            plSqlMethod.setEndOffset(Integer.valueOf(plSqlSearch.getEndToken().getEnd()));
            PlSqlToken plSqlToken2 = plSqlSearch.getNamedMatchStartToken("pname");
            PlSqlToken plSqlToken3 = plSqlSearch.getNamedMatchStartToken("fname");
            PlSqlToken plSqlToken4 = plSqlToken2 != null ? plSqlToken2 : plSqlToken3;
            String string = this.getSubProgramName(plSqlToken4, (PlSqlSubProgram)plSqlMethod);
            plSqlMethod.setName(string);
            plSqlMethod.setFinal(plSqlSearch.getNamedMatch(final_) != null);
            plSqlMethod.setOverriding(plSqlSearch.getNamedMatch(over) != null);
            plSqlMethod.setInstantiable(plSqlSearch.getNamedMatch(notInst) == null);
            String string2 = plSqlSearch.getNamedMatch(methodType);
            string2 = string2.replace(" ", "_");
            try {
                plSqlMethod.setMethodType(PlSqlMethod.MethodType.valueOf((String)string2));
            }
            catch (Exception exception) {
                plSqlMethod.setMethodType(PlSqlMethod.MethodType.MEMBER);
            }
            String string3 = this.getNameSearchStripQuotes(plSqlSearch, javaname);
            String string4 = this.getNameSearchStripQuotes(plSqlSearch, clibname);
            if (string3 != null) {
                plSqlMethod.setCallSpecLanguage(PlSqlMethod.CallSpecLanguage.JAVA);
                plSqlMethod.setCallSpecName(string3);
            } else if (string4 != null) {
                plSqlMethod.setCallSpecLanguage(PlSqlMethod.CallSpecLanguage.C);
                plSqlMethod.setCallSpecName(this.getNameSearchStripQuotes(plSqlSearch, cname));
                plSqlMethod.setCallSpecLibName(string4);
                plSqlMethod.setCallSpecWithContext(plSqlSearch.getNamedMatch(ccontext) != null);
            }
            String string5 = this.getNameSearchStripQuotes(plSqlSearch, extname);
            String string6 = this.getNameSearchStripQuotes(plSqlSearch, extvarname);
            if (string5 != null) {
                plSqlMethod.setSqljSigName(string5);
            } else if (string6 != null) {
                plSqlMethod.setSqljSigVarName(string6);
            }
        }
        return plSqlMethod;
    }

    private void processAlterAttributeClause(Type type, String string, PlSqlToken plSqlToken, PlSqlToken plSqlToken2, PlSqlParser plSqlParser) throws CancelledException {
        if (DROP.equalsIgnoreCase(string)) {
            PlSqlAttribute plSqlAttribute = type.getAttribute(plSqlToken.getSource(true));
            if (plSqlAttribute != null) {
                type.removeAttribute(plSqlAttribute);
            }
        } else {
            PlSqlAttribute plSqlAttribute = this.getAttribute(type, plSqlToken, plSqlToken2, plSqlParser);
            if (plSqlAttribute != null) {
                if (ADD.equalsIgnoreCase(string)) {
                    type.addAttribute(plSqlAttribute);
                } else {
                    PlSqlAttribute plSqlAttribute2 = type.getAttribute(plSqlAttribute.getName());
                    plSqlAttribute.copyTo((Object)plSqlAttribute2);
                }
            }
        }
    }

    private void processDropMethodClause(Type type, PlSqlToken plSqlToken, PlSqlParser plSqlParser) throws CancelledException {
        PlSqlMethod plSqlMethod = this.getMethod(type, plSqlToken, plSqlParser);
        if (plSqlMethod != null) {
            String string = plSqlMethod.getSignature();
            PlSqlMethod plSqlMethod2 = null;
            for (PlSqlMethod plSqlMethod3 : type.getMethods()) {
                if (!string.equals(plSqlMethod3.getSignature())) continue;
                plSqlMethod2 = plSqlMethod3;
                break;
            }
            if (plSqlMethod2 != null) {
                type.removeMethod(plSqlMethod2);
            }
        }
    }

    private Integer getIntegerNamedMatch(PlSqlSearch plSqlSearch, String string) {
        Integer n = null;
        String string2 = plSqlSearch.getNamedMatch(string);
        if (string2 != null) {
            try {
                n = Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                n = null;
            }
        }
        return n;
    }

    private String getNameSearchStripQuotes(PlSqlSearch plSqlSearch, String string) {
        String string2 = plSqlSearch.getNamedMatch(string);
        if (string2 != null && (string2.startsWith("'") && string2.endsWith("'") || string2.startsWith("\"") && string2.endsWith("\""))) {
            string2 = string2.substring(1, string2.length() - 1);
        }
        return string2;
    }
}

