/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.GlobalSettings;
import oracle.javatools.db.Index;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.DefaultSourceOptions;
import oracle.javatools.db.plsql.PlSqlBlock;
import oracle.javatools.db.plsql.PlSqlCodeFragment;
import oracle.javatools.db.plsql.PlSqlParameter;
import oracle.javatools.db.plsql.PlSqlReference;
import oracle.javatools.db.plsql.PlSqlSchemaObject;
import oracle.javatools.db.plsql.PlSqlSchemaObjectBody;
import oracle.javatools.db.plsql.PlSqlSchemaObjectSpec;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlStatement;
import oracle.javatools.db.plsql.PlSqlSubProgram;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.plsql.PlSqlUtilCore;
import oracle.javatools.db.plsql.Procedure;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.plsql.parser.AbstractPlSqlBuilder;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.plsql.parser.PlSqlReferenceResolver;
import oracle.javatools.db.property.DerivedPropertyBuilder;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.token.Token;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Tuple;

public final class PlSqlUtil
extends PlSqlUtilCore {
    public static final String TYPE_NAME_SEARCH = "[create [or replace]] <type {package [body]|type [body]|?}> <name ?.>";
    public static final String FUNCTION_SEARCH = "[create [or replace]] FUNCTION <signature {^{RETURN|AS|IS|;}}... [RETURN <datatype ?%>]>";
    public static final String TYPECODE_SEARCH = "[create [or replace]] TYPE ?. [OID ?] [AUTHID ?] <isAsUnder {IS|AS|UNDER}> <type [{OPAQUE|OBJECT|TABLE OF|VARRAY|VARYING ARRAY}]>";
    public static final String SUBPROGRAM_SEARCH = "{PROCEDURE <pname ?> <pparams [(...)]>|FUNCTION <fname ?> <fparams [(...)]> RETURN <datatype ?%>}";
    public static final String METHOD_SEARCH = "[ { NOT FINAL | <final FINAL> |     NOT OVERRIDING | <over OVERRIDING> |     <notInst  NOT INSTANTIABLE> | INSTANTIABLE }...] <methodType {MEMBER|STATIC|CONSTRUCTOR|MAP MEMBER|ORDER MEMBER}> { PROCEDURE <pname ?> <pparams [(...)]> |   FUNCTION <fname ?> <fparams [(...)]> RETURN <datatype {SELF AS RESULT|?%}> } [EXTERNAL {NAME <extname ?> | VARIABLE NAME <extvarname ?> } ][{DETERMINISTIC|PIPELINED|RESULT_CACHE}...][ {IS|AS} LANGUAGE     { JAVA NAME <javaname ?>     | C [NAME <cname ?>] LIBRARY <clibname ?.>       [AGENT IN ({^)}...) ]       [WITH <ccontext CONTEXT>]       [PARAMETERS ({^)}...) ]     } ]";
    public static final String PARAMETER_SEARCH = "<param ?> [<mode {IN OUT|OUT|IN}>] [<nocopy NOCOPY>] <datatype ?%> [{DEFAULT|:=} <default ?.[(...)]>]";
    public static final String DATATYPE_SEARCH = "<type {TYPE|SUBTYPE}> <name ?> IS <structure ?>";
    public static final String VARIABLE_SEARCH = "<var ?> [CONSTANT] <datatype ?%>";
    public static final String INTO_SEARCH = "select {^{into|from}}... into <intoClause {^from}...>";
    public static final String ALTER_TYPE_SEARCH = "alter type ?. <action {ADD|DROP|MODIFY}> <what ?>";
    private static final String SP = " ";
    private static final String SP2 = "  ";
    private static final String SP4 = "    ";
    private static final String NEWLINE = "\n";
    private static final String SEMICOLON = ";";
    private static final String AS = "AS";
    private static final String IS = "IS";
    private static final String BEGIN = "BEGIN";
    private static final String CREATE_OR_REPLACE = "CREATE OR REPLACE";
    private static final String BODY = "BODY";
    private static final String END = "END";
    private static final String NULL = "NULL";
    private static final String RETURN = "RETURN";
    private static final String SELECT = "SELECT * FROM DUAL;";

    private PlSqlUtil() {
    }

    protected PlSqlSubProgram findPlSqlSubProgramImpl(String string, PlSqlBlock plSqlBlock) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray = string.replace("(", ".(").split("\\.")) {
            arrayList.add(string2);
        }
        return PlSqlUtil.findPlSqlSubProgram(arrayList, plSqlBlock);
    }

    protected List<DBObject> getPlSqlFragmentReferersImpl(PlSqlSourceObject plSqlSourceObject, DBObjectID dBObjectID, DBObjectProvider dBObjectProvider) throws CancelledException {
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        if (dBObjectID != null) {
            PlSqlParser plSqlParser;
            String string = DBUtil.getDBObjectName((DBObjectID)dBObjectID);
            String string2 = dBObjectID.getType();
            Class clazz = Metadata.getInstance().getObjectClass(string2);
            boolean bl = SchemaObject.class.isAssignableFrom(clazz) && Index.class != clazz || DBObjectPlSqlFragment.class.isAssignableFrom(clazz) || Column.class == clazz;
            if (string != null && bl && plSqlSourceObject.getSource() != null && (plSqlParser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)plSqlSourceObject, (DBObjectProvider)dBObjectProvider)) != null) {
                String string3 = string.contains("(") ? string.substring(0, string.indexOf("(")) : string;
                List list = plSqlParser.getLocationOffsets(string3);
                for (Integer n : list) {
                    DBObjectPlSqlFragment dBObjectPlSqlFragment = plSqlSourceObject.getReferenceAtOffset(n.intValue());
                    if (dBObjectPlSqlFragment == null) continue;
                    PlSqlUtil.addRefs((DBObject)dBObjectPlSqlFragment, dBObjectID, arrayList);
                }
            }
        }
        return arrayList;
    }

    protected String getTypeFromSourceImpl(String string) {
        return PlSqlUtil.getTypeAndNameFromSource(string, null).getType();
    }

    protected String getNameFromSourceImpl(String string) {
        return PlSqlUtil.getTypeAndNameFromSource(string, null).getName();
    }

    protected PlSqlParser findOrCreateParserImpl(PlSqlSourceObject plSqlSourceObject, DBObjectProvider dBObjectProvider) throws CancelledException {
        PlSqlParser plSqlParser = null;
        if (plSqlSourceObject instanceof DBObjectPlSqlFragment && dBObjectProvider != null) {
            DBObjectPlSqlFragment dBObjectPlSqlFragment = (DBObjectPlSqlFragment)plSqlSourceObject;
            DerivedPropertyBuilder derivedPropertyBuilder = dBObjectProvider.getObjectFactory().ensureDerivedPropertyBuilder((DBObject)dBObjectPlSqlFragment, false);
            if (derivedPropertyBuilder instanceof AbstractPlSqlBuilder) {
                plSqlParser = ((AbstractPlSqlBuilder)derivedPropertyBuilder).getParser((PlSqlCodeFragment)plSqlSourceObject);
            } else {
                DBLog.getLogger((Object)((Object)this)).log(Level.SEVERE, "Unexpected derived property builder");
            }
        }
        return plSqlParser;
    }

    public static void registerPlSqlUtil() {
        PlSqlUtil plSqlUtil = new PlSqlUtil();
        PlSqlUtil.setInstance((PlSqlUtilCore)plSqlUtil);
    }

    public static PlSqlSubProgram findPlSqlSubProgram(List<String> list, PlSqlBlock plSqlBlock) {
        StringTokenizer stringTokenizer;
        String string;
        if (list.size() > 2 || list.size() == 2 && !list.get(1).startsWith("(")) {
            return null;
        }
        ArrayList<PlSqlSubProgram> arrayList = new ArrayList<PlSqlSubProgram>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (list.get(list.size() - 1).startsWith("(")) {
            string = list.get(list.size() - 2);
            stringTokenizer = new StringTokenizer(list.get(list.size() - 1), "(),", false);
            while (stringTokenizer.hasMoreTokens()) {
                arrayList2.add(stringTokenizer.nextToken());
            }
        } else {
            string = list.get(list.size() - 1);
        }
        stringTokenizer = null;
        for (PlSqlSubProgram plSqlSubProgram : plSqlBlock.getSubPrograms()) {
            String string2;
            String string3 = plSqlSubProgram.getName();
            String string4 = string2 = string3 == null ? null : plSqlSubProgram.getName().split("[\\( ]")[0];
            if (!string.equals(string2)) continue;
            if (stringTokenizer == null) {
                stringTokenizer = plSqlSubProgram;
            }
            if (arrayList2.size() > plSqlSubProgram.getParameters().length) continue;
            boolean bl = false;
            for (String string5 : arrayList2) {
                PlSqlParameter plSqlParameter;
                if ("?".equals(string5) || (plSqlParameter = plSqlSubProgram.getParameter(string5)) != null) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(plSqlSubProgram);
        }
        if (arrayList.size() == 0) {
            return stringTokenizer;
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            int n;
            ArrayList<PlSqlParameter> arrayList3 = new ArrayList<PlSqlParameter>();
            int n2 = 0;
            PlSqlParameter[] plSqlParameterArray = ((PlSqlSubProgram)arrayList.get(i)).getParameters();
            int n3 = plSqlParameterArray.length;
            for (n = 0; n < n3; ++n) {
                PlSqlParameter plSqlParameter = plSqlParameterArray[n];
                arrayList3.add(plSqlParameter);
            }
            boolean bl = false;
            for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                if (bl && "?".equals(arrayList2.get(n3))) {
                    n2 = 1;
                    break;
                }
                if ("?".equals(arrayList2.get(n3))) {
                    arrayList3.set(n3, null);
                    continue;
                }
                for (n = 0; n < arrayList3.size(); ++n) {
                    if (arrayList3.get(n) == null || !((String)arrayList2.get(n3)).equals(((PlSqlParameter)arrayList3.get(n)).getName())) continue;
                    arrayList3.set(n, null);
                    break;
                }
                bl = true;
            }
            for (n3 = 0; n3 < arrayList3.size(); ++n3) {
                if (arrayList3.get(n3) == null || ((PlSqlParameter)arrayList3.get(n3)).getMode() != PlSqlParameter.Mode.OUT && ((PlSqlParameter)arrayList3.get(n3)).getMode() != PlSqlParameter.Mode.INOUT && ((PlSqlParameter)arrayList3.get(n3)).getDefaultValue() != null) continue;
                n2 = 1;
                break;
            }
            if (n2 == 0) continue;
            arrayList.remove(i);
        }
        if (arrayList.size() < 2) {
            return arrayList.size() == 0 ? stringTokenizer : (PlSqlSubProgram)arrayList.get(0);
        }
        return (PlSqlSubProgram)arrayList.get(0);
    }

    private static void addRefs(DBObject dBObject, DBObjectID dBObjectID, List<DBObject> list) {
        DBObjectID[] dBObjectIDArray = dBObject instanceof PlSqlReference ? ((PlSqlReference)dBObject).getReferences() : dBObject.getReferenceIDs();
        for (DBObjectID dBObjectID2 : dBObjectIDArray) {
            if (!DBUtil.isSameOrChildOf((DBObjectID)dBObjectID2, (DBObjectID)dBObjectID, (boolean)false)) continue;
            list.add(dBObject);
            break;
        }
        for (DBObjectID dBObjectID2 : dBObject.getOwnedObjects()) {
            PlSqlUtil.addRefs((DBObject)dBObjectID2, dBObjectID, list);
        }
    }

    @Deprecated
    public static boolean updateSoureForPropertyChange(PlSqlSourceObject plSqlSourceObject, DBObjectProvider dBObjectProvider, DBObject dBObject, String string, Object object) {
        try {
            return PlSqlUtil.updateSourceForRefactor(plSqlSourceObject, dBObjectProvider, dBObject, string, dBObject.getProperty(string), object);
        }
        catch (CancelledException cancelledException) {
            DBLog.getLogger(PlSqlUtil.class).info(cancelledException.getMessage());
            return false;
        }
    }

    private static String getName(String string, Object object) {
        String string2;
        if ("schema".equals(string)) {
            string2 = ((Schema)object).getName();
        } else if (((String)object).contains("(")) {
            String string3 = (String)object;
            string2 = string3 = string3.substring(0, string3.indexOf("("));
        } else {
            string2 = (String)object;
        }
        return string2;
    }

    public static boolean updateSourceForRefactor(PlSqlSourceObject plSqlSourceObject, DBObjectProvider dBObjectProvider, DBObject dBObject, String string, Object object, Object object2) throws CancelledException {
        boolean bl = false;
        if (plSqlSourceObject != null && ModelUtil.hasLength((String)plSqlSourceObject.getSource())) {
            Object object3;
            String string2;
            if ("name".equals(string) && dBObject == plSqlSourceObject && ModelUtil.areDifferent((Object)object, (Object)(string2 = ((TypeAndNameInfo)(object3 = PlSqlUtil.getTypeAndNameFromSource(plSqlSourceObject, dBObjectProvider.getDescriptor()))).getName())) && ModelUtil.areDifferent((Object)object2, (Object)string2)) {
                return false;
            }
            if ("name".equals(string) || "schema".equals(string)) {
                object3 = dBObject.getID();
                string2 = PlSqlUtil.getName(string, object2);
                PlSqlParser plSqlParser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)plSqlSourceObject, (DBObjectProvider)dBObjectProvider);
                if (plSqlParser != null) {
                    DBObjectID[] dBObjectIDArray;
                    DBObjectPlSqlFragment dBObjectPlSqlFragment;
                    String string3 = PlSqlUtil.getName(string, object);
                    List list = plSqlParser.getLocationOffsets(string3);
                    PlSqlToken plSqlToken = plSqlParser.getNameToken();
                    if (plSqlSourceObject == dBObject && plSqlToken != null && !plSqlToken.matches(string3)) {
                        list.add(plSqlToken.getStart());
                    }
                    Object[] objectArray = list.toArray(new Integer[list.size()]);
                    Arrays.sort(objectArray);
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    for (Object object4 : objectArray) {
                        dBObjectPlSqlFragment = plSqlSourceObject.getReferenceAtOffset(((Integer)object4).intValue());
                        if (dBObjectPlSqlFragment instanceof PlSqlReference) {
                            arrayList.add((PlSqlReference)dBObjectPlSqlFragment);
                            continue;
                        }
                        if (dBObjectPlSqlFragment == null || !object3.equals(dBObjectPlSqlFragment.getID(), false)) continue;
                        dBObjectIDArray = new PlSqlReference();
                        DBObjectID[] dBObjectIDArray2 = new DBObjectID[]{dBObjectPlSqlFragment.getID()};
                        dBObjectIDArray.setReferences(dBObjectIDArray2);
                        if (dBObject instanceof PlSqlSubProgram) {
                            PlSqlToken plSqlToken2 = plSqlParser.getTokenAtOffset(dBObjectPlSqlFragment.getStartOffset().intValue());
                            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            dBObjectIDArray.setStartOffset(Integer.valueOf(plSqlToken2.getStart()));
                            dBObjectIDArray.setEndOffset(Integer.valueOf(plSqlToken2.getEnd()));
                        } else {
                            dBObjectIDArray.setStartOffset(dBObjectPlSqlFragment.getStartOffset());
                            dBObjectIDArray.setEndOffset(dBObjectPlSqlFragment.getEndOffset());
                        }
                        arrayList.add(dBObjectIDArray);
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    String string4 = plSqlSourceObject.getSource();
                    int n = string4.length();
                    block1: for (int i = arrayList.size() - 1; i >= 0; --i) {
                        dBObjectPlSqlFragment = (PlSqlReference)arrayList.get(i);
                        dBObjectIDArray = dBObjectPlSqlFragment.getReferences();
                        int n2 = dBObjectIDArray.length;
                        for (int j = 0; j < n2; ++j) {
                            String string5;
                            DBObjectID dBObjectID;
                            DBObjectID dBObjectID2 = dBObjectID = dBObjectIDArray[j];
                            PlSqlToken plSqlToken3 = plSqlParser.getTokenAtOffset(dBObjectPlSqlFragment.getStartOffset().intValue());
                            PlSqlToken plSqlToken4 = plSqlParser.getTokenAtOffset(dBObjectPlSqlFragment.getEndOffset().intValue());
                            PlSqlToken plSqlToken5 = plSqlToken3;
                            if (dBObjectPlSqlFragment.getReferenceType() == PlSqlReference.ReferenceType.PCT_TYPE || dBObjectPlSqlFragment.getReferenceType() == PlSqlReference.ReferenceType.PCT_ROWTYPE) {
                                plSqlToken4 = (PlSqlToken)((PlSqlToken)plSqlToken4.getPrevToken()).getPrevToken();
                            } else if (object3.equals(dBObjectID2, false) && dBObject instanceof PlSqlParameter) {
                                plSqlToken4 = plSqlToken3;
                            }
                            while (dBObjectID2 != null) {
                                boolean bl2 = false;
                                if (dBObjectID2 instanceof TemporaryObjectID) {
                                    if (dBObject == ((TemporaryObjectID)dBObjectID2).getDBObject()) {
                                        bl2 = true;
                                    }
                                } else if (dBObject == plSqlSourceObject && "UNSPECIFIED_TYPE".equals(dBObjectID2.getType()) && ModelUtil.areEqual((Object)plSqlSourceObject.getName(), (Object)string2) && dBObjectID2 instanceof ReferenceID && (string5 = ((ReferenceID)dBObjectID2).getName()) != null) {
                                    int n3 = string5.indexOf("(");
                                    if (n3 > 0) {
                                        string5 = string5.substring(0, n3);
                                    }
                                    boolean bl3 = bl2 = string5.equals(string2) || string5.equals(string3);
                                }
                                if (bl2 || object3.equals(dBObjectID2, false)) {
                                    plSqlToken5 = plSqlToken4;
                                    break;
                                }
                                if ((dBObjectID2 = dBObjectID2.getParent()) == null) continue;
                                if (plSqlToken4.getEnd() != plSqlToken3.getEnd() && ((PlSqlToken)plSqlToken4.getPrevToken()).matches(".")) {
                                    plSqlToken4 = (PlSqlToken)((PlSqlToken)plSqlToken4.getPrevToken()).getPrevToken();
                                    continue;
                                }
                                dBObjectID2 = null;
                            }
                            if (dBObjectID2 == null) continue;
                            bl = true;
                            stringBuilder.insert(0, string4.substring(plSqlToken5.getEnd() + 1, n));
                            n = plSqlToken5.getStart();
                            if ("schema".equals(string)) {
                                stringBuilder.insert(0, plSqlToken5.getSource());
                                if (!((PlSqlToken)plSqlToken5.getPrevCodeToken()).matches(".")) {
                                    stringBuilder.insert(0, ".");
                                } else {
                                    plSqlToken5 = (PlSqlToken)((PlSqlToken)plSqlToken5.getPrevCodeToken()).getPrevCodeToken();
                                    n = plSqlToken5.getStart();
                                    if (plSqlSourceObject.getSchema().getName().equals(string2)) continue;
                                    stringBuilder.insert(0, ".");
                                }
                            }
                            String string6 = dBObjectProvider.getExternalName(string2);
                            string5 = plSqlToken5.getSource();
                            Object object5 = !string2.equals(string6) ? string6 : (plSqlToken5.getType() == Token.Type.DOUBLE_QUOTED_STRING && !dBObjectProvider.getExternalName(dBObjectProvider.getInternalName(string5)).equals(string5) ? "\"" + string2 + "\"" : (string5.toLowerCase().equals(string5) ? string2.toLowerCase() : string2));
                            stringBuilder.insert(0, (String)object5);
                            continue block1;
                        }
                    }
                    if (bl) {
                        stringBuilder.insert(0, string4.substring(0, n));
                        plSqlSourceObject.setSource(stringBuilder.toString());
                    }
                }
            }
        }
        return bl;
    }

    public static boolean isBodyOf(DBObject dBObject, DBObject dBObject2) {
        DBObjectID dBObjectID;
        boolean bl = false;
        if (dBObject instanceof PlSqlSchemaObjectSpec && dBObject2 instanceof PlSqlSchemaObjectBody && (dBObjectID = ((PlSqlSchemaObjectBody)dBObject2).getSpecID()) != null) {
            bl = dBObjectID.equals(dBObject.getID(), false);
        }
        return bl;
    }

    public static void rebuildSource(DBObjectProvider dBObjectProvider, PlSqlSourceObject plSqlSourceObject) throws CancelledException {
        PlSqlParser plSqlParser;
        if ((plSqlSourceObject instanceof Procedure || plSqlSourceObject instanceof Trigger) && (plSqlParser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)plSqlSourceObject, (DBObjectProvider)dBObjectProvider)) != null) {
            PlSqlToken plSqlToken;
            String string;
            PlSqlToken plSqlToken2 = plSqlParser.getTypeToken();
            while (plSqlToken2.getType() != Token.Type.ALPHANUMERIC && plSqlToken2.getType() != Token.Type.END_MARKER) {
                plSqlToken2 = (PlSqlToken)plSqlToken2.getNextToken();
            }
            boolean bl = false;
            if (plSqlToken2.getType() == Token.Type.ALPHANUMERIC) {
                string = plSqlToken2.getSource();
                bl = string.equals(string.toLowerCase());
            }
            string = null;
            try {
                string = (PlSqlSourceObject)plSqlSourceObject.getClass().newInstance();
                string = (PlSqlSourceObject)plSqlSourceObject.copyTo((Object)string);
                string.setSource(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                DBLog.getLogger(PlSqlUtil.class).warning("Failed to create copy: " + illegalAccessException.getMessage());
            }
            catch (InstantiationException instantiationException) {
                DBLog.getLogger(PlSqlUtil.class).warning("Failed to create copy: " + instantiationException.getMessage());
            }
            StringBuilder stringBuilder = new StringBuilder(PlSqlUtil.getDefaultSource(dBObjectProvider, (PlSqlSourceObject)string, bl));
            PlSqlToken plSqlToken3 = (PlSqlToken)plSqlToken2.getTokenAt(0);
            if (!plSqlToken3.isCode()) {
                plSqlToken = (PlSqlToken)((PlSqlToken)plSqlToken3.getNextCodeToken()).getPrevToken();
                stringBuilder.insert(0, plSqlToken3.getSource(false, (Token)plSqlToken));
            }
            if (plSqlSourceObject instanceof Procedure) {
                string.setSource(stringBuilder.toString());
                plSqlToken = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)string, (DBObjectProvider)dBObjectProvider);
                if (plSqlToken != null) {
                    Tuple<PlSqlToken, PlSqlToken> tuple = PlSqlUtil.getParameterLimits(plSqlParser.getTypeToken());
                    Tuple<PlSqlToken, PlSqlToken> tuple2 = PlSqlUtil.getParameterLimits(plSqlToken.getTypeToken());
                    PlSqlToken plSqlToken4 = (PlSqlToken)tuple.getFirst();
                    PlSqlToken plSqlToken5 = (PlSqlToken)tuple.getSecond();
                    PlSqlToken plSqlToken6 = (PlSqlToken)tuple2.getFirst();
                    PlSqlToken plSqlToken7 = (PlSqlToken)tuple2.getSecond();
                    if (plSqlToken4 != null && plSqlToken5 != null && plSqlToken6 != null && plSqlToken7 != null) {
                        stringBuilder = new StringBuilder();
                        stringBuilder.append(plSqlSourceObject.getSource().substring(0, plSqlToken4.getStart()));
                        stringBuilder.append(string.getSource().substring(plSqlToken6.getStart(), plSqlToken7.getStart()));
                        stringBuilder.append(plSqlSourceObject.getSource().substring(plSqlToken5.getStart()));
                    }
                }
            }
            plSqlSourceObject.setSource(stringBuilder.toString());
        }
    }

    public static String getDefaultSource(DBObjectProvider dBObjectProvider, PlSqlSourceObject plSqlSourceObject) {
        boolean bl = false;
        GlobalSettings globalSettings = GlobalSettings.getInstance();
        if (globalSettings != null) {
            bl = globalSettings.isNewPlSqlLowerCase();
        }
        return PlSqlUtil.getDefaultSource(dBObjectProvider, plSqlSourceObject, bl);
    }

    @Deprecated
    public static String getDefaultSource(DBObjectProvider dBObjectProvider, PlSqlSourceObject plSqlSourceObject, DDLGenerator dDLGenerator) {
        return PlSqlUtil.getDefaultSource(dBObjectProvider, plSqlSourceObject);
    }

    private static String getDefaultSource(DBObjectProvider dBObjectProvider, PlSqlSourceObject plSqlSourceObject, boolean bl) {
        Trigger trigger;
        DatabaseDescriptor databaseDescriptor = dBObjectProvider.getDescriptor();
        DefaultSourceOptions defaultSourceOptions = databaseDescriptor.getDefaultSourceOptions();
        boolean bl2 = false;
        if (plSqlSourceObject instanceof Trigger) {
            trigger = (Trigger)plSqlSourceObject;
            if ("".equals(trigger.getWhenClause())) {
                trigger.setWhenClause(null);
            }
            if (!trigger.isEnabled() && defaultSourceOptions.isEnableTriggers()) {
                bl2 = true;
                trigger.setEnabled(true);
            }
        }
        trigger = new DDLOptions(defaultSourceOptions.isUseCreateOrReplace(), false);
        DDLGenerator dDLGenerator = dBObjectProvider.getDDLGenerator();
        String string = dDLGenerator.getCreateDDL((DDLOptions)trigger, new DBObject[]{plSqlSourceObject}).toString(defaultSourceOptions.isIncludeTerminators());
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder();
            PlSqlToken plSqlToken = PlSqlTokenizer.tokenize((String)string, (String[])new String[0]);
            while (plSqlToken.getType() != Token.Type.END_MARKER) {
                plSqlToken = (PlSqlToken)plSqlToken.getPrevToken();
            }
            plSqlToken = (PlSqlToken)plSqlToken.getNextToken();
            while (plSqlToken.getType() != Token.Type.END_MARKER) {
                if (plSqlToken.isCode() && !plSqlToken.getSource().startsWith("\"")) {
                    stringBuilder.append(plSqlToken.getSource().toLowerCase());
                } else {
                    stringBuilder.append(plSqlToken.getSource());
                }
                plSqlToken = (PlSqlToken)plSqlToken.getNextToken();
            }
            string = stringBuilder.toString();
        }
        if (bl2) {
            ((Trigger)plSqlSourceObject).setEnabled(false);
        }
        return string;
    }

    @Deprecated
    public static void setSource(PlSqlSourceObject plSqlSourceObject, String string, boolean bl) {
    }

    @Deprecated
    public static void clearDerivedProperties(SourceObject sourceObject) {
    }

    @Deprecated
    public static boolean isDerivedPropsBuilt(DBObjectPlSqlFragment dBObjectPlSqlFragment) {
        return false;
    }

    private static Tuple<PlSqlToken, PlSqlToken> getParameterLimits(PlSqlToken plSqlToken) {
        PlSqlToken plSqlToken2 = null;
        PlSqlToken plSqlToken3 = null;
        PlSqlSearch plSqlSearch = new PlSqlSearch("{procedure|function} ?.");
        PlSqlSearch plSqlSearch2 = new PlSqlSearch("[return ?%] {is|as}");
        PlSqlToken plSqlToken4 = plSqlToken;
        if (plSqlSearch.isWithin(plSqlToken4)) {
            plSqlToken4 = plSqlSearch.getEndToken();
            plSqlToken2 = plSqlToken4 = (PlSqlToken)plSqlToken4.getNextToken();
            if ((plSqlToken4 = (PlSqlToken)plSqlToken4.getNextCodeToken()).matches("(")) {
                int n = 1;
                plSqlToken4 = (PlSqlToken)plSqlToken4.getNextCodeToken();
                while (n > 0 && plSqlToken4.getType() != Token.Type.END_MARKER) {
                    if (plSqlToken4.matches("(")) {
                        ++n;
                    } else if (plSqlToken4.matches(")")) {
                        --n;
                    }
                    plSqlToken4 = (PlSqlToken)plSqlToken4.getNextToken();
                }
            }
            if (plSqlSearch2.isWithin(plSqlToken4)) {
                plSqlToken4 = plSqlSearch2.getEndToken();
                plSqlToken3 = plSqlToken4 = (PlSqlToken)plSqlToken4.getPrevToken();
            }
        }
        return new Tuple(plSqlToken2, plSqlToken3);
    }

    public static TypeAndNameInfo getTypeAndNameFromSource(PlSqlSourceObject plSqlSourceObject, DatabaseDescriptor databaseDescriptor) {
        return PlSqlUtil.getTypeAndNameFromSource(plSqlSourceObject == null ? null : plSqlSourceObject.getSource(), databaseDescriptor);
    }

    public static TypeAndNameInfo getTypeAndNameFromSource(String string, DatabaseDescriptor databaseDescriptor) {
        PlSqlToken plSqlToken;
        TypeAndNameInfo typeAndNameInfo = new TypeAndNameInfo();
        PlSqlSearch plSqlSearch = new PlSqlSearch(TYPE_NAME_SEARCH);
        if (string != null && plSqlSearch.matches(plSqlToken = PlSqlTokenizer.tokenize((Reader)new StringReader(string), (Integer)10))) {
            typeAndNameInfo.m_type = plSqlSearch.getNamedMatch("type", true);
            typeAndNameInfo.m_typeStart = plSqlSearch.getNamedMatchStartToken("type").getStart();
            typeAndNameInfo.m_typeEnd = plSqlSearch.getNamedMatchEndToken("type").getEnd();
            typeAndNameInfo.m_name = databaseDescriptor == null ? plSqlSearch.getNamedMatchEndToken("name").getSource(true) : databaseDescriptor.getInternalName(plSqlSearch.getNamedMatchEndToken("name").getSource(), typeAndNameInfo.m_type);
            typeAndNameInfo.m_nameStart = plSqlSearch.getNamedMatchStartToken("name").getStart();
            typeAndNameInfo.m_nameEnd = plSqlSearch.getNamedMatchEndToken("name").getEnd();
        }
        return typeAndNameInfo;
    }

    @Deprecated
    public static boolean containsUnResolvedReferences(PlSqlSourceObject plSqlSourceObject, DBObjectProvider dBObjectProvider) {
        return false;
    }

    public static String getDefaultBodyForSpec(PlSqlSourceObject plSqlSourceObject, String string, DBObjectProvider dBObjectProvider) throws CancelledException {
        PlSqlParser plSqlParser;
        StringBuilder stringBuilder = new StringBuilder();
        if (plSqlSourceObject != null && (plSqlParser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)plSqlSourceObject, (DBObjectProvider)dBObjectProvider)) != null) {
            stringBuilder.append(PlSqlUtil.getDefaultBodyHeaderForSpec(plSqlSourceObject, string));
            PlSqlSearch plSqlSearch = new PlSqlSearch("not instantiable");
            IdentityHashMap identityHashMap = new IdentityHashMap();
            for (PlSqlSubProgram plSqlSubProgram : plSqlSourceObject.getSubPrograms()) {
                if (!plSqlParser.getTokenAtOffset(plSqlSubProgram.getStartOffset().intValue()).matches("cursor")) continue;
                stringBuilder.append(PlSqlUtil.getDefaultImplementation(plSqlSourceObject, plSqlSubProgram, dBObjectProvider));
                identityHashMap.put(plSqlSubProgram, null);
            }
            for (PlSqlSubProgram plSqlSubProgram : plSqlSourceObject.getSubPrograms()) {
                if (identityHashMap.containsKey(plSqlSubProgram) || plSqlSearch.isWithin(plSqlParser.getTokenAtOffset(plSqlSubProgram.getStartOffset().intValue()), plSqlParser.getTokenAtOffset(plSqlSubProgram.getEndOffset().intValue()))) continue;
                stringBuilder.append(PlSqlUtil.getDefaultImplementation(plSqlSourceObject, plSqlSubProgram, dBObjectProvider));
            }
            stringBuilder.append(PlSqlUtil.getDefaultBodyFooterForSpec(plSqlSourceObject, string));
        }
        return stringBuilder.toString();
    }

    private static String getDefaultBodyHeaderForSpec(PlSqlSourceObject plSqlSourceObject, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (plSqlSourceObject != null) {
            stringBuilder.append(CREATE_OR_REPLACE).append(NEWLINE);
            stringBuilder.append(plSqlSourceObject.getType()).append(SP).append(BODY).append(SP).append(string).append(SP).append(AS).append(NEWLINE).append(NEWLINE);
        }
        return PlSqlUtil.toLowerIfNeeded(stringBuilder.toString());
    }

    private static String getDefaultBodyFooterForSpec(PlSqlSourceObject plSqlSourceObject, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (plSqlSourceObject != null) {
            stringBuilder.append(END);
            if (!(plSqlSourceObject instanceof Type)) {
                stringBuilder.append(SP).append(string);
            }
            stringBuilder.append(SEMICOLON);
        }
        return PlSqlUtil.toLowerIfNeeded(stringBuilder.toString());
    }

    public static String getDefaultImplementation(PlSqlSourceObject plSqlSourceObject, PlSqlSubProgram plSqlSubProgram, DBObjectProvider dBObjectProvider) throws CancelledException {
        StringBuilder stringBuilder = new StringBuilder();
        PlSqlParser plSqlParser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)plSqlSourceObject, (DBObjectProvider)dBObjectProvider);
        if (plSqlParser != null) {
            PlSqlToken plSqlToken;
            PlSqlToken plSqlToken2 = plSqlToken = plSqlParser.getTokenAtOffset(plSqlSubProgram.getStartOffset().intValue());
            while (!(plSqlToken2.matches("FUNCTION") || plSqlToken2.matches("PROCEDURE") || plSqlToken2.matches("CURSOR"))) {
                plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
            }
            String string = plSqlToken2.getSource();
            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
            String string2 = plSqlToken2.getSource();
            if ("CURSOR".equalsIgnoreCase(string)) {
                stringBuilder.append(SP2);
                PlSqlToken plSqlToken3 = plSqlParser.getTokenAtOffset(plSqlSubProgram.getEndOffset().intValue());
                if (plSqlToken3.matches(SEMICOLON)) {
                    plSqlToken3 = (PlSqlToken)plSqlToken3.getPrevCodeToken();
                    stringBuilder.append(plSqlToken.getSource(false, (Token)plSqlToken3)).append(SP).append(IS);
                    stringBuilder.append(NEWLINE).append(SP4).append(APIBundle.format((String)"NEW_SOURCE_TODO_IMPLEMENTATION_REQD", (Object[])new Object[]{string, plSqlSourceObject.getName(), string2}));
                    stringBuilder.append(NEWLINE).append(SP4).append(SELECT);
                }
                stringBuilder.append(NEWLINE).append(NEWLINE);
            } else {
                String string3 = plSqlSourceObject.getSource().substring(plSqlSubProgram.getStartOffset(), plSqlSubProgram.getEndOffset() + 1);
                int n = string3.length();
                if (n > 0) {
                    int n2;
                    if (plSqlSourceObject.getType().equals("PACKAGE") && (n2 = string3.lastIndexOf(SEMICOLON)) > 0) {
                        n = n2;
                    }
                    stringBuilder.append(SP2);
                    stringBuilder.append(string3.substring(0, n)).append(SP).append(AS);
                    stringBuilder.append(NEWLINE).append(SP2).append(BEGIN);
                    stringBuilder.append(NEWLINE).append(SP4).append(APIBundle.format((String)"NEW_SOURCE_TODO_IMPLEMENTATION_REQD", (Object[])new Object[]{string, plSqlSourceObject.getName(), string2}));
                    stringBuilder.append(NEWLINE).append(SP4);
                    if (plSqlSubProgram.getReturnTypeReference() != null) {
                        stringBuilder.append(RETURN).append(SP);
                    }
                    stringBuilder.append(NULL).append(SEMICOLON);
                    stringBuilder.append(NEWLINE).append(SP2).append(END).append(SP).append(string2).append(SEMICOLON);
                    stringBuilder.append(NEWLINE).append(NEWLINE);
                }
            }
        }
        return PlSqlUtil.toLowerIfNeeded(stringBuilder.toString());
    }

    public static String toLowerIfNeeded(String string) {
        boolean bl;
        GlobalSettings globalSettings = GlobalSettings.getInstance();
        boolean bl2 = bl = globalSettings != null && globalSettings.isNewPlSqlLowerCase();
        if (string != null && bl) {
            StringBuilder stringBuilder = new StringBuilder();
            PlSqlToken plSqlToken = PlSqlTokenizer.tokenize((String)string, (String[])new String[0]);
            while (!plSqlToken.isEndMarker()) {
                plSqlToken = (PlSqlToken)plSqlToken.getPrevToken();
            }
            plSqlToken = (PlSqlToken)plSqlToken.getNextToken();
            while (plSqlToken.getType() != Token.Type.END_MARKER) {
                if (plSqlToken.isCode(true) && !plSqlToken.getSource().startsWith("\"")) {
                    stringBuilder.append(plSqlToken.getSource().toLowerCase());
                } else {
                    stringBuilder.append(plSqlToken.getSource());
                }
                plSqlToken = (PlSqlToken)plSqlToken.getNextToken();
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    public static PlSqlSchemaObject getCompanionObject(PlSqlSchemaObject plSqlSchemaObject, DBObjectProvider dBObjectProvider) throws DBException {
        PlSqlSchemaObject plSqlSchemaObject2 = null;
        if (plSqlSchemaObject != null) {
            DBObjectID dBObjectID = null;
            if (plSqlSchemaObject instanceof PlSqlSchemaObjectSpec && !DBUtil.needsBuilding((DBObject)plSqlSchemaObject, (String)"bodyID")) {
                dBObjectID = ((PlSqlSchemaObjectSpec)plSqlSchemaObject).getBodyID();
            } else if (plSqlSchemaObject instanceof PlSqlSchemaObjectBody && !DBUtil.needsBuilding((DBObject)plSqlSchemaObject, (String)"specID")) {
                dBObjectID = ((PlSqlSchemaObjectBody)plSqlSchemaObject).getSpecID();
            }
            if (dBObjectID != null) {
                plSqlSchemaObject2 = (PlSqlSchemaObject)dBObjectID.resolveID();
            }
            if (plSqlSchemaObject2 == null) {
                boolean bl;
                String string = plSqlSchemaObject.getName();
                String string2 = PlSqlUtil.getCompanionObjectType(plSqlSchemaObject);
                if (dBObjectID == null) {
                    bl = true;
                } else {
                    String string3 = PlSqlUtil.getNameFromID(dBObjectID);
                    if (string3 == null) {
                        bl = false;
                    } else {
                        boolean bl2 = bl = !dBObjectProvider.getDescriptor().areNamesEqual(string, string3, string2, false);
                    }
                }
                if (bl) {
                    plSqlSchemaObject2 = (PlSqlSchemaObject)dBObjectProvider.getObject(string2, plSqlSchemaObject.getSchema(), string);
                }
            }
        }
        return plSqlSchemaObject2;
    }

    private static String getNameFromID(DBObjectID dBObjectID) {
        String string = dBObjectID instanceof TemporaryObjectID ? ((TemporaryObjectID)dBObjectID).getDBObject().getName() : (dBObjectID instanceof NameBasedID ? ((NameBasedID)dBObjectID).getName() : null);
        return string;
    }

    public static String getCompanionObjectType(PlSqlSchemaObject plSqlSchemaObject) {
        return PlSqlUtil.getCompanionObjectType(plSqlSchemaObject.getType());
    }

    public static String getCompanionObjectType(String string) {
        String string2 = "PACKAGE".equals(string) ? "PACKAGE BODY" : ("TYPE".equals(string) ? "TYPE BODY" : ("PACKAGE BODY".equals(string) ? "PACKAGE" : ("TYPE BODY".equals(string) ? "TYPE" : null)));
        return string2;
    }

    public static List<Tuple<PlSqlSubProgram, PlSqlSubProgram>> getTopLevelPlSqlFragments(DBObjectProvider dBObjectProvider, PlSqlSchemaObject plSqlSchemaObject, PlSqlSchemaObject plSqlSchemaObject2) throws CancelledException {
        String string;
        PlSqlStatement.Type type;
        if (plSqlSchemaObject == null) {
            throw new IllegalArgumentException("obj is null");
        }
        ArrayList<Tuple<PlSqlSubProgram, PlSqlSubProgram>> arrayList = new ArrayList<Tuple<PlSqlSubProgram, PlSqlSubProgram>>();
        HashMap<String, PlSqlStatement.Type> hashMap = new HashMap<String, PlSqlStatement.Type>();
        PlSqlParser plSqlParser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)plSqlSchemaObject, (DBObjectProvider)dBObjectProvider);
        if (plSqlParser == null || plSqlParser.isWrapped()) {
            return arrayList;
        }
        if (plSqlSchemaObject2 != null) {
            PlSqlParser plSqlParser2 = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)plSqlSchemaObject2, (DBObjectProvider)dBObjectProvider);
            if (plSqlParser2 == null || plSqlParser2.isWrapped()) {
                return arrayList;
            }
            PlSqlSubProgram[] plSqlSubProgramArray = plSqlSchemaObject2.getSubPrograms();
            int n = plSqlSubProgramArray.length;
            for (int i = 0; i < n; ++i) {
                String string2;
                type = plSqlSubProgramArray[i];
                CancelledException.checkInterrupt();
                string = type.getStatementType();
                if (plSqlSchemaObject2 instanceof PlSqlSchemaObjectBody && (string == PlSqlStatement.Type.FUNCTION_FD || string == PlSqlStatement.Type.PROCEDURE_FD) || (string2 = type.getSignature(false)) == null) continue;
                hashMap.put(string2, type);
            }
        }
        for (PlSqlParser plSqlParser3 : plSqlSchemaObject.getSubPrograms()) {
            type = plSqlParser3.getStatementType();
            if (plSqlSchemaObject instanceof PlSqlSchemaObjectBody && (type == PlSqlStatement.Type.FUNCTION_FD || type == PlSqlStatement.Type.PROCEDURE_FD) || (string = plSqlParser3.getSignature(false)) == null) continue;
            arrayList.add((Tuple<PlSqlSubProgram, PlSqlSubProgram>)new Tuple((Object)plSqlParser3, (Object)((PlSqlSubProgram)hashMap.get(string))));
        }
        return arrayList;
    }

    public static List<DBObjectID> findReferences(List<String> list, DBObjectProvider dBObjectProvider, DBObject dBObject) throws DBException {
        return PlSqlReferenceResolver.findReferences(list, dBObjectProvider, dBObject);
    }

    public static class TypeAndNameInfo {
        private String m_type;
        private int m_typeStart;
        private int m_typeEnd;
        private String m_name;
        private int m_nameStart;
        private int m_nameEnd;

        public String getType() {
            return this.m_type;
        }

        public int getTypeStart() {
            return this.m_typeStart;
        }

        public int getTypeEnd() {
            return this.m_typeEnd;
        }

        public String getName() {
            return this.m_name;
        }

        public int getNameStart() {
            return this.m_nameStart;
        }

        public int getNameEnd() {
            return this.m_nameEnd;
        }
    }
}

