/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Index;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Table;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.LocalIndexPartitionHelper;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleExternalTableProperties;
import oracle.javatools.db.ora.OracleIndexOrganizedTableProperties;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.ReferencePartitionHelper;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.refactoring.CascadeAction;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.MissingValidatorException;
import oracle.javatools.db.validators.TableValidator;
import oracle.javatools.db.validators.ValidationContext;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;

public class OracleTableValidator<T extends Table>
extends TableValidator<T> {
    public OracleTableValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    @Override
    protected boolean isColumnRenameCascadableToVirtualExpression() {
        return !(this.getProvider() instanceof OracleDatabase);
    }

    @DBObjectValidator.PropertyValidator(value={"OracleIndexOrganizedTableProperties"})
    public void validateIOTProperties(T t, T t2) throws ValidationException {
        OracleIndexOrganizedTableProperties oracleIndexOrganizedTableProperties;
        Table.TableType tableType = (Table.TableType)t2.getProperty("TableType");
        if (tableType == Table.TableType.INDEX_ORGANIZED && (oracleIndexOrganizedTableProperties = (OracleIndexOrganizedTableProperties)t2.getProperty("OracleIndexOrganizedTableProperties")) != null) {
            try {
                this.getProvider().validateObject((DBObject)oracleIndexOrganizedTableProperties);
            }
            catch (MissingValidatorException missingValidatorException) {
                throw new ValidationException(t2, APIBundle.get((String)"IOT_PROPERTY_NOT_SUPPORTED"));
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"OracleExternalTableProperties"})
    public void validateExternalTableProperties(ValidationContext<T> validationContext) throws ValidationException {
        Table table = (Table)validationContext.getUpdatedObject();
        Table.TableType tableType = (Table.TableType)table.getProperty("TableType");
        if (tableType == Table.TableType.EXTERNAL) {
            OracleExternalTableProperties oracleExternalTableProperties = (OracleExternalTableProperties)table.getProperty("OracleExternalTableProperties");
            if (oracleExternalTableProperties == null) {
                ValidationException validationException = new ValidationException((DBObject)table, Property.createPath((String[])new String[]{"OracleExternalTableProperties", "defaultDirectory"}), APIBundle.get((String)"EXTERNAL_TABLE_PROPERTY_MISSING_DEFAULT_DIR"));
                validationException.setNextException((DBException)((Object)new ValidationException((DBObject)table, Property.createPath((String[])new String[]{"OracleExternalTableProperties", "locationSpecifiers"}), APIBundle.get((String)"EXTERNAL_TABLE_PROPERTY_MISSING_LOCATION"))));
                throw validationException;
            }
            this.validateOwnedObjects(validationContext.getLevel(), new DBObject[]{oracleExternalTableProperties});
        }
    }

    @DBObjectValidator.PropertyValidator(value={"NESTED TABLE"}, level=ValidationLevel.FULL)
    public void validateNested(T t, T t2) throws ValidationException {
        Table.TableType tableType;
        boolean bl = Boolean.TRUE.equals(t2.getProperty("NESTED TABLE"));
        if (bl && (tableType = (Table.TableType)t2.getProperty("TableType")) == Table.TableType.EXTERNAL) {
            throw new ValidationException(t2, APIBundle.format((String)"TABLE_PROPERTY_ERROR_INVALID_COMBINATION", (Object[])new Object[]{APIBundle.get((String)"TABLE_TYPE_EXTERNAL"), APIBundle.get((String)"TABLE_PROPERTY_NESTED")}));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"PARTITIONED TABLE"}, level=ValidationLevel.FULL)
    public void validatePartitioned(T t, T t2) throws ValidationException {
        boolean bl = Boolean.TRUE.equals(t2.getProperty("PARTITIONED TABLE"));
        if (bl) {
            Table.TableType tableType = (Table.TableType)t2.getProperty("TableType");
            if (tableType == Table.TableType.SESSION_TEMP || tableType == Table.TableType.TRANSACTION_TEMP) {
                throw new ValidationException(t2, APIBundle.format((String)"TABLE_PROPERTY_ERROR_INVALID_PROPERTY", (Object[])new Object[]{APIBundle.get((String)"TABLE_TYPE_TEMPORARY"), APIBundle.get((String)"TABLE_PROPERTY_PARTITIONS")}));
            }
            if (tableType == Table.TableType.EXTERNAL) {
                throw new ValidationException(t2, APIBundle.format((String)"TABLE_PROPERTY_ERROR_INVALID_COMBINATION", (Object[])new Object[]{APIBundle.get((String)"TABLE_TYPE_EXTERNAL"), APIBundle.get((String)"TABLE_PROPERTY_PARTITIONED")}));
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"OracleTablePartitions"})
    public void validatePartitions(ValidationContext<T> validationContext) throws ValidationException {
        OracleTablePartitions oracleTablePartitions;
        Table table = (Table)validationContext.getUpdatedObject();
        boolean bl = Boolean.TRUE.equals(table.getProperty("PARTITIONED TABLE"));
        if (bl && (oracleTablePartitions = (OracleTablePartitions)table.getProperty("OracleTablePartitions")) != null) {
            try {
                this.validateOwnedObjects(validationContext.getLevel(), new DBObject[]{oracleTablePartitions});
            }
            catch (MissingValidatorException missingValidatorException) {
                throw new ValidationException((DBObject)table, APIBundle.get((String)"TABLE_PARTITION_NOT_SUPPORTED"));
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"Comment"}, level=ValidationLevel.FULL)
    public void validateComment(T t, T t2) throws ValidationException {
        if (t2.getProperty("Comment") != null && t2.getProperty("TableType") == Table.TableType.EXTERNAL) {
            throw new ValidationException(t2, "Comment", APIBundle.format((String)"TABLE_PROPERTY_ERROR_INVALID_PROPERTY", (Object[])new Object[]{APIBundle.get((String)"TABLE_TYPE_EXTERNAL"), APIBundle.get((String)"TABLE_PROPERTY_COMMENTS")}));
        }
        super.validateComment(t, t2);
    }

    @Override
    protected boolean supportsOtherTableTypes() {
        return true;
    }

    @Override
    @DBObjectValidator.PropertyValidator(value={"columns"})
    public void validateColumns(ValidationContext<T> validationContext) throws ValidationException {
        Table table = (Table)validationContext.getUpdatedObject();
        if (validationContext.getLevel() == ValidationLevel.FULL) {
            Column[] columnArray = table.getColumns();
            int n = 0;
            if (columnArray != null && columnArray.length > 0) {
                for (Column column : columnArray) {
                    if (column.getVirtualExpressionSource() != null) continue;
                    ++n;
                    break;
                }
            }
            if (n == 0) {
                throw new ValidationException((DBObject)table, APIBundle.format((String)"COLUMN_ERROR_NEED_REAL_COLUMN", (Object[])new Object[]{table.getName()}));
            }
        }
        super.validateColumns(validationContext);
    }

    @Override
    protected boolean enforceOneColumnExists(ValidationContext<T> validationContext) {
        return super.enforceOneColumnExists(validationContext) && (this.getProvider().getDescriptor().getDatabaseVersion() <= 120 || ((Table)validationContext.getUpdatedObject()).getProperty("TableType") != Table.TableType.EXTERNAL);
    }

    @Override
    @DBObjectValidator.PropertyValidator(value={"constraints"})
    public void validateConstraints(ValidationContext<T> validationContext) throws ValidationException {
        super.validateConstraints(validationContext);
        if (validationContext.getLevel() == ValidationLevel.FULL) {
            Table table = (Table)validationContext.getUpdatedObject();
            Constraint[] constraintArray = table.getConstraints();
            Table.TableType tableType = (Table.TableType)table.getProperty("TableType");
            if (tableType == Table.TableType.INDEX_ORGANIZED) {
                PKConstraint pKConstraint = PKConstraint.getPrimaryKey((Relation)table);
                if (pKConstraint == null) {
                    throw new ValidationException((DBObject)table, "constraints", APIBundle.get((String)"IOT_PROPERTY_ERROR_MISSING_PRIMARY_KEY"));
                }
            } else if (tableType == Table.TableType.SESSION_TEMP || tableType == Table.TableType.TRANSACTION_TEMP) {
                for (Constraint constraint : constraintArray) {
                    if (!(constraint instanceof FKConstraint)) continue;
                    throw new ValidationException((DBObject)table, APIBundle.format((String)"TABLE_PROPERTY_ERROR_INVALID_PROPERTY", (Object[])new Object[]{APIBundle.get((String)"TABLE_TYPE_TEMPORARY"), APIBundle.get((String)"TABLE_PROPERTY_FKS")}));
                }
            } else if (tableType == Table.TableType.EXTERNAL && constraintArray.length != 0) {
                throw new ValidationException((DBObject)table, "constraints", APIBundle.format((String)"TABLE_PROPERTY_ERROR_INVALID_PROPERTY", (Object[])new Object[]{APIBundle.get((String)"TABLE_TYPE_EXTERNAL"), APIBundle.get((String)"TABLE_PROPERTY_CONSTRAINTS")}));
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"indexes"})
    public void validateIndexes(ValidationContext<T> validationContext) throws ValidationException {
        Table table = (Table)validationContext.getUpdatedObject();
        Index[] indexArray = table.getIndexes();
        if (validationContext.getLevel() == ValidationLevel.FULL && table.getProperty("TableType") == Table.TableType.EXTERNAL && indexArray.length != 0) {
            throw new ValidationException((DBObject)table, "indexes", APIBundle.format((String)"TABLE_PROPERTY_ERROR_INVALID_PROPERTY", (Object[])new Object[]{APIBundle.get((String)"TABLE_TYPE_EXTERNAL"), APIBundle.get((String)"TABLE_PROPERTY_INDEXES")}));
        }
        this.validateOwnedObjects(validationContext.getLevel(), (DBObject[])indexArray);
    }

    @Override
    protected CascadeAction cascadePropertyChange(Difference difference, String string, Object object, Object object2, T t) throws DBException {
        CascadeAction cascadeAction = super.cascadePropertyChange(difference, string, object, object2, t);
        if ("partitions".equals(string) || "subpartitionModel".equals(string) || "hashQuantity".equals(string) || "partitionType".equals(string)) {
            boolean bl;
            DBObject dBObject;
            OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)t.getProperty("OracleTablePartitions");
            Collection<OracleIndexPartitions> collection = LocalIndexPartitionHelper.getLocalIndexPartitionModels(t);
            DBObject dBObject2 = (DBObject)difference.getUpdatedObject();
            boolean bl2 = false;
            if (dBObject2 == null) {
                dBObject2 = (DBObject)difference.getOriginalObject();
            }
            if ((dBObject = dBObject2.getParent()) != null) {
                bl2 = dBObject.getID().equals(t.getID(), false);
            }
            boolean bl3 = bl = !(this.getProvider() instanceof Database) && oracleTablePartitions != null && oracleTablePartitions.getPartitionType() == OracleTablePartitions.PartitionType.REFERENCE && !bl2;
            if ("partitions".equals(string)) {
                if (bl) {
                    cascadeAction = this.cascadePartitionChangesToReferencePartitions(cascadeAction, difference, t);
                }
                cascadeAction = this.cascadePartitionChangesToLocalIndexPartitions(cascadeAction, difference, t);
            } else if ("subpartitionModel".equals(string)) {
                if (bl) {
                    cascadeAction = this.cascadeSubpartitionTemplateChangesToReferencePartitions(cascadeAction, difference, t);
                }
                for (OracleIndexPartitions oracleIndexPartitions : collection) {
                    cascadeAction = this.cascadeSubpartitionTemplateChangesToLocalIndexPartitions(cascadeAction, difference, oracleIndexPartitions);
                }
            } else if ("hashQuantity".equals(string)) {
                Integer n = object == null ? 0 : (Integer)object;
                Integer n2 = object2 == null ? 0 : (Integer)object2;
                if (bl) {
                    cascadeAction = this.cascadeHashQuantityChangesToReferencePartitions(cascadeAction, n, n2, t);
                }
                cascadeAction = this.cascadeHashQuantityChangesToLocalIndexPartitions(cascadeAction, n, n2, t);
            } else if ("partitionType".equals(string) && bl && (object2 == null || object != object2)) {
                for (TablePartition tablePartition : oracleTablePartitions.getPartitions()) {
                    oracleTablePartitions.removePartition(tablePartition);
                }
                cascadeAction = CascadeAction.UPDATE;
            }
        }
        return cascadeAction;
    }

    private void addReferencePartitions(OracleTablePartitions oracleTablePartitions, String string, int n, int n2, int n3) {
        for (int i = n; i < n + n2; ++i) {
            String string2 = string + i;
            TablePartition tablePartition = this.createReferencePartition(string2);
            oracleTablePartitions.addPartition(n3, tablePartition);
            ++n3;
        }
    }

    private TablePartition createReferencePartition(String string) {
        TablePartition tablePartition = new TablePartition(string, OracleTablePartitions.PartitionType.REFERENCE, OracleTablePartitions.ObjectType.PARTITION);
        return tablePartition;
    }

    private IndexPartition createLocalIndexPartition(TablePartition tablePartition, String string) {
        int n;
        IndexPartition indexPartition = new IndexPartition();
        indexPartition.setName(string);
        if (tablePartition != null && (n = ReferencePartitionHelper.getSubPartitionsCount(tablePartition)) > 0) {
            OracleIndexPartitions oracleIndexPartitions = new OracleIndexPartitions(OracleIndexPartitions.PartitionType.SUBPARTITION);
            for (int i = 1; i <= n; ++i) {
                oracleIndexPartitions.addPartition(LocalIndexPartitionHelper.createLocalIndexPartition(null, string + "_SUBPARTITION" + i));
            }
            indexPartition.setSubpartitions(oracleIndexPartitions);
        }
        return indexPartition;
    }

    private void addLocalIndexSubpartitions(OracleIndexPartitions oracleIndexPartitions, TablePartition tablePartition, int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            oracleIndexPartitions.addPartition(this.createLocalIndexPartition(null, tablePartition.getName() + "_SUBPARTITION" + i));
        }
    }

    private void addLocalIndexSubpartitions(OracleIndexPartitions oracleIndexPartitions, TablePartition tablePartition, int n) {
        int n2 = ReferencePartitionHelper.getSubPartitionsCount(tablePartition);
        this.addLocalIndexSubpartitions(oracleIndexPartitions, tablePartition, n, n2);
    }

    private CascadeAction cascadePartitionChangesToReferencePartitions(CascadeAction cascadeAction, Difference difference, T t) {
        OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)difference.getOriginalObject();
        OracleTablePartitions oracleTablePartitions2 = (OracleTablePartitions)difference.getUpdatedObject();
        boolean bl = oracleTablePartitions2.getSubpartitionModel() != null;
        Difference difference2 = difference.getChildDifference("partitions");
        OracleTablePartitions oracleTablePartitions3 = (OracleTablePartitions)t.getProperty("OracleTablePartitions");
        TablePartition[] tablePartitionArray = oracleTablePartitions3.getPartitions();
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        TreeMap treeMap = new TreeMap(Collections.reverseOrder());
        int n = ReferencePartitionHelper.getReferencedTablePartitionsCount(oracleTablePartitions);
        if (oracleTablePartitions3.getPartitionType() == OracleTablePartitions.PartitionType.REFERENCE && tablePartitionArray.length > 0 && (oracleTablePartitions == null || n == tablePartitionArray.length)) {
            TablePartition tablePartition;
            TablePartition tablePartition2;
            int n2 = 0;
            for (Difference object : difference2.getChildren()) {
                int n3 = object.getIndexOfOriginalObject();
                int n4 = object.getIndexOfUpdatedObject();
                tablePartition2 = (TablePartition)(object.getOriginalObject() == null ? null : object.getOriginalObject());
                tablePartition = (TablePartition)object.getUpdatedObject();
                if (!object.isSame()) {
                    int tablePartition10;
                    int n5;
                    int tablePartition4;
                    if (tablePartition == null) {
                        if (bl) {
                            int string;
                            int partitionType = ReferencePartitionHelper.getSubPartitionsCount(tablePartition2);
                            for (tablePartition4 = string = n2 + partitionType - 1; tablePartition4 > string - partitionType; --tablePartition4) {
                                oracleTablePartitions3.removePartition(tablePartitionArray[tablePartition4]);
                            }
                        } else {
                            oracleTablePartitions3.removePartition(tablePartitionArray[n3]);
                        }
                        treeSet.add(n3);
                        continue;
                    }
                    if (tablePartition2 == null) {
                        if (bl) {
                            int difference3 = ReferencePartitionHelper.getSubPartitionsCount(tablePartition);
                            for (int string3 = 1; string3 <= difference3; ++string3) {
                                String string2 = tablePartition.getName() + "_SUBPARTITION" + string3;
                                TablePartition tablePartition6 = this.createReferencePartition(string2);
                                oracleTablePartitions3.addPartition(tablePartition6);
                            }
                            continue;
                        }
                        OracleTablePartitions.PartitionType n24 = tablePartition.getPartitionType();
                        if (n24 == OracleTablePartitions.PartitionType.HASH && (n24 != OracleTablePartitions.PartitionType.HASH || n4 <= 0)) continue;
                        String difference4 = tablePartition.getName();
                        TablePartition difference5 = this.createReferencePartition(difference4);
                        oracleTablePartitions3.addPartition(difference5);
                        continue;
                    }
                    if (n3 != n4) continue;
                    Difference difference3 = object.getChildDifference("name", true);
                    if (difference3 != null) {
                        String n16;
                        String tablePartitionArray5;
                        String tablePartitionArray4 = tablePartition2 == null ? null : tablePartition2.getName();
                        String string = tablePartitionArray5 = tablePartition == null ? null : tablePartition.getName();
                        if (bl) {
                            int n12 = ReferencePartitionHelper.getSubPartitionsCount(tablePartition);
                            for (int n13 = n2; n13 < n2 + n12; ++n13) {
                                String n19;
                                TablePartition tablePartitionArray2 = tablePartitionArray[n13];
                                String string2 = n19 = tablePartitionArray2 == null ? null : tablePartitionArray2.getName();
                                if (tablePartitionArray4 == null || tablePartitionArray5 == null || n19 == null || !n19.startsWith(tablePartitionArray4)) continue;
                                String n52 = n19.replaceFirst(tablePartitionArray4, tablePartitionArray5);
                                tablePartitionArray2.setName(n52);
                            }
                            continue;
                        }
                        TablePartition n15 = tablePartitionArray[n4];
                        String string3 = n16 = n15 == null ? null : n15.getName();
                        if (tablePartitionArray4 == null || n16 == null || !n16.equals(tablePartitionArray4)) continue;
                        n15.setName(tablePartitionArray5);
                        continue;
                    }
                    if (!bl) continue;
                    Difference difference4 = object.getChildDifference("partitionLevelSubpartitions");
                    if (difference4.getUpdatedObject() == null) {
                        int difference6;
                        int n20;
                        tablePartition4 = ReferencePartitionHelper.getSubPartitionsCount(tablePartition2);
                        for (n20 = difference6 = n2 + tablePartition4 - 1; n20 >= n2; --n20) {
                            oracleTablePartitions3.removePartition(tablePartitionArray[n20]);
                        }
                        n20 = ReferencePartitionHelper.getSubPartitionsCount(tablePartition);
                        this.addReferencePartitions(oracleTablePartitions3, tablePartition.getName() + "_SUBPARTITION", 1, n20, n2);
                        continue;
                    }
                    Difference difference5 = difference4.getChildDifference("hashQuantity");
                    if (difference5 != null && !difference5.isSame()) {
                        int tablePartition9;
                        Integer arrayList = difference5.getOriginalObject() == null ? 0 : (Integer)difference5.getOriginalObject();
                        Integer n25 = difference5.getUpdatedObject() == null ? 0 : (Integer)difference5.getUpdatedObject();
                        int n26 = n2 + n25;
                        if (arrayList < n25) {
                            if (arrayList == 0) {
                                int difference7 = ReferencePartitionHelper.getSubPartitionsCount(tablePartition2);
                                for (n5 = tablePartition9 = n2 + difference7 - 1; n5 >= n2; --n5) {
                                    oracleTablePartitions3.removePartition(tablePartitionArray[n5]);
                                }
                            }
                            this.addReferencePartitions(oracleTablePartitions3, tablePartition.getName() + "_SUBPARTITION", arrayList + 1, n25 - arrayList, n2 + arrayList);
                            continue;
                        }
                        if (n25 < arrayList) {
                            int tablePartitionArray3;
                            for (tablePartition9 = tablePartitionArray3 = n2 + arrayList - 1; tablePartition9 >= n26; --tablePartition9) {
                                oracleTablePartitions3.removePartition(tablePartitionArray[tablePartition9]);
                            }
                            if (n25 != 0) continue;
                            tablePartition9 = ReferencePartitionHelper.getSubPartitionsCount(tablePartition);
                            this.addReferencePartitions(oracleTablePartitions3, tablePartition.getName() + "_SUBPARTITION", 1, tablePartition9, n2);
                            continue;
                        }
                        n2 += ReferencePartitionHelper.getSubPartitionsCount((TablePartition)object.getUpdatedObject());
                        continue;
                    }
                    Difference difference6 = difference4.getChildDifference("partitions");
                    if (difference6 == null || difference6.isSame()) continue;
                    int n6 = n2;
                    treeSet.clear();
                    for (Difference i : difference6.getChildren()) {
                        Object object2;
                        String string;
                        String string4;
                        tablePartition10 = i.getIndexOfOriginalObject();
                        n5 = i.getIndexOfUpdatedObject();
                        TablePartition tablePartition3 = (TablePartition)(i.getOriginalObject() == null ? null : i.getOriginalObject());
                        TablePartition tablePartition5 = (TablePartition)i.getUpdatedObject();
                        String string5 = tablePartition3 == null ? null : tablePartition3.getName();
                        String string6 = string4 = tablePartition5 == null ? null : tablePartition5.getName();
                        if (tablePartition10 == n5 && !i.isSame()) {
                            string = tablePartitionArray[n2 += n5];
                            object2 = string == null ? null : string.getName();
                            if (object2 == null || string5 == null || string4 == null || !((String)object2).equals(string5)) continue;
                            string.setName(string4);
                            continue;
                        }
                        if (n5 < 0) {
                            int n7 = n2 + tablePartition10;
                            oracleTablePartitions3.removePartition(tablePartitionArray[n7]);
                            treeSet.add(n3);
                            continue;
                        }
                        if (tablePartition10 < 0) {
                            string = tablePartition5.getName();
                            object2 = this.createReferencePartition(string);
                            oracleTablePartitions3.addPartition(n2 + n5, (TablePartition)object2);
                            continue;
                        }
                        if (tablePartition10 == n5 || treeSet.contains(n5)) continue;
                        string = tablePartitionArray[n6 + tablePartition10];
                        oracleTablePartitions3.removePartition((TablePartition)string);
                        oracleTablePartitions3.addPartition(n6 + n5, (TablePartition)string);
                    }
                    TablePartition[] tablePartitionArray2 = (TablePartition[])difference6.getOriginalObject();
                    TablePartition[] i = (TablePartition[])difference6.getUpdatedObject();
                    if (i.length == 0) {
                        tablePartition10 = ReferencePartitionHelper.getSubPartitionsCount(tablePartition);
                        this.addReferencePartitions(oracleTablePartitions3, tablePartition.getName() + "_SUBPARTITION", 1, tablePartition10, n2);
                        continue;
                    }
                    if (tablePartitionArray2 != null && tablePartitionArray2.length != 0) continue;
                    tablePartition10 = ReferencePartitionHelper.getSubPartitionsCount(tablePartition2);
                    for (int j = n5 = n2 + tablePartition10 - 1; j >= n2; --j) {
                        oracleTablePartitions3.removePartition(tablePartitionArray[j]);
                    }
                    continue;
                }
                if (n3 != n4) {
                    treeMap.put(n4, n3);
                }
                if (!bl) continue;
                n2 += ReferencePartitionHelper.getSubPartitionsCount((TablePartition)object.getUpdatedObject());
            }
            if (!treeMap.isEmpty()) {
                for (Map.Entry entry : treeMap.entrySet()) {
                    Integer n8 = (Integer)entry.getKey();
                    if (treeSet.contains(n8)) continue;
                    Integer n9 = (Integer)entry.getValue();
                    tablePartition2 = tablePartitionArray[n9];
                    if (bl) {
                        tablePartition = oracleTablePartitions2.getPartitions()[n8];
                        int n10 = ReferencePartitionHelper.getSubPartitionsCount(tablePartition);
                        TablePartition[] tablePartitionArray3 = oracleTablePartitions.getPartitions();
                        TablePartition[] tablePartitionArray4 = oracleTablePartitions2.getPartitions();
                        ArrayList<TablePartition> arrayList = new ArrayList<TablePartition>();
                        int n11 = 0;
                        int n12 = 0;
                        if (n8 > 0) {
                            for (int i = 0; i < n8; ++i) {
                                TablePartition tablePartition11 = tablePartitionArray4[i];
                                n11 += ReferencePartitionHelper.getSubPartitionsCount(tablePartition11);
                            }
                        }
                        if (n8 > n9) {
                            n11 += n10;
                        }
                        if (n9 > 0) {
                            for (int i = 0; i < n9; ++i) {
                                TablePartition tablePartition6 = tablePartitionArray3[i];
                                n12 += ReferencePartitionHelper.getSubPartitionsCount(tablePartition6);
                            }
                        }
                        for (int i = n12; i < n12 + n10; ++i) {
                            TablePartition tablePartition7 = this.createReferencePartition(tablePartitionArray[i].getName());
                            arrayList.add(tablePartitionArray[i]);
                            oracleTablePartitions3.addPartition(n11, tablePartition7);
                            ++n11;
                        }
                        for (TablePartition tablePartition7 : arrayList) {
                            oracleTablePartitions3.removePartition(tablePartition7);
                        }
                        continue;
                    }
                    oracleTablePartitions3.removePartition(tablePartition2);
                    oracleTablePartitions3.addPartition(n8.intValue(), tablePartition2);
                }
            }
            cascadeAction = CascadeAction.UPDATE;
        }
        return cascadeAction;
    }

    private CascadeAction cascadeHashQuantityChangesToReferencePartitions(CascadeAction cascadeAction, Integer n, Integer n2, T t) {
        OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)t.getProperty("OracleTablePartitions");
        if (oracleTablePartitions.getPartitions().length > 0) {
            if (n < n2) {
                for (int i = n + 1; i <= n2; ++i) {
                    String string = "PARTITION" + i;
                    TablePartition tablePartition = this.createReferencePartition(string);
                    oracleTablePartitions.addPartition(tablePartition);
                }
            } else {
                int n3;
                int n4 = n2;
                for (int i = n3 = n - 1; i >= n4; --i) {
                    oracleTablePartitions.removePartition(oracleTablePartitions.getPartitions()[i]);
                }
            }
            cascadeAction = CascadeAction.UPDATE;
        }
        return cascadeAction;
    }

    private CascadeAction cascadeHashQuantityChangesToLocalIndexPartitions(CascadeAction cascadeAction, Integer n, Integer n2, T t) {
        Collection<OracleIndexPartitions> collection = LocalIndexPartitionHelper.getLocalIndexPartitionModels(t);
        for (OracleIndexPartitions oracleIndexPartitions : collection) {
            int n3;
            if (oracleIndexPartitions.getPartitions().length <= 0) continue;
            if (n < n2) {
                for (n3 = n + 1; n3 <= n2; ++n3) {
                    String string = "PARTITION" + n3;
                    IndexPartition indexPartition = this.createLocalIndexPartition(null, string);
                    oracleIndexPartitions.addPartition(indexPartition);
                }
            } else {
                int n4;
                n3 = n2;
                for (int i = n4 = n - 1; i >= n3; --i) {
                    oracleIndexPartitions.removePartition(oracleIndexPartitions.getPartitions()[i]);
                }
            }
            cascadeAction = CascadeAction.UPDATE;
        }
        return cascadeAction;
    }

    private CascadeAction cascadeSubpartitionTemplateChangesToReferencePartitions(CascadeAction cascadeAction, Difference difference, T t) {
        OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)t.getProperty("OracleTablePartitions");
        OracleTablePartitions oracleTablePartitions2 = (OracleTablePartitions)difference.getUpdatedObject();
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        Difference difference2 = difference.getChildDifference("subpartitionModel");
        OracleTablePartitions oracleTablePartitions3 = (OracleTablePartitions)difference2.getUpdatedObject();
        Difference difference3 = difference2.getChildDifference("hashQuantity");
        Integer n = null;
        Integer n2 = null;
        if (!difference3.isSame()) {
            n = difference3.getOriginalObject() == null ? 1 : (Integer)difference3.getOriginalObject();
            n2 = difference3.getUpdatedObject() == null ? 1 : (Integer)difference3.getUpdatedObject();
        }
        int n3 = 0;
        TablePartition[] tablePartitionArray = oracleTablePartitions.getPartitions();
        TablePartition[] tablePartitionArray2 = oracleTablePartitions2.getPartitions();
        if (tablePartitionArray.length > 0) {
            for (TablePartition tablePartition : tablePartitionArray2) {
                int n4 = n3;
                treeSet.clear();
                OracleTablePartitions oracleTablePartitions4 = tablePartition.getPartitionLevelSubpartitions();
                if (oracleTablePartitions4 == null || oracleTablePartitions4.getPartitions().length == 0 && oracleTablePartitions4.getHashQuantity() == null) {
                    if (!difference3.isSame()) {
                        int n5;
                        int n6 = n3 + n2;
                        if (n < n2) {
                            this.addReferencePartitions(oracleTablePartitions, tablePartition.getName() + "_SUBPARTITION", n + 1, n2 - n, n3 + n);
                            n3 += n2.intValue();
                            continue;
                        }
                        if (n2 >= n) continue;
                        for (int i = n5 = n3 + n - 1; i >= n6; --i) {
                            oracleTablePartitions.removePartition(tablePartitionArray[i]);
                        }
                        n3 += n.intValue();
                        continue;
                    }
                    Difference difference4 = difference2.getChildDifference("partitions");
                    for (Difference difference5 : difference4.getChildren()) {
                        TablePartition tablePartition2;
                        String string;
                        String string2;
                        int n7 = difference5.getIndexOfOriginalObject();
                        int n8 = difference5.getIndexOfUpdatedObject();
                        TablePartition tablePartition3 = (TablePartition)difference5.getUpdatedObject();
                        TablePartition tablePartition4 = (TablePartition)difference5.getOriginalObject();
                        String string3 = tablePartition4 == null ? null : tablePartition4.getName();
                        String string4 = string2 = tablePartition3 == null ? null : tablePartition3.getName();
                        if (n8 < 0) {
                            if (oracleTablePartitions3.getPartitions().length > 0) {
                                oracleTablePartitions.removePartition(tablePartitionArray[n3]);
                                treeSet.add(n7);
                            }
                        } else if (n7 < 0) {
                            string = tablePartition.getName() + "_" + string2;
                            if (oracleTablePartitions3.getPartitions().length > 1 && n8 != 0) {
                                tablePartition2 = this.createReferencePartition(string);
                                oracleTablePartitions.addPartition(n3, tablePartition2);
                            } else {
                                tablePartition2 = oracleTablePartitions.getPartitions()[n3];
                                tablePartition2.setName(string);
                            }
                        } else if (n7 == n8) {
                            string = difference5.getChildDifference("name", true);
                            if (string != null) {
                                String string5;
                                tablePartition2 = oracleTablePartitions.getPartitions()[n3];
                                String string6 = string5 = tablePartition2 == null ? null : tablePartition2.getName();
                                if (string5.endsWith(string3)) {
                                    String string7 = string5.replaceFirst(string3, string2);
                                    tablePartition2.setName(string7);
                                }
                            }
                        } else if (n7 != n8 && !treeSet.contains(n8)) {
                            string = tablePartitionArray[n4 + n7];
                            oracleTablePartitions.removePartition((TablePartition)string);
                            oracleTablePartitions.addPartition(n4 + n8, (TablePartition)string);
                        }
                        ++n3;
                    }
                    continue;
                }
                n3 += ReferencePartitionHelper.getSubPartitionsCount(tablePartition);
            }
            cascadeAction = CascadeAction.UPDATE;
        }
        return cascadeAction;
    }

    private CascadeAction cascadeSubpartitionTemplateChangesToLocalIndexPartitions(CascadeAction cascadeAction, Difference difference, OracleIndexPartitions oracleIndexPartitions) {
        OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)difference.getUpdatedObject();
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        Difference difference2 = difference.getChildDifference("subpartitionModel");
        OracleTablePartitions oracleTablePartitions2 = (OracleTablePartitions)difference2.getUpdatedObject();
        Difference difference3 = difference2.getChildDifference("hashQuantity");
        Integer n = null;
        Integer n2 = null;
        if (!difference3.isSame()) {
            n = difference3.getOriginalObject() == null ? 1 : (Integer)difference3.getOriginalObject();
            n2 = difference3.getUpdatedObject() == null ? 1 : (Integer)difference3.getUpdatedObject();
        }
        IndexPartition[] indexPartitionArray = oracleIndexPartitions.getPartitions();
        TablePartition[] tablePartitionArray = oracleTablePartitions.getPartitions();
        TreeMap treeMap = new TreeMap(Collections.reverseOrder());
        int n3 = 0;
        if (indexPartitionArray.length > 0) {
            for (TablePartition tablePartition : tablePartitionArray) {
                treeSet.clear();
                OracleTablePartitions oracleTablePartitions3 = tablePartition.getPartitionLevelSubpartitions();
                IndexPartition indexPartition = oracleIndexPartitions.getPartitions()[n3];
                OracleIndexPartitions oracleIndexPartitions2 = indexPartition.getSubpartitions();
                IndexPartition[] indexPartitionArray2 = oracleIndexPartitions2.getPartitions();
                if (oracleTablePartitions3 == null || oracleTablePartitions3.getPartitions().length == 0 && oracleTablePartitions3.getHashQuantity() == null) {
                    if (!difference3.isSame()) {
                        int n4 = n2;
                        if (n < n2) {
                            this.addLocalIndexSubpartitions(oracleIndexPartitions2, tablePartition, n + 1, n2);
                        } else if (n2 < n) {
                            int n5;
                            for (int i = n5 = n - 1; i >= n4; --i) {
                                oracleIndexPartitions2.removePartition(indexPartitionArray2[i]);
                            }
                        }
                    } else {
                        Difference difference4 = difference2.getChildDifference("partitions");
                        for (Difference difference5 : difference4.getChildren()) {
                            IndexPartition indexPartition2;
                            String string;
                            String string2;
                            int n6 = difference5.getIndexOfOriginalObject();
                            int n7 = difference5.getIndexOfUpdatedObject();
                            TablePartition tablePartition2 = (TablePartition)difference5.getUpdatedObject();
                            TablePartition tablePartition3 = (TablePartition)difference5.getOriginalObject();
                            String string3 = tablePartition3 == null ? null : tablePartition3.getName();
                            String string4 = string2 = tablePartition2 == null ? null : tablePartition2.getName();
                            if (n7 < 0) {
                                if (oracleTablePartitions2.getPartitions().length <= 0) continue;
                                oracleIndexPartitions2.removePartition(indexPartitionArray2[n6]);
                                treeSet.add(n6);
                                continue;
                            }
                            if (n6 < 0) {
                                string = tablePartition.getName() + "_" + string2;
                                if (oracleTablePartitions2.getPartitions().length > 1 && n7 != 0 || oracleIndexPartitions2.getPartitions().length == 0) {
                                    indexPartition2 = this.createLocalIndexPartition(null, string);
                                    oracleIndexPartitions2.addPartition(n7, indexPartition2);
                                    continue;
                                }
                                indexPartition2 = oracleIndexPartitions2.getPartitions()[n7];
                                indexPartition2.setName(string);
                                continue;
                            }
                            if (n6 == n7) {
                                String string5;
                                string = difference5.getChildDifference("name", true);
                                if (string == null || !(string5 = (indexPartition2 = oracleIndexPartitions2.getPartitions()[n7]) == null ? null : indexPartition2.getName()).endsWith(string3)) continue;
                                String string6 = string5.replaceFirst(string3, string2);
                                indexPartition2.setName(string6);
                                continue;
                            }
                            if (n6 == n7 || treeSet.contains(n7)) continue;
                            treeMap.put(n7, n6);
                        }
                    }
                }
                if (!treeMap.isEmpty()) {
                    for (Map.Entry entry : treeMap.entrySet()) {
                        Integer n8 = (Integer)entry.getKey();
                        Integer n9 = (Integer)entry.getValue();
                        if (oracleIndexPartitions2 == null) continue;
                        IndexPartition indexPartition3 = indexPartitionArray2[n9];
                        oracleIndexPartitions2.removePartition(indexPartition3);
                        oracleIndexPartitions2.addPartition(n8.intValue(), indexPartition3);
                    }
                    treeMap.clear();
                }
                ++n3;
            }
            cascadeAction = CascadeAction.UPDATE;
        }
        return cascadeAction;
    }

    private CascadeAction cascadePartitionChangesToLocalIndexPartitions(CascadeAction cascadeAction, Difference difference, T t) {
        Collection<OracleIndexPartitions> collection = LocalIndexPartitionHelper.getLocalIndexPartitionModels(t);
        for (OracleIndexPartitions oracleIndexPartitions : collection) {
            cascadeAction = this.cascadeToLocalIndexPartitions(cascadeAction, difference, oracleIndexPartitions);
        }
        return cascadeAction;
    }

    private CascadeAction cascadeToLocalIndexPartitions(CascadeAction cascadeAction, Difference difference, OracleIndexPartitions oracleIndexPartitions) {
        OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)difference.getOriginalObject();
        OracleTablePartitions oracleTablePartitions2 = (OracleTablePartitions)difference.getUpdatedObject();
        boolean bl = oracleTablePartitions2.getSubpartitionModel() != null;
        Difference difference2 = difference.getChildDifference("partitions");
        IndexPartition[] indexPartitionArray = oracleIndexPartitions.getPartitions();
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        TreeMap treeMap = new TreeMap(Collections.reverseOrder());
        if (indexPartitionArray.length > 0 && LocalIndexPartitionHelper.areTableAndIndexPartitionsSameShape(oracleTablePartitions, oracleIndexPartitions)) {
            TablePartition tablePartition;
            for (Difference object : difference2.getChildren()) {
                int n = object.getIndexOfOriginalObject();
                int n2 = object.getIndexOfUpdatedObject();
                tablePartition = (TablePartition)(object.getOriginalObject() == null ? null : object.getOriginalObject());
                TablePartition tablePartition2 = (TablePartition)object.getUpdatedObject();
                if (!object.isSame()) {
                    Object object2;
                    int n3;
                    Object object3;
                    Object object4;
                    String string;
                    IndexPartition indexPartition;
                    Object object5;
                    String string2;
                    OracleTablePartitions.PartitionType partitionType;
                    if (tablePartition2 == null) {
                        oracleIndexPartitions.removePartition(indexPartitionArray[n]);
                        treeSet.add(n);
                        continue;
                    }
                    if (tablePartition == null) {
                        partitionType = tablePartition2.getPartitionType();
                        if (partitionType == OracleTablePartitions.PartitionType.HASH && (partitionType != OracleTablePartitions.PartitionType.HASH || n2 <= 0)) continue;
                        string2 = tablePartition2.getName();
                        object5 = LocalIndexPartitionHelper.createLocalIndexPartition(tablePartition2, string2);
                        oracleIndexPartitions.addPartition(object5);
                        continue;
                    }
                    if (n != n2) continue;
                    partitionType = object.getChildDifference("name", true);
                    if (partitionType != null) {
                        string2 = tablePartition == null ? null : tablePartition.getName();
                        object5 = tablePartition2 == null ? null : tablePartition2.getName();
                        indexPartition = indexPartitionArray[n2];
                        String string3 = string = indexPartition == null ? null : indexPartition.getName();
                        if (string2 == null || string == null || !string.equals(string2)) continue;
                        if (bl) {
                            // empty if block
                        }
                        indexPartition.setName((String)object5);
                        continue;
                    }
                    if (!bl) continue;
                    string2 = object.getChildDifference("partitionLevelSubpartitions");
                    object5 = oracleIndexPartitions.getPartitions()[n];
                    indexPartition = object5.getSubpartitions();
                    if (string2.getUpdatedObject() == null) {
                        if (indexPartition == null) continue;
                        indexPartition.setPartitions(null);
                        this.addLocalIndexSubpartitions((OracleIndexPartitions)indexPartition, tablePartition2, 1);
                        continue;
                    }
                    string = string2.getChildDifference("hashQuantity");
                    if (string != null && !string.isSame()) {
                        object4 = string.getOriginalObject() == null ? 0 : (Integer)string.getOriginalObject();
                        object3 = string.getUpdatedObject() == null ? 0 : (Integer)string.getUpdatedObject();
                        if ((Integer)object4 < (Integer)object3) {
                            if ((Integer)object4 == 0) {
                                indexPartition.setPartitions(null);
                            }
                            if (indexPartition != null) {
                                this.addLocalIndexSubpartitions((OracleIndexPartitions)indexPartition, tablePartition2, (Integer)object4 + 1);
                            }
                        } else if ((Integer)object3 < (Integer)object4 && indexPartition != null) {
                            int entry;
                            IndexPartition[] indexPartitionArray2 = indexPartition.getPartitions();
                            for (n3 = entry = (Integer)object4 - 1; n3 >= (Integer)object3; --n3) {
                                indexPartition.removePartition((IndexPartition)indexPartitionArray2[n3]);
                            }
                            if ((Integer)object3 == 0) {
                                this.addLocalIndexSubpartitions((OracleIndexPartitions)indexPartition, tablePartition2, 1);
                            }
                        }
                        cascadeAction = CascadeAction.UPDATE;
                        continue;
                    }
                    object4 = string2.getChildDifference("partitions");
                    if (object4 == null || object4.isSame()) continue;
                    treeSet.clear();
                    object3 = indexPartition.getPartitions();
                    for (Difference difference3 : object4.getChildren()) {
                        TablePartition[] tablePartitionArray;
                        String string4;
                        String string5;
                        n3 = difference3.getIndexOfOriginalObject();
                        int n4 = difference3.getIndexOfUpdatedObject();
                        object2 = (TablePartition)(difference3.getOriginalObject() == null ? null : difference3.getOriginalObject());
                        TablePartition tablePartition3 = (TablePartition)difference3.getUpdatedObject();
                        String string6 = object2 == null ? null : object2.getName();
                        String string7 = string5 = tablePartition3 == null ? null : tablePartition3.getName();
                        if (n3 == n4 && !difference3.isSame()) {
                            if (indexPartition == null || (string4 = (tablePartitionArray = indexPartition.getPartitions()[n4]) == null ? null : tablePartitionArray.getName()) == null || string6 == null || string5 == null || !string4.equals(string6)) continue;
                            tablePartitionArray.setName(string5);
                            continue;
                        }
                        if (n4 < 0) {
                            if (indexPartition == null) continue;
                            indexPartition.removePartition((IndexPartition)object3[n3]);
                            treeSet.add(n);
                            continue;
                        }
                        if (n3 < 0) {
                            if (indexPartition == null) continue;
                            tablePartitionArray = (TablePartition[])object4.getOriginalObject();
                            if (tablePartitionArray == null || tablePartitionArray.length == 0 && n4 == 0) {
                                indexPartition.setPartitions(null);
                            }
                            string4 = this.createLocalIndexPartition(null, tablePartition3.getName());
                            indexPartition.addPartition((IndexPartition)string4);
                            continue;
                        }
                        if (n3 == n4 || treeSet.contains(n2)) continue;
                        treeMap.put(n4, n3);
                    }
                    if (indexPartition.getPartitions().length == 0) {
                        this.addLocalIndexSubpartitions((OracleIndexPartitions)indexPartition, tablePartition2, 1);
                    }
                    if (treeMap.isEmpty() || treeSet.contains(n2)) continue;
                    for (Map.Entry entry : treeMap.entrySet()) {
                        Integer n5 = (Integer)entry.getKey();
                        Integer n6 = (Integer)entry.getValue();
                        if (indexPartition == null) continue;
                        object2 = object3[n6];
                        indexPartition.removePartition((IndexPartition)object2);
                        indexPartition.addPartition(n5.intValue(), (IndexPartition)object2);
                    }
                    treeMap.clear();
                    continue;
                }
                if (n == n2) continue;
                treeMap.put(n2, n);
            }
            if (!treeMap.isEmpty()) {
                for (Map.Entry entry : treeMap.entrySet()) {
                    Integer n = (Integer)entry.getKey();
                    if (treeSet.contains(n)) continue;
                    Integer n7 = (Integer)entry.getValue();
                    tablePartition = indexPartitionArray[n7];
                    oracleIndexPartitions.removePartition((IndexPartition)tablePartition);
                    oracleIndexPartitions.addPartition(n.intValue(), (IndexPartition)tablePartition);
                }
            }
            cascadeAction = CascadeAction.UPDATE;
        }
        return cascadeAction;
    }
}

