/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.ora.OracleNumberDataType;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.DataTypeUsageValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.util.ModelUtil;

public class OracleDataTypeUsageValidator
extends DataTypeUsageValidator {
    public OracleDataTypeUsageValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    @Override
    protected void validateAttributeUsage(DataTypeAttribute dataTypeAttribute, Object object, DataType dataType, DataTypeUsage dataTypeUsage) throws ValidationException {
        if (DataTypeHelper.isTypeOf((DataType)dataType, OracleNumberDataType.class)) {
            Long l;
            if ("precision".equals(dataTypeAttribute.getName())) {
                String string = DataTypeHelper.toString((Object)object);
                if (ModelUtil.hasLength((String)string) && !string.trim().equals("*")) {
                    int n = 0;
                    try {
                        n = Long.valueOf(string).intValue();
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.throwAttributeValueInvalid(dataTypeUsage, dataTypeAttribute, APIBundle.get((String)"DATATYPE_ERROR_INVALID_ORACLE_PRECISION"));
                    }
                    if (n < 1) {
                        this.throwAttributeValueInvalid(dataTypeUsage, dataTypeAttribute, APIBundle.format((String)"DATATYPE_ERROR_INVALID_NUMERIC_VALUE1", (Object[])new Object[]{APIBundle.get((String)"DATATYPE_ATTRIBUTE_LABEL_PRECISION"), 1}));
                    }
                    if (n > 38) {
                        this.throwAttributeValueInvalid(dataTypeUsage, dataTypeAttribute, APIBundle.format((String)"DATATYPE_ERROR_INVALID_NUMERIC_VALUE2", (Object[])new Object[]{APIBundle.get((String)"DATATYPE_ATTRIBUTE_LABEL_PRECISION"), 38}));
                    }
                }
            } else if ("scale".equals(dataTypeAttribute.getName()) && (l = DataTypeHelper.toLong((Object)object)) != null) {
                if (l.compareTo(-84L) < 0) {
                    this.throwAttributeValueInvalid(dataTypeUsage, dataTypeAttribute, APIBundle.format((String)"DATATYPE_ERROR_INVALID_NUMERIC_VALUE1", (Object[])new Object[]{APIBundle.get((String)"DATATYPE_ATTRIBUTE_LABEL_SCALE"), -84}));
                }
                if (l.compareTo(127L) > 0) {
                    this.throwAttributeValueInvalid(dataTypeUsage, dataTypeAttribute, APIBundle.format((String)"DATATYPE_ERROR_INVALID_NUMERIC_VALUE2", (Object[])new Object[]{APIBundle.get((String)"DATATYPE_ATTRIBUTE_LABEL_SCALE"), 127}));
                }
            }
        } else {
            super.validateAttributeUsage(dataTypeAttribute, object, dataType, dataTypeUsage);
        }
    }
}

