/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sxml;

import java.util.ArrayList;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ora.sxml.SXMLFragmentGenerator;
import oracle.javatools.db.ora.sxml.SXMLMappings;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.property.Property;
import oracle.javatools.util.ModelUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class TriggerSXMLGenerator
extends SXMLFragmentGenerator {
    TriggerSXMLGenerator() {
    }

    @Override
    protected void populateNode(Node node, Document document, Object object) {
        Object object2;
        String string;
        Trigger trigger = (Trigger)object;
        Trigger.BaseType baseType = trigger.getBaseType();
        if (baseType == null) {
            baseType = Trigger.BaseType.TABLE;
        }
        switch (baseType) {
            case SCHEMA: {
                string = "DDL_EVENT";
                break;
            }
            case DATABASE: {
                object2 = trigger.getEvents();
                if (((String[])object2).length > 0 && Trigger.isDatabaseOnlyEvent((String)object2[0])) {
                    string = "DATABASE_EVENT";
                    break;
                }
                string = "DDL_EVENT";
                break;
            }
            default: {
                string = "DML_EVENT";
            }
        }
        this.findOrCreateNodeAfter(document, node, string, "TRIGGER_TYPE");
        switch (baseType) {
            case SCHEMA: {
                this.processPropertyMapping(node, document, trigger, string + "/EVENT_LIST//EVENT_LIST_ITEM/EVENT", "events");
                this.processPropertyMapping(node, document, trigger, string + "/SCHEMA", "baseSchemaName");
                break;
            }
            case DATABASE: {
                object2 = trigger.getEvents();
                if (((String[])object2).length <= 0) break;
                this.processPropertyMapping(node, document, trigger, string + "/EVENT_LIST//EVENT_LIST_ITEM/EVENT", "events");
                if (Trigger.isDatabaseOnlyEvent((String)object2[0])) break;
                this.findOrCreateNode(document, node, string + "/DATABASE");
                break;
            }
            default: {
                object2 = this.findOrCreateNode(document, node, string + "/EVENT_LIST");
                String[] stringArray = trigger.getEvents();
                for (int i = 0; i < stringArray.length; ++i) {
                    Node node2 = this.createNode(document, (Node)object2, "EVENT_LIST_ITEM");
                    Node node3 = this.createNode(document, node2, "EVENT");
                    node3.appendChild(document.createTextNode(stringArray[i]));
                    if (!stringArray[i].equals("UPDATE")) continue;
                    this.processPropertyMapping(node2, document, trigger, "COL_LIST//COL_LIST_ITEM/NAME", "columnIDs");
                }
                this.processPropertyMapping(node, document, trigger, string + "/SCHEMA", Property.createPath((String[])new String[]{"tableID", "schema", "name"}));
                this.processPropertyMapping(node, document, trigger, string + "/NAME", "tableID");
                if (ModelUtil.hasLength((String)trigger.getReferencingOldAs())) {
                    Node node4 = this.findOrCreateNode(document, node, string + "/REFERENCING/OLD_AS");
                    node4.appendChild(document.createTextNode(trigger.getReferencingOldAs()));
                }
                if (ModelUtil.hasLength((String)trigger.getReferencingNewAs())) {
                    Node node5 = this.findOrCreateNode(document, node, string + "/REFERENCING/NEW_AS");
                    node5.appendChild(document.createTextNode(trigger.getReferencingNewAs()));
                }
                this.processPropertyMapping(node, document, trigger, string + "/REFERENCING/FOR_EACH_ROW", "statementLevel", new SXMLMappings.InverseBooleanConverter());
            }
        }
    }

    @Override
    protected void readNode(Node node, Object object) {
        NameBasedID nameBasedID;
        Trigger trigger = (Trigger)object;
        Node node2 = null;
        Schema schema = null;
        if (this.nodeExists(node, "DATABASE_EVENT")) {
            trigger.setBaseType(Trigger.BaseType.DATABASE);
            node2 = this.findNode(node, "DATABASE_EVENT/EVENT_LIST");
        } else if (this.nodeExists(node, "DDL_EVENT/DATABASE")) {
            trigger.setBaseType(Trigger.BaseType.DATABASE);
            node2 = this.findNode(node, "DDL_EVENT/EVENT_LIST");
        } else if (this.nodeExists(node, "DDL_EVENT")) {
            nameBasedID = new NameBasedID();
            nameBasedID.setType("SCHEMA");
            nameBasedID.setName(this.nodeText(node, "DDL_EVENT/SCHEMA"));
            trigger.setBaseObjectID((DBObjectID)nameBasedID);
            trigger.setBaseType(Trigger.BaseType.SCHEMA);
            node2 = this.findNode(node, "DDL_EVENT/EVENT_LIST");
        } else {
            schema = new Schema(this.nodeText(node, "DML_EVENT/SCHEMA"));
            nameBasedID = new NameBasedID();
            nameBasedID.setSchema(schema);
            nameBasedID.setName(this.nodeText(node, "DML_EVENT/NAME"));
            trigger.setBaseObjectID((DBObjectID)nameBasedID);
            if ("INSTEAD_OF".equals(this.nodeText(node, "TRIGGER_TYPE"))) {
                trigger.setBaseType(Trigger.BaseType.VIEW);
                nameBasedID.setType("VIEW");
            } else {
                trigger.setBaseType(Trigger.BaseType.TABLE);
                nameBasedID.setType("TABLE");
            }
            node2 = this.findNode(node, "DML_EVENT/EVENT_LIST");
            trigger.setReferencingOldAs(this.nodeText(node, "DML_EVENT/REFERENCING/OLD_AS"));
            trigger.setReferencingNewAs(this.nodeText(node, "DML_EVENT/REFERENCING/NEW_AS"));
            if (this.nodeExists(node, "DML_EVENT/REFERENCING/FOR_EACH_ROW")) {
                trigger.setStatementLevel(false);
            }
        }
        nameBasedID = new ArrayList();
        if (node2 != null) {
            SXMLFragmentGenerator.childXMLElementIterator childXMLElementIterator2 = new SXMLFragmentGenerator.childXMLElementIterator(node2);
            while (childXMLElementIterator2.hasNext()) {
                String string;
                Node node3 = (Node)childXMLElementIterator2.next();
                if (!"EVENT_LIST_ITEM".equals(node3.getLocalName()) || (string = this.nodeText(node3, "EVENT")) == null) continue;
                nameBasedID.add(string);
                if (!this.nodeExists(node3, "COL_LIST")) continue;
                ArrayList<NameBasedID> arrayList = new ArrayList<NameBasedID>();
                Node node4 = this.findNode(node3, "COL_LIST");
                NodeList nodeList = node4.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node5 = nodeList.item(i);
                    if (!"COL_LIST_ITEM".equals(node5.getLocalName())) continue;
                    NameBasedID nameBasedID2 = new NameBasedID();
                    nameBasedID2.setSchema(schema);
                    nameBasedID2.setName(this.nodeText(node5, "NAME"));
                    nameBasedID2.setType("COLUMN");
                    nameBasedID2.setParent(trigger.getBaseObjectID());
                    arrayList.add(nameBasedID2);
                }
                trigger.setColumnIDs(arrayList.toArray(new DBObjectID[arrayList.size()]));
            }
            trigger.setEvents(nameBasedID.toArray(new String[nameBasedID.size()]));
        }
    }
}

