/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sxml;

import oracle.javatools.db.ora.sxml.DataTypeSXMLGenerator;
import oracle.javatools.db.ora.sxml.SXMLFragmentGenerator;
import oracle.javatools.db.plsql.PlSqlMethod;
import oracle.javatools.db.plsql.PlSqlParameter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class PlSqlMethodGenerator
extends SXMLFragmentGenerator {
    PlSqlMethodGenerator() {
    }

    @Override
    protected void populateNode(Node node, Document document, Object object) {
        if (object instanceof PlSqlMethod) {
            PlSqlMethod plSqlMethod = (PlSqlMethod)object;
            if (plSqlMethod.getMethodType().equals((Object)PlSqlMethod.MethodType.CONSTRUCTOR)) {
                Node node2 = this.createNode(document, node, "CONSTRUCTOR_FUNCTION");
                this.populateSubProgramNode(node2, document, plSqlMethod, true);
            } else {
                String string = plSqlMethod.getMethodType().toString();
                String string2 = plSqlMethod.getReturnTypeID() == null ? "PROCEDURE" : "FUNCTION";
                Node node3 = this.createNode(document, node, string);
                Node node4 = this.createNode(document, node3, string2);
                this.populateSubProgramNode(node4, document, plSqlMethod, false);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void populateSubProgramNode(Node node, Document document, PlSqlMethod plSqlMethod, boolean bl) {
        Object object;
        if (bl) {
            object = this.createNode(document, node, "DATATYPE");
            object.appendChild(document.createTextNode("UDT"));
        } else {
            void var8_15;
            object = this.createNode(document, node, "NAME");
            String string = plSqlMethod.getName();
            int n = string.indexOf("(");
            if (n < 0) {
                String string2 = string;
            } else {
                String string2 = string.substring(0, n);
            }
            object.appendChild(document.createTextNode((String)var8_15));
        }
        for (PlSqlParameter plSqlParameter : plSqlMethod.getParameters()) {
            Node node2 = this.findOrCreateNode(document, node, "PARAMETER_LIST");
            Node node3 = this.createNode(document, node2, "PARAMETER_LIST_ITEM");
            this.getParentGenerator().populateNode(node3, document, plSqlParameter);
        }
        if (bl) {
            this.createNode(document, node, "RETURN_SELF");
        } else if ((plSqlMethod.getSqljSigName() != null || plSqlMethod.getSqljSigVarName() != null) && plSqlMethod.getReturnTypeID().equals(plSqlMethod.getParent().getID())) {
            this.createNode(document, node, "RETURN_SELF");
        } else if (plSqlMethod.getReturnTypeID() != null) {
            object = this.createNode(document, node, "RETURN");
            DataTypeSXMLGenerator dataTypeSXMLGenerator = new DataTypeSXMLGenerator();
            dataTypeSXMLGenerator.setParentGenerator(this.getParentGenerator());
            dataTypeSXMLGenerator.populateNode((Node)object, document, plSqlMethod);
        }
        if (plSqlMethod.getCallSpecLanguage() != null) {
            object = this.createNode(document, node, "CALL_SPEC");
            Node node4 = this.createNode(document, (Node)object, "LANGUAGE");
            if (plSqlMethod.getCallSpecLanguage() == PlSqlMethod.CallSpecLanguage.JAVA) {
                this.createNode(document, node4, "JAVA");
            } else {
                this.createNode(document, node4, "C");
            }
            if (plSqlMethod.getCallSpecName() != null) {
                Node node5 = this.createNode(document, (Node)object, "NAME");
                node5.appendChild(document.createTextNode(plSqlMethod.getCallSpecName()));
            }
            if (plSqlMethod.getCallSpecLibName() != null) {
                Node node6 = this.createNode(document, (Node)object, "LIBRARY");
                node6.appendChild(document.createTextNode(plSqlMethod.getCallSpecLibName()));
            }
            if (plSqlMethod.isCallSpecWithContext()) {
                this.createNode(document, (Node)object, "WITH_CONTEXT");
            }
        } else if (plSqlMethod.getSqljSigName() != null) {
            object = this.createNode(document, node, "EXTERNAL_NAME");
            object.appendChild(document.createTextNode(plSqlMethod.getSqljSigName()));
        } else if (plSqlMethod.getSqljSigVarName() != null) {
            object = this.createNode(document, node, "EXTERNAL_VARIABLE_NAME");
            object.appendChild(document.createTextNode(plSqlMethod.getSqljSigVarName()));
        }
    }

    @Override
    protected void readNode(Node node, Object object) {
    }
}

