/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.parser.ParseNode;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ora.sql.Keywords;
import oracle.javatools.db.ora.sql.OracleSQLQueryBuilder;
import oracle.javatools.db.ora.sql.OracleSQLQueryBuilderHelper;
import oracle.javatools.db.ora.sql.ParserRules;
import oracle.javatools.db.ora.sxml.SQLFragmentSXMLGenerator;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.BuiltInFunction;
import oracle.javatools.db.sql.ExpressionList;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.Function;
import oracle.javatools.db.sql.FunctionUsage;
import oracle.javatools.db.sql.GroupByExpression;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.token.Token;

public final class ExpressionContext
implements Keywords,
ParserRules {
    private final DBObjectProvider m_provider;
    private final OracleSQLQueryBuilder m_queryBuilder;
    private final SQLQuery m_query;
    private final Object m_queryContext;
    private final SQLFragment m_creating;
    private final Schema m_defaultSchema;
    private final OracleSQLQueryBuilderHelper m_helper;

    ExpressionContext(OracleSQLQueryBuilder oracleSQLQueryBuilder, SQLQuery sQLQuery, DBObjectProvider dBObjectProvider, Schema schema, OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper, Object object, SQLFragment sQLFragment) {
        this.m_queryBuilder = oracleSQLQueryBuilder;
        this.m_query = sQLQuery;
        this.m_provider = dBObjectProvider;
        this.m_defaultSchema = schema;
        this.m_helper = oracleSQLQueryBuilderHelper;
        this.m_queryContext = object;
        this.m_creating = sQLFragment;
    }

    public Object getQueryContext() {
        return this.m_queryContext;
    }

    public SQLFragment getCreating() {
        return this.m_creating;
    }

    public OracleSQLQueryBuilderHelper getHelper() {
        return this.m_helper;
    }

    public SQLQuery getQuery() {
        return this.m_query;
    }

    public OracleSQLQueryBuilder getQueryBuilder() {
        return this.m_queryBuilder;
    }

    public DBObjectProvider getProvider() {
        return this.m_provider;
    }

    public Schema getDefaultSchema() {
        return this.m_defaultSchema;
    }

    public String getDefaultSchemaName() {
        return this.m_defaultSchema == null ? null : this.m_defaultSchema.getName();
    }

    public FromObject findFromObject(String string, FromObject fromObject) {
        FromObject fromObject2 = this.m_queryBuilder.getFromObject(string, fromObject);
        if (fromObject2 == null) {
            for (OracleSQLQueryBuilder oracleSQLQueryBuilder = (OracleSQLQueryBuilder)this.m_queryBuilder.getParentBuilder(); oracleSQLQueryBuilder != null && fromObject2 == null; oracleSQLQueryBuilder = (OracleSQLQueryBuilder)oracleSQLQueryBuilder.getParentBuilder()) {
                fromObject2 = oracleSQLQueryBuilder.getFromObject(string);
            }
        }
        return fromObject2;
    }

    public SQLFragment[] getArgList(Object object, ParseNode parseNode) throws SQLQueryException {
        List<ParseNode> list = this.m_helper.getOrderedChildren(parseNode);
        int n = this.m_helper.getKeywordIndex(list, "(");
        int n2 = this.m_helper.getKeywordIndex(list, ")");
        if (n2 == -1) {
            n2 = list.size();
        }
        int n3 = n + 1;
        return this.getArgList(object, list, n3, n2);
    }

    public SQLFragment[] getArgList(Object object, List<ParseNode> list, int n, int n2) throws SQLQueryException {
        boolean bl;
        SQLFragment sQLFragment = null;
        int n3 = this.m_helper.getKeywordIndex(list, "FROM");
        boolean bl2 = bl = n3 != -1 && n3 < n2;
        if (this.m_helper.isKeyword(list.get(n), "DISTINCT", "ALL")) {
            ++n;
        } else if (this.m_helper.isKeyword(list.get(n), "LEADING", "TRAILING", "BOTH")) {
            if (!this.m_helper.isKeyword(list.get(++n), "FROM")) {
                sQLFragment = this.createFragment(list.get(n), this.m_creating, object);
                ++n;
            }
            ++n;
        } else if (bl) {
            sQLFragment = this.createFragment(list.get(n), this.m_creating, object);
            ++n;
            ++n;
        }
        List<List<ParseNode>> list2 = this.m_helper.getCommaSeparatedList(list.subList(n, n2));
        if (n2 == n + 1 && object instanceof GroupByExpression && GroupByExpression.GroupingType.GROUPING_SETS.equals((Object)((GroupByExpression)object).getGroupByType())) {
            list2 = this.m_helper.getCommaSeparatedList(list.get(n));
        }
        ArrayList<SQLFragment> arrayList = new ArrayList<SQLFragment>();
        for (List<ParseNode> list3 : list2) {
            if (list3 == null || list3.size() != 1) continue;
            SQLFragment sQLFragment2 = this.createFragment(list3.get(0), this.m_creating, object);
            arrayList.add(sQLFragment2);
        }
        if (sQLFragment != null) {
            arrayList.add(sQLFragment);
        }
        SQLFragment[] sQLFragmentArray = arrayList.toArray(new SQLFragment[arrayList.size()]);
        return sQLFragmentArray;
    }

    private DBObjectID findObjectID(DBObject dBObject, PlSqlToken plSqlToken) {
        block9: {
            String string;
            block8: {
                String[] stringArray = new String[]{"FUNCTION", "PACKAGE", "TYPE"};
                string = this.m_provider.getInternalName(plSqlToken.getSource(true));
                if (!(dBObject instanceof Schema)) break block8;
                for (String string2 : stringArray) {
                    SchemaObject schemaObject = null;
                    try {
                        schemaObject = this.m_provider.getObject(string2, (Schema)dBObject, string);
                    }
                    catch (DBException dBException) {
                        schemaObject = null;
                    }
                    if (schemaObject == null) continue;
                    if (((PlSqlToken)plSqlToken.getNextCodeToken()).getType() == Token.Type.END_MARKER) {
                        return schemaObject.getID();
                    }
                    if (((PlSqlToken)plSqlToken.getNextCodeToken()).matches(".")) {
                        return this.findObjectID((DBObject)schemaObject, (PlSqlToken)plSqlToken.getNextCodeToken(2));
                    }
                    return null;
                }
                break block9;
            }
            if (dBObject == null) break block9;
            for (DBObject dBObject2 : dBObject.getOwnedObjects()) {
                if (dBObject2.getName() == null || !dBObject2.getName().equals(string)) continue;
                if (((PlSqlToken)plSqlToken.getNextCodeToken()).getType() == Token.Type.END_MARKER) {
                    return dBObject2.getID();
                }
                if (((PlSqlToken)plSqlToken.getNextCodeToken()).matches(".")) {
                    return this.findObjectID(dBObject2, (PlSqlToken)plSqlToken.getNextCodeToken(2));
                }
                return null;
            }
        }
        return null;
    }

    public DBObjectID findIdForFunctionString(String string) {
        Schema schema;
        PlSqlToken plSqlToken;
        DBObjectID dBObjectID = null;
        PlSqlToken plSqlToken2 = plSqlToken = PlSqlTokenizer.tokenize((String)string, (String[])new String[0]);
        PlSqlToken plSqlToken3 = null;
        while (plSqlToken2.getType() != Token.Type.END_MARKER) {
            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextToken();
        }
        plSqlToken3 = (PlSqlToken)plSqlToken2.getPrevCodeToken();
        dBObjectID = this.findObjectID((DBObject)this.m_defaultSchema, plSqlToken);
        if (dBObjectID == null) {
            try {
                schema = this.m_provider.getSchema(this.m_provider.getInternalName(plSqlToken.getSource(true)));
                if (schema != null && ((PlSqlToken)plSqlToken.getNextCodeToken()).matches(".")) {
                    dBObjectID = this.findObjectID((DBObject)schema, (PlSqlToken)plSqlToken.getNextCodeToken(2));
                }
            }
            catch (DBException dBException) {
                DBLog.getLogger((Object)this).fine(dBException.getMessage());
            }
        }
        if (dBObjectID == null) {
            schema = string.split("\\.");
            ReferenceID referenceID = null;
            for (Schema schema2 : schema) {
                Schema schema3 = referenceID == null ? this.m_defaultSchema : null;
                ReferenceID referenceID2 = new ReferenceID("UNSPECIFIED_TYPE", schema3, (String)schema2);
                referenceID2.setProvider(this.m_provider);
                referenceID2.setParent(referenceID);
                dBObjectID = referenceID2;
                referenceID = referenceID2;
            }
        }
        return dBObjectID;
    }

    public SQLFragment createFunction(String string, BuiltInFunction builtInFunction, String string2, boolean bl, SQLFragment[] sQLFragmentArray) throws SQLQueryException {
        FunctionUsage functionUsage = null;
        if (SQLFragmentSXMLGenerator.isInCompoundExpressionGroup(builtInFunction.getName())) {
            functionUsage = this.m_queryBuilder.createFunction(builtInFunction.getName(), sQLFragmentArray, string);
            if (functionUsage == null) {
                this.m_queryBuilder.throwException(new SQLQueryException(APIBundle.format((String)"SQL_UNKNOWN_FUNC", (Object[])new Object[]{builtInFunction})));
            }
            ((Function)functionUsage).setDistinct(bl);
            ((Function)functionUsage).setDistinctSource(string2);
        } else {
            functionUsage = new FunctionUsage();
            functionUsage.setObjectID(this.findIdForFunctionString(builtInFunction.getName()));
            functionUsage.setArguments(sQLFragmentArray);
        }
        return functionUsage;
    }

    public List<List<ParseNode>> getCompoundExpression(List<ParseNode> list, int n) {
        list = this.m_helper.getOrderedChildren(list.get(n));
        List<List<ParseNode>> list2 = this.m_helper.getCommaSeparatedList(list.subList(this.m_helper.getKeywordIndex(list, "(") + 1, this.m_helper.getKeywordIndex(list, ")")));
        return list2;
    }

    public ExpressionList createExpressionList(List<List<ParseNode>> list, SQLFragment sQLFragment) throws SQLQueryException {
        SelectObject[] selectObjectArray = new SelectObject[list.size()];
        int n = 0;
        for (List<ParseNode> list2 : list) {
            ParseNode parseNode = list2.get(0);
            SQLFragment sQLFragment2 = this.createFragment(parseNode, sQLFragment);
            String string = null;
            if (list2.size() > 1 && this.m_helper.isLeaf(list2.get(1))) {
                string = this.m_helper.getContent(list2.get(1));
            }
            selectObjectArray[n] = new SelectObject(sQLFragment2, string);
            ++n;
        }
        ExpressionList expressionList = new ExpressionList((SQLFragment[])selectObjectArray);
        return expressionList;
    }

    public SQLFragment createFragment(ParseNode parseNode, SQLFragment sQLFragment) throws SQLQueryException {
        return this.createFragment(parseNode, sQLFragment, null);
    }

    public SQLFragment createFragment(ParseNode parseNode, SQLFragment sQLFragment, Object object) throws SQLQueryException {
        return this.m_queryBuilder.createFragment(parseNode, sQLFragment, object, this.m_helper);
    }
}

