/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.owb;

import java.util.HashMap;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.ora.owb.OMBSinglePropertyResolver;
import oracle.javatools.db.ora.owb.OMBStoragePropsBuilder;

public class OMBTablePartitionDefPropsBuilder
extends OMBStoragePropsBuilder<TablePartition> {
    public OMBTablePartitionDefPropsBuilder(Object object) {
        super((TablePartition)object, "segmentAttributes");
        this.registerPropertyMappings();
        this.buildSetProperties();
    }

    @Override
    public void registerPropertyMappings() {
        super.registerPropertyMappings();
        this.registerPropertyMapping("values", new OMBPartitionValuePropResolver((TablePartition)this.getContextObject()));
        this.registerPropertyMapping("compression", "DATA_SEGMENT_COMPRESSION");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("true", "COMPRESS");
        hashMap.put("false", "NOCOMPRESS");
        this.registerSubstitutionValues("DATA_SEGMENT_COMPRESSION", (HashMap)hashMap);
    }

    public final class OMBPartitionValuePropResolver
    implements OMBSinglePropertyResolver {
        TablePartition m_partition = null;
        final String COMMA = ",";

        public OMBPartitionValuePropResolver(TablePartition tablePartition) {
            this.m_partition = tablePartition;
        }

        @Override
        public String resolvePropertyValue() {
            if (this.m_partition.getValues() != null) {
                StringBuffer stringBuffer = new StringBuffer();
                boolean bl = true;
                for (int i = 0; i < this.m_partition.getValues().length; ++i) {
                    String string;
                    if (!bl) {
                        stringBuffer.append(",");
                    }
                    if ((string = this.m_partition.getValues()[i].toString()).indexOf("'") != -1) {
                        string = this.stripQuotes(string);
                        stringBuffer.append("''");
                        stringBuffer.append(string);
                        stringBuffer.append("''");
                    } else {
                        stringBuffer.append(string);
                    }
                    bl = false;
                }
                if (stringBuffer.length() == 0) {
                    return null;
                }
                return stringBuffer.toString();
            }
            return null;
        }

        @Override
        public String resolvePropertyName() {
            if (this.m_partition.getPartitionType().equals((Object)OracleTablePartitions.PartitionType.LIST)) {
                return "VALUES_EQUAL_TO";
            }
            return "VALUES_LESS_THAN";
        }

        private String stripQuotes(String string) {
            if (string.contains("'")) {
                string = string.replaceAll("'", "");
            }
            return string;
        }
    }
}

