/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.owb;

import java.util.HashMap;
import oracle.javatools.db.Relation;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.owb.OMBPropsStatementBuilder;
import oracle.javatools.db.ora.owb.OMBSinglePropertyResolver;
import oracle.javatools.db.ora.owb.OMBStoragePropsBuilder;
import oracle.javatools.db.property.Property;

class OMBMatViewPropsBuilder
extends OMBStoragePropsBuilder<MaterializedView> {
    public OMBMatViewPropsBuilder(Object object) {
        super((MaterializedView)object, Property.createPath((String[])new String[]{"properties", "OracleStorageProperties"}));
        this.registerPropertyMappings();
        this.buildSetProperties();
    }

    @Override
    public void registerPropertyMappings() {
        super.registerPropertyMappings();
        this.registerPropertyMapping("buildType", "BUILD");
        if (((MaterializedView)this.getContextObject()).getRefreshMode().equals((Object)MaterializedView.RefreshMode.SPECIFY)) {
            this.registerPropertyMapping("firstRefresh", new OMBStartsWithPropResolver());
            this.registerPropertyMapping("interval", "NEXTDATE");
        }
        String string = Property.createPath((String[])new String[]{"properties", "OracleTableProperties", "parallelDegree"});
        this.registerPropertyMapping(string, new String[]{"PARALLEL_ACCESS_MODE", "PARALLEL_DEGREE"});
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("$DEFAULT$", "PARALLEL");
        this.registerSubstitutionValues("PARALLEL_ACCESS_MODE", (HashMap)hashMap);
        this.registerPropertyMapping("queryRewrite", "QUERY_REWRITE");
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        hashMap2.put("true", "ENABLE");
        hashMap2.put("false", "DISABLE");
        this.registerSubstitutionValues("QUERY_REWRITE", (HashMap)hashMap2);
        this.registerPropertyMapping("refreshMethod", "REFRESH");
        this.registerPropertyMapping("refreshMode", "REFRESH_ON");
        HashMap<String, String> hashMap3 = new HashMap<String, String>();
        hashMap3.put("NEVER", "$IGNORE$");
        hashMap3.put("SPECIFY", "$IGNORE$");
        this.registerSubstitutionValues("REFRESH_ON", (HashMap)hashMap3);
        this.registerPropertyMapping("useNoIndex", "USING_INDEX_MODE");
        HashMap<String, String> hashMap4 = new HashMap<String, String>();
        hashMap4.put("true", "USING_NO_INDEX");
        hashMap4.put("false", "USING_INDEX");
        this.registerSubstitutionValues("USING_INDEX_MODE", (HashMap)hashMap4);
        this.registerPropertyMapping("rollbackSegmentType", "ROLLBACK");
        HashMap<String, String> hashMap5 = new HashMap<String, String>();
        hashMap5.put("MASTER", "DEFAULT MASTER");
        hashMap5.put("LOCAL", "DEFAULT LOCAL");
        hashMap5.put("NONE", "NONE");
        this.registerSubstitutionValues("ROLLBACK", (HashMap)hashMap5);
        this.registerPropertyMapping("rollbackSegmentName", new OMBRollbackSegPropResolver());
        this.registerPropertyMapping("viewText", new OMBPropsStatementBuilder.OMBViewQueryPropResolver(this, (Relation)((MaterializedView)this.getContextObject())));
        String string2 = Property.createPath((String[])new String[]{"properties", "MatViewIndexStorageProperties"});
        this.registerPropertyMapping(Property.createPath((String[])new String[]{string2, "bufferMode"}), "DEFAULTINDEXBUFFERPOOL");
        this.registerPropertyMapping(Property.createPath((String[])new String[]{string2, "freelistGroups"}), "DEFAULTINDEXFREELISTGROUPS");
        this.registerPropertyMapping(Property.createPath((String[])new String[]{string2, "freelists"}), "DEFAULTINDEXFREELISTS");
        this.registerPropertyMapping(Property.createPath((String[])new String[]{string2, "initialExtent"}), "DEFAULTINDEXINITIAL");
        this.registerPropertyMapping(Property.createPath((String[])new String[]{string2, "initrans"}), "DEFAULTINDEXINITRANS");
        this.registerPropertyMapping(Property.createPath((String[])new String[]{string2, "maxtrans"}), "DEFAULTINDEXMAXTRANS");
        this.registerPropertyMapping(Property.createPath((String[])new String[]{string2, "maxExtent"}), "DEFAULTINDEXMAXEXTENTS");
        this.registerPropertyMapping(Property.createPath((String[])new String[]{string2, "minExtent"}), "DEFAULTINDEXMINEXTENTS");
        this.registerPropertyMapping(Property.createPath((String[])new String[]{string2, "nextExtent"}), "DEFAULTINDEXNEXT");
        this.registerPropertyMapping(Property.createPath((String[])new String[]{string2, "percentIncrease"}), "DEFAULTINDEXPCTINCREASE");
        this.registerPropertyMapping(Property.createPath((String[])new String[]{string2, "tablespaceID", "name"}), "DEFAULT_INDEX_TABLESPACE");
    }

    public final class OMBStartsWithPropResolver
    implements OMBSinglePropertyResolver {
        @Override
        public String resolvePropertyValue() {
            MaterializedView materializedView = (MaterializedView)OMBMatViewPropsBuilder.this.getContextObject();
            StringBuilder stringBuilder = new StringBuilder();
            if (materializedView.getFirstRefresh() != null) {
                stringBuilder.append(materializedView.getFirstRefresh());
            }
            return stringBuilder.toString();
        }

        @Override
        public String resolvePropertyName() {
            return "STARTWITH";
        }
    }

    public final class OMBRollbackSegPropResolver
    implements OMBSinglePropertyResolver {
        @Override
        public String resolvePropertyValue() {
            return ((MaterializedView)OMBMatViewPropsBuilder.this.getContextObject()).getRollbackSegmentName();
        }

        @Override
        public String resolvePropertyName() {
            if (((MaterializedView)OMBMatViewPropsBuilder.this.getContextObject()).getRollbackSegmentType().equals((Object)MaterializedView.RollbackSegmentType.LOCAL)) {
                return "ROLLBACKSEGMENTLOCAL";
            }
            return "ROLLBACKSEGMENTMASTER";
        }
    }
}

