/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.owb;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.Table;
import oracle.javatools.db.datatypes.DataTypeID;
import oracle.javatools.db.ora.owb.OMBPropertyResolver;
import oracle.javatools.db.ora.owb.OMBPropertyValidator;
import oracle.javatools.db.ora.owb.OMBPropsStatementBuilder;
import oracle.javatools.db.ora.owb.OMBSinglePropertyResolver;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.util.ModelUtil;

class OMBColumnPropsBuilder
extends OMBPropsStatementBuilder<Column> {
    public OMBColumnPropsBuilder(Object object) {
        super((Column)object);
        this.registerPropertyMappings();
        this.buildSetProperties();
    }

    @Override
    public void registerPropertyMappings() {
        String string;
        Object object;
        Object object2;
        Column column = (Column)this.getContextObject();
        String string2 = Property.createPath((String[])new String[]{"dataTypeUsage", "dataTypeID", "name"});
        this.registerPropertyMapping(string2, "DATATYPE");
        this.registerPropertyMapping("default", new OMBColDefaultValuePropResolver());
        PropertyHelper propertyHelper = new PropertyHelper();
        String string3 = Property.createPath((String[])new String[]{"properties", "TableType"});
        Object object3 = propertyHelper.getPropertyValue((Object)column.getParent(), string3);
        if (object3 == null || object3 != Table.TableType.EXTERNAL) {
            this.registerPropertyMapping("notNull", "NOT_NULL");
            object2 = new HashMap();
            ((HashMap)object2).put("true", "1");
            ((HashMap)object2).put("false", "0");
            this.registerSubstitutionValues("NOT_NULL", (HashMap<String, String>)object2);
        }
        if ((object2 = column.getDataTypeUsage()) != null && (object = object2.getDataTypeID()) instanceof DataTypeID) {
            string = Property.createPath((String[])new String[]{"dataTypeUsage", "attributeValues", "scale"});
            DataTypeID dataTypeID = (DataTypeID)object;
            if (dataTypeID.getTypeName().equals("TIMESTAMP")) {
                this.registerPropertyMapping(string, "FRACTIONAL_SECONDS_PRECISION");
            } else {
                this.registerPropertyMapping(string, "SCALE");
            }
        }
        object = Property.createPath((String[])new String[]{"dataTypeUsage", "attributeValues", "precision"});
        string = Property.createPath((String[])new String[]{"dataTypeUsage", "attributeValues", "size"});
        this.registerPropertyMapping((String)object, "PRECISION");
        this.registerPropertyMapping(string, "LENGTH");
        this.registerPropertyValidator("DATATYPE", new OMBDatatypePropValidator());
        this.registerPropertyMapping("virtualExpressionSource", new OMBColVirtualExpressionPropResolver());
    }

    public final class OMBDatatypePropValidator
    extends OMBPropertyValidator {
        final Set<String> m_validDatatypes = new HashSet<String>();

        void setValidDataTypes() {
            this.m_validDatatypes.add("BINARY_DOUBLE");
            this.m_validDatatypes.add("BINARY_FLOAT");
            this.m_validDatatypes.add("BLOB");
            this.m_validDatatypes.add("CHAR");
            this.m_validDatatypes.add("CLOB");
            this.m_validDatatypes.add("DATE");
            this.m_validDatatypes.add("FLOAT");
            this.m_validDatatypes.add("INTEGER");
            this.m_validDatatypes.add("INTERVAL DAY");
            this.m_validDatatypes.add("INTERVAL YEAR");
            this.m_validDatatypes.add("NCHAR");
            this.m_validDatatypes.add("NCLOB");
            this.m_validDatatypes.add("NUMBER");
            this.m_validDatatypes.add("NVARCHAR2");
            this.m_validDatatypes.add("RAW");
            this.m_validDatatypes.add("SYS.ANYDATA");
            this.m_validDatatypes.add("SYS.LCR$_ROW_RECORD");
            this.m_validDatatypes.add("SYS.XMLFORMAT");
            this.m_validDatatypes.add("TIMESTAMP");
            this.m_validDatatypes.add("VARCHAR");
            this.m_validDatatypes.add("VARCHAR2");
            this.m_validDatatypes.add("XMLTYPE");
        }

        @Override
        public void validateProperty(String string, String string2) {
            this.setValidDataTypes();
            if (!this.m_validDatatypes.contains(string2)) {
                DBLog.getLogger((Object)this).warning("Column datatype " + string2 + " is not supported in OMB Script");
            }
        }
    }

    public final class OMBColDefaultValuePropResolver
    implements OMBSinglePropertyResolver {
        @Override
        public String resolvePropertyValue() {
            String string = (String)((Column)OMBColumnPropsBuilder.this.getContextObject()).getDefault();
            return string.trim().replaceAll("'", "''");
        }

        @Override
        public String resolvePropertyName() {
            return "DEFAULT_VALUE";
        }
    }

    public final class OMBColVirtualExpressionPropResolver
    implements OMBPropertyResolver {
        @Override
        public String[] resolvePropertyValues() {
            String[] stringArray;
            String string = ((Column)OMBColumnPropsBuilder.this.getContextObject()).getVirtualExpressionSource();
            if (!ModelUtil.hasLength((String)string)) {
                stringArray = new String[]{};
            } else {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "true";
                stringArray = stringArray2;
                stringArray2[1] = string;
            }
            return stringArray;
        }

        @Override
        public String[] resolvePropertyNames() {
            String[] stringArray;
            String string = ((Column)OMBColumnPropsBuilder.this.getContextObject()).getVirtualExpressionSource();
            if (!ModelUtil.hasLength((String)string)) {
                stringArray = new String[]{};
            } else {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "VIRTUAL";
                stringArray = stringArray2;
                stringArray2[1] = "EXPRESSION";
            }
            return stringArray;
        }
    }
}

