/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTableBuilder;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.OracleTableProperties;
import oracle.javatools.db.ora.OracleTablespaceUtil;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.MultiMap;

public class OracleTablePartitionsBuilder
extends OracleDBObjectBuilder<OracleTablePartitions> {
    public OracleTablePartitionsBuilder(BaseOracleDatabase baseOracleDatabase) {
        super(baseOracleDatabase, "PARTITION MODEL");
    }

    private Table getTable(DBObject dBObject) {
        return (Table)DBUtil.findParentOfType((DBObject)dBObject, Table.class);
    }

    protected boolean canBuildComponents() {
        return true;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"partitionColumns"})
    public void fillInPartitionColumns(OracleTablePartitions oracleTablePartitions) throws DBException {
        Table table;
        if (oracleTablePartitions.getObjectType() == OracleTablePartitions.ObjectType.SUBPARTITION && (table = this.getTable((DBObject)oracleTablePartitions)) != null) {
            QueryWrapper queryWrapper = this.getDatabase().newQueryWrapper((SystemObject)table, "select /*OracleDictionaryQueries.ALL_TABLE_SUBPARTITION_COLUMNS_QUERY*/\n       COLUMN_NAME\nfrom   SYS.ALL_SUBPART_KEY_COLUMNS\nwhere  OWNER = ?\nand    NAME  = ?\norder by COLUMN_POSITION", table.getSchema(), table);
            final ArrayList arrayList = new ArrayList();
            QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet resultSet) throws DBException, SQLException {
                    while (resultSet.next()) {
                        Column column = table.getColumn(resultSet.getString(1));
                        if (column == null) continue;
                        arrayList.add(column.getID());
                    }
                }
            };
            queryWrapper.executeQuery(queryRunnable);
            oracleTablePartitions.setPartitionColumns(arrayList.toArray(new DBObjectID[arrayList.size()]));
        }
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"partitions"})
    public void fillInPartitions(OracleTablePartitions oracleTablePartitions) throws DBException {
        Table table = this.getTable((DBObject)oracleTablePartitions);
        if (table != null) {
            OracleTablePartitions.ObjectType objectType = oracleTablePartitions.getObjectType();
            if (objectType == OracleTablePartitions.ObjectType.PARTITION) {
                this.fillInPartitions(table, oracleTablePartitions);
            } else if (objectType == OracleTablePartitions.ObjectType.SUBPARTITION) {
                this.fillInTemplates(table, oracleTablePartitions);
            }
        }
    }

    private void fillInPartitions(Table table, final OracleTablePartitions oracleTablePartitions) throws DBException {
        final ArrayList arrayList = new ArrayList();
        final BaseOracleDatabase baseOracleDatabase = this.getDatabase();
        QueryWrapper queryWrapper = baseOracleDatabase.newQueryWrapper((SystemObject)table, this.getTablePartitionsQuery(table), table.getSchema(), OracleTableBuilder.getQueryObject(table));
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException, SQLException {
                TablePartitionBuilder tablePartitionBuilder = new TablePartitionBuilder(baseOracleDatabase);
                while (resultSet.next()) {
                    TablePartition tablePartition = (TablePartition)OracleTablePartitionsBuilder.this.newObject(TablePartition.class, resultSet.getString("PARTITION_NAME"));
                    baseOracleDatabase.setOracleBuilder(tablePartition, tablePartitionBuilder);
                    tablePartition.setObjectType(oracleTablePartitions.getObjectType());
                    tablePartition.setPartitionType(oracleTablePartitions.getPartitionType());
                    tablePartition.setID((DBObjectID)new NameBasedID((DBObject)tablePartition, oracleTablePartitions.getID()));
                    arrayList.add(tablePartition);
                    OracleTablePartitionsBuilder.this.initialisePartition(tablePartition, resultSet);
                }
            }
        };
        queryWrapper.executeQuery(queryRunnable);
        oracleTablePartitions.setPartitions(arrayList.toArray(new TablePartition[arrayList.size()]));
    }

    private void fillInTemplates(Table table, final OracleTablePartitions oracleTablePartitions) throws DBException {
        final ArrayList arrayList = new ArrayList();
        final BaseOracleDatabase baseOracleDatabase = this.getDatabase();
        QueryWrapper queryWrapper = baseOracleDatabase.newQueryWrapper((SystemObject)table, "select /*OracleDictionaryQueries.ALL_TABLE_SUBPARTITION_TEMPLATES_QUERY*/\n       SUBPARTITION_NAME, TABLESPACE_NAME, HIGH_BOUND\nfrom   SYS.ALL_SUBPARTITION_TEMPLATES\nwhere  /**/USER_NAME  = ?\nand    TABLE_NAME = ?\norder by SUBPARTITION_POSITION", table.getSchema(), table);
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException, SQLException {
                TablePartitionBuilder tablePartitionBuilder = new TablePartitionBuilder(baseOracleDatabase);
                while (resultSet.next()) {
                    String string = resultSet.getString("SUBPARTITION_NAME");
                    TablePartition tablePartition = (TablePartition)OracleTablePartitionsBuilder.this.newObject(TablePartition.class, string);
                    baseOracleDatabase.setOracleBuilder(tablePartition, tablePartitionBuilder);
                    tablePartition.setObjectType(OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE);
                    tablePartition.setPartitionType(oracleTablePartitions.getPartitionType());
                    tablePartition.setID((DBObjectID)new NameBasedID((DBObject)tablePartition, oracleTablePartitions.getID()));
                    String string2 = resultSet.getString("HIGH_BOUND");
                    if (string2 != null && !resultSet.wasNull()) {
                        tablePartition.setValues(string2);
                    }
                    OracleTablePartitionsBuilder.this.fillInTablespace(tablePartition, resultSet);
                    arrayList.add(tablePartition);
                }
            }
        };
        queryWrapper.executeQuery(queryRunnable);
        if (!arrayList.isEmpty()) {
            oracleTablePartitions.setObjectType(OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE);
            oracleTablePartitions.setPartitions(arrayList.toArray(new TablePartition[arrayList.size()]));
        }
    }

    private void fillInPartitionLOBs(final Table table, final OracleTablePartitions oracleTablePartitions, String string) throws DBException {
        final MultiMap multiMap = new MultiMap(IdentityHashMap.class, ArrayList.class);
        QueryWrapper queryWrapper = this.getDatabase().newQueryWrapper((SystemObject)table, string, table.getSchema(), table);
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException, SQLException {
                while (resultSet.next()) {
                    String string;
                    Column column = table.getColumn(resultSet.getString("COLUMN_NAME"));
                    if (column == null) continue;
                    TablePartition tablePartition = OracleTablePartitionsBuilder.this.findTablePartition(resultSet.getString("NAME"), oracleTablePartitions);
                    LOBDescriptor lOBDescriptor = new LOBDescriptor();
                    lOBDescriptor.addColumn(column.getID());
                    lOBDescriptor.setLOBSegName(resultSet.getString("LOB_SEGMENT_NAME"));
                    if (tablePartition.getObjectType() != OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE && tablePartition.getPartitionType() != OracleTablePartitions.PartitionType.HASH) {
                        int n = resultSet.getInt("CHUNK");
                        lOBDescriptor.setChunk(resultSet.wasNull() ? null : Integer.valueOf(n));
                        int n2 = resultSet.getInt("PCTVERSION");
                        lOBDescriptor.setPctVersion(resultSet.wasNull() ? null : Integer.valueOf(n2));
                        lOBDescriptor.setStorageInRow(Boolean.valueOf("YES".equalsIgnoreCase(resultSet.getString("IN_ROW"))));
                        OracleTableBuilder.setLOBCache(lOBDescriptor, resultSet.getString("CACHE"));
                        OracleStorageProperties oracleStorageProperties = OracleTableBuilder.getStorageProperties(resultSet);
                        OracleTableBuilder.setLogging(resultSet, oracleStorageProperties);
                        lOBDescriptor.setStorage(oracleStorageProperties);
                    }
                    DBObjectID dBObjectID = ModelUtil.hasLength((String)(string = resultSet.getString("TABLESPACE_NAME"))) ? OracleTablespaceUtil.getTablespaceID((DBObjectProvider)OracleTablePartitionsBuilder.this.getDatabase(), string) : null;
                    OracleTablePartitionsBuilder.this.getOrCreateStorage(lOBDescriptor).setTablespaceID(dBObjectID);
                    lOBDescriptor.setID((DBObjectID)new NameBasedID((DBObject)lOBDescriptor, tablePartition.getID()));
                    multiMap.add((Object)tablePartition, (Object)lOBDescriptor);
                }
            }
        };
        queryWrapper.executeQuery(queryRunnable);
        for (Map.Entry entry : multiMap.entrySet()) {
            Collection collection = (Collection)entry.getValue();
            ((TablePartition)entry.getKey()).setLOBDescriptors(collection.toArray(new LOBDescriptor[collection.size()]));
        }
    }

    private void initialisePartition(TablePartition tablePartition, ResultSet resultSet) throws SQLException {
        OracleTablePartitions.PartitionType partitionType = tablePartition.getPartitionType();
        assert (partitionType != null);
        if (tablePartition.getPartitionType() == OracleTablePartitions.PartitionType.HASH) {
            this.fillInTablespace(tablePartition, resultSet);
        } else if (partitionType != null) {
            tablePartition.setValues(resultSet.getString("HIGH_VALUE"));
            tablePartition.setSegmentAttributes(OracleTableBuilder.getSegmentAttributeProperties(resultSet, this.getDatabase()));
        }
        this.fillInPartitionTableProperties(tablePartition, resultSet);
    }

    private void fillInPartitionTableProperties(TablePartition tablePartition, ResultSet resultSet) throws SQLException {
        if (this.getDatabase().getDatabaseVersion() >= 110) {
            String string;
            String string2 = resultSet.getString("COMPRESSION");
            OracleTableProperties oracleTableProperties = OracleTableBuilder.getOracleTableProperties((DBObject)tablePartition, string2, string = resultSet.getString("COMPRESS_FOR"), null, null, this.getDatabase());
            if (oracleTableProperties.getTableCompression() != null) {
                tablePartition.setProperty("OracleTableProperties", (Object)oracleTableProperties);
            }
            OracleTableBuilder.fillInMemoryProperties((DBObject)tablePartition, resultSet, this.getDatabase());
        }
    }

    private void fillInPartitionLevelSubpartitions(Table table, final OracleTablePartitions oracleTablePartitions, final OracleTablePartitions.PartitionType partitionType) throws DBException {
        final IdentityHashMap identityHashMap = new IdentityHashMap();
        BaseOracleDatabase baseOracleDatabase = this.getDatabase();
        QueryWrapper queryWrapper = baseOracleDatabase.newQueryWrapper((SystemObject)table, this.getTablePartitionLevelSubpartitionsQuery(), table.getSchema(), table);
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException, SQLException {
                while (resultSet.next()) {
                    TablePartition tablePartition = OracleTablePartitionsBuilder.this.findTablePartition(resultSet.getString("PARTITION_NAME"), oracleTablePartitions);
                    if (tablePartition == null) continue;
                    OracleTablePartitions oracleTablePartitions2 = (OracleTablePartitions)identityHashMap.get(tablePartition);
                    if (oracleTablePartitions2 == null) {
                        oracleTablePartitions2 = new OracleTablePartitions(partitionType, OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION);
                        oracleTablePartitions2.setID((DBObjectID)new NameBasedID((DBObject)oracleTablePartitions2, tablePartition.getID()));
                        identityHashMap.put(tablePartition, oracleTablePartitions2);
                    }
                    String string = resultSet.getString("SUBPARTITION_NAME");
                    TablePartition tablePartition2 = oracleTablePartitions2.createPartition(string);
                    tablePartition2.setID((DBObjectID)new NameBasedID((DBObject)tablePartition2, oracleTablePartitions2.getID()));
                    tablePartition2.setValues(resultSet.getString("HIGH_VALUE"));
                    OracleTablePartitionsBuilder.this.fillInPartitionTableProperties(tablePartition2, resultSet);
                    OracleTablePartitionsBuilder.this.fillInTablespace(tablePartition2, resultSet);
                }
            }
        };
        queryWrapper.executeQuery(queryRunnable);
        for (Map.Entry entry : identityHashMap.entrySet()) {
            ((TablePartition)entry.getKey()).setPartitionLevelSubpartitions((OracleTablePartitions)entry.getValue());
        }
    }

    private void fillInTablespace(TablePartition tablePartition, ResultSet resultSet) throws SQLException {
        String string = resultSet.getString("TABLESPACE_NAME");
        if (string != null && !resultSet.wasNull()) {
            OracleStorageProperties oracleStorageProperties = tablePartition.getSegmentAttributes();
            if (oracleStorageProperties == null) {
                oracleStorageProperties = (OracleStorageProperties)this.newObject(OracleStorageProperties.class, null);
                tablePartition.setSegmentAttributes(oracleStorageProperties);
            }
            oracleStorageProperties.setTablespaceID(OracleTablespaceUtil.getTablespaceID((DBObjectProvider)this.getDatabase(), string));
        }
    }

    private OracleStorageProperties getOrCreateStorage(LOBDescriptor lOBDescriptor) {
        OracleStorageProperties oracleStorageProperties = lOBDescriptor.getStorage();
        if (oracleStorageProperties == null) {
            oracleStorageProperties = (OracleStorageProperties)this.newObject(OracleStorageProperties.class, null);
            lOBDescriptor.setStorage(oracleStorageProperties);
        }
        return oracleStorageProperties;
    }

    private TablePartition findTablePartition(String string, OracleTablePartitions oracleTablePartitions) {
        TablePartition tablePartition = null;
        DatabaseDescriptor databaseDescriptor = this.getDatabase().getDescriptor();
        for (TablePartition tablePartition2 : oracleTablePartitions.getPartitions()) {
            if (!databaseDescriptor.areNamesEqual(tablePartition2.getName(), string, "PARTITION", false)) continue;
            tablePartition = tablePartition2;
            break;
        }
        return tablePartition;
    }

    private String getTablePartitionsQuery(Table table) {
        int n;
        String string = Table.TableType.INDEX_ORGANIZED == table.getProperty("TableType") ? "select /*OracleDictionaryQueries.ALL_INDEX_PARTITIONS_QUERY*/\n       TABLESPACE_NAME, PCT_FREE, null PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENT min_extents, MAX_EXTENT max_extents,\n       PCT_INCREASE, FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL,\n       COMPRESSION, PARTITION_NAME, HIGH_VALUE, PARAMETERS\nfrom   sys.all_ind_partitions aip\nwhere  aip.index_owner = ?\nand    aip.index_name  = ?\norder by aip.partition_position" : ((n = this.getDatabase().getDatabaseVersion()) >= 1210 ? "select /*OracleDictionaryQueries.ALL_TABLE_PARTITIONS_12c102_QUERY*/\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, min_extent MIN_EXTENTS, max_extent MAX_EXTENTS,\n       PCT_INCREASE, FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL,\n       PARTITION_NAME, HIGH_VALUE, COMPRESSION, COMPRESS_FOR, INMEMORY, \n       INMEMORY_COMPRESSION, INMEMORY_PRIORITY, INMEMORY_DISTRIBUTE, INMEMORY_DUPLICATE\nfrom   sys.all_tab_partitions atp\nwhere  atp.table_owner = ?\nand    atp.table_name  = ?\norder by atp.partition_position" : (n >= 110 ? "select /*OracleDictionaryQueries.ALL_TABLE_PARTITIONS_11g_QUERY*/\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, min_extent MIN_EXTENTS, max_extent MAX_EXTENTS,\n       PCT_INCREASE, FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL,\n       PARTITION_NAME, HIGH_VALUE, COMPRESSION, COMPRESS_FOR \nfrom   sys.all_tab_partitions atp\nwhere  atp.table_owner = ?\nand    atp.table_name  = ?\norder by atp.partition_position" : "select /*OracleDictionaryQueries.ALL_TABLE_PARTITIONS_QUERY*/\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, min_extent MIN_EXTENTS, max_extent MAX_EXTENTS,\n       PCT_INCREASE, FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL,\n       PARTITION_NAME, HIGH_VALUE\nfrom   sys.all_tab_partitions atp\nwhere  atp.table_owner = ?\nand    atp.table_name  = ?\norder by atp.partition_position"));
        return string;
    }

    private String getTablePartitionLevelSubpartitionsQuery() {
        int n = this.getDatabase().getDatabaseVersion();
        String string = n >= 1210 ? "select /*OracleDictionaryQueries.ALL_TABLE_PARTITION_LEVEL_SUBPARTITIONS_12C102_QUERY*/\n       PARTITION_NAME, SUBPARTITION_NAME, TABLESPACE_NAME, HIGH_VALUE, \n       COMPRESSION, COMPRESS_FOR, INMEMORY, INMEMORY_COMPRESSION, INMEMORY_PRIORITY, \n       INMEMORY_DUPLICATE, INMEMORY_DISTRIBUTE \nfrom   SYS.ALL_TAB_SUBPARTITIONS\nwhere  TABLE_OWNER = ?\nand    TABLE_NAME  = ?\norder by PARTITION_NAME, SUBPARTITION_POSITION" : (n >= 110 ? "select /*OracleDictionaryQueries.ALL_TABLE_PARTITION_LEVEL_SUBPARTITIONS_11g_QUERY*/\n       PARTITION_NAME, SUBPARTITION_NAME, TABLESPACE_NAME, HIGH_VALUE, \n       COMPRESSION, COMPRESS_FOR \nfrom   SYS.ALL_TAB_SUBPARTITIONS\nwhere  TABLE_OWNER = ?\nand    TABLE_NAME  = ?\norder by PARTITION_NAME, SUBPARTITION_POSITION" : "select /*OracleDictionaryQueries.ALL_TABLE_PARTITION_LEVEL_SUBPARTITIONS_QUERY*/\n       PARTITION_NAME, SUBPARTITION_NAME, TABLESPACE_NAME, HIGH_VALUE\nfrom   SYS.ALL_TAB_SUBPARTITIONS\nwhere  TABLE_OWNER = ?\nand    TABLE_NAME  = ?\norder by PARTITION_NAME, SUBPARTITION_POSITION");
        return string;
    }

    public class TablePartitionBuilder
    extends OracleDBObjectBuilder<TablePartition> {
        TablePartitionBuilder(BaseOracleDatabase baseOracleDatabase) {
            super(baseOracleDatabase, "PARTITION");
        }

        protected boolean canBuildComponents() {
            return true;
        }

        private OracleTablePartitions getOTP(DBObject dBObject) {
            DBObject dBObject2 = dBObject.getParent();
            return dBObject2 instanceof OracleTablePartitions ? (OracleTablePartitions)dBObject2 : null;
        }

        @AbstractDBObjectBuilder.PropertyBuilder(value={"LOBDescriptors"})
        public void fillInLOBDescriptors(TablePartition tablePartition) throws DBException {
            OracleTablePartitions oracleTablePartitions = this.getOTP((DBObject)tablePartition);
            if (oracleTablePartitions != null) {
                Table table;
                OracleTablePartitions.ObjectType objectType = oracleTablePartitions.getObjectType();
                String string = null;
                if (objectType == OracleTablePartitions.ObjectType.PARTITION) {
                    string = "select /*OracleDictionaryQueries.ALL_TABLE_LOB_PARTITIONS_QUERY*/\n       COLUMN_NAME, PARTITION_NAME NAME, LOB_PARTITION_NAME LOB_SEGMENT_NAME, CHUNK,\n       PCTVERSION, CACHE, IN_ROW, TABLESPACE_NAME, LOGGING, BUFFER_POOL,\n       decode(INITIAL_EXTENT, 'DEFAULT', null, INITIAL_EXTENT) INITIAL_EXTENT,\n       decode(NEXT_EXTENT, 'DEFAULT', null, NEXT_EXTENT) NEXT_EXTENT,\n       decode(MIN_EXTENTS, 'DEFAULT', null, MIN_EXTENTS) MIN_EXTENTS,\n       decode(MAX_EXTENTS, 'DEFAULT', null, MAX_EXTENTS) MAX_EXTENTS,\n       decode(PCT_INCREASE, 'DEFAULT', null, PCT_INCREASE) PCT_INCREASE,\n       decode(FREELISTS, 'DEFAULT', null, FREELISTS) FREELISTS,\n       decode(FREELIST_GROUPS, 'DEFAULT', null, FREELIST_GROUPS) FREELIST_GROUPS\nfrom   SYS.ALL_LOB_PARTITIONS\nwhere  TABLE_OWNER = ?\nand    TABLE_NAME  = ?\norder by PARTITION_POSITION, COLUMN_NAME";
                } else if (objectType == OracleTablePartitions.ObjectType.SUBPARTITION) {
                    string = "select /*OracleDictionaryQueries.ALL_TABLE_LOB_TEMPLATES_QUERY*/\n       distinct SUBPARTITION_NAME NAME, LOB_SEGMENT_NAME, TABLESPACE_NAME, LOB_COL_NAME COLUMN_NAME\nfrom   SYS.ALL_LOB_TEMPLATES\nwhere  /**/USER_NAME  = ?\nand    TABLE_NAME = ?\norder by SUBPARTITION_NAME";
                } else if (objectType == OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION) {
                    string = "select /*OracleDictionaryQueries.ALL_TABLE_LOB_SUBPARTITIONS_QUERY*/\n       COLUMN_NAME, SUBPARTITION_NAME NAME, LOB_PARTITION_NAME LOB_SEGMENT_NAME, CHUNK,\n       PCTVERSION, CACHE, IN_ROW, TABLESPACE_NAME, LOGGING, BUFFER_POOL,\n       decode(INITIAL_EXTENT, 'DEFAULT', null, INITIAL_EXTENT) INITIAL_EXTENT,\n       decode(NEXT_EXTENT, 'DEFAULT', null, NEXT_EXTENT) NEXT_EXTENT,\n       decode(MIN_EXTENTS, 'DEFAULT', null, MIN_EXTENTS) MIN_EXTENTS,\n       decode(MAX_EXTENTS, 'DEFAULT', null, MAX_EXTENTS) MAX_EXTENTS,\n       decode(PCT_INCREASE, 'DEFAULT', null, PCT_INCREASE) PCT_INCREASE,\n       decode(FREELISTS, 'DEFAULT', null, FREELISTS) FREELISTS,\n       decode(FREELIST_GROUPS, 'DEFAULT', null, FREELIST_GROUPS) FREELIST_GROUPS\nfrom   SYS.ALL_LOB_SUBPARTITIONS\nwhere  TABLE_OWNER = ?\nand    TABLE_NAME  = ?\norder by SUBPARTITION_POSITION, COLUMN_NAME";
                }
                if (string != null && (table = OracleTablePartitionsBuilder.this.getTable((DBObject)oracleTablePartitions)) != null) {
                    boolean bl = false;
                    for (Column column : table.getColumns()) {
                        if (!LOBDescriptor.isLOBColumn((Column)column)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) {
                        OracleTablePartitionsBuilder.this.fillInPartitionLOBs(table, oracleTablePartitions, string);
                    }
                }
            }
        }

        @AbstractDBObjectBuilder.PropertyBuilder(value={"partitionLevelSubpartitions"})
        public void fillInSubpartitions(TablePartition tablePartition) throws DBException {
            Table table;
            OracleTablePartitions oracleTablePartitions;
            OracleTablePartitions oracleTablePartitions2;
            OracleTablePartitions.PartitionType partitionType;
            if (tablePartition.getObjectType() == OracleTablePartitions.ObjectType.PARTITION && ((partitionType = tablePartition.getPartitionType()) == OracleTablePartitions.PartitionType.RANGE || partitionType == OracleTablePartitions.PartitionType.LIST) && (oracleTablePartitions2 = this.getOTP((DBObject)tablePartition)) != null && (oracleTablePartitions = oracleTablePartitions2.getSubpartitionModel()) != null && (table = OracleTablePartitionsBuilder.this.getTable((DBObject)oracleTablePartitions2)) != null) {
                OracleTablePartitionsBuilder.this.fillInPartitionLevelSubpartitions(table, oracleTablePartitions2, oracleTablePartitions.getPartitionType());
            }
        }
    }
}

