/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnSequenceProcessor;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.OracleColumnProperties;
import oracle.javatools.db.ora.OracleColumnPropertiesBuilder;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleDictionaryQueries;
import oracle.javatools.db.ora.OracleExternalTableProperties;
import oracle.javatools.db.ora.OracleInMemoryColumnProperties;
import oracle.javatools.db.ora.OracleInMemoryProperties;
import oracle.javatools.db.ora.OracleIndexBuilder;
import oracle.javatools.db.ora.OracleIndexOrganizedTableProperties;
import oracle.javatools.db.ora.OracleRelationBuilder;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleStoragePropertiesBuilder;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.OracleTablePartitionsBuilder;
import oracle.javatools.db.ora.OracleTableProperties;
import oracle.javatools.db.ora.OracleTablespaceProperties;
import oracle.javatools.db.ora.OracleTablespaceUtil;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

public class OracleTableBuilder<T extends Table>
extends OracleRelationBuilder<T> {
    public static final BigInteger MAXEXTENTS_UNLIMITED = BigInteger.valueOf(0x7FFFFFFDL);
    private static final String ENABLED = "ENABLED";
    private static final String DIRECT_LOAD_OPERATIONS = "DIRECT LOAD ONLY";
    private static final String ALL_OPERATIONS = "FOR ALL OPERATIONS";
    private static final String OLTP = "OLTP";
    private static final String BASIC = "BASIC";
    private static final String ADVANCED = "ADVANCED";
    private static final String QUERY_LOW = "QUERY LOW";
    private static final String QUERY_HIGH = "QUERY HIGH";
    private static final String ARCHIVE_LOW = "ARCHIVE LOW";
    private static final String ARCHIVE_HIGH = "ARCHIVE HIGH";
    private static final String ROW_LEVEL_LOCKING = "ROW LEVEL LOCKING";
    private static final String QUERY_LOW_ROW_LEVEL_LOCKING = "QUERY LOW ROW LEVEL LOCKING";
    private static final String QUERY_HIGH_ROW_LEVEL_LOCKING = "QUERY HIGH ROW LEVEL LOCKING";
    private static final String ARCHIVE_LOW_ROW_LEVEL_LOCKING = "ARCHIVE LOW ROW LEVEL LOCKING";
    private static final String ARCHIVE_HIGH_ROW_LEVEL_LOCKING = "ARCHIVE HIGH ROW LEVEL LOCKING";

    protected OracleTableBuilder(BaseOracleDatabase baseOracleDatabase) {
        this(baseOracleDatabase, "TABLE");
    }

    protected OracleTableBuilder(BaseOracleDatabase baseOracleDatabase, String string) {
        super(baseOracleDatabase, string);
    }

    protected boolean canBuildComponents() {
        return true;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"indexes"}, depends={"TableType", "constraints"})
    public void fillInIndexes(T t) throws DBException {
        OracleIndexBuilder oracleIndexBuilder = (OracleIndexBuilder)this.getDatabase().getBuilderForType("INDEX");
        oracleIndexBuilder.fillInIndexes((Table)t);
        this.updateTimestamp((AbstractBuildableObject)t, true);
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"TableType", "NESTED TABLE", "OBJECT TABLE", "PARTITIONED TABLE"})
    public void fillInTableType(T t) throws DBException {
        String string = this.getTableTypeQuery();
        if (string == null) {
            t.setProperty("TableType", (Object)Table.TableType.NORMAL);
            t.setProperty("NESTED TABLE", null);
            t.setProperty("PARTITIONED TABLE", null);
            t.setProperty("OBJECT TABLE", null);
        } else {
            final Holder holder = new Holder((Object)true);
            QueryWrapper queryWrapper = this.getDatabase().newQueryWrapper((SystemObject)t, string, t.getSchema(), t);
            queryWrapper.executeQuery(new QueryWrapper.QueryRunnable((Table)t, queryWrapper){
                final /* synthetic */ Table val$table;
                final /* synthetic */ QueryWrapper val$wrap;
                {
                    this.val$table = table;
                    this.val$wrap = queryWrapper;
                }

                public void processResultSet(ResultSet resultSet) throws DBException {
                    try {
                        if (resultSet.next()) {
                            holder.set((Object)false);
                            this.val$table.setProperty("OBJECT TABLE", null);
                            OracleTableBuilder.this.setTableType(this.val$table, resultSet);
                        }
                    }
                    catch (SQLException sQLException) {
                        this.val$wrap.throwDBException((DBObject)this.val$table, sQLException);
                    }
                }
            });
            if (((Boolean)holder.get()).booleanValue()) {
                QueryWrapper queryWrapper2 = this.getDatabase().newQueryWrapper((SystemObject)t, this.convertToObjectQuery(string), t.getSchema(), t);
                queryWrapper2.executeQuery(new QueryWrapper.QueryRunnable((Table)t, queryWrapper){
                    final /* synthetic */ Table val$table;
                    final /* synthetic */ QueryWrapper val$wrap;
                    {
                        this.val$table = table;
                        this.val$wrap = queryWrapper;
                    }

                    public void processResultSet(ResultSet resultSet) throws DBException {
                        try {
                            if (resultSet.next()) {
                                this.val$table.setProperty("OBJECT TABLE", (Object)Boolean.TRUE);
                                OracleTableBuilder.this.setTableType(this.val$table, resultSet);
                            }
                        }
                        catch (SQLException sQLException) {
                            this.val$wrap.throwDBException((DBObject)this.val$table, sQLException);
                        }
                    }
                });
            }
        }
    }

    private void setTableType(Table table, ResultSet resultSet) throws SQLException {
        boolean bl = "YES".equals(resultSet.getString(5));
        boolean bl2 = "YES".equals(resultSet.getString(4));
        Table.TableType tableType = Table.TableType.NORMAL;
        if ("IOT".equals(resultSet.getString(3))) {
            tableType = Table.TableType.INDEX_ORGANIZED;
        } else if ("Y".equals(resultSet.getString(1))) {
            String string = resultSet.getString(2);
            if ("SYS$SESSION".equals(string)) {
                tableType = Table.TableType.SESSION_TEMP;
            } else if ("SYS$TRANSACTION".equals(string)) {
                tableType = Table.TableType.TRANSACTION_TEMP;
            }
        } else if (!bl && "1".equals(resultSet.getString(6))) {
            tableType = Table.TableType.EXTERNAL;
        } else if ("Y".equals(resultSet.getString(7))) {
            tableType = Table.TableType.SHARDED;
        } else if ("Y".equals(resultSet.getString(8))) {
            tableType = Table.TableType.DUPLICATED;
        }
        table.setProperty("TableType", (Object)tableType);
        table.setProperty("NESTED TABLE", (Object)(bl ? Boolean.TRUE : null));
        table.setProperty("PARTITIONED TABLE", (Object)(bl2 ? Boolean.TRUE : null));
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"OracleStorageProperties", "OracleExternalTableProperties", "OracleTableProperties", "OracleInMemoryProperties"}, depends={"TableType", "OBJECT TABLE", "NESTED TABLE", "PARTITIONED TABLE"})
    public void fillInBaseProperties(T t) throws DBException {
        boolean bl = Boolean.TRUE.equals(t.getProperty("OBJECT TABLE"));
        String string = this.getTableQuery();
        if (bl) {
            string = this.convertToObjectQuery(string);
        }
        QueryWrapper queryWrapper = this.getDatabase().newQueryWrapper((SystemObject)t, string, t.getSchema(), t);
        queryWrapper.executeQuery(new QueryWrapper.QueryRunnable((Table)t, queryWrapper){
            final /* synthetic */ Table val$table;
            final /* synthetic */ QueryWrapper val$wrap;
            {
                this.val$table = table;
                this.val$wrap = queryWrapper;
            }

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    if (resultSet.next()) {
                        OracleTableBuilder.this.setBasePropertiesFromRS(this.val$table, resultSet);
                    }
                }
                catch (SQLException sQLException) {
                    this.val$wrap.throwDBException((DBObject)this.val$table, sQLException);
                }
            }
        });
    }

    protected void setBasePropertiesFromRS(T t, ResultSet resultSet) throws SQLException, DBException {
        OracleTableProperties oracleTableProperties;
        boolean bl = Boolean.TRUE.equals(t.getProperty("PARTITIONED TABLE"));
        Table.TableType tableType = (Table.TableType)t.getProperty("TableType");
        BaseOracleDatabase baseOracleDatabase = this.getDatabase();
        String string = null;
        if (baseOracleDatabase.getDatabaseVersion() >= 1220) {
            string = resultSet.getString("TABLESPACE_SET_NAME");
        }
        if ((oracleTableProperties = OracleTableBuilder.getOracleTableProperties(t, resultSet.getString(15), resultSet.getString(16), resultSet.getString(17), string, baseOracleDatabase)).getParallelDegree() != null || oracleTableProperties.getTableCompression() != null) {
            t.setProperty("OracleTableProperties", (Object)oracleTableProperties);
        }
        if (tableType == Table.TableType.INDEX_ORGANIZED) {
            if (bl) {
                t.setProperty("OracleStorageProperties", (Object)this.getSegmentAttributeProperties("select /*OracleDictionaryQueries.ALL_PARTITIONED_IOT_DEFAULT_STORAGE_PROPERTIES_QUERY*/\n       def_tablespace_name TABLESPACE_NAME,\n       def_pct_free PCT_FREE, null PCT_USED,\n       def_ini_trans INI_TRANS, def_max_trans MAX_TRANS,\n       decode(def_initial_extent, 'DEFAULT', null, def_initial_extent) INITIAL_EXTENT,\n       decode(def_next_extent, 'DEFAULT', null, def_next_extent) NEXT_EXTENT,\n       decode(def_min_extents, 'DEFAULT', null, def_min_extents) MIN_EXTENTS,\n       decode(def_max_extents, 'DEFAULT', null, def_max_extents) MAX_EXTENTS,\n       decode(def_pct_increase, 'DEFAULT', null, def_pct_increase) PCT_INCREASE,\n       decode(def_freelists, 0, null, def_freelists) FREELISTS,\n       decode(def_freelist_groups, 0, null, def_freelist_groups) FREELIST_GROUPS,\n       decode(def_logging, 'NONE', null, def_logging) LOGGING,\n       def_buffer_pool BUFFER_POOL\nfrom   sys.all_part_indexes\nwhere  owner = ?\nand    index_name = ?\n", t, OracleTableBuilder.getQueryObject(t).getName()));
            } else {
                t.setProperty("OracleStorageProperties", (Object)this.getSegmentAttributeProperties(OracleDictionaryQueries.TABLE_IOT_STORAGE_PROPERTIES_QUERY, t, t.getName()));
            }
        } else if (tableType == Table.TableType.EXTERNAL) {
            t.setProperty("OracleExternalTableProperties", (Object)this.getExternalTableProperties(t));
        } else if (bl) {
            t.setProperty("OracleStorageProperties", (Object)this.getSegmentAttributeProperties("select /*OracleDictionaryQueries.ALL_PARTITIONED_TABLE_DEFAULT_STORAGE_PROPERTIES_QUERY*/\n       def_tablespace_name TABLESPACE_NAME,\n       def_pct_free PCT_FREE, def_pct_used PCT_USED,\n       def_ini_trans INI_TRANS, def_max_trans MAX_TRANS,\n       decode(def_initial_extent, 'DEFAULT', null, def_initial_extent) INITIAL_EXTENT,\n       decode(def_next_extent, 'DEFAULT', null, def_next_extent) NEXT_EXTENT,\n       decode(def_min_extents, 'DEFAULT', null, def_min_extents) MIN_EXTENTS,\n       decode(def_max_extents, 'DEFAULT', null, def_max_extents) MAX_EXTENTS,\n       decode(def_pct_increase, 'DEFAULT', null, def_pct_increase) PCT_INCREASE,\n       decode(def_freelists, 0, null, def_freelists) FREELISTS,\n       decode(def_freelist_groups, 0, null, def_freelist_groups) FREELIST_GROUPS,\n       decode(def_logging, 'NONE', null, def_logging) LOGGING,\n       def_buffer_pool BUFFER_POOL\nfrom   sys.all_part_tables\nwhere  owner = ?\nand    table_name = ?\n", t, t.getName()));
        } else {
            t.setProperty("OracleStorageProperties", (Object)OracleTableBuilder.getSegmentAttributeProperties(resultSet, baseOracleDatabase));
        }
        OracleTableBuilder.fillInMemoryProperties(t, resultSet, baseOracleDatabase);
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"OracleInMemoryColumnProperties"}, depends={"columns", "OracleInMemoryProperties"})
    public void buildInMemoryColumnProperties(T t) throws DBException {
        Object object;
        boolean bl = false;
        BaseOracleDatabase baseOracleDatabase = this.getDatabase();
        if (baseOracleDatabase.getDatabaseVersion() >= 1210) {
            object = (OracleInMemoryProperties)t.getProperty("OracleInMemoryProperties");
            boolean bl2 = bl = object == null || object.isInMemory();
        }
        if (bl) {
            object = new HashMap();
            QueryWrapper queryWrapper = baseOracleDatabase.newQueryWrapper((SystemObject)t, "SELECT /**OracleDictionaryQueries.TABLE_IM_SELECTIVE_COLUMNS_QUERY*/\n COLUMN_NAME, INMEMORY_COMPRESSION \nFROM V$IM_COLUMN_LEVEL \nWHERE OWNER = ? AND TABLE_NAME = ?", DBUtil.getSchema(t), t);
            try {
                queryWrapper.executeQuery(new QueryWrapper.QueryRunnable((Map)object){
                    final /* synthetic */ Map val$map;
                    {
                        this.val$map = map;
                    }

                    public void processResultSet(ResultSet resultSet) throws DBException, SQLException {
                        while (resultSet.next()) {
                            String string = resultSet.getString("INMEMORY_COMPRESSION");
                            if (resultSet.wasNull() || string == null || "DEFAULT".equals(string)) continue;
                            String string2 = resultSet.getString("COLUMN_NAME");
                            if (resultSet.wasNull()) continue;
                            this.val$map.put(string2, string);
                        }
                    }
                });
            }
            catch (DBException dBException) {
                Column[] columnArray = dBException.getCause();
                if (columnArray instanceof SQLException && ((SQLException)columnArray).getErrorCode() == 942) {
                    this.getLogger().fine("Could not build inMemoryColumnProperties");
                }
                throw dBException;
            }
            if (!object.isEmpty()) {
                ArrayList<OracleInMemoryColumnProperties> arrayList = new ArrayList<OracleInMemoryColumnProperties>();
                for (Column column : t.getColumns()) {
                    String string = column.getName();
                    String string2 = (String)object.get(string);
                    if (string2 == null) continue;
                    OracleInMemoryColumnProperties oracleInMemoryColumnProperties = (OracleInMemoryColumnProperties)this.newObject(OracleInMemoryColumnProperties.class, null);
                    if (string2.equals("NO INMEMORY")) {
                        oracleInMemoryColumnProperties.setInMemory(false);
                    } else {
                        oracleInMemoryColumnProperties.setInMemoryCompression((OracleInMemoryProperties.InMemoryCompression)DBUtil.findEnumFromString((String)string2, OracleInMemoryProperties.InMemoryCompression.class));
                    }
                    oracleInMemoryColumnProperties.setColumnIDs(new DBObjectID[]{column.getID()});
                    oracleInMemoryColumnProperties.setID((DBObjectID)new NameBasedID("OracleInMemoryColumnProperties", string, t.getID()));
                    arrayList.add(oracleInMemoryColumnProperties);
                }
                t.setProperty("OracleInMemoryColumnProperties", (Object)arrayList.toArray(new OracleInMemoryColumnProperties[arrayList.size()]));
            }
        }
    }

    static OracleStorageProperties getStorageProperties(ResultSet resultSet) throws SQLException {
        OracleStorageProperties oracleStorageProperties = new OracleStorageProperties();
        OracleTableBuilder.populateStorageProperties(oracleStorageProperties, resultSet);
        return oracleStorageProperties;
    }

    static void populateStorageProperties(OracleStorageProperties oracleStorageProperties, ResultSet resultSet) throws SQLException {
        BigInteger bigInteger;
        BigDecimal bigDecimal = resultSet.getBigDecimal("INITIAL_EXTENT");
        oracleStorageProperties.setInitialExtent(resultSet.wasNull() ? null : bigDecimal.toBigInteger());
        BigDecimal bigDecimal2 = resultSet.getBigDecimal("NEXT_EXTENT");
        oracleStorageProperties.setNextExtent(resultSet.wasNull() ? null : bigDecimal2.toBigInteger());
        BigDecimal bigDecimal3 = resultSet.getBigDecimal("MIN_EXTENTS");
        oracleStorageProperties.setMinExtent(resultSet.wasNull() ? null : bigDecimal3.toBigInteger());
        BigDecimal bigDecimal4 = resultSet.getBigDecimal("MAX_EXTENTS");
        BigInteger bigInteger2 = bigInteger = resultSet.wasNull() ? null : bigDecimal4.toBigInteger();
        if (bigInteger != null && bigInteger.equals(MAXEXTENTS_UNLIMITED)) {
            bigInteger = BigInteger.ZERO;
        }
        oracleStorageProperties.setMaxExtent(bigInteger);
        int n = resultSet.getInt("PCT_INCREASE");
        oracleStorageProperties.setPercentIncrease(resultSet.wasNull() ? null : Integer.valueOf(n));
        int n2 = resultSet.getInt("FREELISTS");
        oracleStorageProperties.setFreelists(resultSet.wasNull() ? null : Integer.valueOf(n2));
        int n3 = resultSet.getInt("FREELIST_GROUPS");
        oracleStorageProperties.setFreelistGroups(resultSet.wasNull() ? null : Integer.valueOf(n3));
        String string = resultSet.getString("BUFFER_POOL");
        oracleStorageProperties.setBufferMode(ModelUtil.hasLength((String)string) ? OracleStorageProperties.BufferModes.valueOf((String)string) : null);
    }

    private OracleStorageProperties getSegmentAttributeProperties(String string, T t, String string2) throws DBException {
        OracleStorageProperties oracleStorageProperties = new OracleStorageProperties();
        OracleStoragePropertiesBuilder oracleStoragePropertiesBuilder = new OracleStoragePropertiesBuilder(this.getDatabase(), string, t.getSchema(), string2);
        this.getDatabase().setOracleBuilder(oracleStorageProperties, oracleStoragePropertiesBuilder);
        return oracleStorageProperties;
    }

    public static OracleStorageProperties getSegmentAttributeProperties(ResultSet resultSet, BaseOracleDatabase baseOracleDatabase) throws SQLException {
        OracleStorageProperties oracleStorageProperties = new OracleStorageProperties();
        OracleTableBuilder.populateSegmentAttributes(oracleStorageProperties, resultSet, baseOracleDatabase);
        return oracleStorageProperties;
    }

    static void populateSegmentAttributes(OracleStorageProperties oracleStorageProperties, ResultSet resultSet, BaseOracleDatabase baseOracleDatabase) throws SQLException {
        String string;
        OracleTableBuilder.populateStorageProperties(oracleStorageProperties, resultSet);
        int n = resultSet.getInt("PCT_FREE");
        oracleStorageProperties.setPercentFree(resultSet.wasNull() ? null : Integer.valueOf(n));
        int n2 = resultSet.getInt("PCT_USED");
        oracleStorageProperties.setPercentUsed(resultSet.wasNull() ? null : Integer.valueOf(n2));
        int n3 = resultSet.getInt("INI_TRANS");
        oracleStorageProperties.setInitrans(resultSet.wasNull() || n3 == 0 ? null : Integer.valueOf(n3));
        if (baseOracleDatabase.getDatabaseVersion() == 92) {
            int n4 = resultSet.getInt("MAX_TRANS");
            oracleStorageProperties.setInitrans(resultSet.wasNull() || n4 == 0 ? null : Integer.valueOf(n4));
        }
        if (ModelUtil.hasLength((String)(string = resultSet.getString("TABLESPACE_NAME")))) {
            oracleStorageProperties.setTablespaceID(OracleTablespaceUtil.getTablespaceID((DBObjectProvider)baseOracleDatabase, string));
        }
        OracleTableBuilder.setLogging(resultSet, oracleStorageProperties);
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"OracleIndexOrganizedTableProperties"}, depends={"columns", "constraints", "TableType"})
    public void fillInIOTProperties(T t) throws DBException {
        if (t.getProperty("TableType") == Table.TableType.INDEX_ORGANIZED) {
            t.setProperty("OracleIndexOrganizedTableProperties", (Object)this.getIotProperties(t));
        }
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"OracleTablePartitions"}, depends={"columns", "constraints", "TableType", "PARTITIONED TABLE"})
    public void fillInTablePartitions(T t) throws DBException {
        boolean bl = t.getProperty("TableType") == Table.TableType.EXTERNAL;
        boolean bl2 = Boolean.TRUE.equals(t.getProperty("PARTITIONED TABLE"));
        if (bl2 && !bl) {
            t.setProperty("OracleTablePartitions", (Object)this.getOracleTablePartitions(t));
        }
    }

    @Override
    protected void setupOracleColumnProperties(T t, Column column, DataType dataType) {
        BaseOracleDatabase baseOracleDatabase = this.getDatabase();
        if (dataType == null || OracleColumnPropertiesBuilder.needColumnProperties(baseOracleDatabase, t, column, dataType)) {
            OracleColumnProperties oracleColumnProperties = (OracleColumnProperties)this.newObject(OracleColumnProperties.class, null);
            OracleColumnPropertiesBuilder oracleColumnPropertiesBuilder = new OracleColumnPropertiesBuilder(baseOracleDatabase);
            baseOracleDatabase.setOracleBuilder(oracleColumnProperties, oracleColumnPropertiesBuilder);
            column.setProperty("OracleColumnProperties", (Object)oracleColumnProperties);
            oracleColumnProperties.setID((DBObjectID)new NameBasedID((DBObject)oracleColumnProperties, column.getID()));
        }
    }

    protected OracleTablePartitions getOracleTablePartitions(T t) throws DBException {
        final Holder holder = new Holder();
        ArrayList arrayList = new ArrayList();
        final BaseOracleDatabase baseOracleDatabase = this.getDatabase();
        QueryWrapper queryWrapper = baseOracleDatabase.newQueryWrapper((SystemObject)t, OracleTableBuilder.getTablePartitionsTypeQuery(this.getDatabase()), t.getSchema(), t);
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable((Table)t, arrayList){
            final /* synthetic */ Table val$table;
            final /* synthetic */ List val$colIDs;
            {
                this.val$table = table;
                this.val$colIDs = list;
            }

            public void processResultSet(ResultSet resultSet) throws DBException, SQLException {
                while (resultSet.next()) {
                    Object object;
                    OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)holder.get();
                    OracleTablePartitions.PartitionType partitionType = null;
                    OracleTablePartitions.PartitionType partitionType2 = null;
                    if (oracleTablePartitions == null) {
                        partitionType = OracleTableBuilder.this.getPartitionType(resultSet.getString(1));
                        partitionType2 = OracleTableBuilder.this.getPartitionType(resultSet.getString(2));
                        if (partitionType != null) {
                            object = new OracleTablePartitionsBuilder(baseOracleDatabase);
                            oracleTablePartitions = new OracleTablePartitions(partitionType, OracleTablePartitions.ObjectType.PARTITION);
                            baseOracleDatabase.setOracleBuilder(oracleTablePartitions, object);
                            holder.set((Object)oracleTablePartitions);
                            NameBasedID nameBasedID = new NameBasedID((DBObject)oracleTablePartitions, this.val$table.getID());
                            oracleTablePartitions.setID((DBObjectID)nameBasedID);
                            if (partitionType2 != null && (OracleTablePartitions.PartitionType.HASH == partitionType2 || OracleTablePartitions.PartitionType.LIST == partitionType2 || OracleTablePartitions.PartitionType.RANGE == partitionType2)) {
                                OracleTablePartitions oracleTablePartitions2 = new OracleTablePartitions(partitionType2, OracleTablePartitions.ObjectType.SUBPARTITION);
                                oracleTablePartitions2.setID((DBObjectID)new NameBasedID((DBObject)oracleTablePartitions2, (DBObjectID)nameBasedID));
                                oracleTablePartitions.setSubpartitionModel(oracleTablePartitions2);
                                baseOracleDatabase.setOracleBuilder(oracleTablePartitions2, object);
                            }
                        }
                    }
                    if (oracleTablePartitions == null) continue;
                    if (OracleTablePartitions.PartitionType.REFERENCE == partitionType) {
                        object = (FKConstraint)this.val$table.getConstraint(resultSet.getString(4));
                        if (object == null) continue;
                        oracleTablePartitions.setReferenceConstraintID(object.getID());
                        continue;
                    }
                    object = this.val$table.getColumn(resultSet.getString(3));
                    if (object == null) continue;
                    this.val$colIDs.add(object.getID());
                }
            }
        };
        queryWrapper.executeQuery(queryRunnable);
        OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)holder.get();
        if (!arrayList.isEmpty()) {
            oracleTablePartitions.setPartitionColumns(arrayList.toArray(new DBObjectID[arrayList.size()]));
        }
        return oracleTablePartitions;
    }

    private OracleIndexOrganizedTableProperties getIotProperties(T t) throws DBException {
        OracleIndexOrganizedTableProperties oracleIndexOrganizedTableProperties = new OracleIndexOrganizedTableProperties();
        oracleIndexOrganizedTableProperties.setID((DBObjectID)new NameBasedID((DBObject)oracleIndexOrganizedTableProperties, t.getID()));
        this.populateIotPropsFromAllIndexes(t, oracleIndexOrganizedTableProperties);
        this.populateIotPropsFromAllTables(t, oracleIndexOrganizedTableProperties);
        return oracleIndexOrganizedTableProperties;
    }

    private void populateIotPropsFromAllIndexes(T t, final OracleIndexOrganizedTableProperties oracleIndexOrganizedTableProperties) throws DBException {
        QueryWrapper queryWrapper = this.getDatabase().newQueryWrapper((SystemObject)t, OracleDictionaryQueries.TABLE_IOT_INDEX_QUERY, t.getSchema(), OracleTableBuilder.getQueryObject(t));
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable((Table)t, queryWrapper){
            final /* synthetic */ Table val$table;
            final /* synthetic */ QueryWrapper val$wrap;
            {
                this.val$table = table;
                this.val$wrap = queryWrapper;
            }

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    if (resultSet.next()) {
                        int n = resultSet.getInt(1);
                        oracleIndexOrganizedTableProperties.setPctThreshold(resultSet.wasNull() ? null : Integer.valueOf(n));
                        int n2 = resultSet.getInt(2);
                        oracleIndexOrganizedTableProperties.setKeyCompression(resultSet.wasNull() ? null : Integer.valueOf(n2));
                        int n3 = resultSet.getInt(3);
                        Column column = null;
                        if (!resultSet.wasNull()) {
                            Column[] columnArray = this.val$table.getColumns();
                            Column column2 = column = n3 > 0 && n3 <= columnArray.length ? columnArray[n3 - 1] : null;
                        }
                        if (column != null) {
                            oracleIndexOrganizedTableProperties.setIncludeColumn(column.getID());
                        }
                    }
                }
                catch (SQLException sQLException) {
                    this.val$wrap.throwDBException(sQLException);
                }
            }
        };
        queryWrapper.executeQuery(queryRunnable);
    }

    private void populateIotPropsFromAllTables(T t, final OracleIndexOrganizedTableProperties oracleIndexOrganizedTableProperties) throws DBException {
        QueryWrapper queryWrapper = this.getDatabase().newQueryWrapper((SystemObject)t, OracleDictionaryQueries.TABLE_IOT_MAPPING_AND_OVERFLOW_QUERY, t.getSchema(), t);
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable((Table)t, queryWrapper){
            final /* synthetic */ Table val$table;
            final /* synthetic */ QueryWrapper val$wrap;
            {
                this.val$table = table;
                this.val$wrap = queryWrapper;
            }

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        if (resultSet.getString("IOT_TYPE").equals("IOT_OVERFLOW")) {
                            oracleIndexOrganizedTableProperties.setOverflowable(true);
                            if (Boolean.TRUE.equals(this.val$table.getProperty("PARTITIONED TABLE"))) {
                                String string = resultSet.getString("TABLE_NAME");
                                oracleIndexOrganizedTableProperties.setOverflowProperties(OracleTableBuilder.this.getSegmentAttributeProperties("select /*OracleDictionaryQueries.ALL_PARTITIONED_TABLE_DEFAULT_STORAGE_PROPERTIES_QUERY*/\n       def_tablespace_name TABLESPACE_NAME,\n       def_pct_free PCT_FREE, def_pct_used PCT_USED,\n       def_ini_trans INI_TRANS, def_max_trans MAX_TRANS,\n       decode(def_initial_extent, 'DEFAULT', null, def_initial_extent) INITIAL_EXTENT,\n       decode(def_next_extent, 'DEFAULT', null, def_next_extent) NEXT_EXTENT,\n       decode(def_min_extents, 'DEFAULT', null, def_min_extents) MIN_EXTENTS,\n       decode(def_max_extents, 'DEFAULT', null, def_max_extents) MAX_EXTENTS,\n       decode(def_pct_increase, 'DEFAULT', null, def_pct_increase) PCT_INCREASE,\n       decode(def_freelists, 0, null, def_freelists) FREELISTS,\n       decode(def_freelist_groups, 0, null, def_freelist_groups) FREELIST_GROUPS,\n       decode(def_logging, 'NONE', null, def_logging) LOGGING,\n       def_buffer_pool BUFFER_POOL\nfrom   sys.all_part_tables\nwhere  owner = ?\nand    table_name = ?\n", this.val$table, string));
                                continue;
                            }
                            oracleIndexOrganizedTableProperties.setOverflowProperties(OracleTableBuilder.getSegmentAttributeProperties(resultSet, OracleTableBuilder.this.getDatabase()));
                            continue;
                        }
                        oracleIndexOrganizedTableProperties.setMapped(true);
                    }
                }
                catch (SQLException sQLException) {
                    this.val$wrap.throwDBException((DBObject)this.val$table, sQLException);
                }
            }
        };
        queryWrapper.executeQuery(queryRunnable);
    }

    private OracleExternalTableProperties getExternalTableProperties(T t) throws DBException {
        final Holder holder = new Holder();
        BaseOracleDatabase baseOracleDatabase = this.getDatabase();
        String string = OracleTableBuilder.getExternalTableQuery(baseOracleDatabase);
        if (string != null) {
            final QueryWrapper queryWrapper = this.getDatabase().newQueryWrapper((SystemObject)t, string, t.getSchema(), t);
            QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable((Table)t){
                final /* synthetic */ Table val$table;
                {
                    this.val$table = table;
                }

                public void processResultSet(ResultSet resultSet) throws DBException {
                    block8: {
                        try {
                            String string;
                            if (!resultSet.next()) break block8;
                            OracleExternalTableProperties oracleExternalTableProperties = (OracleExternalTableProperties)OracleTableBuilder.this.newObject(OracleExternalTableProperties.class, null);
                            oracleExternalTableProperties.setAccessDriverType(resultSet.getString(1));
                            Integer n = null;
                            String string2 = resultSet.getString(2);
                            if ("UNLIMITED".equals(string2)) {
                                n = -1;
                            } else {
                                try {
                                    n = Integer.valueOf(string2);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    OracleTableBuilder.this.getLogger().severe("rejectLimit " + numberFormatException.getMessage());
                                }
                            }
                            oracleExternalTableProperties.setRejectLimit(n);
                            if (resultSet.getString(4) != null) {
                                oracleExternalTableProperties.setAccessParameters(resultSet.getString(4).trim());
                            }
                            if ((string = resultSet.getString(5)) != null && !string.equals("null")) {
                                oracleExternalTableProperties.setProjectColumn(OracleExternalTableProperties.ProjectColumn.valueOf((String)string));
                            }
                            oracleExternalTableProperties.setDefaultDirectory(OracleTableBuilder.this.getDirectory(resultSet.getString(6), resultSet.getString(7)));
                            holder.set((Object)oracleExternalTableProperties);
                        }
                        catch (SQLException sQLException) {
                            queryWrapper.throwDBException((DBObject)this.val$table, sQLException);
                        }
                    }
                }
            };
            queryWrapper.executeQuery(queryRunnable);
            OracleExternalTableProperties oracleExternalTableProperties = (OracleExternalTableProperties)holder.get();
            if (oracleExternalTableProperties != null) {
                this.populateLocAndDir(t, oracleExternalTableProperties);
            }
        }
        return (OracleExternalTableProperties)holder.get();
    }

    private void populateLocAndDir(T t, final OracleExternalTableProperties oracleExternalTableProperties) throws DBException {
        final QueryWrapper queryWrapper = this.getDatabase().newQueryWrapper((SystemObject)t, "select /*OracleDictionaryQueries.ALL_TABLE_EXT_LOCATIONS_QUERY*/\n       LOCATION, DIRECTORY_OWNER, DIRECTORY_NAME \nfrom   SYS.ALL_EXTERNAL_LOCATIONS \nwhere  OWNER = ?\nand    TABLE_NAME = ?\n", t.getSchema(), t);
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable((Table)t){
            final /* synthetic */ Table val$table;
            {
                this.val$table = table;
            }

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        oracleExternalTableProperties.addLocationSpecifier(OracleTableBuilder.this.getDirectory(resultSet.getString(2), resultSet.getString(3)), resultSet.getString(1));
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)this.val$table, sQLException);
                }
            }
        };
        queryWrapper.executeQuery(queryRunnable);
    }

    private DBObjectID getDirectory(String string, String string2) {
        if (ModelUtil.hasLength((String)string2)) {
            return new ReferenceID("DIRECTORY", string, string2);
        }
        return null;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"AUTO_GENERATED_SEQUENCE_TRIGGER"})
    public void fillInColumnSequenceColumns(T t) throws DBException {
        BaseOracleDatabase baseOracleDatabase = this.getDatabase();
        String string = this.getColSeqTriggerQuery(baseOracleDatabase);
        if (string != null) {
            final HashMap hashMap = new HashMap();
            final QueryWrapper queryWrapper = baseOracleDatabase.newQueryWrapper((SystemObject)t, string, t.getSchema(), t);
            QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet resultSet) throws DBException {
                    try {
                        while (resultSet.next()) {
                            String string = resultSet.getString(1);
                            String string2 = resultSet.getString(2);
                            StringBuilder stringBuilder = (StringBuilder)hashMap.get(string);
                            if (stringBuilder == null) {
                                stringBuilder = new StringBuilder();
                                hashMap.put(string, stringBuilder);
                            }
                            stringBuilder.append(string2);
                        }
                    }
                    catch (SQLException sQLException) {
                        queryWrapper.throwDBException(sQLException);
                    }
                }
            };
            queryWrapper.executeQuery(queryRunnable);
            for (Map.Entry entry : hashMap.entrySet()) {
                String string2 = (String)entry.getKey();
                String string3 = ((StringBuilder)entry.getValue()).toString();
                for (ColumnSequenceProcessor.ColumnInfo columnInfo : ColumnSequenceProcessor.getColumnInfos(string3, (DBObjectProvider)baseOracleDatabase)) {
                    Column column = t.getColumn(columnInfo.getColumnName());
                    if (column == null) continue;
                    Schema schema = null;
                    schema = columnInfo.getSequenceSchemaName() != null ? baseOracleDatabase.getSchema(columnInfo.getSequenceSchemaName()) : t.getSchema();
                    DBObjectID dBObjectID = this.getColSeqID("SEQUENCE", schema, columnInfo.getSequenceName());
                    DBObjectID dBObjectID2 = this.getColSeqID("TRIGGER", t.getSchema(), string2);
                    column.setProperty("AUTO_GENERATED_SEQUENCE", (Object)dBObjectID);
                    column.setProperty("AUTO_GENERATED_SEQUENCE_TRIGGER", (Object)dBObjectID2);
                    column.setProperty("ColumnSequenceExpander.TriggerNullCheck", (Object)columnInfo.isCheckForNull());
                }
            }
        }
    }

    private DBObjectID getColSeqID(String string, Schema schema, String string2) throws DBException {
        DBObjectID dBObjectID = null;
        SchemaObject schemaObject = this.getDatabase().getObject(string, schema, string2);
        if (schemaObject != null) {
            dBObjectID = schemaObject.getID();
        }
        return dBObjectID;
    }

    private String getTableTypeQuery() {
        BaseOracleDatabase baseOracleDatabase = this.getDatabase();
        String string = baseOracleDatabase.getDatabaseType();
        int n = baseOracleDatabase.getDatabaseVersion();
        String string2 = "Oracle Lite".equals(string) || n < 81 ? null : (n <= 82 ? "SELECT /*OracleDictionaryQueries.TABLE_TYPE_ORACLE8_QUERY(SYS.ALL_TABLES)*/\n 'N' TEMPORARY, null DURATION, IOT_TYPE, PARTITIONED, NESTED, null EXTERNAL_TAB\n 'N' SHARDED, 'N' DUPLICATED \nFROM SYS.ALL_TABLES\nWHERE OWNER = ? AND TABLE_NAME = ?" : (n <= 1210 ? "SELECT /*OracleDictionaryQueries.TABLE_TYPE_ORACLE11_QUERY*/\n A.TEMPORARY, A.DURATION, A.IOT_TYPE, A.PARTITIONED, A.NESTED,\n ( SELECT 1 FROM SYS.ALL_EXTERNAL_TABLES E    WHERE E.OWNER = A.OWNER AND E.TABLE_NAME = A.TABLE_NAME ) EXTERNAL_TAB,\n 'N' SHARDED, 'N' DUPLICATED \nFROM SYS.ALL_TABLES A \nWHERE A.OWNER = ? AND A.TABLE_NAME = ?" : "SELECT /*OracleDictionaryQueries.ALL_TABLE_TYPE_QUERY*/\n A.TEMPORARY, A.DURATION, A.IOT_TYPE, A.PARTITIONED, A.NESTED, \n ( SELECT 1 FROM SYS.ALL_EXTERNAL_TABLES E    WHERE E.OWNER = A.OWNER AND E.TABLE_NAME = A.TABLE_NAME ) EXTERNAL_TAB,\n A.SHARDED, A.DUPLICATED \nFROM SYS.ALL_TABLES A \nWHERE A.OWNER = ? AND A.TABLE_NAME = ?"));
        return string2;
    }

    private static String getExternalTableQuery(BaseOracleDatabase baseOracleDatabase) {
        String string = baseOracleDatabase.getDatabaseType();
        int n = baseOracleDatabase.getDatabaseVersion();
        String string2 = "Oracle Lite".equals(string) || n <= 82 ? null : (n <= 92 ? "select /*OracleDictionaryQueries.ALL_TABLE_EXTERNAL_TAB_ORACLE9i_QUERY*/\n       TYPE_NAME, REJECT_LIMIT, ACCESS_TYPE, ACCESS_PARAMETERS, null, \n       DEFAULT_DIRECTORY_OWNER, DEFAULT_DIRECTORY_NAME \nfrom   SYS.ALL_EXTERNAL_TABLES \nwhere  OWNER = ? \nand    TABLE_NAME = ? \n" : "select /*OracleDictionaryQueries.ALL_TABLE_EXTERNAL_TAB_QUERY*/\n       TYPE_NAME, REJECT_LIMIT, ACCESS_TYPE, ACCESS_PARAMETERS, PROPERTY, \n       DEFAULT_DIRECTORY_OWNER, DEFAULT_DIRECTORY_NAME \nfrom   SYS.ALL_EXTERNAL_TABLES \nwhere  OWNER = ? \nand    TABLE_NAME = ? \n");
        return string2;
    }

    protected String getTableQuery() {
        return OracleTableBuilder.getTableQuery(this.getDatabase());
    }

    private String convertToObjectQuery(String string) {
        String string2 = null;
        if (this.getDatabase().getDatabaseVersion() > 81) {
            Pattern pattern = Pattern.compile("ALL_TABLES", 2);
            string2 = pattern.matcher(string).replaceAll("ALL_OBJECT_TABLES");
        }
        return string2;
    }

    private String getColSeqTriggerQuery(BaseOracleDatabase baseOracleDatabase) {
        String string = baseOracleDatabase.getDatabaseType();
        return "Oracle Lite".equals(string) ? null : "SELECT /*OracleDictionaryQueries.ALL_TABLE_COLSEQ_TRIGGERS_QUERY*/\n       S.NAME, S.TEXT\nFROM   SYS.ALL_SOURCE S\nWHERE  S.OWNER = ? \nAND    S.TYPE = 'TRIGGER'\nAND EXISTS (SELECT 1\n            FROM   SYS.ALL_TRIGGERS T\n            WHERE  T.OWNER = S.OWNER\n            AND    T.TABLE_NAME = ? \n            AND    T.TRIGGER_NAME = S.NAME\n            AND    T.TABLE_OWNER = S.OWNER\n            AND    T.BASE_OBJECT_TYPE = 'TABLE'\n            AND    T.TRIGGER_TYPE LIKE '%EACH ROW'\n            AND    T.TRIGGERING_EVENT LIKE '%INSERT%'\n            AND EXISTS (SELECT 1\n                        FROM   SYS.ALL_SOURCE S2\n                        WHERE  S2.OWNER = S.OWNER\n                        AND    S2.NAME = S.NAME\n                        AND    S2.TYPE = S2.TYPE\n                        AND    S2.TEXT LIKE '%<<COLUMN_SEQUENCES>>%'\n                        )\n             )\nORDER BY S.NAME, S.LINE";
    }

    static void setLOBCache(LOBDescriptor lOBDescriptor, String string) {
        lOBDescriptor.setLOBCache((LOBDescriptor.LOBCache)(string.equals("YES") ? LOBDescriptor.LOBCache.CACHE : (string.equals("NO") ? LOBDescriptor.LOBCache.NOCACHE : (string.equals("CACHEREADS") ? LOBDescriptor.LOBCache.CACHE_READS : null))));
    }

    static OracleTableProperties getOracleTableProperties(DBObject dBObject, String string, String string2, String string3, String string4, BaseOracleDatabase baseOracleDatabase) {
        OracleTableProperties oracleTableProperties = new OracleTableProperties();
        OracleTableProperties.OracleTableCompression oracleTableCompression = OracleTableProperties.OracleTableCompression.NOCOMPRESS;
        if (dBObject instanceof MaterializedView || dBObject instanceof TablePartition || dBObject instanceof Table && (Table.TableType)dBObject.getProperty("TableType") == Table.TableType.NORMAL) {
            if (string != null) {
                oracleTableCompression = string.equals(ENABLED) ? (string2 == null || string2.equals(BASIC) ? OracleTableProperties.OracleTableCompression.COMPRESS : (string2.equals(DIRECT_LOAD_OPERATIONS) ? OracleTableProperties.OracleTableCompression.COMPRESS_FOR_DIRECT_LOAD_OPERATIONS : (string2.equals(ALL_OPERATIONS) ? OracleTableProperties.OracleTableCompression.COMPRESS_FOR_ALL_OPERATIONS : (string2.equals(ADVANCED) ? OracleTableProperties.OracleTableCompression.ROW_STORE_COMPRESS_ADVANCED : (string2.equals(OLTP) ? OracleTableProperties.OracleTableCompression.COMPRESS_FOR_OLTP : (string2.equals(ROW_LEVEL_LOCKING) ? OracleTableProperties.OracleTableCompression.COLUMN_STORE_COMPRESS_ROW_LEVEL_LOCKING : (string2.equals(QUERY_LOW) ? OracleTableProperties.OracleTableCompression.COMPRESS_FOR_QUERY_LOW : (string2.equals(QUERY_HIGH) ? OracleTableProperties.OracleTableCompression.COMPRESS_FOR_QUERY_HIGH : (string2.equals(ARCHIVE_LOW) ? OracleTableProperties.OracleTableCompression.COMPRESS_FOR_ARCHIVE_LOW : (string2.equals(ARCHIVE_HIGH) ? OracleTableProperties.OracleTableCompression.COMPRESS_FOR_ARCHIVE_HIGH : (string2.equals(QUERY_LOW_ROW_LEVEL_LOCKING) ? OracleTableProperties.OracleTableCompression.COLUMN_STORE_COMPRESS_FOR_QUERY_LOW_ROW_LEVEL_LOCKING : (string2.equals(QUERY_HIGH_ROW_LEVEL_LOCKING) ? OracleTableProperties.OracleTableCompression.COLUMN_STORE_COMPRESS_FOR_QUERY_HIGH_ROW_LEVEL_LOCKING : (string2.equals(ARCHIVE_LOW_ROW_LEVEL_LOCKING) ? OracleTableProperties.OracleTableCompression.COLUMN_STORE_COMPRESS_FOR_ARCHIVE_LOW_ROW_LEVEL_LOCKING : (string2.equals(ARCHIVE_HIGH_ROW_LEVEL_LOCKING) ? OracleTableProperties.OracleTableCompression.COLUMN_STORE_COMPRESS_FOR_ARCHIVE_HIGH_ROW_LEVEL_LOCKING : OracleTableProperties.OracleTableCompression.COMPRESS)))))))))))))) : OracleTableProperties.OracleTableCompression.NOCOMPRESS;
            }
            oracleTableProperties.setTableCompression(oracleTableCompression);
        }
        if (string3 != null) {
            Integer n;
            if ((string3 = string3.trim()).equals("DEFAULT")) {
                n = 0;
            } else {
                try {
                    n = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    DBLog.getLogger(OracleTableBuilder.class).warning(numberFormatException.getMessage());
                    n = null;
                }
            }
            oracleTableProperties.setParallelDegree(n);
        }
        if (string4 != null) {
            oracleTableProperties.setTablespaceSet(string4);
        }
        return oracleTableProperties;
    }

    static DBObject getQueryObject(Table table) {
        if (Table.TableType.INDEX_ORGANIZED == table.getProperty("TableType")) {
            for (Constraint constraint : table.getConstraints()) {
                if (!(constraint instanceof PKConstraint)) continue;
                return constraint;
            }
        }
        return table;
    }

    static void setLogging(ResultSet resultSet, OracleStorageProperties oracleStorageProperties) throws SQLException {
        String string = resultSet.getString("LOGGING");
        if (!resultSet.wasNull() && string != null && !string.equalsIgnoreCase("NONE")) {
            oracleStorageProperties.setLogging("YES".equalsIgnoreCase(string) ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    static String getTableQuery(OracleDatabase oracleDatabase) {
        int n;
        String string = null;
        string = "Oracle Lite".equals(oracleDatabase.getDatabaseType()) ? "SELECT /*OracleDictionaryQueries.ALL_TABLE_PROPERTIES_OLITE_QUERY*/\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,\n       null FREELISTS, null FREELIST_GROUPS, null LOGGING,\n       null BUFFER_POOL, null COMPRESSION, null COMPRESS_FOR, null DEGREE, null CACHE \nFROM  SYS.ALL_TABLES\nWHERE OWNER = ? AND TABLE_NAME = ?" : ((n = oracleDatabase.getDatabaseVersion()) >= 1220 ? "SELECT /*OracleDictionaryQueries.ALL_TABLE_PROPERTIES_QUERY(SYS.ALL_TABLES)*/\n       A.TABLESPACE_NAME, A.PCT_FREE, A.PCT_USED, A.INI_TRANS, A.MAX_TRANS,\n       A.INITIAL_EXTENT, A.NEXT_EXTENT, A.MIN_EXTENTS, A.MAX_EXTENTS, A.PCT_INCREASE,\n       A.FREELISTS, A.FREELIST_GROUPS, A.LOGGING, A.BUFFER_POOL, A.COMPRESSION,\n       A.COMPRESS_FOR, A.DEGREE, A.CACHE, A.INMEMORY, A.INMEMORY_COMPRESSION, \n       A.INMEMORY_PRIORITY, A.INMEMORY_DISTRIBUTE, A.INMEMORY_DUPLICATE, \n       CASE WHEN A.SHARDED='Y' THEN P.DEF_TABLESPACE_NAME ELSE NULL END AS TABLESPACE_SET_NAME \nFROM  SYS.ALL_TABLES A, SYS.ALL_PART_TABLES P\nWHERE A.TABLE_NAME = P.TABLE_NAME(+) AND A.OWNER = P.OWNER(+) AND A.OWNER = ? AND A.TABLE_NAME = ?" : (n >= 1210 ? "SELECT /*OracleDictionaryQueries.ALL_TABLE_PROPERTIES_QUERY(SYS.ALL_TABLES)*/\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,\n       FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL, COMPRESSION,\n       COMPRESS_FOR, DEGREE, CACHE, INMEMORY, INMEMORY_COMPRESSION, \n       INMEMORY_PRIORITY, INMEMORY_DISTRIBUTE, INMEMORY_DUPLICATE \nFROM  SYS.ALL_TABLES\nWHERE OWNER = ? AND TABLE_NAME = ?" : (n >= 110 ? "SELECT /*OracleDictionaryQueries.ALL_TABLE_PROPERTIES_QUERY(SYS.ALL_TABLES)*/\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,\n       FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL, COMPRESSION,\n       COMPRESS_FOR, DEGREE, CACHE\nFROM  SYS.ALL_TABLES\nWHERE OWNER = ? AND TABLE_NAME = ?" : (n >= 100 ? "SELECT /*OracleDictionaryQueries.ALL_TABLE_PROPERTIES_ORACLE10_QUERY(SYS.ALL_TABLES)*/\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,\n       FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL, COMPRESSION,\n       null COMPRESS_FOR, DEGREE, CACHE\nFROM  SYS.ALL_TABLES\nWHERE OWNER = ? AND TABLE_NAME = ?" : (n >= 91 ? "SELECT /*OracleDictionaryQueries.ALL_TABLE_PROPERTIES_ORACLE9_QUERY(SYS.ALL_TABLES)*/\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,\n       FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL, null COMPRESSION,\n       null COMPRESS_FOR, DEGREE, CACHE\nFROM  SYS.ALL_TABLES\nWHERE OWNER = ? AND TABLE_NAME = ?" : (n >= 81 ? "SELECT /*OracleDictionaryQueries.ALL_TABLE_PROPERTIES_ORACLE8_QUERY*/\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,\n       FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL, null COMPRESSION,\n       null COMPRESS_FOR, DEGREE, CACHE\nFROM  SYS.ALL_TABLES\nWHERE OWNER = ? AND TABLE_NAME = ?" : "SELECT /*OracleDictionaryQueries.ALL_TABLE_PROPERTIES_ORACLE7_QUERY*/\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,\n       FREELISTS, FREELIST_GROUPS, null LOGGING, null BUFFER_POOL, null COMPRESSION,\n       null COMPRESSION_FOR, 1 DEGREE, CACHE \nFROM  SYS.ALL_TABLES\nWHERE OWNER = ? AND TABLE_NAME = ?"))))));
        return string;
    }

    private static String getTablePartitionsTypeQuery(OracleDatabase oracleDatabase) {
        String string = null;
        string = oracleDatabase.getDatabaseVersion() >= 110 ? "select /*OracleDictionaryQueries.ALL_TABLE_PARTITIONS_TYPE_QUERY*/\n       apt.partitioning_type, apt.subpartitioning_type, apkc.column_name, apt.ref_ptn_constraint_name\nfrom   sys.all_part_tables apt, sys.all_part_key_columns apkc\nwhere  apt.owner = ?\nand    apt.table_name = ?\nand    apkc.owner = apt.owner\nand    apkc.name  = apt.table_name\nand    apkc.object_type = 'TABLE'\norder by apkc.column_position" : "select /*OracleDictionaryQueries.ALL_TABLE_PARTITIONS_TYPE_QUERY*/\n       apt.partitioning_type, apt.subpartitioning_type, apkc.column_name\nfrom   sys.all_part_tables apt, sys.all_part_key_columns apkc\nwhere  apt.owner = ?\nand    apt.table_name = ?\nand    apkc.owner = apt.owner\nand    apkc.name  = apt.table_name\nand    apkc.object_type = 'TABLE'\norder by apkc.column_position";
        return string;
    }

    static void fillInMemoryProperties(DBObject dBObject, ResultSet resultSet, BaseOracleDatabase baseOracleDatabase) throws SQLException {
        if (baseOracleDatabase.getDatabaseVersion() >= 1210) {
            String string = resultSet.getString(OracleTableBuilder.getInMemoryColumnName(null, dBObject));
            if (!resultSet.wasNull()) {
                OracleInMemoryProperties oracleInMemoryProperties = new OracleInMemoryProperties();
                if (ENABLED.equals(string)) {
                    oracleInMemoryProperties.setInMemory(true);
                    OracleInMemoryProperties.InMemoryCompression inMemoryCompression = (OracleInMemoryProperties.InMemoryCompression)OracleTableBuilder.parseEnumFromRS(resultSet, OracleTableBuilder.getInMemoryColumnName("COMPRESSION", dBObject), OracleInMemoryProperties.InMemoryCompression.class);
                    oracleInMemoryProperties.setInMemoryCompression(inMemoryCompression);
                    OracleInMemoryProperties.InMemoryPriority inMemoryPriority = (OracleInMemoryProperties.InMemoryPriority)OracleTableBuilder.parseEnumFromRS(resultSet, OracleTableBuilder.getInMemoryColumnName("PRIORITY", dBObject), OracleInMemoryProperties.InMemoryPriority.class);
                    oracleInMemoryProperties.setInMemoryPriority(inMemoryPriority);
                    OracleInMemoryProperties.InMemoryDuplicate inMemoryDuplicate = (OracleInMemoryProperties.InMemoryDuplicate)OracleTableBuilder.parseEnumFromRS(resultSet, OracleTableBuilder.getInMemoryColumnName("DUPLICATE", dBObject), OracleInMemoryProperties.InMemoryDuplicate.class);
                    oracleInMemoryProperties.setInMemoryDuplicate(inMemoryDuplicate);
                    OracleInMemoryProperties.InMemoryDistribute inMemoryDistribute = (OracleInMemoryProperties.InMemoryDistribute)OracleTableBuilder.parseEnumFromRS(resultSet, OracleTableBuilder.getInMemoryColumnName("DISTRIBUTE", dBObject), OracleInMemoryProperties.InMemoryDistribute.class);
                    oracleInMemoryProperties.setInMemoryDistribute(inMemoryDistribute);
                } else {
                    oracleInMemoryProperties.setInMemory(false);
                }
                dBObject.setProperty("OracleInMemoryProperties", (Object)oracleInMemoryProperties);
            }
        }
    }

    private static String getInMemoryColumnName(String string, DBObject dBObject) {
        StringBuilder stringBuilder = new StringBuilder();
        if (dBObject instanceof OracleTablespaceProperties) {
            stringBuilder.append("DEF_");
        }
        stringBuilder.append("INMEMORY");
        if (string != null) {
            stringBuilder.append("_").append(string);
        }
        return stringBuilder.toString();
    }

    private static <T extends Enum> T parseEnumFromRS(ResultSet resultSet, String string, Class<? extends Enum> clazz) throws SQLException {
        Enum enum_ = null;
        String string2 = resultSet.getString(string);
        if (!resultSet.wasNull()) {
            enum_ = DBUtil.findEnumFromString((String)string2, clazz);
        }
        return (T)enum_;
    }

    private OracleTablePartitions.PartitionType getPartitionType(String string) {
        OracleTablePartitions.PartitionType partitionType;
        try {
            partitionType = OracleTablePartitions.PartitionType.valueOf((String)string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            partitionType = null;
        }
        return partitionType;
    }
}

