/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.ora.OracleLite;

public class OracleSynonymBuilder
extends OracleDBObjectBuilder<Synonym> {
    OracleSynonymBuilder(BaseOracleDatabase baseOracleDatabase) {
        super(baseOracleDatabase, "SYNONYM");
    }

    protected boolean canBuildComponents() {
        return true;
    }

    public Synonym createObject(String string, Schema schema, DBObjectID dBObjectID) {
        Synonym synonym = (Synonym)super.createObject(string, schema, dBObjectID);
        synonym.setPublic(this.getDatabase().isPublicSchema(schema));
        return synonym;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"reference"})
    public void fillInObject(final Synonym synonym) throws DBException {
        if (synonym.getSchema() != null) {
            synonym.setPublic(this.getDatabase().isPublicSchema(synonym.getSchema()));
        }
        final QueryWrapper queryWrapper = this.getQueryWrapper(synonym);
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    if (resultSet.next()) {
                        String string = resultSet.getString(1);
                        String string2 = resultSet.getString(2);
                        String string3 = resultSet.getString(3);
                        String string4 = resultSet.getString(4);
                        String string5 = null;
                        BigDecimal bigDecimal = null;
                        if (string4 != null) {
                            int n = string4.indexOf(95);
                            if (n > 0) {
                                try {
                                    bigDecimal = new BigDecimal(string4.substring(0, n));
                                    if (BigDecimal.ZERO.equals(bigDecimal)) {
                                        bigDecimal = null;
                                    }
                                    string5 = string4.substring(n + 1);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    OracleSynonymBuilder.this.getLogger().severe(numberFormatException.getMessage());
                                }
                            } else {
                                OracleSynonymBuilder.this.getLogger().severe("Invalid ref details: " + string4);
                            }
                        }
                        OracleSynonymBuilder.this.populateSynonym(synonym, string, string2, string3, string5, bigDecimal);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)synonym, sQLException);
                }
            }
        };
        queryWrapper.executeQuery(queryRunnable);
    }

    private void populateSynonym(Synonym synonym, String string, String string2, String string3, String string4, Object object) throws DBException {
        ReferenceID referenceID;
        Schema schema;
        BaseOracleDatabase baseOracleDatabase = this.getDatabase();
        Schema schema2 = string == null ? null : (schema = string3 == null ? this.getSchema(string) : new Schema(string));
        if (object == null) {
            referenceID = new ReferenceID("UNSPECIFIED_TYPE", schema, string2, string3);
            referenceID.setProvider((DBObjectProvider)baseOracleDatabase);
        } else {
            referenceID = baseOracleDatabase.createID(null, schema, string2, string4, object);
        }
        synonym.setReference((DBObjectID)referenceID);
    }

    private QueryWrapper getQueryWrapper(Synonym synonym) {
        if (this.getDatabase() instanceof OracleLite) {
            return this.getDatabase().newQueryWrapper((SystemObject)synonym, "SELECT /*OracleDictionaryQueries.ALL_SYNONYM_REF_OBJECT_OLITE_QUERY*/\n       S.TABLE_OWNER, S.TABLE_NAME, S.DB_LINK, '0_TABLE'  FROM  SYS.ALL_TABLES REF, SYS.ALL_SYNONYMS S  WHERE S.OWNER        = ?  AND   S.SYNONYM_NAME = ?  AND   S.TABLE_OWNER  = REF.OWNER AND   S.TABLE_NAME   = REF.TABLE_NAME UNION ALL\n SELECT S.TABLE_OWNER, S.TABLE_NAME, S.DB_LINK, '0_VIEW'  FROM  SYS.ALL_VIEWS REF, SYS.ALL_SYNONYMS S  WHERE S.OWNER        = ?  AND   S.SYNONYM_NAME = ?  AND   S.TABLE_OWNER  = REF.OWNER AND   S.TABLE_NAME   = REF.VIEW_NAME", synonym.getSchema(), synonym, synonym.getSchema(), synonym);
        }
        return this.getDatabase().newQueryWrapper((SystemObject)synonym, "SELECT /*OracleDictionaryQueries.ALL_SYNONYM_REF_OBJECT_QUERY*/\n    S.TABLE_OWNER, S.TABLE_NAME, S.DB_LINK,\n    DECODE( S.DB_LINK, NULL, ( SELECT OBJECT_ID || '_' || OBJECT_TYPE \n       FROM SYS.ALL_OBJECTS REF \n       WHERE REF.OWNER = S.TABLE_OWNER \n         AND REF.OBJECT_NAME = S.TABLE_NAME \n         AND OBJECT_TYPE NOT LIKE '% BODY' ), NULL) REF_ID_TYPE \n FROM  SYS.ALL_SYNONYMS S  WHERE S.OWNER        = ?  AND   S.SYNONYM_NAME = ? ", synonym.getSchema(), synonym);
    }
}

