/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTableBuilder;

class OracleStoragePropertiesBuilder
extends OracleDBObjectBuilder<OracleStorageProperties> {
    private final String m_query;
    private final Object[] m_queryParams;

    public OracleStoragePropertiesBuilder(BaseOracleDatabase baseOracleDatabase, String string, Object ... objectArray) {
        super(baseOracleDatabase, "OracleStorageProperties");
        this.m_query = string;
        this.m_queryParams = objectArray;
    }

    protected void fillInObject(final OracleStorageProperties oracleStorageProperties) throws DBException {
        SystemObject systemObject = DBUtil.getSystemObject((DBObject)oracleStorageProperties);
        if (systemObject != null) {
            QueryWrapper queryWrapper = this.getDatabase().newQueryWrapper(systemObject, this.m_query, this.m_queryParams);
            QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet resultSet) throws DBException, SQLException {
                    if (resultSet.next()) {
                        OracleTableBuilder.populateSegmentAttributes(oracleStorageProperties, resultSet, OracleStoragePropertiesBuilder.this.getDatabase());
                    }
                }
            };
            queryWrapper.executeQuery(queryRunnable);
        }
    }
}

