/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.TreeSet;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.db.ora.OracleDictionaryQueries;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.util.ModelUtil;

public class OracleSchemaBuilder
extends OracleDBObjectBuilder<Schema> {
    public OracleSchemaBuilder(BaseOracleDatabase baseOracleDatabase) {
        super(baseOracleDatabase, "SCHEMA");
    }

    private boolean shouldBuild(Schema schema) {
        return this.getDatabase() instanceof OracleDatabaseImpl && ModelUtil.areEqual((Object)schema.getName(), (Object)this.getDatabase().getUserName());
    }

    protected boolean fillInObjectComponentImpl(Schema schema, String string) throws DBException {
        if (this.shouldBuild(schema) && Thread.holdsLock(this.getDatabase().getConnection())) {
            DBLog.logIllegalState((String)"Deadlock risk: Connection locked before Schema property lock");
        }
        return super.fillInObjectComponentImpl((AbstractBuildableObject)schema, string);
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"OracleSchemaProperties"})
    public void fillInSchemaProperties(Schema schema) throws DBException {
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"USER_PRIVS"})
    public void fillInPrivs(Schema schema) throws DBException {
        if (this.shouldBuild(schema)) {
            final TreeSet treeSet = new TreeSet();
            final QueryWrapper queryWrapper = new QueryWrapper((Database)this.getDatabase(), "SELECT /*OracleDictionaryQueries.ALL_PRIVS_QUERY*/\n       PRIVILEGE FROM SYS.SESSION_PRIVS");
            QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet resultSet) throws DBException {
                    try {
                        while (resultSet.next()) {
                            treeSet.add(resultSet.getString(1));
                        }
                    }
                    catch (SQLException sQLException) {
                        queryWrapper.throwDBException(sQLException);
                    }
                }
            };
            try {
                queryWrapper.executeQuery(queryRunnable);
            }
            catch (DBException dBException) {
                this.getLogger().warning(APIBundle.format((String)"PRIVS_LOAD_ERR", (Object[])new Object[]{this.getDatabase().getConnectionName(), dBException.getMessage()}));
            }
            schema.setProperty("USER_PRIVS", (Object)treeSet.toArray(new String[treeSet.size()]));
        }
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"USER_ROLES"})
    public void fillInRoles(Schema schema) throws DBException {
        if (this.shouldBuild(schema)) {
            final TreeSet treeSet = new TreeSet();
            final QueryWrapper queryWrapper = new QueryWrapper((Database)this.getDatabase(), "SELECT /*OracleDictionaryQueries.ALL_ROLES_QUERY*/\n       ROLE FROM SYS.SESSION_ROLES");
            QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet resultSet) throws DBException {
                    block3: {
                        try {
                            while (resultSet.next()) {
                                treeSet.add(resultSet.getString(1));
                            }
                        }
                        catch (SQLException sQLException) {
                            if (OracleDictionaryQueries.isSaaS() && sQLException.getErrorCode() == 942) break block3;
                            queryWrapper.throwDBException(sQLException);
                        }
                    }
                }
            };
            try {
                queryWrapper.executeQuery(queryRunnable);
            }
            catch (CancelledException cancelledException) {
                throw cancelledException;
            }
            catch (DBException dBException) {
                this.getLogger().log(DBLog.getExceptionLogLevel(), "Could not load roles for database " + this.getDatabase().getConnectionName(), dBException.getCause() == null ? dBException : dBException.getCause());
            }
            schema.setProperty("USER_ROLES", (Object)treeSet.toArray(new String[treeSet.size()]));
        }
    }

    protected boolean canBuildComponents() {
        return true;
    }
}

