/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.SQLException;
import java.util.List;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.OracleDictionaryQueries;
import oracle.javatools.util.Holder;

class OracleQueryWrapper
extends QueryWrapper {
    private final Holder<Boolean> m_queryChecked = new Holder((Object)false);

    public OracleQueryWrapper(BaseOracleDatabase baseOracleDatabase, String string, Object ... objectArray) {
        super((Database)baseOracleDatabase, string, objectArray);
    }

    public OracleQueryWrapper(BaseOracleDatabase baseOracleDatabase, String string, List list) {
        super((Database)baseOracleDatabase, string, list);
    }

    public void executeQuery(int n, QueryWrapper.QueryRunnable queryRunnable) throws DBException {
        this.getQuery();
        super.executeQuery(n, queryRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getQuery() {
        Holder<Boolean> holder = this.m_queryChecked;
        synchronized (holder) {
            if (!((Boolean)this.m_queryChecked.get()).booleanValue()) {
                String[] stringArray = this.getStatementStrings();
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = this.checkQuery(stringArray[i]);
                }
                this.setStatement(stringArray);
                this.m_queryChecked.set((Object)true);
            }
        }
        return super.getQuery();
    }

    private String checkQuery(String string) {
        OracleDictionaryQueries oracleDictionaryQueries = ((BaseOracleDatabase)this.getDatabase()).getDictionaryQueries();
        String string2 = string;
        string2 = this.getDatabaseName() != null ? string2.replaceAll("(SYS\\.[A-Z0-9_.]*)", "$1@" + this.getDatabaseName()) : oracleDictionaryQueries.getQuery(string2);
        return string2;
    }

    protected boolean hasCancelled(SQLException sQLException) {
        return super.hasCancelled(sQLException) || sQLException.getErrorCode() == 1013;
    }
}

