/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.logging.Level;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.Schema;
import oracle.javatools.db.extension.DBObjectRegistry;
import oracle.javatools.db.ora.DatabaseLinkBuilder;
import oracle.javatools.db.ora.JavaBinaryBuilder;
import oracle.javatools.db.ora.JavaSourceBuilder;
import oracle.javatools.db.ora.MaterializedViewBuilder;
import oracle.javatools.db.ora.MaterializedViewLogBuilder;
import oracle.javatools.db.ora.Oracle8;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.PropertyAction;
import oracle.javatools.util.ModelUtil;
import oracle.jdbc.OracleConnection;

public class Oracle8i
extends Oracle8 {
    private static final String DBA = "DBA";
    private static final String CREATE_PRIV = "CREATE {0}";
    private static final String CREATE_ANY_PRIV = "CREATE ANY {0}";
    private static final String CREATE_PUBLIC_PRIV = "CREATE PUBLIC {0}";
    private static final String ALTER_ANY_PRIV = "ALTER ANY {0}";
    private static final String ALTER_PUBLIC_PRIV = "ALTER PUBLIC {0}";
    private static final String ALTER_PRIV = "ALTER {0}";
    private static final String DROP_ANY_PRIV = "DROP ANY {0}";
    private static final String DROP_PUBLIC_PRIV = "DROP PUBLIC {0}";

    Oracle8i(String string, String string2, Connection connection, int n) {
        super(string, string2, connection, n);
        if (connection instanceof OracleConnection) {
            Oracle8i.initOC((OracleConnection)connection);
        }
    }

    @Override
    protected void registerBuilders() {
        super.registerBuilders();
        if (this.supportsJava()) {
            this.registerBuilder("JAVA SOURCE", (DBObjectBuilder)new JavaSourceBuilder(this));
            this.registerBuilder("JAVA CLASS", (DBObjectBuilder)new JavaBinaryBuilder(this, "JAVA CLASS"));
            this.registerBuilder("JAVA RESOURCE", (DBObjectBuilder)new JavaBinaryBuilder(this, "JAVA RESOURCE"));
        }
        this.registerBuilder("MATERIALIZED VIEW", (DBObjectBuilder)new MaterializedViewBuilder(this));
        this.registerBuilder("MATERIALIZED VIEW LOG", (DBObjectBuilder)new MaterializedViewLogBuilder(this));
        this.registerBuilder("DATABASE LINK", (DBObjectBuilder)new DatabaseLinkBuilder(this));
    }

    @Override
    public boolean supportsJava() {
        return true;
    }

    @Override
    public boolean hasSystemPrivilege(String string, Schema schema, String string2) {
        String string3 = string;
        if ("MATERIALIZED VIEW".equals(string) && this.getDatabaseVersion() < 100) {
            string3 = "SNAPSHOT";
        } else if ("PACKAGE".equals(string) || "PACKAGE BODY".equals(string) || "FUNCTION".equals(string)) {
            string3 = "PROCEDURE";
        } else if ("TYPE BODY".equals(string)) {
            string3 = "TYPE";
        } else if ("MATERIALIZED VIEW LOG".equals(string)) {
            string3 = "TABLE";
        } else if ("SCHEMA".equals(string)) {
            string3 = "USER";
        }
        if (DBObjectRegistry.isExtensionType((String)string3, (String)"Oracle Database", (int)this.getDatabaseVersion())) {
            return true;
        }
        Object[] objectArray = new Object[]{string3};
        if (ModelUtil.areEqual((Object)"CREATE", (Object)string2)) {
            if ("INDEX".equals(string) && (schema == null || this.isCurrentUser(schema))) {
                return true;
            }
            if ("XML SCHEMA".equals(string)) {
                return true;
            }
            boolean bl = this.hasPrivilege(MessageFormat.format(CREATE_ANY_PRIV, objectArray));
            if (!bl) {
                if (schema == null || this.isCurrentUser(schema)) {
                    bl = this.hasPrivilege(MessageFormat.format(CREATE_PRIV, objectArray));
                } else if (schema != null && this.isPublicSchema(schema)) {
                    bl = this.hasPrivilege(MessageFormat.format(CREATE_PUBLIC_PRIV, objectArray));
                }
            }
            return bl;
        }
        if (ModelUtil.areEqual((Object)"MODIFY", (Object)string2)) {
            boolean bl;
            if (Metadata.getInstance().isSchemaObject(string)) {
                bl = this.isCurrentUser(schema) ? true : (this.getPropertyManager().supportsAction(string, PropertyAction.Type.ALTER) ? this.hasPrivilege(MessageFormat.format(this.isPublicSchema(schema) ? ALTER_PUBLIC_PRIV : ALTER_ANY_PRIV, objectArray)) : this.hasSystemPrivilege(string, schema, "DELETE") && this.hasSystemPrivilege(string, schema, "CREATE"));
            } else {
                bl = this.hasPrivilege(MessageFormat.format(ALTER_PRIV, objectArray));
                if (bl && "TABLESPACE".equals(string)) {
                    bl = this.hasRole(DBA);
                }
            }
            return bl;
        }
        if (ModelUtil.areEqual((Object)"DELETE", (Object)string2)) {
            if ("SCHEMA".equals(string)) {
                return !this.isCurrentUser(schema) && !this.isPublicSchema(schema) && this.hasPrivilege("DROP USER");
            }
            if ("TABLESPACE".equals(string)) {
                return this.hasPrivilege("DROP TABLESPACE");
            }
            boolean bl = true;
            if (!this.isCurrentUser(schema)) {
                bl = false;
                if (this.isPublicSchema(schema)) {
                    bl = this.hasPrivilege(MessageFormat.format(DROP_PUBLIC_PRIV, objectArray));
                }
                if (!bl) {
                    bl = this.hasPrivilege(MessageFormat.format(DROP_ANY_PRIV, objectArray));
                }
            }
            return bl;
        }
        return super.hasSystemPrivilege(string, schema, string2);
    }

    static void initOC(OracleConnection oracleConnection) {
        if (oracleConnection.getSessionTimeZone() == null) {
            boolean bl = false;
            TimeZone timeZone = TimeZone.getDefault();
            String string = timeZone != null ? timeZone.getID() : "America/Los_Angeles";
            try {
                oracleConnection.setSessionTimeZone(string);
                bl = true;
            }
            catch (SQLException sQLException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                bl = true;
            }
            if (!bl) {
                Calendar calendar = timeZone != null ? Calendar.getInstance(timeZone) : Calendar.getInstance();
                int n = calendar.get(16) + calendar.get(15);
                int n2 = n / 60000;
                String string2 = MessageFormat.format("{0,number,00}:{1,number,00}", new Integer(n2 / 60), new Integer(n2 % 60));
                try {
                    oracleConnection.setSessionTimeZone(string2);
                }
                catch (SQLException sQLException) {
                    DBLog.getLogger(Oracle8i.class).log(Level.WARNING, "Error setting Session TimeZone to either {0} or {1}: {2}", new Object[]{string, string2, sQLException.getMessage()});
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }
}

