/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.mysql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import oracle.javatools.db.CascadeRequiredException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.jdbc.JdbcDDLDatabase;
import oracle.javatools.db.mysql.MySQLDatabase;
import oracle.javatools.db.mysql.MySQLTableBuilder;
import oracle.javatools.db.mysql.MySQLViewBuilder;

public class MySQLDatabaseImpl
extends JdbcDDLDatabase
implements MySQLDatabase {
    protected MySQLDatabaseImpl(String string, String string2, Connection connection) {
        super(string, string2, connection);
    }

    @Override
    protected void registerBuilders(Collection<String> collection, String string) {
        super.registerBuilders(collection, string);
        if (collection.contains("TABLE")) {
            this.registerBuilder("TABLE", (DBObjectBuilder)new MySQLTableBuilder(this, string));
        }
        if (collection.contains("VIEW")) {
            this.registerBuilder("VIEW", (DBObjectBuilder)new MySQLViewBuilder(this, string));
        }
    }

    @Override
    public Schema getSchema(String string) throws DBException {
        Schema schema = super.getSchema(string);
        if (schema == null) {
            schema = super.getSchema(this.getCatalog());
        }
        return schema;
    }

    @Override
    protected Schema findSchema(String string) throws DBException {
        Schema schema = super.findSchema(string);
        if (schema == null) {
            schema = super.getSchema(this.getCatalog());
        }
        return schema;
    }

    @Override
    public String normaliseDefaultValue(DataType dataType, String object) {
        if (!DataTypeHelper.isNumericType((DataType)dataType)) {
            object = ((String)object).replaceAll("'", "''");
            object = "'" + (String)object + "'";
        }
        return object;
    }

    @Override
    public boolean catalogIsSchema() {
        return true;
    }

    protected void processDeleteException(DBException dBException, SystemObject systemObject) throws DBException {
        int n;
        Throwable throwable = dBException.getCause();
        if (throwable instanceof SQLException && ((n = ((SQLException)throwable).getErrorCode()) == 1217 || n == 1091)) {
            throw new CascadeRequiredException((DBObject)systemObject, ((SQLException)throwable).getMessage());
        }
        throw dBException;
    }

    protected Boolean isConnectionClosedImpl(SQLException sQLException, Connection connection) {
        return Boolean.TRUE.equals(super.isConnectionClosedImpl(sQLException, connection));
    }
}

