/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.mysql;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.datatypes.DataTypeCache;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.jdbc.JdbcDatabaseDescriptor;
import oracle.javatools.db.mysql.MySQL5;
import oracle.javatools.db.mysql.MySQLColumnValidator;
import oracle.javatools.db.mysql.MySQLConstraintValidator;
import oracle.javatools.db.mysql.MySQLDDLGenerator;
import oracle.javatools.db.mysql.MySQLDatabase;
import oracle.javatools.db.mysql.MySQLIndexValidator;
import oracle.javatools.db.property.PropertyInitializer;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.DBObjectValidator;

public class MySQLDatabaseDescriptor
extends JdbcDatabaseDescriptor {
    public static final int MAX_NAME_LENGTH = 255;
    public static final char QUOTE_IDENTIFIER = '`';
    private static final Set RESERVED_WORDS = new HashSet<String>(Arrays.asList("ACCESSIBLE", "ADD", "ALL", "ALTER", "ANALYZE", "AND", "AS", "ASC", "ASENSITIVE", "BEFORE", "BETWEEN", "BIGINT", "BINARY", "BLOB", "BOTH", "BY", "CALL", "CASCADE", "CASE", "CHANGE", "CHAR", "CHARACTER", "CHECK", "COLLATE", "COLUMN", "CONDITION", "CONNECTION", "CONSTRAINT", "CONTINUE", "CONVERT", "CREATE  CROSS", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR  DATABASE", "DATABASES", "DAY_HOUR", "DAY_MICROSECOND", "DAY_MINUTE", "DAY_SECOND", "DEC", "DECIMAL", "DECLARE ", "DEFAULT", "DELAYED", "DELETE  DESC", "DESCRIBE", "DETERMINISTIC", "DISTINCT", "DISTINCTROW", "DIV", "DOUBLE", "DROP", "DUAL", "EACH", "ELSE", "ELSEIF", "ENCLOSED", "ESCAPED", "EXISTS", "EXIT", "EXPLAIN", "FALSE", "FETCH", "FLOAT", "FLOAT4", "FLOAT8", "FOR", "FORCE", "FOREIGN", "FROM", "FULLTEXT", "GOTO", "GRANT", "GROUP", "HAVING", "HIGH_PRIORITY", "HOUR_MICROSECOND", "HOUR_MINUTE", "HOUR_SECOND", "IF", "IGNORE", "IN", "INDEX", "INFILE", "INNER", "INOUT", "INSENSITIVE", "INSERT", "INT", "INT1", "INT2", "INT3", "INT4", "INT8", "INTEGER", "INTERVAL", "INTO", "IS", "ITERATE", "JOIN", "KEY", "KEYS", "KILL", "LABEL", "LEADING", "LEAVE", "LEFT", "LIKE", "LIMIT", "LINEAR", "LINES", "LOAD", "LOCALTIME", "LOCALTIMESTAMP", "LOCK", "LONG", "LONGBLOB", "LONGTEXT", "LOOP", "LOW_PRIORITY", "MASTER_SSL_VERIFY_SERVER_CERT", "MATCH", "MEDIUMBLOB", "MEDIUMINT", "MEDIUMTEXT", "MIDDLEINT", "MINUTE_MICROSECOND", "MINUTE_SECOND", "MOD", "MODIFIES", "NATURAL", "NOT", "NO_WRITE_TO_BINLOG", "NULL", "NUMERIC", "ON", "OPTIMIZE", "OPTION", "OPTIONALLY", "OR", "ORDER", "OUT", "OUTER", "OUTFILE", "PRECISION", "PRIMARY", "PROCEDURE", "PURGE", "RANGE", "READ", "READS", "READ_ONLY", "READ_WRITE", "REAL", "REFERENCES", "REGEXP", "RELEASE", "RENAME", "REPEAT", "REPLACE", "REQUIRE", "RESTRICT", "RETURN", "REVOKE", "RIGHT", "RLIKE", "SCHEMA", "SCHEMAS", "SECOND_MICROSECOND", "SELECT", "SENSITIVE", "SEPARATOR", "SET", "SHOW", "SMALLINT", "SPATIAL", "SPECIFIC", "SQL", "SQLEXCEPTION", "SQLSTATE", "SQLWARNING", "SQL_BIG_RESULT", "SQL_CALC_FOUND_ROWS", "SQL_SMALL_RESULT", "SSL", "STARTING", "STRAIGHT_JOIN", "TABLE", "TERMINATED", "THEN", "TINYBLOB", "TINYINT", "TINYTEXT", "TO", "TRAILING", "TRIGGER", "TRUE", "UNDO", "UNION", "UNIQUE", "UNLOCK", "UNSIGNED", "UPDATE", "UPGRADE", "USAGE", "USE", "USING", "UTC_DATE", "UTC_TIME", "UTC_TIMESTAMP", "VALUES", "VARBINARY", "VARCHAR", "VARCHARACTER", "VARYING", "WHEN", "WHERE", "WHILE", "WITH", "WRITE", "XOR", "YEAR_MONTH", "ZEROFILL"));

    public MySQLDatabaseDescriptor(Class<? extends MySQLDatabase> clazz) {
        super(clazz);
    }

    @Override
    public int getCasePolicy() {
        return 3;
    }

    @Override
    public String getIdentifierQuoteString() {
        return String.valueOf('`');
    }

    @Override
    public int getMaxNameLength(String string) {
        return 255;
    }

    @Override
    public void validateName(String string, String string2) throws InvalidNameException {
        if ("CONSTRAINT".equals(string) && "PRIMARY".equals(string2)) {
            return;
        }
        MySQLDatabaseDescriptor.validateIdentifier((String)string2, (char)'`', (int)255, (String)"_$", (boolean)false, (Set)RESERVED_WORDS, (int)this.getCasePolicy(), (boolean)this.allowSurrogatesInIdentifierValidation());
    }

    @Override
    public Map<String, DBObjectValidator> getValidators(DBObjectProvider dBObjectProvider) {
        Map<String, DBObjectValidator> map = super.getValidators(dBObjectProvider);
        map.put("INDEX", (DBObjectValidator)new MySQLIndexValidator(dBObjectProvider));
        map.put("COLUMN", new MySQLColumnValidator(dBObjectProvider));
        map.put("CONSTRAINT", new MySQLConstraintValidator(dBObjectProvider));
        if (this.getDatabaseVersion() < 50) {
            map.remove("VIEW");
        }
        return map;
    }

    @Override
    public DDLGenerator getDDLGenerator(DBObjectProvider dBObjectProvider) {
        return new MySQLDDLGenerator(this.getDatabaseClass(), dBObjectProvider);
    }

    @Override
    public String getDatabaseType() {
        return "MySQL";
    }

    @Override
    public int getDatabaseVersion() {
        int n = 40;
        Class clazz = this.getDatabaseClass();
        if (MySQL5.class.isAssignableFrom(clazz)) {
            n = 50;
        }
        return n;
    }

    public String getSchemaDisplayName() {
        return APIBundle.get((String)"DATABASE");
    }

    @Override
    public Collection<String> getReservedWords() {
        return RESERVED_WORDS;
    }

    @Override
    public List<PropertyInitializer> getPropertyInitializers(DBObjectProvider dBObjectProvider) {
        List<PropertyInitializer> list = super.getPropertyInitializers(dBObjectProvider);
        list.add(0, new MySQLDefaultsInitializer(dBObjectProvider));
        return list;
    }

    @Override
    protected void registerDataTypes(DataTypeCache dataTypeCache) {
        if (this.getDatabaseVersion() == 40) {
            dataTypeCache.registerDataType("BIGINT");
            dataTypeCache.registerDataType("BINARY");
            dataTypeCache.registerDataType("BIT");
            dataTypeCache.registerDataType("BLOB");
            dataTypeCache.registerDataType("BOOL");
            dataTypeCache.registerDataType("BOOLEAN");
            dataTypeCache.registerDataType("CHAR");
            dataTypeCache.registerDataType("DATE");
            dataTypeCache.registerDataType("DATETIME");
            dataTypeCache.registerDataType("DECIMAL");
            dataTypeCache.registerDataType("DOUBLE");
            dataTypeCache.registerDataType("ENUM");
            dataTypeCache.registerDataType("FLOAT");
            dataTypeCache.registerDataType("INT");
            dataTypeCache.registerDataType("LONGBLOB");
            dataTypeCache.registerDataType("LONGTEXT");
            dataTypeCache.registerDataType("MEDIUMBLOB");
            dataTypeCache.registerDataType("MEDIUMINT");
            dataTypeCache.registerDataType("MEDIUMTEXT");
            dataTypeCache.registerDataType("SET");
            dataTypeCache.registerDataType("SMALLINT");
            dataTypeCache.registerDataType("TEXT");
            dataTypeCache.registerDataType("TIME");
            dataTypeCache.registerDataType("TIMESTAMP");
            dataTypeCache.registerDataType("TINYBLOB");
            dataTypeCache.registerDataType("TINYINT");
            dataTypeCache.registerDataType("TINYTEXT");
            dataTypeCache.registerDataType("VARBINARY");
            dataTypeCache.registerDataType("VARCHAR");
            dataTypeCache.registerDataType("YEAR");
            dataTypeCache.registerDataTypeSynonym("CHARACTER", "CHAR");
            dataTypeCache.registerDataTypeSynonym("CHARACTER VARYING", "VARCHAR");
            dataTypeCache.registerDataTypeSynonym("NCHAR", "CHAR");
            dataTypeCache.registerDataTypeSynonym("NATIONAL CHAR", "CHAR");
            dataTypeCache.registerDataTypeSynonym("NATIONAL VARCHAR", "VARCHAR");
            dataTypeCache.registerDataTypeSynonym("NATIONAL CHARACTER VARYING", "VARCHAR");
            dataTypeCache.registerDataTypeSynonym("LONG VARCHAR", "MEDIUMTEXT");
            dataTypeCache.registerDataTypeSynonym("LONG VARBINARY", "MEDIUMBLOB");
            dataTypeCache.registerDataTypeSynonym("DEC", "DECIMAL");
            dataTypeCache.registerDataTypeSynonym("DOUBLE PRECISION", "DOUBLE");
            dataTypeCache.registerDataTypeSynonym("FIXED", "DECIMAL");
            dataTypeCache.registerDataTypeSynonym("INTEGER", "INT");
            dataTypeCache.registerDataTypeSynonym("NUMERIC", "DECIMAL");
            dataTypeCache.registerDataTypeSynonym("REAL", "DOUBLE");
        }
    }

    private static class MySQLDefaultsInitializer
    extends PropertyInitializer {
        private static String[] s_names = new String[]{"name"};
        private static String[] s_empty = new String[0];

        MySQLDefaultsInitializer(DBObjectProvider dBObjectProvider) {
            super(dBObjectProvider);
        }

        public String[] getPropertyNames(Class<? extends DBObject> clazz) {
            if (PKConstraint.class.isAssignableFrom(clazz)) {
                return s_names;
            }
            return s_empty;
        }

        public Object getPropertyInitialValue(DBObject dBObject, String string) throws PropertyInitializer.InitializationVeto {
            String string2 = null;
            if (dBObject instanceof PKConstraint && "name".equals(string)) {
                string2 = "PRIMARY";
            }
            return string2;
        }
    }
}

