/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.mysql;

import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.mysql.MySQLColumnValidator;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.DataTypeUsageValidator;
import oracle.javatools.db.validators.ValidationException;

public class MySQLDataTypeUsageValidator
extends DataTypeUsageValidator {
    public MySQLDataTypeUsageValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    @Override
    protected void validateAttributes(DataTypeUsage dataTypeUsage, DataType dataType) throws ValidationException {
        Long l;
        boolean bl = false;
        if ("FLOAT".equals(dataType.getName()) && (l = DataTypeHelper.getLongAttributeValue((DataTypeUsage)dataTypeUsage, (String)"scale")) == null) {
            bl = true;
            Long l2 = (Long)dataTypeUsage.getAttributeValue("size");
            if (l2 != null) {
                long l3;
                long l4 = MySQLColumnValidator.FLOAT_PRECISION.getMinValue();
                if (l2.compareTo(l4) < 0) {
                    this.throwAttributeValueInvalid(dataTypeUsage, "size", APIBundle.format((String)"DATATYPE_ERROR_INVALID_NUMERIC_VALUE1", (Object[])new Object[]{APIBundle.get((String)"DATATYPE_ATTRIBUTE_LABEL_SIZE"), l4}));
                }
                if (l2.compareTo(l3 = MySQLColumnValidator.FLOAT_PRECISION.getMaxValue().longValue()) > 0) {
                    this.throwAttributeValueInvalid(dataTypeUsage, "size", APIBundle.format((String)"DATATYPE_ERROR_INVALID_MYSQL_FLOAT", (Object[])new Object[]{APIBundle.get((String)"DATATYPE_ATTRIBUTE_LABEL_SIZE"), l3}));
                }
            }
        }
        if (!bl) {
            super.validateAttributes(dataTypeUsage, dataType);
        }
    }
}

